/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotsitewise.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.iotsitewise.model.AssetCompositeModelPathCopier;
import software.amazon.awssdk.services.iotsitewise.model.AssetCompositeModelPathSegment;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AssetCompositeModelSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AssetCompositeModelSummary> {
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("id").getter(AssetCompositeModelSummary.getter(AssetCompositeModelSummary::id)).setter(AssetCompositeModelSummary.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()}).build();
    private static final SdkField<String> EXTERNAL_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("externalId").getter(AssetCompositeModelSummary.getter(AssetCompositeModelSummary::externalId)).setter(AssetCompositeModelSummary.setter(Builder::externalId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("externalId").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(AssetCompositeModelSummary.getter(AssetCompositeModelSummary::name)).setter(AssetCompositeModelSummary.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("type").getter(AssetCompositeModelSummary.getter(AssetCompositeModelSummary::type)).setter(AssetCompositeModelSummary.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(AssetCompositeModelSummary.getter(AssetCompositeModelSummary::description)).setter(AssetCompositeModelSummary.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<List<AssetCompositeModelPathSegment>> PATH_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("path").getter(AssetCompositeModelSummary.getter(AssetCompositeModelSummary::path)).setter(AssetCompositeModelSummary.setter(Builder::path)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("path").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AssetCompositeModelPathSegment::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, EXTERNAL_ID_FIELD, NAME_FIELD, TYPE_FIELD, DESCRIPTION_FIELD, PATH_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("id", ID_FIELD);
            this.put("externalId", EXTERNAL_ID_FIELD);
            this.put("name", NAME_FIELD);
            this.put("type", TYPE_FIELD);
            this.put("description", DESCRIPTION_FIELD);
            this.put("path", PATH_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String id;
    private final String externalId;
    private final String name;
    private final String type;
    private final String description;
    private final List<AssetCompositeModelPathSegment> path;

    private AssetCompositeModelSummary(BuilderImpl builder) {
        this.id = builder.id;
        this.externalId = builder.externalId;
        this.name = builder.name;
        this.type = builder.type;
        this.description = builder.description;
        this.path = builder.path;
    }

    public final String id() {
        return this.id;
    }

    public final String externalId() {
        return this.externalId;
    }

    public final String name() {
        return this.name;
    }

    public final String type() {
        return this.type;
    }

    public final String description() {
        return this.description;
    }

    public final boolean hasPath() {
        return this.path != null && !(this.path instanceof SdkAutoConstructList);
    }

    public final List<AssetCompositeModelPathSegment> path() {
        return this.path;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.externalId());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.type());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPath() ? this.path() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssetCompositeModelSummary)) {
            return false;
        }
        AssetCompositeModelSummary other = (AssetCompositeModelSummary)obj;
        return Objects.equals(this.id(), other.id()) && Objects.equals(this.externalId(), other.externalId()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.type(), other.type()) && Objects.equals(this.description(), other.description()) && this.hasPath() == other.hasPath() && Objects.equals(this.path(), other.path());
    }

    public final String toString() {
        return ToString.builder((String)"AssetCompositeModelSummary").add("Id", (Object)this.id()).add("ExternalId", (Object)this.externalId()).add("Name", (Object)this.name()).add("Type", (Object)this.type()).add("Description", (Object)this.description()).add("Path", this.hasPath() ? this.path() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "externalId": {
                return Optional.ofNullable(clazz.cast(this.externalId()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "type": {
                return Optional.ofNullable(clazz.cast(this.type()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "path": {
                return Optional.ofNullable(clazz.cast(this.path()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<AssetCompositeModelSummary, T> g) {
        return obj -> g.apply((AssetCompositeModelSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String id;
        private String externalId;
        private String name;
        private String type;
        private String description;
        private List<AssetCompositeModelPathSegment> path = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AssetCompositeModelSummary model) {
            this.id(model.id);
            this.externalId(model.externalId);
            this.name(model.name);
            this.type(model.type);
            this.description(model.description);
            this.path(model.path);
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getExternalId() {
            return this.externalId;
        }

        public final void setExternalId(String externalId) {
            this.externalId = externalId;
        }

        @Override
        public final Builder externalId(String externalId) {
            this.externalId = externalId;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final List<AssetCompositeModelPathSegment.Builder> getPath() {
            List<AssetCompositeModelPathSegment.Builder> result = AssetCompositeModelPathCopier.copyToBuilder(this.path);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPath(Collection<AssetCompositeModelPathSegment.BuilderImpl> path) {
            this.path = AssetCompositeModelPathCopier.copyFromBuilder(path);
        }

        @Override
        public final Builder path(Collection<AssetCompositeModelPathSegment> path) {
            this.path = AssetCompositeModelPathCopier.copy(path);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder path(AssetCompositeModelPathSegment ... path) {
            this.path(Arrays.asList(path));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder path(Consumer<AssetCompositeModelPathSegment.Builder> ... path) {
            this.path(Stream.of(path).map(c -> (AssetCompositeModelPathSegment)((AssetCompositeModelPathSegment.Builder)AssetCompositeModelPathSegment.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public AssetCompositeModelSummary build() {
            return new AssetCompositeModelSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AssetCompositeModelSummary> {
        public Builder id(String var1);

        public Builder externalId(String var1);

        public Builder name(String var1);

        public Builder type(String var1);

        public Builder description(String var1);

        public Builder path(Collection<AssetCompositeModelPathSegment> var1);

        public Builder path(AssetCompositeModelPathSegment ... var1);

        public Builder path(Consumer<AssetCompositeModelPathSegment.Builder> ... var1);
    }
}

