/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotsitewise.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.iotsitewise.model.AssetModelCompositeModel;
import software.amazon.awssdk.services.iotsitewise.model.AssetModelCompositeModelsCopier;
import software.amazon.awssdk.services.iotsitewise.model.AssetModelHierarchiesCopier;
import software.amazon.awssdk.services.iotsitewise.model.AssetModelHierarchy;
import software.amazon.awssdk.services.iotsitewise.model.AssetModelPropertiesCopier;
import software.amazon.awssdk.services.iotsitewise.model.AssetModelProperty;
import software.amazon.awssdk.services.iotsitewise.model.AssetModelVersionType;
import software.amazon.awssdk.services.iotsitewise.model.IoTSiteWiseRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateAssetModelRequest
extends IoTSiteWiseRequest
implements ToCopyableBuilder<Builder, UpdateAssetModelRequest> {
    private static final SdkField<String> ASSET_MODEL_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("assetModelId").getter(UpdateAssetModelRequest.getter(UpdateAssetModelRequest::assetModelId)).setter(UpdateAssetModelRequest.setter(Builder::assetModelId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("assetModelId").build()}).build();
    private static final SdkField<String> ASSET_MODEL_EXTERNAL_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("assetModelExternalId").getter(UpdateAssetModelRequest.getter(UpdateAssetModelRequest::assetModelExternalId)).setter(UpdateAssetModelRequest.setter(Builder::assetModelExternalId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assetModelExternalId").build()}).build();
    private static final SdkField<String> ASSET_MODEL_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("assetModelName").getter(UpdateAssetModelRequest.getter(UpdateAssetModelRequest::assetModelName)).setter(UpdateAssetModelRequest.setter(Builder::assetModelName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assetModelName").build()}).build();
    private static final SdkField<String> ASSET_MODEL_DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("assetModelDescription").getter(UpdateAssetModelRequest.getter(UpdateAssetModelRequest::assetModelDescription)).setter(UpdateAssetModelRequest.setter(Builder::assetModelDescription)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assetModelDescription").build()}).build();
    private static final SdkField<List<AssetModelProperty>> ASSET_MODEL_PROPERTIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("assetModelProperties").getter(UpdateAssetModelRequest.getter(UpdateAssetModelRequest::assetModelProperties)).setter(UpdateAssetModelRequest.setter(Builder::assetModelProperties)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assetModelProperties").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AssetModelProperty::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<AssetModelHierarchy>> ASSET_MODEL_HIERARCHIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("assetModelHierarchies").getter(UpdateAssetModelRequest.getter(UpdateAssetModelRequest::assetModelHierarchies)).setter(UpdateAssetModelRequest.setter(Builder::assetModelHierarchies)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assetModelHierarchies").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AssetModelHierarchy::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<AssetModelCompositeModel>> ASSET_MODEL_COMPOSITE_MODELS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("assetModelCompositeModels").getter(UpdateAssetModelRequest.getter(UpdateAssetModelRequest::assetModelCompositeModels)).setter(UpdateAssetModelRequest.setter(Builder::assetModelCompositeModels)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assetModelCompositeModels").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AssetModelCompositeModel::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clientToken").getter(UpdateAssetModelRequest.getter(UpdateAssetModelRequest::clientToken)).setter(UpdateAssetModelRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<String> IF_MATCH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ifMatch").getter(UpdateAssetModelRequest.getter(UpdateAssetModelRequest::ifMatch)).setter(UpdateAssetModelRequest.setter(Builder::ifMatch)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("If-Match").build()}).build();
    private static final SdkField<String> IF_NONE_MATCH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ifNoneMatch").getter(UpdateAssetModelRequest.getter(UpdateAssetModelRequest::ifNoneMatch)).setter(UpdateAssetModelRequest.setter(Builder::ifNoneMatch)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("If-None-Match").build()}).build();
    private static final SdkField<String> MATCH_FOR_VERSION_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("matchForVersionType").getter(UpdateAssetModelRequest.getter(UpdateAssetModelRequest::matchForVersionTypeAsString)).setter(UpdateAssetModelRequest.setter(Builder::matchForVersionType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("Match-For-Version-Type").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASSET_MODEL_ID_FIELD, ASSET_MODEL_EXTERNAL_ID_FIELD, ASSET_MODEL_NAME_FIELD, ASSET_MODEL_DESCRIPTION_FIELD, ASSET_MODEL_PROPERTIES_FIELD, ASSET_MODEL_HIERARCHIES_FIELD, ASSET_MODEL_COMPOSITE_MODELS_FIELD, CLIENT_TOKEN_FIELD, IF_MATCH_FIELD, IF_NONE_MATCH_FIELD, MATCH_FOR_VERSION_TYPE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("assetModelId", ASSET_MODEL_ID_FIELD);
            this.put("assetModelExternalId", ASSET_MODEL_EXTERNAL_ID_FIELD);
            this.put("assetModelName", ASSET_MODEL_NAME_FIELD);
            this.put("assetModelDescription", ASSET_MODEL_DESCRIPTION_FIELD);
            this.put("assetModelProperties", ASSET_MODEL_PROPERTIES_FIELD);
            this.put("assetModelHierarchies", ASSET_MODEL_HIERARCHIES_FIELD);
            this.put("assetModelCompositeModels", ASSET_MODEL_COMPOSITE_MODELS_FIELD);
            this.put("clientToken", CLIENT_TOKEN_FIELD);
            this.put("If-Match", IF_MATCH_FIELD);
            this.put("If-None-Match", IF_NONE_MATCH_FIELD);
            this.put("Match-For-Version-Type", MATCH_FOR_VERSION_TYPE_FIELD);
        }
    });
    private final String assetModelId;
    private final String assetModelExternalId;
    private final String assetModelName;
    private final String assetModelDescription;
    private final List<AssetModelProperty> assetModelProperties;
    private final List<AssetModelHierarchy> assetModelHierarchies;
    private final List<AssetModelCompositeModel> assetModelCompositeModels;
    private final String clientToken;
    private final String ifMatch;
    private final String ifNoneMatch;
    private final String matchForVersionType;

    private UpdateAssetModelRequest(BuilderImpl builder) {
        super(builder);
        this.assetModelId = builder.assetModelId;
        this.assetModelExternalId = builder.assetModelExternalId;
        this.assetModelName = builder.assetModelName;
        this.assetModelDescription = builder.assetModelDescription;
        this.assetModelProperties = builder.assetModelProperties;
        this.assetModelHierarchies = builder.assetModelHierarchies;
        this.assetModelCompositeModels = builder.assetModelCompositeModels;
        this.clientToken = builder.clientToken;
        this.ifMatch = builder.ifMatch;
        this.ifNoneMatch = builder.ifNoneMatch;
        this.matchForVersionType = builder.matchForVersionType;
    }

    public final String assetModelId() {
        return this.assetModelId;
    }

    public final String assetModelExternalId() {
        return this.assetModelExternalId;
    }

    public final String assetModelName() {
        return this.assetModelName;
    }

    public final String assetModelDescription() {
        return this.assetModelDescription;
    }

    public final boolean hasAssetModelProperties() {
        return this.assetModelProperties != null && !(this.assetModelProperties instanceof SdkAutoConstructList);
    }

    public final List<AssetModelProperty> assetModelProperties() {
        return this.assetModelProperties;
    }

    public final boolean hasAssetModelHierarchies() {
        return this.assetModelHierarchies != null && !(this.assetModelHierarchies instanceof SdkAutoConstructList);
    }

    public final List<AssetModelHierarchy> assetModelHierarchies() {
        return this.assetModelHierarchies;
    }

    public final boolean hasAssetModelCompositeModels() {
        return this.assetModelCompositeModels != null && !(this.assetModelCompositeModels instanceof SdkAutoConstructList);
    }

    public final List<AssetModelCompositeModel> assetModelCompositeModels() {
        return this.assetModelCompositeModels;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    public final String ifMatch() {
        return this.ifMatch;
    }

    public final String ifNoneMatch() {
        return this.ifNoneMatch;
    }

    public final AssetModelVersionType matchForVersionType() {
        return AssetModelVersionType.fromValue(this.matchForVersionType);
    }

    public final String matchForVersionTypeAsString() {
        return this.matchForVersionType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.assetModelId());
        hashCode = 31 * hashCode + Objects.hashCode(this.assetModelExternalId());
        hashCode = 31 * hashCode + Objects.hashCode(this.assetModelName());
        hashCode = 31 * hashCode + Objects.hashCode(this.assetModelDescription());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAssetModelProperties() ? this.assetModelProperties() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAssetModelHierarchies() ? this.assetModelHierarchies() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAssetModelCompositeModels() ? this.assetModelCompositeModels() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.ifMatch());
        hashCode = 31 * hashCode + Objects.hashCode(this.ifNoneMatch());
        hashCode = 31 * hashCode + Objects.hashCode(this.matchForVersionTypeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateAssetModelRequest)) {
            return false;
        }
        UpdateAssetModelRequest other = (UpdateAssetModelRequest)((Object)obj);
        return Objects.equals(this.assetModelId(), other.assetModelId()) && Objects.equals(this.assetModelExternalId(), other.assetModelExternalId()) && Objects.equals(this.assetModelName(), other.assetModelName()) && Objects.equals(this.assetModelDescription(), other.assetModelDescription()) && this.hasAssetModelProperties() == other.hasAssetModelProperties() && Objects.equals(this.assetModelProperties(), other.assetModelProperties()) && this.hasAssetModelHierarchies() == other.hasAssetModelHierarchies() && Objects.equals(this.assetModelHierarchies(), other.assetModelHierarchies()) && this.hasAssetModelCompositeModels() == other.hasAssetModelCompositeModels() && Objects.equals(this.assetModelCompositeModels(), other.assetModelCompositeModels()) && Objects.equals(this.clientToken(), other.clientToken()) && Objects.equals(this.ifMatch(), other.ifMatch()) && Objects.equals(this.ifNoneMatch(), other.ifNoneMatch()) && Objects.equals(this.matchForVersionTypeAsString(), other.matchForVersionTypeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateAssetModelRequest").add("AssetModelId", (Object)this.assetModelId()).add("AssetModelExternalId", (Object)this.assetModelExternalId()).add("AssetModelName", (Object)this.assetModelName()).add("AssetModelDescription", (Object)this.assetModelDescription()).add("AssetModelProperties", this.hasAssetModelProperties() ? this.assetModelProperties() : null).add("AssetModelHierarchies", this.hasAssetModelHierarchies() ? this.assetModelHierarchies() : null).add("AssetModelCompositeModels", this.hasAssetModelCompositeModels() ? this.assetModelCompositeModels() : null).add("ClientToken", (Object)this.clientToken()).add("IfMatch", (Object)this.ifMatch()).add("IfNoneMatch", (Object)this.ifNoneMatch()).add("MatchForVersionType", (Object)this.matchForVersionTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "assetModelId": {
                return Optional.ofNullable(clazz.cast(this.assetModelId()));
            }
            case "assetModelExternalId": {
                return Optional.ofNullable(clazz.cast(this.assetModelExternalId()));
            }
            case "assetModelName": {
                return Optional.ofNullable(clazz.cast(this.assetModelName()));
            }
            case "assetModelDescription": {
                return Optional.ofNullable(clazz.cast(this.assetModelDescription()));
            }
            case "assetModelProperties": {
                return Optional.ofNullable(clazz.cast(this.assetModelProperties()));
            }
            case "assetModelHierarchies": {
                return Optional.ofNullable(clazz.cast(this.assetModelHierarchies()));
            }
            case "assetModelCompositeModels": {
                return Optional.ofNullable(clazz.cast(this.assetModelCompositeModels()));
            }
            case "clientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "ifMatch": {
                return Optional.ofNullable(clazz.cast(this.ifMatch()));
            }
            case "ifNoneMatch": {
                return Optional.ofNullable(clazz.cast(this.ifNoneMatch()));
            }
            case "matchForVersionType": {
                return Optional.ofNullable(clazz.cast(this.matchForVersionTypeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<UpdateAssetModelRequest, T> g) {
        return obj -> g.apply((UpdateAssetModelRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IoTSiteWiseRequest.BuilderImpl
    implements Builder {
        private String assetModelId;
        private String assetModelExternalId;
        private String assetModelName;
        private String assetModelDescription;
        private List<AssetModelProperty> assetModelProperties = DefaultSdkAutoConstructList.getInstance();
        private List<AssetModelHierarchy> assetModelHierarchies = DefaultSdkAutoConstructList.getInstance();
        private List<AssetModelCompositeModel> assetModelCompositeModels = DefaultSdkAutoConstructList.getInstance();
        private String clientToken;
        private String ifMatch;
        private String ifNoneMatch;
        private String matchForVersionType;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateAssetModelRequest model) {
            super(model);
            this.assetModelId(model.assetModelId);
            this.assetModelExternalId(model.assetModelExternalId);
            this.assetModelName(model.assetModelName);
            this.assetModelDescription(model.assetModelDescription);
            this.assetModelProperties(model.assetModelProperties);
            this.assetModelHierarchies(model.assetModelHierarchies);
            this.assetModelCompositeModels(model.assetModelCompositeModels);
            this.clientToken(model.clientToken);
            this.ifMatch(model.ifMatch);
            this.ifNoneMatch(model.ifNoneMatch);
            this.matchForVersionType(model.matchForVersionType);
        }

        public final String getAssetModelId() {
            return this.assetModelId;
        }

        public final void setAssetModelId(String assetModelId) {
            this.assetModelId = assetModelId;
        }

        @Override
        public final Builder assetModelId(String assetModelId) {
            this.assetModelId = assetModelId;
            return this;
        }

        public final String getAssetModelExternalId() {
            return this.assetModelExternalId;
        }

        public final void setAssetModelExternalId(String assetModelExternalId) {
            this.assetModelExternalId = assetModelExternalId;
        }

        @Override
        public final Builder assetModelExternalId(String assetModelExternalId) {
            this.assetModelExternalId = assetModelExternalId;
            return this;
        }

        public final String getAssetModelName() {
            return this.assetModelName;
        }

        public final void setAssetModelName(String assetModelName) {
            this.assetModelName = assetModelName;
        }

        @Override
        public final Builder assetModelName(String assetModelName) {
            this.assetModelName = assetModelName;
            return this;
        }

        public final String getAssetModelDescription() {
            return this.assetModelDescription;
        }

        public final void setAssetModelDescription(String assetModelDescription) {
            this.assetModelDescription = assetModelDescription;
        }

        @Override
        public final Builder assetModelDescription(String assetModelDescription) {
            this.assetModelDescription = assetModelDescription;
            return this;
        }

        public final List<AssetModelProperty.Builder> getAssetModelProperties() {
            List<AssetModelProperty.Builder> result = AssetModelPropertiesCopier.copyToBuilder(this.assetModelProperties);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAssetModelProperties(Collection<AssetModelProperty.BuilderImpl> assetModelProperties) {
            this.assetModelProperties = AssetModelPropertiesCopier.copyFromBuilder(assetModelProperties);
        }

        @Override
        public final Builder assetModelProperties(Collection<AssetModelProperty> assetModelProperties) {
            this.assetModelProperties = AssetModelPropertiesCopier.copy(assetModelProperties);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder assetModelProperties(AssetModelProperty ... assetModelProperties) {
            this.assetModelProperties(Arrays.asList(assetModelProperties));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder assetModelProperties(Consumer<AssetModelProperty.Builder> ... assetModelProperties) {
            this.assetModelProperties(Stream.of(assetModelProperties).map(c -> (AssetModelProperty)((AssetModelProperty.Builder)AssetModelProperty.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<AssetModelHierarchy.Builder> getAssetModelHierarchies() {
            List<AssetModelHierarchy.Builder> result = AssetModelHierarchiesCopier.copyToBuilder(this.assetModelHierarchies);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAssetModelHierarchies(Collection<AssetModelHierarchy.BuilderImpl> assetModelHierarchies) {
            this.assetModelHierarchies = AssetModelHierarchiesCopier.copyFromBuilder(assetModelHierarchies);
        }

        @Override
        public final Builder assetModelHierarchies(Collection<AssetModelHierarchy> assetModelHierarchies) {
            this.assetModelHierarchies = AssetModelHierarchiesCopier.copy(assetModelHierarchies);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder assetModelHierarchies(AssetModelHierarchy ... assetModelHierarchies) {
            this.assetModelHierarchies(Arrays.asList(assetModelHierarchies));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder assetModelHierarchies(Consumer<AssetModelHierarchy.Builder> ... assetModelHierarchies) {
            this.assetModelHierarchies(Stream.of(assetModelHierarchies).map(c -> (AssetModelHierarchy)((AssetModelHierarchy.Builder)AssetModelHierarchy.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<AssetModelCompositeModel.Builder> getAssetModelCompositeModels() {
            List<AssetModelCompositeModel.Builder> result = AssetModelCompositeModelsCopier.copyToBuilder(this.assetModelCompositeModels);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAssetModelCompositeModels(Collection<AssetModelCompositeModel.BuilderImpl> assetModelCompositeModels) {
            this.assetModelCompositeModels = AssetModelCompositeModelsCopier.copyFromBuilder(assetModelCompositeModels);
        }

        @Override
        public final Builder assetModelCompositeModels(Collection<AssetModelCompositeModel> assetModelCompositeModels) {
            this.assetModelCompositeModels = AssetModelCompositeModelsCopier.copy(assetModelCompositeModels);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder assetModelCompositeModels(AssetModelCompositeModel ... assetModelCompositeModels) {
            this.assetModelCompositeModels(Arrays.asList(assetModelCompositeModels));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder assetModelCompositeModels(Consumer<AssetModelCompositeModel.Builder> ... assetModelCompositeModels) {
            this.assetModelCompositeModels(Stream.of(assetModelCompositeModels).map(c -> (AssetModelCompositeModel)((AssetModelCompositeModel.Builder)AssetModelCompositeModel.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getIfMatch() {
            return this.ifMatch;
        }

        public final void setIfMatch(String ifMatch) {
            this.ifMatch = ifMatch;
        }

        @Override
        public final Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public final String getIfNoneMatch() {
            return this.ifNoneMatch;
        }

        public final void setIfNoneMatch(String ifNoneMatch) {
            this.ifNoneMatch = ifNoneMatch;
        }

        @Override
        public final Builder ifNoneMatch(String ifNoneMatch) {
            this.ifNoneMatch = ifNoneMatch;
            return this;
        }

        public final String getMatchForVersionType() {
            return this.matchForVersionType;
        }

        public final void setMatchForVersionType(String matchForVersionType) {
            this.matchForVersionType = matchForVersionType;
        }

        @Override
        public final Builder matchForVersionType(String matchForVersionType) {
            this.matchForVersionType = matchForVersionType;
            return this;
        }

        @Override
        public final Builder matchForVersionType(AssetModelVersionType matchForVersionType) {
            this.matchForVersionType(matchForVersionType == null ? null : matchForVersionType.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateAssetModelRequest build() {
            return new UpdateAssetModelRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends IoTSiteWiseRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateAssetModelRequest> {
        public Builder assetModelId(String var1);

        public Builder assetModelExternalId(String var1);

        public Builder assetModelName(String var1);

        public Builder assetModelDescription(String var1);

        public Builder assetModelProperties(Collection<AssetModelProperty> var1);

        public Builder assetModelProperties(AssetModelProperty ... var1);

        public Builder assetModelProperties(Consumer<AssetModelProperty.Builder> ... var1);

        public Builder assetModelHierarchies(Collection<AssetModelHierarchy> var1);

        public Builder assetModelHierarchies(AssetModelHierarchy ... var1);

        public Builder assetModelHierarchies(Consumer<AssetModelHierarchy.Builder> ... var1);

        public Builder assetModelCompositeModels(Collection<AssetModelCompositeModel> var1);

        public Builder assetModelCompositeModels(AssetModelCompositeModel ... var1);

        public Builder assetModelCompositeModels(Consumer<AssetModelCompositeModel.Builder> ... var1);

        public Builder clientToken(String var1);

        public Builder ifMatch(String var1);

        public Builder ifNoneMatch(String var1);

        public Builder matchForVersionType(String var1);

        public Builder matchForVersionType(AssetModelVersionType var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

