/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotsitewise.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.iotsitewise.IoTSiteWiseAsyncClient;
import software.amazon.awssdk.services.iotsitewise.internal.UserAgentUtils;
import software.amazon.awssdk.services.iotsitewise.model.ListProjectAssetsRequest;
import software.amazon.awssdk.services.iotsitewise.model.ListProjectAssetsResponse;

public class ListProjectAssetsPublisher
implements SdkPublisher<ListProjectAssetsResponse> {
    private final IoTSiteWiseAsyncClient client;
    private final ListProjectAssetsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListProjectAssetsPublisher(IoTSiteWiseAsyncClient client, ListProjectAssetsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListProjectAssetsPublisher(IoTSiteWiseAsyncClient client, ListProjectAssetsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListProjectAssetsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListProjectAssetsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<String> assetIds() {
        Function<ListProjectAssetsResponse, Iterator> getIterator = response -> {
            if (response != null && response.assetIds() != null) {
                return response.assetIds().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListProjectAssetsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListProjectAssetsResponseFetcher
    implements AsyncPageFetcher<ListProjectAssetsResponse> {
        private ListProjectAssetsResponseFetcher() {
        }

        public boolean hasNextPage(ListProjectAssetsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListProjectAssetsResponse> nextPage(ListProjectAssetsResponse previousPage) {
            if (previousPage == null) {
                return ListProjectAssetsPublisher.this.client.listProjectAssets(ListProjectAssetsPublisher.this.firstRequest);
            }
            return ListProjectAssetsPublisher.this.client.listProjectAssets((ListProjectAssetsRequest)((Object)ListProjectAssetsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

