/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotsitewise.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.iotsitewise.model.AssetModelPropertyPathCopier;
import software.amazon.awssdk.services.iotsitewise.model.AssetModelPropertyPathSegment;
import software.amazon.awssdk.services.iotsitewise.model.PropertyDataType;
import software.amazon.awssdk.services.iotsitewise.model.PropertyType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AssetModelProperty
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AssetModelProperty> {
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("id").getter(AssetModelProperty.getter(AssetModelProperty::id)).setter(AssetModelProperty.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(AssetModelProperty.getter(AssetModelProperty::name)).setter(AssetModelProperty.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> DATA_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("dataType").getter(AssetModelProperty.getter(AssetModelProperty::dataTypeAsString)).setter(AssetModelProperty.setter(Builder::dataType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataType").build()}).build();
    private static final SdkField<String> DATA_TYPE_SPEC_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("dataTypeSpec").getter(AssetModelProperty.getter(AssetModelProperty::dataTypeSpec)).setter(AssetModelProperty.setter(Builder::dataTypeSpec)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataTypeSpec").build()}).build();
    private static final SdkField<String> UNIT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("unit").getter(AssetModelProperty.getter(AssetModelProperty::unit)).setter(AssetModelProperty.setter(Builder::unit)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("unit").build()}).build();
    private static final SdkField<PropertyType> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("type").getter(AssetModelProperty.getter(AssetModelProperty::type)).setter(AssetModelProperty.setter(Builder::type)).constructor(PropertyType::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()}).build();
    private static final SdkField<List<AssetModelPropertyPathSegment>> PATH_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("path").getter(AssetModelProperty.getter(AssetModelProperty::path)).setter(AssetModelProperty.setter(Builder::path)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("path").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AssetModelPropertyPathSegment::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> EXTERNAL_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("externalId").getter(AssetModelProperty.getter(AssetModelProperty::externalId)).setter(AssetModelProperty.setter(Builder::externalId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("externalId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, NAME_FIELD, DATA_TYPE_FIELD, DATA_TYPE_SPEC_FIELD, UNIT_FIELD, TYPE_FIELD, PATH_FIELD, EXTERNAL_ID_FIELD));
    private static final long serialVersionUID = 1L;
    private final String id;
    private final String name;
    private final String dataType;
    private final String dataTypeSpec;
    private final String unit;
    private final PropertyType type;
    private final List<AssetModelPropertyPathSegment> path;
    private final String externalId;

    private AssetModelProperty(BuilderImpl builder) {
        this.id = builder.id;
        this.name = builder.name;
        this.dataType = builder.dataType;
        this.dataTypeSpec = builder.dataTypeSpec;
        this.unit = builder.unit;
        this.type = builder.type;
        this.path = builder.path;
        this.externalId = builder.externalId;
    }

    public final String id() {
        return this.id;
    }

    public final String name() {
        return this.name;
    }

    public final PropertyDataType dataType() {
        return PropertyDataType.fromValue(this.dataType);
    }

    public final String dataTypeAsString() {
        return this.dataType;
    }

    public final String dataTypeSpec() {
        return this.dataTypeSpec;
    }

    public final String unit() {
        return this.unit;
    }

    public final PropertyType type() {
        return this.type;
    }

    public final boolean hasPath() {
        return this.path != null && !(this.path instanceof SdkAutoConstructList);
    }

    public final List<AssetModelPropertyPathSegment> path() {
        return this.path;
    }

    public final String externalId() {
        return this.externalId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataTypeSpec());
        hashCode = 31 * hashCode + Objects.hashCode(this.unit());
        hashCode = 31 * hashCode + Objects.hashCode(this.type());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPath() ? this.path() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.externalId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssetModelProperty)) {
            return false;
        }
        AssetModelProperty other = (AssetModelProperty)obj;
        return Objects.equals(this.id(), other.id()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.dataTypeAsString(), other.dataTypeAsString()) && Objects.equals(this.dataTypeSpec(), other.dataTypeSpec()) && Objects.equals(this.unit(), other.unit()) && Objects.equals(this.type(), other.type()) && this.hasPath() == other.hasPath() && Objects.equals(this.path(), other.path()) && Objects.equals(this.externalId(), other.externalId());
    }

    public final String toString() {
        return ToString.builder((String)"AssetModelProperty").add("Id", (Object)this.id()).add("Name", (Object)this.name()).add("DataType", (Object)this.dataTypeAsString()).add("DataTypeSpec", (Object)this.dataTypeSpec()).add("Unit", (Object)this.unit()).add("Type", (Object)this.type()).add("Path", this.hasPath() ? this.path() : null).add("ExternalId", (Object)this.externalId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "dataType": {
                return Optional.ofNullable(clazz.cast(this.dataTypeAsString()));
            }
            case "dataTypeSpec": {
                return Optional.ofNullable(clazz.cast(this.dataTypeSpec()));
            }
            case "unit": {
                return Optional.ofNullable(clazz.cast(this.unit()));
            }
            case "type": {
                return Optional.ofNullable(clazz.cast(this.type()));
            }
            case "path": {
                return Optional.ofNullable(clazz.cast(this.path()));
            }
            case "externalId": {
                return Optional.ofNullable(clazz.cast(this.externalId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AssetModelProperty, T> g) {
        return obj -> g.apply((AssetModelProperty)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String id;
        private String name;
        private String dataType;
        private String dataTypeSpec;
        private String unit;
        private PropertyType type;
        private List<AssetModelPropertyPathSegment> path = DefaultSdkAutoConstructList.getInstance();
        private String externalId;

        private BuilderImpl() {
        }

        private BuilderImpl(AssetModelProperty model) {
            this.id(model.id);
            this.name(model.name);
            this.dataType(model.dataType);
            this.dataTypeSpec(model.dataTypeSpec);
            this.unit(model.unit);
            this.type(model.type);
            this.path(model.path);
            this.externalId(model.externalId);
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDataType() {
            return this.dataType;
        }

        public final void setDataType(String dataType) {
            this.dataType = dataType;
        }

        @Override
        public final Builder dataType(String dataType) {
            this.dataType = dataType;
            return this;
        }

        @Override
        public final Builder dataType(PropertyDataType dataType) {
            this.dataType(dataType == null ? null : dataType.toString());
            return this;
        }

        public final String getDataTypeSpec() {
            return this.dataTypeSpec;
        }

        public final void setDataTypeSpec(String dataTypeSpec) {
            this.dataTypeSpec = dataTypeSpec;
        }

        @Override
        public final Builder dataTypeSpec(String dataTypeSpec) {
            this.dataTypeSpec = dataTypeSpec;
            return this;
        }

        public final String getUnit() {
            return this.unit;
        }

        public final void setUnit(String unit) {
            this.unit = unit;
        }

        @Override
        public final Builder unit(String unit) {
            this.unit = unit;
            return this;
        }

        public final PropertyType.Builder getType() {
            return this.type != null ? this.type.toBuilder() : null;
        }

        public final void setType(PropertyType.BuilderImpl type) {
            this.type = type != null ? type.build() : null;
        }

        @Override
        public final Builder type(PropertyType type) {
            this.type = type;
            return this;
        }

        public final List<AssetModelPropertyPathSegment.Builder> getPath() {
            List<AssetModelPropertyPathSegment.Builder> result = AssetModelPropertyPathCopier.copyToBuilder(this.path);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPath(Collection<AssetModelPropertyPathSegment.BuilderImpl> path) {
            this.path = AssetModelPropertyPathCopier.copyFromBuilder(path);
        }

        @Override
        public final Builder path(Collection<AssetModelPropertyPathSegment> path) {
            this.path = AssetModelPropertyPathCopier.copy(path);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder path(AssetModelPropertyPathSegment ... path) {
            this.path(Arrays.asList(path));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder path(Consumer<AssetModelPropertyPathSegment.Builder> ... path) {
            this.path(Stream.of(path).map(c -> (AssetModelPropertyPathSegment)((AssetModelPropertyPathSegment.Builder)AssetModelPropertyPathSegment.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getExternalId() {
            return this.externalId;
        }

        public final void setExternalId(String externalId) {
            this.externalId = externalId;
        }

        @Override
        public final Builder externalId(String externalId) {
            this.externalId = externalId;
            return this;
        }

        public AssetModelProperty build() {
            return new AssetModelProperty(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AssetModelProperty> {
        public Builder id(String var1);

        public Builder name(String var1);

        public Builder dataType(String var1);

        public Builder dataType(PropertyDataType var1);

        public Builder dataTypeSpec(String var1);

        public Builder unit(String var1);

        public Builder type(PropertyType var1);

        default public Builder type(Consumer<PropertyType.Builder> type) {
            return this.type((PropertyType)((PropertyType.Builder)PropertyType.builder().applyMutation(type)).build());
        }

        public Builder path(Collection<AssetModelPropertyPathSegment> var1);

        public Builder path(AssetModelPropertyPathSegment ... var1);

        public Builder path(Consumer<AssetModelPropertyPathSegment.Builder> ... var1);

        public Builder externalId(String var1);
    }
}

