/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotsitewise.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.iotsitewise.model.AssetModelPropertyPathCopier;
import software.amazon.awssdk.services.iotsitewise.model.AssetModelPropertyPathSegment;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class VariableValue
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, VariableValue> {
    private static final SdkField<String> PROPERTY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("propertyId").getter(VariableValue.getter(VariableValue::propertyId)).setter(VariableValue.setter(Builder::propertyId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("propertyId").build()}).build();
    private static final SdkField<String> HIERARCHY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("hierarchyId").getter(VariableValue.getter(VariableValue::hierarchyId)).setter(VariableValue.setter(Builder::hierarchyId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("hierarchyId").build()}).build();
    private static final SdkField<List<AssetModelPropertyPathSegment>> PROPERTY_PATH_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("propertyPath").getter(VariableValue.getter(VariableValue::propertyPath)).setter(VariableValue.setter(Builder::propertyPath)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("propertyPath").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AssetModelPropertyPathSegment::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROPERTY_ID_FIELD, HIERARCHY_ID_FIELD, PROPERTY_PATH_FIELD));
    private static final long serialVersionUID = 1L;
    private final String propertyId;
    private final String hierarchyId;
    private final List<AssetModelPropertyPathSegment> propertyPath;

    private VariableValue(BuilderImpl builder) {
        this.propertyId = builder.propertyId;
        this.hierarchyId = builder.hierarchyId;
        this.propertyPath = builder.propertyPath;
    }

    public final String propertyId() {
        return this.propertyId;
    }

    public final String hierarchyId() {
        return this.hierarchyId;
    }

    public final boolean hasPropertyPath() {
        return this.propertyPath != null && !(this.propertyPath instanceof SdkAutoConstructList);
    }

    public final List<AssetModelPropertyPathSegment> propertyPath() {
        return this.propertyPath;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.propertyId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hierarchyId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPropertyPath() ? this.propertyPath() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VariableValue)) {
            return false;
        }
        VariableValue other = (VariableValue)obj;
        return Objects.equals(this.propertyId(), other.propertyId()) && Objects.equals(this.hierarchyId(), other.hierarchyId()) && this.hasPropertyPath() == other.hasPropertyPath() && Objects.equals(this.propertyPath(), other.propertyPath());
    }

    public final String toString() {
        return ToString.builder((String)"VariableValue").add("PropertyId", (Object)this.propertyId()).add("HierarchyId", (Object)this.hierarchyId()).add("PropertyPath", this.hasPropertyPath() ? this.propertyPath() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "propertyId": {
                return Optional.ofNullable(clazz.cast(this.propertyId()));
            }
            case "hierarchyId": {
                return Optional.ofNullable(clazz.cast(this.hierarchyId()));
            }
            case "propertyPath": {
                return Optional.ofNullable(clazz.cast(this.propertyPath()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<VariableValue, T> g) {
        return obj -> g.apply((VariableValue)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String propertyId;
        private String hierarchyId;
        private List<AssetModelPropertyPathSegment> propertyPath = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(VariableValue model) {
            this.propertyId(model.propertyId);
            this.hierarchyId(model.hierarchyId);
            this.propertyPath(model.propertyPath);
        }

        public final String getPropertyId() {
            return this.propertyId;
        }

        public final void setPropertyId(String propertyId) {
            this.propertyId = propertyId;
        }

        @Override
        public final Builder propertyId(String propertyId) {
            this.propertyId = propertyId;
            return this;
        }

        public final String getHierarchyId() {
            return this.hierarchyId;
        }

        public final void setHierarchyId(String hierarchyId) {
            this.hierarchyId = hierarchyId;
        }

        @Override
        public final Builder hierarchyId(String hierarchyId) {
            this.hierarchyId = hierarchyId;
            return this;
        }

        public final List<AssetModelPropertyPathSegment.Builder> getPropertyPath() {
            List<AssetModelPropertyPathSegment.Builder> result = AssetModelPropertyPathCopier.copyToBuilder(this.propertyPath);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPropertyPath(Collection<AssetModelPropertyPathSegment.BuilderImpl> propertyPath) {
            this.propertyPath = AssetModelPropertyPathCopier.copyFromBuilder(propertyPath);
        }

        @Override
        public final Builder propertyPath(Collection<AssetModelPropertyPathSegment> propertyPath) {
            this.propertyPath = AssetModelPropertyPathCopier.copy(propertyPath);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder propertyPath(AssetModelPropertyPathSegment ... propertyPath) {
            this.propertyPath(Arrays.asList(propertyPath));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder propertyPath(Consumer<AssetModelPropertyPathSegment.Builder> ... propertyPath) {
            this.propertyPath(Stream.of(propertyPath).map(c -> (AssetModelPropertyPathSegment)((AssetModelPropertyPathSegment.Builder)AssetModelPropertyPathSegment.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public VariableValue build() {
            return new VariableValue(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, VariableValue> {
        public Builder propertyId(String var1);

        public Builder hierarchyId(String var1);

        public Builder propertyPath(Collection<AssetModelPropertyPathSegment> var1);

        public Builder propertyPath(AssetModelPropertyPathSegment ... var1);

        public Builder propertyPath(Consumer<AssetModelPropertyPathSegment.Builder> ... var1);
    }
}

