/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotsitewise.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.iotsitewise.model.IdentityType;
import software.amazon.awssdk.services.iotsitewise.model.IoTSiteWiseRequest;
import software.amazon.awssdk.services.iotsitewise.model.ResourceType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListAccessPoliciesRequest
extends IoTSiteWiseRequest
implements ToCopyableBuilder<Builder, ListAccessPoliciesRequest> {
    private static final SdkField<String> IDENTITY_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("identityType").getter(ListAccessPoliciesRequest.getter(ListAccessPoliciesRequest::identityTypeAsString)).setter(ListAccessPoliciesRequest.setter(Builder::identityType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("identityType").build()}).build();
    private static final SdkField<String> IDENTITY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("identityId").getter(ListAccessPoliciesRequest.getter(ListAccessPoliciesRequest::identityId)).setter(ListAccessPoliciesRequest.setter(Builder::identityId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("identityId").build()}).build();
    private static final SdkField<String> RESOURCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("resourceType").getter(ListAccessPoliciesRequest.getter(ListAccessPoliciesRequest::resourceTypeAsString)).setter(ListAccessPoliciesRequest.setter(Builder::resourceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("resourceType").build()}).build();
    private static final SdkField<String> RESOURCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("resourceId").getter(ListAccessPoliciesRequest.getter(ListAccessPoliciesRequest::resourceId)).setter(ListAccessPoliciesRequest.setter(Builder::resourceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("resourceId").build()}).build();
    private static final SdkField<String> IAM_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("iamArn").getter(ListAccessPoliciesRequest.getter(ListAccessPoliciesRequest::iamArn)).setter(ListAccessPoliciesRequest.setter(Builder::iamArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("iamArn").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListAccessPoliciesRequest.getter(ListAccessPoliciesRequest::nextToken)).setter(ListAccessPoliciesRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("nextToken").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("maxResults").getter(ListAccessPoliciesRequest.getter(ListAccessPoliciesRequest::maxResults)).setter(ListAccessPoliciesRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("maxResults").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IDENTITY_TYPE_FIELD, IDENTITY_ID_FIELD, RESOURCE_TYPE_FIELD, RESOURCE_ID_FIELD, IAM_ARN_FIELD, NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD));
    private final String identityType;
    private final String identityId;
    private final String resourceType;
    private final String resourceId;
    private final String iamArn;
    private final String nextToken;
    private final Integer maxResults;

    private ListAccessPoliciesRequest(BuilderImpl builder) {
        super(builder);
        this.identityType = builder.identityType;
        this.identityId = builder.identityId;
        this.resourceType = builder.resourceType;
        this.resourceId = builder.resourceId;
        this.iamArn = builder.iamArn;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
    }

    public final IdentityType identityType() {
        return IdentityType.fromValue(this.identityType);
    }

    public final String identityTypeAsString() {
        return this.identityType;
    }

    public final String identityId() {
        return this.identityId;
    }

    public final ResourceType resourceType() {
        return ResourceType.fromValue(this.resourceType);
    }

    public final String resourceTypeAsString() {
        return this.resourceType;
    }

    public final String resourceId() {
        return this.resourceId;
    }

    public final String iamArn() {
        return this.iamArn;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.identityTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.identityId());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.iamArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListAccessPoliciesRequest)) {
            return false;
        }
        ListAccessPoliciesRequest other = (ListAccessPoliciesRequest)((Object)obj);
        return Objects.equals(this.identityTypeAsString(), other.identityTypeAsString()) && Objects.equals(this.identityId(), other.identityId()) && Objects.equals(this.resourceTypeAsString(), other.resourceTypeAsString()) && Objects.equals(this.resourceId(), other.resourceId()) && Objects.equals(this.iamArn(), other.iamArn()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.maxResults(), other.maxResults());
    }

    public final String toString() {
        return ToString.builder((String)"ListAccessPoliciesRequest").add("IdentityType", (Object)this.identityTypeAsString()).add("IdentityId", (Object)this.identityId()).add("ResourceType", (Object)this.resourceTypeAsString()).add("ResourceId", (Object)this.resourceId()).add("IamArn", (Object)this.iamArn()).add("NextToken", (Object)this.nextToken()).add("MaxResults", (Object)this.maxResults()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "identityType": {
                return Optional.ofNullable(clazz.cast(this.identityTypeAsString()));
            }
            case "identityId": {
                return Optional.ofNullable(clazz.cast(this.identityId()));
            }
            case "resourceType": {
                return Optional.ofNullable(clazz.cast(this.resourceTypeAsString()));
            }
            case "resourceId": {
                return Optional.ofNullable(clazz.cast(this.resourceId()));
            }
            case "iamArn": {
                return Optional.ofNullable(clazz.cast(this.iamArn()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "maxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListAccessPoliciesRequest, T> g) {
        return obj -> g.apply((ListAccessPoliciesRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IoTSiteWiseRequest.BuilderImpl
    implements Builder {
        private String identityType;
        private String identityId;
        private String resourceType;
        private String resourceId;
        private String iamArn;
        private String nextToken;
        private Integer maxResults;

        private BuilderImpl() {
        }

        private BuilderImpl(ListAccessPoliciesRequest model) {
            super(model);
            this.identityType(model.identityType);
            this.identityId(model.identityId);
            this.resourceType(model.resourceType);
            this.resourceId(model.resourceId);
            this.iamArn(model.iamArn);
            this.nextToken(model.nextToken);
            this.maxResults(model.maxResults);
        }

        public final String getIdentityType() {
            return this.identityType;
        }

        public final void setIdentityType(String identityType) {
            this.identityType = identityType;
        }

        @Override
        public final Builder identityType(String identityType) {
            this.identityType = identityType;
            return this;
        }

        @Override
        public final Builder identityType(IdentityType identityType) {
            this.identityType(identityType == null ? null : identityType.toString());
            return this;
        }

        public final String getIdentityId() {
            return this.identityId;
        }

        public final void setIdentityId(String identityId) {
            this.identityId = identityId;
        }

        @Override
        public final Builder identityId(String identityId) {
            this.identityId = identityId;
            return this;
        }

        public final String getResourceType() {
            return this.resourceType;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        @Override
        public final Builder resourceType(ResourceType resourceType) {
            this.resourceType(resourceType == null ? null : resourceType.toString());
            return this;
        }

        public final String getResourceId() {
            return this.resourceId;
        }

        public final void setResourceId(String resourceId) {
            this.resourceId = resourceId;
        }

        @Override
        public final Builder resourceId(String resourceId) {
            this.resourceId = resourceId;
            return this;
        }

        public final String getIamArn() {
            return this.iamArn;
        }

        public final void setIamArn(String iamArn) {
            this.iamArn = iamArn;
        }

        @Override
        public final Builder iamArn(String iamArn) {
            this.iamArn = iamArn;
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListAccessPoliciesRequest build() {
            return new ListAccessPoliciesRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends IoTSiteWiseRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListAccessPoliciesRequest> {
        public Builder identityType(String var1);

        public Builder identityType(IdentityType var1);

        public Builder identityId(String var1);

        public Builder resourceType(String var1);

        public Builder resourceType(ResourceType var1);

        public Builder resourceId(String var1);

        public Builder iamArn(String var1);

        public Builder nextToken(String var1);

        public Builder maxResults(Integer var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

