/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotsitewise.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.iotsitewise.IoTSiteWiseClient;
import software.amazon.awssdk.services.iotsitewise.internal.UserAgentUtils;
import software.amazon.awssdk.services.iotsitewise.model.AssetPropertySummary;
import software.amazon.awssdk.services.iotsitewise.model.ListAssetPropertiesRequest;
import software.amazon.awssdk.services.iotsitewise.model.ListAssetPropertiesResponse;

public class ListAssetPropertiesIterable
implements SdkIterable<ListAssetPropertiesResponse> {
    private final IoTSiteWiseClient client;
    private final ListAssetPropertiesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListAssetPropertiesIterable(IoTSiteWiseClient client, ListAssetPropertiesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListAssetPropertiesResponseFetcher();
    }

    public Iterator<ListAssetPropertiesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<AssetPropertySummary> assetPropertySummaries() {
        Function<ListAssetPropertiesResponse, Iterator> getIterator = response -> {
            if (response != null && response.assetPropertySummaries() != null) {
                return response.assetPropertySummaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListAssetPropertiesResponseFetcher
    implements SyncPageFetcher<ListAssetPropertiesResponse> {
        private ListAssetPropertiesResponseFetcher() {
        }

        public boolean hasNextPage(ListAssetPropertiesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListAssetPropertiesResponse nextPage(ListAssetPropertiesResponse previousPage) {
            if (previousPage == null) {
                return ListAssetPropertiesIterable.this.client.listAssetProperties(ListAssetPropertiesIterable.this.firstRequest);
            }
            return ListAssetPropertiesIterable.this.client.listAssetProperties((ListAssetPropertiesRequest)((Object)ListAssetPropertiesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

