/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotsitewise.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains success information for an entry that is associated with the <a
 * href="https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_BatchGetAssetPropertyAggregates.html"
 * >BatchGetAssetPropertyAggregates</a> API.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchGetAssetPropertyAggregatesSuccessEntry implements SdkPojo, Serializable,
        ToCopyableBuilder<BatchGetAssetPropertyAggregatesSuccessEntry.Builder, BatchGetAssetPropertyAggregatesSuccessEntry> {
    private static final SdkField<String> ENTRY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("entryId").getter(getter(BatchGetAssetPropertyAggregatesSuccessEntry::entryId))
            .setter(setter(Builder::entryId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("entryId").build()).build();

    private static final SdkField<List<AggregatedValue>> AGGREGATED_VALUES_FIELD = SdkField
            .<List<AggregatedValue>> builder(MarshallingType.LIST)
            .memberName("aggregatedValues")
            .getter(getter(BatchGetAssetPropertyAggregatesSuccessEntry::aggregatedValues))
            .setter(setter(Builder::aggregatedValues))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("aggregatedValues").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AggregatedValue> builder(MarshallingType.SDK_POJO)
                                            .constructor(AggregatedValue::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENTRY_ID_FIELD,
            AGGREGATED_VALUES_FIELD));

    private static final long serialVersionUID = 1L;

    private final String entryId;

    private final List<AggregatedValue> aggregatedValues;

    private BatchGetAssetPropertyAggregatesSuccessEntry(BuilderImpl builder) {
        this.entryId = builder.entryId;
        this.aggregatedValues = builder.aggregatedValues;
    }

    /**
     * <p>
     * The ID of the entry.
     * </p>
     * 
     * @return The ID of the entry.
     */
    public final String entryId() {
        return entryId;
    }

    /**
     * For responses, this returns true if the service returned a value for the AggregatedValues property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAggregatedValues() {
        return aggregatedValues != null && !(aggregatedValues instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The requested aggregated asset property values (for example, average, minimum, and maximum).
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAggregatedValues} method.
     * </p>
     * 
     * @return The requested aggregated asset property values (for example, average, minimum, and maximum).
     */
    public final List<AggregatedValue> aggregatedValues() {
        return aggregatedValues;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(entryId());
        hashCode = 31 * hashCode + Objects.hashCode(hasAggregatedValues() ? aggregatedValues() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchGetAssetPropertyAggregatesSuccessEntry)) {
            return false;
        }
        BatchGetAssetPropertyAggregatesSuccessEntry other = (BatchGetAssetPropertyAggregatesSuccessEntry) obj;
        return Objects.equals(entryId(), other.entryId()) && hasAggregatedValues() == other.hasAggregatedValues()
                && Objects.equals(aggregatedValues(), other.aggregatedValues());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BatchGetAssetPropertyAggregatesSuccessEntry").add("EntryId", entryId())
                .add("AggregatedValues", hasAggregatedValues() ? aggregatedValues() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "entryId":
            return Optional.ofNullable(clazz.cast(entryId()));
        case "aggregatedValues":
            return Optional.ofNullable(clazz.cast(aggregatedValues()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BatchGetAssetPropertyAggregatesSuccessEntry, T> g) {
        return obj -> g.apply((BatchGetAssetPropertyAggregatesSuccessEntry) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, BatchGetAssetPropertyAggregatesSuccessEntry> {
        /**
         * <p>
         * The ID of the entry.
         * </p>
         * 
         * @param entryId
         *        The ID of the entry.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder entryId(String entryId);

        /**
         * <p>
         * The requested aggregated asset property values (for example, average, minimum, and maximum).
         * </p>
         * 
         * @param aggregatedValues
         *        The requested aggregated asset property values (for example, average, minimum, and maximum).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder aggregatedValues(Collection<AggregatedValue> aggregatedValues);

        /**
         * <p>
         * The requested aggregated asset property values (for example, average, minimum, and maximum).
         * </p>
         * 
         * @param aggregatedValues
         *        The requested aggregated asset property values (for example, average, minimum, and maximum).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder aggregatedValues(AggregatedValue... aggregatedValues);

        /**
         * <p>
         * The requested aggregated asset property values (for example, average, minimum, and maximum).
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.iotsitewise.model.AggregatedValue.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.iotsitewise.model.AggregatedValue#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.iotsitewise.model.AggregatedValue.Builder#build()} is called
         * immediately and its result is passed to {@link #aggregatedValues(List<AggregatedValue>)}.
         * 
         * @param aggregatedValues
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.iotsitewise.model.AggregatedValue.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #aggregatedValues(java.util.Collection<AggregatedValue>)
         */
        Builder aggregatedValues(Consumer<AggregatedValue.Builder>... aggregatedValues);
    }

    static final class BuilderImpl implements Builder {
        private String entryId;

        private List<AggregatedValue> aggregatedValues = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchGetAssetPropertyAggregatesSuccessEntry model) {
            entryId(model.entryId);
            aggregatedValues(model.aggregatedValues);
        }

        public final String getEntryId() {
            return entryId;
        }

        public final void setEntryId(String entryId) {
            this.entryId = entryId;
        }

        @Override
        public final Builder entryId(String entryId) {
            this.entryId = entryId;
            return this;
        }

        public final List<AggregatedValue.Builder> getAggregatedValues() {
            List<AggregatedValue.Builder> result = AggregatedValuesCopier.copyToBuilder(this.aggregatedValues);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAggregatedValues(Collection<AggregatedValue.BuilderImpl> aggregatedValues) {
            this.aggregatedValues = AggregatedValuesCopier.copyFromBuilder(aggregatedValues);
        }

        @Override
        public final Builder aggregatedValues(Collection<AggregatedValue> aggregatedValues) {
            this.aggregatedValues = AggregatedValuesCopier.copy(aggregatedValues);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder aggregatedValues(AggregatedValue... aggregatedValues) {
            aggregatedValues(Arrays.asList(aggregatedValues));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder aggregatedValues(Consumer<AggregatedValue.Builder>... aggregatedValues) {
            aggregatedValues(Stream.of(aggregatedValues).map(c -> AggregatedValue.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public BatchGetAssetPropertyAggregatesSuccessEntry build() {
            return new BatchGetAssetPropertyAggregatesSuccessEntry(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
