/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotsitewise;

import java.util.Collections;
import java.util.List;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.handler.AwsSyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.client.handler.SyncClientHandler;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.services.iotsitewise.model.AssociateAssetsRequest;
import software.amazon.awssdk.services.iotsitewise.model.AssociateAssetsResponse;
import software.amazon.awssdk.services.iotsitewise.model.AssociateTimeSeriesToAssetPropertyRequest;
import software.amazon.awssdk.services.iotsitewise.model.AssociateTimeSeriesToAssetPropertyResponse;
import software.amazon.awssdk.services.iotsitewise.model.BatchAssociateProjectAssetsRequest;
import software.amazon.awssdk.services.iotsitewise.model.BatchAssociateProjectAssetsResponse;
import software.amazon.awssdk.services.iotsitewise.model.BatchDisassociateProjectAssetsRequest;
import software.amazon.awssdk.services.iotsitewise.model.BatchDisassociateProjectAssetsResponse;
import software.amazon.awssdk.services.iotsitewise.model.BatchGetAssetPropertyAggregatesRequest;
import software.amazon.awssdk.services.iotsitewise.model.BatchGetAssetPropertyAggregatesResponse;
import software.amazon.awssdk.services.iotsitewise.model.BatchGetAssetPropertyValueHistoryRequest;
import software.amazon.awssdk.services.iotsitewise.model.BatchGetAssetPropertyValueHistoryResponse;
import software.amazon.awssdk.services.iotsitewise.model.BatchGetAssetPropertyValueRequest;
import software.amazon.awssdk.services.iotsitewise.model.BatchGetAssetPropertyValueResponse;
import software.amazon.awssdk.services.iotsitewise.model.BatchPutAssetPropertyValueRequest;
import software.amazon.awssdk.services.iotsitewise.model.BatchPutAssetPropertyValueResponse;
import software.amazon.awssdk.services.iotsitewise.model.ConflictingOperationException;
import software.amazon.awssdk.services.iotsitewise.model.CreateAccessPolicyRequest;
import software.amazon.awssdk.services.iotsitewise.model.CreateAccessPolicyResponse;
import software.amazon.awssdk.services.iotsitewise.model.CreateAssetModelRequest;
import software.amazon.awssdk.services.iotsitewise.model.CreateAssetModelResponse;
import software.amazon.awssdk.services.iotsitewise.model.CreateAssetRequest;
import software.amazon.awssdk.services.iotsitewise.model.CreateAssetResponse;
import software.amazon.awssdk.services.iotsitewise.model.CreateBulkImportJobRequest;
import software.amazon.awssdk.services.iotsitewise.model.CreateBulkImportJobResponse;
import software.amazon.awssdk.services.iotsitewise.model.CreateDashboardRequest;
import software.amazon.awssdk.services.iotsitewise.model.CreateDashboardResponse;
import software.amazon.awssdk.services.iotsitewise.model.CreateGatewayRequest;
import software.amazon.awssdk.services.iotsitewise.model.CreateGatewayResponse;
import software.amazon.awssdk.services.iotsitewise.model.CreatePortalRequest;
import software.amazon.awssdk.services.iotsitewise.model.CreatePortalResponse;
import software.amazon.awssdk.services.iotsitewise.model.CreateProjectRequest;
import software.amazon.awssdk.services.iotsitewise.model.CreateProjectResponse;
import software.amazon.awssdk.services.iotsitewise.model.DeleteAccessPolicyRequest;
import software.amazon.awssdk.services.iotsitewise.model.DeleteAccessPolicyResponse;
import software.amazon.awssdk.services.iotsitewise.model.DeleteAssetModelRequest;
import software.amazon.awssdk.services.iotsitewise.model.DeleteAssetModelResponse;
import software.amazon.awssdk.services.iotsitewise.model.DeleteAssetRequest;
import software.amazon.awssdk.services.iotsitewise.model.DeleteAssetResponse;
import software.amazon.awssdk.services.iotsitewise.model.DeleteDashboardRequest;
import software.amazon.awssdk.services.iotsitewise.model.DeleteDashboardResponse;
import software.amazon.awssdk.services.iotsitewise.model.DeleteGatewayRequest;
import software.amazon.awssdk.services.iotsitewise.model.DeleteGatewayResponse;
import software.amazon.awssdk.services.iotsitewise.model.DeletePortalRequest;
import software.amazon.awssdk.services.iotsitewise.model.DeletePortalResponse;
import software.amazon.awssdk.services.iotsitewise.model.DeleteProjectRequest;
import software.amazon.awssdk.services.iotsitewise.model.DeleteProjectResponse;
import software.amazon.awssdk.services.iotsitewise.model.DeleteTimeSeriesRequest;
import software.amazon.awssdk.services.iotsitewise.model.DeleteTimeSeriesResponse;
import software.amazon.awssdk.services.iotsitewise.model.DescribeAccessPolicyRequest;
import software.amazon.awssdk.services.iotsitewise.model.DescribeAccessPolicyResponse;
import software.amazon.awssdk.services.iotsitewise.model.DescribeAssetModelRequest;
import software.amazon.awssdk.services.iotsitewise.model.DescribeAssetModelResponse;
import software.amazon.awssdk.services.iotsitewise.model.DescribeAssetPropertyRequest;
import software.amazon.awssdk.services.iotsitewise.model.DescribeAssetPropertyResponse;
import software.amazon.awssdk.services.iotsitewise.model.DescribeAssetRequest;
import software.amazon.awssdk.services.iotsitewise.model.DescribeAssetResponse;
import software.amazon.awssdk.services.iotsitewise.model.DescribeBulkImportJobRequest;
import software.amazon.awssdk.services.iotsitewise.model.DescribeBulkImportJobResponse;
import software.amazon.awssdk.services.iotsitewise.model.DescribeDashboardRequest;
import software.amazon.awssdk.services.iotsitewise.model.DescribeDashboardResponse;
import software.amazon.awssdk.services.iotsitewise.model.DescribeDefaultEncryptionConfigurationRequest;
import software.amazon.awssdk.services.iotsitewise.model.DescribeDefaultEncryptionConfigurationResponse;
import software.amazon.awssdk.services.iotsitewise.model.DescribeGatewayCapabilityConfigurationRequest;
import software.amazon.awssdk.services.iotsitewise.model.DescribeGatewayCapabilityConfigurationResponse;
import software.amazon.awssdk.services.iotsitewise.model.DescribeGatewayRequest;
import software.amazon.awssdk.services.iotsitewise.model.DescribeGatewayResponse;
import software.amazon.awssdk.services.iotsitewise.model.DescribeLoggingOptionsRequest;
import software.amazon.awssdk.services.iotsitewise.model.DescribeLoggingOptionsResponse;
import software.amazon.awssdk.services.iotsitewise.model.DescribePortalRequest;
import software.amazon.awssdk.services.iotsitewise.model.DescribePortalResponse;
import software.amazon.awssdk.services.iotsitewise.model.DescribeProjectRequest;
import software.amazon.awssdk.services.iotsitewise.model.DescribeProjectResponse;
import software.amazon.awssdk.services.iotsitewise.model.DescribeStorageConfigurationRequest;
import software.amazon.awssdk.services.iotsitewise.model.DescribeStorageConfigurationResponse;
import software.amazon.awssdk.services.iotsitewise.model.DescribeTimeSeriesRequest;
import software.amazon.awssdk.services.iotsitewise.model.DescribeTimeSeriesResponse;
import software.amazon.awssdk.services.iotsitewise.model.DisassociateAssetsRequest;
import software.amazon.awssdk.services.iotsitewise.model.DisassociateAssetsResponse;
import software.amazon.awssdk.services.iotsitewise.model.DisassociateTimeSeriesFromAssetPropertyRequest;
import software.amazon.awssdk.services.iotsitewise.model.DisassociateTimeSeriesFromAssetPropertyResponse;
import software.amazon.awssdk.services.iotsitewise.model.GetAssetPropertyAggregatesRequest;
import software.amazon.awssdk.services.iotsitewise.model.GetAssetPropertyAggregatesResponse;
import software.amazon.awssdk.services.iotsitewise.model.GetAssetPropertyValueHistoryRequest;
import software.amazon.awssdk.services.iotsitewise.model.GetAssetPropertyValueHistoryResponse;
import software.amazon.awssdk.services.iotsitewise.model.GetAssetPropertyValueRequest;
import software.amazon.awssdk.services.iotsitewise.model.GetAssetPropertyValueResponse;
import software.amazon.awssdk.services.iotsitewise.model.GetInterpolatedAssetPropertyValuesRequest;
import software.amazon.awssdk.services.iotsitewise.model.GetInterpolatedAssetPropertyValuesResponse;
import software.amazon.awssdk.services.iotsitewise.model.InternalFailureException;
import software.amazon.awssdk.services.iotsitewise.model.InvalidRequestException;
import software.amazon.awssdk.services.iotsitewise.model.IoTSiteWiseException;
import software.amazon.awssdk.services.iotsitewise.model.LimitExceededException;
import software.amazon.awssdk.services.iotsitewise.model.ListAccessPoliciesRequest;
import software.amazon.awssdk.services.iotsitewise.model.ListAccessPoliciesResponse;
import software.amazon.awssdk.services.iotsitewise.model.ListAssetModelPropertiesRequest;
import software.amazon.awssdk.services.iotsitewise.model.ListAssetModelPropertiesResponse;
import software.amazon.awssdk.services.iotsitewise.model.ListAssetModelsRequest;
import software.amazon.awssdk.services.iotsitewise.model.ListAssetModelsResponse;
import software.amazon.awssdk.services.iotsitewise.model.ListAssetPropertiesRequest;
import software.amazon.awssdk.services.iotsitewise.model.ListAssetPropertiesResponse;
import software.amazon.awssdk.services.iotsitewise.model.ListAssetRelationshipsRequest;
import software.amazon.awssdk.services.iotsitewise.model.ListAssetRelationshipsResponse;
import software.amazon.awssdk.services.iotsitewise.model.ListAssetsRequest;
import software.amazon.awssdk.services.iotsitewise.model.ListAssetsResponse;
import software.amazon.awssdk.services.iotsitewise.model.ListAssociatedAssetsRequest;
import software.amazon.awssdk.services.iotsitewise.model.ListAssociatedAssetsResponse;
import software.amazon.awssdk.services.iotsitewise.model.ListBulkImportJobsRequest;
import software.amazon.awssdk.services.iotsitewise.model.ListBulkImportJobsResponse;
import software.amazon.awssdk.services.iotsitewise.model.ListDashboardsRequest;
import software.amazon.awssdk.services.iotsitewise.model.ListDashboardsResponse;
import software.amazon.awssdk.services.iotsitewise.model.ListGatewaysRequest;
import software.amazon.awssdk.services.iotsitewise.model.ListGatewaysResponse;
import software.amazon.awssdk.services.iotsitewise.model.ListPortalsRequest;
import software.amazon.awssdk.services.iotsitewise.model.ListPortalsResponse;
import software.amazon.awssdk.services.iotsitewise.model.ListProjectAssetsRequest;
import software.amazon.awssdk.services.iotsitewise.model.ListProjectAssetsResponse;
import software.amazon.awssdk.services.iotsitewise.model.ListProjectsRequest;
import software.amazon.awssdk.services.iotsitewise.model.ListProjectsResponse;
import software.amazon.awssdk.services.iotsitewise.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.iotsitewise.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.iotsitewise.model.ListTimeSeriesRequest;
import software.amazon.awssdk.services.iotsitewise.model.ListTimeSeriesResponse;
import software.amazon.awssdk.services.iotsitewise.model.PutDefaultEncryptionConfigurationRequest;
import software.amazon.awssdk.services.iotsitewise.model.PutDefaultEncryptionConfigurationResponse;
import software.amazon.awssdk.services.iotsitewise.model.PutLoggingOptionsRequest;
import software.amazon.awssdk.services.iotsitewise.model.PutLoggingOptionsResponse;
import software.amazon.awssdk.services.iotsitewise.model.PutStorageConfigurationRequest;
import software.amazon.awssdk.services.iotsitewise.model.PutStorageConfigurationResponse;
import software.amazon.awssdk.services.iotsitewise.model.ResourceAlreadyExistsException;
import software.amazon.awssdk.services.iotsitewise.model.ResourceNotFoundException;
import software.amazon.awssdk.services.iotsitewise.model.ServiceUnavailableException;
import software.amazon.awssdk.services.iotsitewise.model.TagResourceRequest;
import software.amazon.awssdk.services.iotsitewise.model.TagResourceResponse;
import software.amazon.awssdk.services.iotsitewise.model.ThrottlingException;
import software.amazon.awssdk.services.iotsitewise.model.TooManyTagsException;
import software.amazon.awssdk.services.iotsitewise.model.UnauthorizedException;
import software.amazon.awssdk.services.iotsitewise.model.UntagResourceRequest;
import software.amazon.awssdk.services.iotsitewise.model.UntagResourceResponse;
import software.amazon.awssdk.services.iotsitewise.model.UpdateAccessPolicyRequest;
import software.amazon.awssdk.services.iotsitewise.model.UpdateAccessPolicyResponse;
import software.amazon.awssdk.services.iotsitewise.model.UpdateAssetModelRequest;
import software.amazon.awssdk.services.iotsitewise.model.UpdateAssetModelResponse;
import software.amazon.awssdk.services.iotsitewise.model.UpdateAssetPropertyRequest;
import software.amazon.awssdk.services.iotsitewise.model.UpdateAssetPropertyResponse;
import software.amazon.awssdk.services.iotsitewise.model.UpdateAssetRequest;
import software.amazon.awssdk.services.iotsitewise.model.UpdateAssetResponse;
import software.amazon.awssdk.services.iotsitewise.model.UpdateDashboardRequest;
import software.amazon.awssdk.services.iotsitewise.model.UpdateDashboardResponse;
import software.amazon.awssdk.services.iotsitewise.model.UpdateGatewayCapabilityConfigurationRequest;
import software.amazon.awssdk.services.iotsitewise.model.UpdateGatewayCapabilityConfigurationResponse;
import software.amazon.awssdk.services.iotsitewise.model.UpdateGatewayRequest;
import software.amazon.awssdk.services.iotsitewise.model.UpdateGatewayResponse;
import software.amazon.awssdk.services.iotsitewise.model.UpdatePortalRequest;
import software.amazon.awssdk.services.iotsitewise.model.UpdatePortalResponse;
import software.amazon.awssdk.services.iotsitewise.model.UpdateProjectRequest;
import software.amazon.awssdk.services.iotsitewise.model.UpdateProjectResponse;
import software.amazon.awssdk.services.iotsitewise.transform.AssociateAssetsRequestMarshaller;
import software.amazon.awssdk.services.iotsitewise.transform.AssociateTimeSeriesToAssetPropertyRequestMarshaller;
import software.amazon.awssdk.services.iotsitewise.transform.BatchAssociateProjectAssetsRequestMarshaller;
import software.amazon.awssdk.services.iotsitewise.transform.BatchDisassociateProjectAssetsRequestMarshaller;
import software.amazon.awssdk.services.iotsitewise.transform.BatchGetAssetPropertyAggregatesRequestMarshaller;
import software.amazon.awssdk.services.iotsitewise.transform.BatchGetAssetPropertyValueHistoryRequestMarshaller;
import software.amazon.awssdk.services.iotsitewise.transform.BatchGetAssetPropertyValueRequestMarshaller;
import software.amazon.awssdk.services.iotsitewise.transform.BatchPutAssetPropertyValueRequestMarshaller;
import software.amazon.awssdk.services.iotsitewise.transform.CreateAccessPolicyRequestMarshaller;
import software.amazon.awssdk.services.iotsitewise.transform.CreateAssetModelRequestMarshaller;
import software.amazon.awssdk.services.iotsitewise.transform.CreateAssetRequestMarshaller;
import software.amazon.awssdk.services.iotsitewise.transform.CreateBulkImportJobRequestMarshaller;
import software.amazon.awssdk.services.iotsitewise.transform.CreateDashboardRequestMarshaller;
import software.amazon.awssdk.services.iotsitewise.transform.CreateGatewayRequestMarshaller;
import software.amazon.awssdk.services.iotsitewise.transform.CreatePortalRequestMarshaller;
import software.amazon.awssdk.services.iotsitewise.transform.CreateProjectRequestMarshaller;
import software.amazon.awssdk.services.iotsitewise.transform.DeleteAccessPolicyRequestMarshaller;
import software.amazon.awssdk.services.iotsitewise.transform.DeleteAssetModelRequestMarshaller;
import software.amazon.awssdk.services.iotsitewise.transform.DeleteAssetRequestMarshaller;
import software.amazon.awssdk.services.iotsitewise.transform.DeleteDashboardRequestMarshaller;
import software.amazon.awssdk.services.iotsitewise.transform.DeleteGatewayRequestMarshaller;
import software.amazon.awssdk.services.iotsitewise.transform.DeletePortalRequestMarshaller;
import software.amazon.awssdk.services.iotsitewise.transform.DeleteProjectRequestMarshaller;
import software.amazon.awssdk.services.iotsitewise.transform.DeleteTimeSeriesRequestMarshaller;
import software.amazon.awssdk.services.iotsitewise.transform.DescribeAccessPolicyRequestMarshaller;
import software.amazon.awssdk.services.iotsitewise.transform.DescribeAssetModelRequestMarshaller;
import software.amazon.awssdk.services.iotsitewise.transform.DescribeAssetPropertyRequestMarshaller;
import software.amazon.awssdk.services.iotsitewise.transform.DescribeAssetRequestMarshaller;
import software.amazon.awssdk.services.iotsitewise.transform.DescribeBulkImportJobRequestMarshaller;
import software.amazon.awssdk.services.iotsitewise.transform.DescribeDashboardRequestMarshaller;
import software.amazon.awssdk.services.iotsitewise.transform.DescribeDefaultEncryptionConfigurationRequestMarshaller;
import software.amazon.awssdk.services.iotsitewise.transform.DescribeGatewayCapabilityConfigurationRequestMarshaller;
import software.amazon.awssdk.services.iotsitewise.transform.DescribeGatewayRequestMarshaller;
import software.amazon.awssdk.services.iotsitewise.transform.DescribeLoggingOptionsRequestMarshaller;
import software.amazon.awssdk.services.iotsitewise.transform.DescribePortalRequestMarshaller;
import software.amazon.awssdk.services.iotsitewise.transform.DescribeProjectRequestMarshaller;
import software.amazon.awssdk.services.iotsitewise.transform.DescribeStorageConfigurationRequestMarshaller;
import software.amazon.awssdk.services.iotsitewise.transform.DescribeTimeSeriesRequestMarshaller;
import software.amazon.awssdk.services.iotsitewise.transform.DisassociateAssetsRequestMarshaller;
import software.amazon.awssdk.services.iotsitewise.transform.DisassociateTimeSeriesFromAssetPropertyRequestMarshaller;
import software.amazon.awssdk.services.iotsitewise.transform.GetAssetPropertyAggregatesRequestMarshaller;
import software.amazon.awssdk.services.iotsitewise.transform.GetAssetPropertyValueHistoryRequestMarshaller;
import software.amazon.awssdk.services.iotsitewise.transform.GetAssetPropertyValueRequestMarshaller;
import software.amazon.awssdk.services.iotsitewise.transform.GetInterpolatedAssetPropertyValuesRequestMarshaller;
import software.amazon.awssdk.services.iotsitewise.transform.ListAccessPoliciesRequestMarshaller;
import software.amazon.awssdk.services.iotsitewise.transform.ListAssetModelPropertiesRequestMarshaller;
import software.amazon.awssdk.services.iotsitewise.transform.ListAssetModelsRequestMarshaller;
import software.amazon.awssdk.services.iotsitewise.transform.ListAssetPropertiesRequestMarshaller;
import software.amazon.awssdk.services.iotsitewise.transform.ListAssetRelationshipsRequestMarshaller;
import software.amazon.awssdk.services.iotsitewise.transform.ListAssetsRequestMarshaller;
import software.amazon.awssdk.services.iotsitewise.transform.ListAssociatedAssetsRequestMarshaller;
import software.amazon.awssdk.services.iotsitewise.transform.ListBulkImportJobsRequestMarshaller;
import software.amazon.awssdk.services.iotsitewise.transform.ListDashboardsRequestMarshaller;
import software.amazon.awssdk.services.iotsitewise.transform.ListGatewaysRequestMarshaller;
import software.amazon.awssdk.services.iotsitewise.transform.ListPortalsRequestMarshaller;
import software.amazon.awssdk.services.iotsitewise.transform.ListProjectAssetsRequestMarshaller;
import software.amazon.awssdk.services.iotsitewise.transform.ListProjectsRequestMarshaller;
import software.amazon.awssdk.services.iotsitewise.transform.ListTagsForResourceRequestMarshaller;
import software.amazon.awssdk.services.iotsitewise.transform.ListTimeSeriesRequestMarshaller;
import software.amazon.awssdk.services.iotsitewise.transform.PutDefaultEncryptionConfigurationRequestMarshaller;
import software.amazon.awssdk.services.iotsitewise.transform.PutLoggingOptionsRequestMarshaller;
import software.amazon.awssdk.services.iotsitewise.transform.PutStorageConfigurationRequestMarshaller;
import software.amazon.awssdk.services.iotsitewise.transform.TagResourceRequestMarshaller;
import software.amazon.awssdk.services.iotsitewise.transform.UntagResourceRequestMarshaller;
import software.amazon.awssdk.services.iotsitewise.transform.UpdateAccessPolicyRequestMarshaller;
import software.amazon.awssdk.services.iotsitewise.transform.UpdateAssetModelRequestMarshaller;
import software.amazon.awssdk.services.iotsitewise.transform.UpdateAssetPropertyRequestMarshaller;
import software.amazon.awssdk.services.iotsitewise.transform.UpdateAssetRequestMarshaller;
import software.amazon.awssdk.services.iotsitewise.transform.UpdateDashboardRequestMarshaller;
import software.amazon.awssdk.services.iotsitewise.transform.UpdateGatewayCapabilityConfigurationRequestMarshaller;
import software.amazon.awssdk.services.iotsitewise.transform.UpdateGatewayRequestMarshaller;
import software.amazon.awssdk.services.iotsitewise.transform.UpdatePortalRequestMarshaller;
import software.amazon.awssdk.services.iotsitewise.transform.UpdateProjectRequestMarshaller;
import software.amazon.awssdk.services.iotsitewise.waiters.IoTSiteWiseWaiter;
import software.amazon.awssdk.utils.Logger;

/**
 * Internal implementation of {@link IoTSiteWiseClient}.
 *
 * @see IoTSiteWiseClient#builder()
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
final class DefaultIoTSiteWiseClient implements IoTSiteWiseClient {
    private static final Logger log = Logger.loggerFor(DefaultIoTSiteWiseClient.class);

    private final SyncClientHandler clientHandler;

    private final AwsJsonProtocolFactory protocolFactory;

    private final SdkClientConfiguration clientConfiguration;

    private final IoTSiteWiseServiceClientConfiguration serviceClientConfiguration;

    protected DefaultIoTSiteWiseClient(IoTSiteWiseServiceClientConfiguration serviceClientConfiguration,
            SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsSyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration;
        this.serviceClientConfiguration = serviceClientConfiguration;
        this.protocolFactory = init(AwsJsonProtocolFactory.builder()).build();
    }

    /**
     * <p>
     * Associates a child asset with the given parent asset through a hierarchy defined in the parent asset's model. For
     * more information, see <a
     * href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/add-associated-assets.html">Associating
     * assets</a> in the <i>IoT SiteWise User Guide</i>.
     * </p>
     *
     * @param associateAssetsRequest
     * @return Result of the AssociateAssets operation returned by the service.
     * @throws InvalidRequestException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters. Check your request and try again.
     * @throws ResourceAlreadyExistsException
     *         The resource already exists.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws InternalFailureException
     *         IoT SiteWise can't process your request right now. Try again later.
     * @throws LimitExceededException
     *         You've reached the limit for a resource. For example, this can occur if you're trying to associate more
     *         than the allowed number of child assets or attempting to create more than the allowed number of
     *         properties for an asset model.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.
     * @throws ThrottlingException
     *         Your request exceeded a rate limit. For example, you might have exceeded the number of IoT SiteWise
     *         assets that can be created per second, the allowed number of messages per second, and so on.
     *         </p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.
     * @throws ConflictingOperationException
     *         Your request has conflicting operations. This can occur if you're trying to perform more than one
     *         operation on the same resource at the same time.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTSiteWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTSiteWiseClient.AssociateAssets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/AssociateAssets" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public AssociateAssetsResponse associateAssets(AssociateAssetsRequest associateAssetsRequest) throws InvalidRequestException,
            ResourceAlreadyExistsException, ResourceNotFoundException, InternalFailureException, LimitExceededException,
            ThrottlingException, ConflictingOperationException, AwsServiceException, SdkClientException, IoTSiteWiseException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<AssociateAssetsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                AssociateAssetsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, associateAssetsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoTSiteWise");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AssociateAssets");
            String hostPrefix = "api.";
            String resolvedHostExpression = "api.";

            return clientHandler.execute(new ClientExecutionParams<AssociateAssetsRequest, AssociateAssetsResponse>()
                    .withOperationName("AssociateAssets").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).hostPrefixExpression(resolvedHostExpression)
                    .withInput(associateAssetsRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new AssociateAssetsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Associates a time series (data stream) with an asset property.
     * </p>
     *
     * @param associateTimeSeriesToAssetPropertyRequest
     * @return Result of the AssociateTimeSeriesToAssetProperty operation returned by the service.
     * @throws InvalidRequestException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters. Check your request and try again.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws InternalFailureException
     *         IoT SiteWise can't process your request right now. Try again later.
     * @throws ThrottlingException
     *         Your request exceeded a rate limit. For example, you might have exceeded the number of IoT SiteWise
     *         assets that can be created per second, the allowed number of messages per second, and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.
     * @throws ConflictingOperationException
     *         Your request has conflicting operations. This can occur if you're trying to perform more than one
     *         operation on the same resource at the same time.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTSiteWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTSiteWiseClient.AssociateTimeSeriesToAssetProperty
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/AssociateTimeSeriesToAssetProperty"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public AssociateTimeSeriesToAssetPropertyResponse associateTimeSeriesToAssetProperty(
            AssociateTimeSeriesToAssetPropertyRequest associateTimeSeriesToAssetPropertyRequest) throws InvalidRequestException,
            ResourceNotFoundException, InternalFailureException, ThrottlingException, ConflictingOperationException,
            AwsServiceException, SdkClientException, IoTSiteWiseException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<AssociateTimeSeriesToAssetPropertyResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, AssociateTimeSeriesToAssetPropertyResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                associateTimeSeriesToAssetPropertyRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoTSiteWise");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AssociateTimeSeriesToAssetProperty");
            String hostPrefix = "api.";
            String resolvedHostExpression = "api.";

            return clientHandler
                    .execute(new ClientExecutionParams<AssociateTimeSeriesToAssetPropertyRequest, AssociateTimeSeriesToAssetPropertyResponse>()
                            .withOperationName("AssociateTimeSeriesToAssetProperty").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).hostPrefixExpression(resolvedHostExpression)
                            .withInput(associateTimeSeriesToAssetPropertyRequest).withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new AssociateTimeSeriesToAssetPropertyRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Associates a group (batch) of assets with an IoT SiteWise Monitor project.
     * </p>
     *
     * @param batchAssociateProjectAssetsRequest
     * @return Result of the BatchAssociateProjectAssets operation returned by the service.
     * @throws InvalidRequestException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters. Check your request and try again.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws InternalFailureException
     *         IoT SiteWise can't process your request right now. Try again later.
     * @throws ThrottlingException
     *         Your request exceeded a rate limit. For example, you might have exceeded the number of IoT SiteWise
     *         assets that can be created per second, the allowed number of messages per second, and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.
     * @throws LimitExceededException
     *         You've reached the limit for a resource. For example, this can occur if you're trying to associate more
     *         than the allowed number of child assets or attempting to create more than the allowed number of
     *         properties for an asset model.
     *         </p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTSiteWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTSiteWiseClient.BatchAssociateProjectAssets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/BatchAssociateProjectAssets"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public BatchAssociateProjectAssetsResponse batchAssociateProjectAssets(
            BatchAssociateProjectAssetsRequest batchAssociateProjectAssetsRequest) throws InvalidRequestException,
            ResourceNotFoundException, InternalFailureException, ThrottlingException, LimitExceededException,
            AwsServiceException, SdkClientException, IoTSiteWiseException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<BatchAssociateProjectAssetsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, BatchAssociateProjectAssetsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, batchAssociateProjectAssetsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoTSiteWise");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "BatchAssociateProjectAssets");
            String hostPrefix = "monitor.";
            String resolvedHostExpression = "monitor.";

            return clientHandler
                    .execute(new ClientExecutionParams<BatchAssociateProjectAssetsRequest, BatchAssociateProjectAssetsResponse>()
                            .withOperationName("BatchAssociateProjectAssets").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).hostPrefixExpression(resolvedHostExpression)
                            .withInput(batchAssociateProjectAssetsRequest).withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new BatchAssociateProjectAssetsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Disassociates a group (batch) of assets from an IoT SiteWise Monitor project.
     * </p>
     *
     * @param batchDisassociateProjectAssetsRequest
     * @return Result of the BatchDisassociateProjectAssets operation returned by the service.
     * @throws InvalidRequestException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters. Check your request and try again.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws InternalFailureException
     *         IoT SiteWise can't process your request right now. Try again later.
     * @throws ThrottlingException
     *         Your request exceeded a rate limit. For example, you might have exceeded the number of IoT SiteWise
     *         assets that can be created per second, the allowed number of messages per second, and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTSiteWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTSiteWiseClient.BatchDisassociateProjectAssets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/BatchDisassociateProjectAssets"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public BatchDisassociateProjectAssetsResponse batchDisassociateProjectAssets(
            BatchDisassociateProjectAssetsRequest batchDisassociateProjectAssetsRequest) throws InvalidRequestException,
            ResourceNotFoundException, InternalFailureException, ThrottlingException, AwsServiceException, SdkClientException,
            IoTSiteWiseException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<BatchDisassociateProjectAssetsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, BatchDisassociateProjectAssetsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                batchDisassociateProjectAssetsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoTSiteWise");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "BatchDisassociateProjectAssets");
            String hostPrefix = "monitor.";
            String resolvedHostExpression = "monitor.";

            return clientHandler
                    .execute(new ClientExecutionParams<BatchDisassociateProjectAssetsRequest, BatchDisassociateProjectAssetsResponse>()
                            .withOperationName("BatchDisassociateProjectAssets").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).hostPrefixExpression(resolvedHostExpression)
                            .withInput(batchDisassociateProjectAssetsRequest).withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new BatchDisassociateProjectAssetsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets aggregated values (for example, average, minimum, and maximum) for one or more asset properties. For more
     * information, see <a
     * href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/query-industrial-data.html#aggregates">Querying
     * aggregates</a> in the <i>IoT SiteWise User Guide</i>.
     * </p>
     *
     * @param batchGetAssetPropertyAggregatesRequest
     * @return Result of the BatchGetAssetPropertyAggregates operation returned by the service.
     * @throws InvalidRequestException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters. Check your request and try again.
     * @throws InternalFailureException
     *         IoT SiteWise can't process your request right now. Try again later.
     * @throws ThrottlingException
     *         Your request exceeded a rate limit. For example, you might have exceeded the number of IoT SiteWise
     *         assets that can be created per second, the allowed number of messages per second, and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.
     * @throws ServiceUnavailableException
     *         The requested service is unavailable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTSiteWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTSiteWiseClient.BatchGetAssetPropertyAggregates
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/BatchGetAssetPropertyAggregates"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public BatchGetAssetPropertyAggregatesResponse batchGetAssetPropertyAggregates(
            BatchGetAssetPropertyAggregatesRequest batchGetAssetPropertyAggregatesRequest) throws InvalidRequestException,
            InternalFailureException, ThrottlingException, ServiceUnavailableException, AwsServiceException, SdkClientException,
            IoTSiteWiseException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<BatchGetAssetPropertyAggregatesResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, BatchGetAssetPropertyAggregatesResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                batchGetAssetPropertyAggregatesRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoTSiteWise");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "BatchGetAssetPropertyAggregates");
            String hostPrefix = "data.";
            String resolvedHostExpression = "data.";

            return clientHandler
                    .execute(new ClientExecutionParams<BatchGetAssetPropertyAggregatesRequest, BatchGetAssetPropertyAggregatesResponse>()
                            .withOperationName("BatchGetAssetPropertyAggregates").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).hostPrefixExpression(resolvedHostExpression)
                            .withInput(batchGetAssetPropertyAggregatesRequest).withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new BatchGetAssetPropertyAggregatesRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets the current value for one or more asset properties. For more information, see <a
     * href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/query-industrial-data.html#current-values"
     * >Querying current values</a> in the <i>IoT SiteWise User Guide</i>.
     * </p>
     *
     * @param batchGetAssetPropertyValueRequest
     * @return Result of the BatchGetAssetPropertyValue operation returned by the service.
     * @throws InvalidRequestException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters. Check your request and try again.
     * @throws InternalFailureException
     *         IoT SiteWise can't process your request right now. Try again later.
     * @throws ThrottlingException
     *         Your request exceeded a rate limit. For example, you might have exceeded the number of IoT SiteWise
     *         assets that can be created per second, the allowed number of messages per second, and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.
     * @throws ServiceUnavailableException
     *         The requested service is unavailable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTSiteWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTSiteWiseClient.BatchGetAssetPropertyValue
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/BatchGetAssetPropertyValue"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public BatchGetAssetPropertyValueResponse batchGetAssetPropertyValue(
            BatchGetAssetPropertyValueRequest batchGetAssetPropertyValueRequest) throws InvalidRequestException,
            InternalFailureException, ThrottlingException, ServiceUnavailableException, AwsServiceException, SdkClientException,
            IoTSiteWiseException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<BatchGetAssetPropertyValueResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, BatchGetAssetPropertyValueResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, batchGetAssetPropertyValueRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoTSiteWise");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "BatchGetAssetPropertyValue");
            String hostPrefix = "data.";
            String resolvedHostExpression = "data.";

            return clientHandler
                    .execute(new ClientExecutionParams<BatchGetAssetPropertyValueRequest, BatchGetAssetPropertyValueResponse>()
                            .withOperationName("BatchGetAssetPropertyValue").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).hostPrefixExpression(resolvedHostExpression)
                            .withInput(batchGetAssetPropertyValueRequest).withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new BatchGetAssetPropertyValueRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets the historical values for one or more asset properties. For more information, see <a
     * href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/query-industrial-data.html#historical-values"
     * >Querying historical values</a> in the <i>IoT SiteWise User Guide</i>.
     * </p>
     *
     * @param batchGetAssetPropertyValueHistoryRequest
     * @return Result of the BatchGetAssetPropertyValueHistory operation returned by the service.
     * @throws InvalidRequestException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters. Check your request and try again.
     * @throws InternalFailureException
     *         IoT SiteWise can't process your request right now. Try again later.
     * @throws ThrottlingException
     *         Your request exceeded a rate limit. For example, you might have exceeded the number of IoT SiteWise
     *         assets that can be created per second, the allowed number of messages per second, and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.
     * @throws ServiceUnavailableException
     *         The requested service is unavailable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTSiteWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTSiteWiseClient.BatchGetAssetPropertyValueHistory
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/BatchGetAssetPropertyValueHistory"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public BatchGetAssetPropertyValueHistoryResponse batchGetAssetPropertyValueHistory(
            BatchGetAssetPropertyValueHistoryRequest batchGetAssetPropertyValueHistoryRequest) throws InvalidRequestException,
            InternalFailureException, ThrottlingException, ServiceUnavailableException, AwsServiceException, SdkClientException,
            IoTSiteWiseException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<BatchGetAssetPropertyValueHistoryResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, BatchGetAssetPropertyValueHistoryResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                batchGetAssetPropertyValueHistoryRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoTSiteWise");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "BatchGetAssetPropertyValueHistory");
            String hostPrefix = "data.";
            String resolvedHostExpression = "data.";

            return clientHandler
                    .execute(new ClientExecutionParams<BatchGetAssetPropertyValueHistoryRequest, BatchGetAssetPropertyValueHistoryResponse>()
                            .withOperationName("BatchGetAssetPropertyValueHistory").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).hostPrefixExpression(resolvedHostExpression)
                            .withInput(batchGetAssetPropertyValueHistoryRequest).withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new BatchGetAssetPropertyValueHistoryRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Sends a list of asset property values to IoT SiteWise. Each value is a timestamp-quality-value (TQV) data point.
     * For more information, see <a
     * href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/ingest-api.html">Ingesting data using the API</a>
     * in the <i>IoT SiteWise User Guide</i>.
     * </p>
     * <p>
     * To identify an asset property, you must specify one of the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * The <code>assetId</code> and <code>propertyId</code> of an asset property.
     * </p>
     * </li>
     * <li>
     * <p>
     * A <code>propertyAlias</code>, which is a data stream alias (for example,
     * <code>/company/windfarm/3/turbine/7/temperature</code>). To define an asset property's alias, see <a
     * href="https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_UpdateAssetProperty.html"
     * >UpdateAssetProperty</a>.
     * </p>
     * </li>
     * </ul>
     * <important>
     * <p>
     * With respect to Unix epoch time, IoT SiteWise accepts only TQVs that have a timestamp of no more than 7 days in
     * the past and no more than 10 minutes in the future. IoT SiteWise rejects timestamps outside of the inclusive
     * range of [-7 days, +10 minutes] and returns a <code>TimestampOutOfRangeException</code> error.
     * </p>
     * <p>
     * For each asset property, IoT SiteWise overwrites TQVs with duplicate timestamps unless the newer TQV has a
     * different quality. For example, if you store a TQV <code>{T1, GOOD, V1}</code>, then storing
     * <code>{T1, GOOD, V2}</code> replaces the existing TQV.
     * </p>
     * </important>
     * <p>
     * IoT SiteWise authorizes access to each <code>BatchPutAssetPropertyValue</code> entry individually. For more
     * information, see <a href=
     * "https://docs.aws.amazon.com/iot-sitewise/latest/userguide/security_iam_service-with-iam.html#security_iam_service-with-iam-id-based-policies-batchputassetpropertyvalue-action"
     * >BatchPutAssetPropertyValue authorization</a> in the <i>IoT SiteWise User Guide</i>.
     * </p>
     *
     * @param batchPutAssetPropertyValueRequest
     * @return Result of the BatchPutAssetPropertyValue operation returned by the service.
     * @throws InvalidRequestException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters. Check your request and try again.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws InternalFailureException
     *         IoT SiteWise can't process your request right now. Try again later.
     * @throws ThrottlingException
     *         Your request exceeded a rate limit. For example, you might have exceeded the number of IoT SiteWise
     *         assets that can be created per second, the allowed number of messages per second, and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.
     * @throws LimitExceededException
     *         You've reached the limit for a resource. For example, this can occur if you're trying to associate more
     *         than the allowed number of child assets or attempting to create more than the allowed number of
     *         properties for an asset model.
     *         </p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.
     * @throws ServiceUnavailableException
     *         The requested service is unavailable.
     * @throws ConflictingOperationException
     *         Your request has conflicting operations. This can occur if you're trying to perform more than one
     *         operation on the same resource at the same time.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTSiteWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTSiteWiseClient.BatchPutAssetPropertyValue
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/BatchPutAssetPropertyValue"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public BatchPutAssetPropertyValueResponse batchPutAssetPropertyValue(
            BatchPutAssetPropertyValueRequest batchPutAssetPropertyValueRequest) throws InvalidRequestException,
            ResourceNotFoundException, InternalFailureException, ThrottlingException, LimitExceededException,
            ServiceUnavailableException, ConflictingOperationException, AwsServiceException, SdkClientException,
            IoTSiteWiseException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<BatchPutAssetPropertyValueResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, BatchPutAssetPropertyValueResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, batchPutAssetPropertyValueRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoTSiteWise");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "BatchPutAssetPropertyValue");
            String hostPrefix = "data.";
            String resolvedHostExpression = "data.";

            return clientHandler
                    .execute(new ClientExecutionParams<BatchPutAssetPropertyValueRequest, BatchPutAssetPropertyValueResponse>()
                            .withOperationName("BatchPutAssetPropertyValue").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).hostPrefixExpression(resolvedHostExpression)
                            .withInput(batchPutAssetPropertyValueRequest).withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new BatchPutAssetPropertyValueRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates an access policy that grants the specified identity (IAM Identity Center user, IAM Identity Center group,
     * or IAM user) access to the specified IoT SiteWise Monitor portal or project resource.
     * </p>
     *
     * @param createAccessPolicyRequest
     * @return Result of the CreateAccessPolicy operation returned by the service.
     * @throws InvalidRequestException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters. Check your request and try again.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws InternalFailureException
     *         IoT SiteWise can't process your request right now. Try again later.
     * @throws ThrottlingException
     *         Your request exceeded a rate limit. For example, you might have exceeded the number of IoT SiteWise
     *         assets that can be created per second, the allowed number of messages per second, and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.
     * @throws LimitExceededException
     *         You've reached the limit for a resource. For example, this can occur if you're trying to associate more
     *         than the allowed number of child assets or attempting to create more than the allowed number of
     *         properties for an asset model.
     *         </p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTSiteWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTSiteWiseClient.CreateAccessPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/CreateAccessPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreateAccessPolicyResponse createAccessPolicy(CreateAccessPolicyRequest createAccessPolicyRequest)
            throws InvalidRequestException, ResourceNotFoundException, InternalFailureException, ThrottlingException,
            LimitExceededException, AwsServiceException, SdkClientException, IoTSiteWiseException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateAccessPolicyResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, CreateAccessPolicyResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createAccessPolicyRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoTSiteWise");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateAccessPolicy");
            String hostPrefix = "monitor.";
            String resolvedHostExpression = "monitor.";

            return clientHandler.execute(new ClientExecutionParams<CreateAccessPolicyRequest, CreateAccessPolicyResponse>()
                    .withOperationName("CreateAccessPolicy").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).hostPrefixExpression(resolvedHostExpression)
                    .withInput(createAccessPolicyRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateAccessPolicyRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates an asset from an existing asset model. For more information, see <a
     * href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/create-assets.html">Creating assets</a> in the
     * <i>IoT SiteWise User Guide</i>.
     * </p>
     *
     * @param createAssetRequest
     * @return Result of the CreateAsset operation returned by the service.
     * @throws InvalidRequestException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters. Check your request and try again.
     * @throws ResourceAlreadyExistsException
     *         The resource already exists.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws InternalFailureException
     *         IoT SiteWise can't process your request right now. Try again later.
     * @throws ThrottlingException
     *         Your request exceeded a rate limit. For example, you might have exceeded the number of IoT SiteWise
     *         assets that can be created per second, the allowed number of messages per second, and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.
     * @throws LimitExceededException
     *         You've reached the limit for a resource. For example, this can occur if you're trying to associate more
     *         than the allowed number of child assets or attempting to create more than the allowed number of
     *         properties for an asset model.
     *         </p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.
     * @throws ConflictingOperationException
     *         Your request has conflicting operations. This can occur if you're trying to perform more than one
     *         operation on the same resource at the same time.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTSiteWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTSiteWiseClient.CreateAsset
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/CreateAsset" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CreateAssetResponse createAsset(CreateAssetRequest createAssetRequest) throws InvalidRequestException,
            ResourceAlreadyExistsException, ResourceNotFoundException, InternalFailureException, ThrottlingException,
            LimitExceededException, ConflictingOperationException, AwsServiceException, SdkClientException, IoTSiteWiseException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateAssetResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                CreateAssetResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createAssetRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoTSiteWise");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateAsset");
            String hostPrefix = "api.";
            String resolvedHostExpression = "api.";

            return clientHandler.execute(new ClientExecutionParams<CreateAssetRequest, CreateAssetResponse>()
                    .withOperationName("CreateAsset").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).hostPrefixExpression(resolvedHostExpression)
                    .withInput(createAssetRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateAssetRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates an asset model from specified property and hierarchy definitions. You create assets from asset models.
     * With asset models, you can easily create assets of the same type that have standardized definitions. Each asset
     * created from a model inherits the asset model's property and hierarchy definitions. For more information, see <a
     * href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/define-models.html">Defining asset models</a> in
     * the <i>IoT SiteWise User Guide</i>.
     * </p>
     *
     * @param createAssetModelRequest
     * @return Result of the CreateAssetModel operation returned by the service.
     * @throws InvalidRequestException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters. Check your request and try again.
     * @throws ResourceAlreadyExistsException
     *         The resource already exists.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws InternalFailureException
     *         IoT SiteWise can't process your request right now. Try again later.
     * @throws ThrottlingException
     *         Your request exceeded a rate limit. For example, you might have exceeded the number of IoT SiteWise
     *         assets that can be created per second, the allowed number of messages per second, and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.
     * @throws LimitExceededException
     *         You've reached the limit for a resource. For example, this can occur if you're trying to associate more
     *         than the allowed number of child assets or attempting to create more than the allowed number of
     *         properties for an asset model.
     *         </p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.
     * @throws ConflictingOperationException
     *         Your request has conflicting operations. This can occur if you're trying to perform more than one
     *         operation on the same resource at the same time.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTSiteWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTSiteWiseClient.CreateAssetModel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/CreateAssetModel" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CreateAssetModelResponse createAssetModel(CreateAssetModelRequest createAssetModelRequest)
            throws InvalidRequestException, ResourceAlreadyExistsException, ResourceNotFoundException, InternalFailureException,
            ThrottlingException, LimitExceededException, ConflictingOperationException, AwsServiceException, SdkClientException,
            IoTSiteWiseException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateAssetModelResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                CreateAssetModelResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createAssetModelRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoTSiteWise");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateAssetModel");
            String hostPrefix = "api.";
            String resolvedHostExpression = "api.";

            return clientHandler.execute(new ClientExecutionParams<CreateAssetModelRequest, CreateAssetModelResponse>()
                    .withOperationName("CreateAssetModel").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).hostPrefixExpression(resolvedHostExpression)
                    .withInput(createAssetModelRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateAssetModelRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Defines a job to ingest data to IoT SiteWise from Amazon S3. For more information, see <a
     * href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/CreateBulkImportJob.html">Create a bulk import
     * job (CLI)</a> in the <i>Amazon Simple Storage Service User Guide</i>.
     * </p>
     * <important>
     * <p>
     * You must enable IoT SiteWise to export data to Amazon S3 before you create a bulk import job. For more
     * information about how to configure storage settings, see <a
     * href="https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_PutStorageConfiguration.html"
     * >PutStorageConfiguration</a>.
     * </p>
     * </important>
     *
     * @param createBulkImportJobRequest
     * @return Result of the CreateBulkImportJob operation returned by the service.
     * @throws InvalidRequestException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters. Check your request and try again.
     * @throws ResourceAlreadyExistsException
     *         The resource already exists.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws InternalFailureException
     *         IoT SiteWise can't process your request right now. Try again later.
     * @throws ThrottlingException
     *         Your request exceeded a rate limit. For example, you might have exceeded the number of IoT SiteWise
     *         assets that can be created per second, the allowed number of messages per second, and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.
     * @throws LimitExceededException
     *         You've reached the limit for a resource. For example, this can occur if you're trying to associate more
     *         than the allowed number of child assets or attempting to create more than the allowed number of
     *         properties for an asset model.
     *         </p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.
     * @throws ConflictingOperationException
     *         Your request has conflicting operations. This can occur if you're trying to perform more than one
     *         operation on the same resource at the same time.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTSiteWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTSiteWiseClient.CreateBulkImportJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/CreateBulkImportJob"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreateBulkImportJobResponse createBulkImportJob(CreateBulkImportJobRequest createBulkImportJobRequest)
            throws InvalidRequestException, ResourceAlreadyExistsException, ResourceNotFoundException, InternalFailureException,
            ThrottlingException, LimitExceededException, ConflictingOperationException, AwsServiceException, SdkClientException,
            IoTSiteWiseException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateBulkImportJobResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, CreateBulkImportJobResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createBulkImportJobRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoTSiteWise");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateBulkImportJob");
            String hostPrefix = "data.";
            String resolvedHostExpression = "data.";

            return clientHandler.execute(new ClientExecutionParams<CreateBulkImportJobRequest, CreateBulkImportJobResponse>()
                    .withOperationName("CreateBulkImportJob").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).hostPrefixExpression(resolvedHostExpression)
                    .withInput(createBulkImportJobRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateBulkImportJobRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a dashboard in an IoT SiteWise Monitor project.
     * </p>
     *
     * @param createDashboardRequest
     * @return Result of the CreateDashboard operation returned by the service.
     * @throws InvalidRequestException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters. Check your request and try again.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws InternalFailureException
     *         IoT SiteWise can't process your request right now. Try again later.
     * @throws ThrottlingException
     *         Your request exceeded a rate limit. For example, you might have exceeded the number of IoT SiteWise
     *         assets that can be created per second, the allowed number of messages per second, and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.
     * @throws LimitExceededException
     *         You've reached the limit for a resource. For example, this can occur if you're trying to associate more
     *         than the allowed number of child assets or attempting to create more than the allowed number of
     *         properties for an asset model.
     *         </p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTSiteWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTSiteWiseClient.CreateDashboard
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/CreateDashboard" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CreateDashboardResponse createDashboard(CreateDashboardRequest createDashboardRequest) throws InvalidRequestException,
            ResourceNotFoundException, InternalFailureException, ThrottlingException, LimitExceededException,
            AwsServiceException, SdkClientException, IoTSiteWiseException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateDashboardResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                CreateDashboardResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createDashboardRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoTSiteWise");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateDashboard");
            String hostPrefix = "monitor.";
            String resolvedHostExpression = "monitor.";

            return clientHandler.execute(new ClientExecutionParams<CreateDashboardRequest, CreateDashboardResponse>()
                    .withOperationName("CreateDashboard").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).hostPrefixExpression(resolvedHostExpression)
                    .withInput(createDashboardRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateDashboardRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a gateway, which is a virtual or edge device that delivers industrial data streams from local servers to
     * IoT SiteWise. For more information, see <a
     * href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/gateway-connector.html">Ingesting data using a
     * gateway</a> in the <i>IoT SiteWise User Guide</i>.
     * </p>
     *
     * @param createGatewayRequest
     * @return Result of the CreateGateway operation returned by the service.
     * @throws InvalidRequestException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters. Check your request and try again.
     * @throws ResourceAlreadyExistsException
     *         The resource already exists.
     * @throws InternalFailureException
     *         IoT SiteWise can't process your request right now. Try again later.
     * @throws ThrottlingException
     *         Your request exceeded a rate limit. For example, you might have exceeded the number of IoT SiteWise
     *         assets that can be created per second, the allowed number of messages per second, and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.
     * @throws LimitExceededException
     *         You've reached the limit for a resource. For example, this can occur if you're trying to associate more
     *         than the allowed number of child assets or attempting to create more than the allowed number of
     *         properties for an asset model.
     *         </p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTSiteWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTSiteWiseClient.CreateGateway
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/CreateGateway" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CreateGatewayResponse createGateway(CreateGatewayRequest createGatewayRequest) throws InvalidRequestException,
            ResourceAlreadyExistsException, InternalFailureException, ThrottlingException, LimitExceededException,
            AwsServiceException, SdkClientException, IoTSiteWiseException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateGatewayResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                CreateGatewayResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createGatewayRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoTSiteWise");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateGateway");
            String hostPrefix = "api.";
            String resolvedHostExpression = "api.";

            return clientHandler.execute(new ClientExecutionParams<CreateGatewayRequest, CreateGatewayResponse>()
                    .withOperationName("CreateGateway").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).hostPrefixExpression(resolvedHostExpression)
                    .withInput(createGatewayRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateGatewayRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a portal, which can contain projects and dashboards. IoT SiteWise Monitor uses IAM Identity Center or IAM
     * to authenticate portal users and manage user permissions.
     * </p>
     * <note>
     * <p>
     * Before you can sign in to a new portal, you must add at least one identity to that portal. For more information,
     * see <a
     * href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/administer-portals.html#portal-change-admins"
     * >Adding or removing portal administrators</a> in the <i>IoT SiteWise User Guide</i>.
     * </p>
     * </note>
     *
     * @param createPortalRequest
     * @return Result of the CreatePortal operation returned by the service.
     * @throws InvalidRequestException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters. Check your request and try again.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws InternalFailureException
     *         IoT SiteWise can't process your request right now. Try again later.
     * @throws ThrottlingException
     *         Your request exceeded a rate limit. For example, you might have exceeded the number of IoT SiteWise
     *         assets that can be created per second, the allowed number of messages per second, and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.
     * @throws LimitExceededException
     *         You've reached the limit for a resource. For example, this can occur if you're trying to associate more
     *         than the allowed number of child assets or attempting to create more than the allowed number of
     *         properties for an asset model.
     *         </p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTSiteWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTSiteWiseClient.CreatePortal
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/CreatePortal" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CreatePortalResponse createPortal(CreatePortalRequest createPortalRequest) throws InvalidRequestException,
            ResourceNotFoundException, InternalFailureException, ThrottlingException, LimitExceededException,
            AwsServiceException, SdkClientException, IoTSiteWiseException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreatePortalResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                CreatePortalResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createPortalRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoTSiteWise");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreatePortal");
            String hostPrefix = "monitor.";
            String resolvedHostExpression = "monitor.";

            return clientHandler.execute(new ClientExecutionParams<CreatePortalRequest, CreatePortalResponse>()
                    .withOperationName("CreatePortal").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).hostPrefixExpression(resolvedHostExpression)
                    .withInput(createPortalRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreatePortalRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a project in the specified portal.
     * </p>
     * <note>
     * <p>
     * Make sure that the project name and description don't contain confidential information.
     * </p>
     * </note>
     *
     * @param createProjectRequest
     * @return Result of the CreateProject operation returned by the service.
     * @throws InvalidRequestException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters. Check your request and try again.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws InternalFailureException
     *         IoT SiteWise can't process your request right now. Try again later.
     * @throws ThrottlingException
     *         Your request exceeded a rate limit. For example, you might have exceeded the number of IoT SiteWise
     *         assets that can be created per second, the allowed number of messages per second, and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.
     * @throws LimitExceededException
     *         You've reached the limit for a resource. For example, this can occur if you're trying to associate more
     *         than the allowed number of child assets or attempting to create more than the allowed number of
     *         properties for an asset model.
     *         </p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTSiteWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTSiteWiseClient.CreateProject
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/CreateProject" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CreateProjectResponse createProject(CreateProjectRequest createProjectRequest) throws InvalidRequestException,
            ResourceNotFoundException, InternalFailureException, ThrottlingException, LimitExceededException,
            AwsServiceException, SdkClientException, IoTSiteWiseException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateProjectResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                CreateProjectResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createProjectRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoTSiteWise");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateProject");
            String hostPrefix = "monitor.";
            String resolvedHostExpression = "monitor.";

            return clientHandler.execute(new ClientExecutionParams<CreateProjectRequest, CreateProjectResponse>()
                    .withOperationName("CreateProject").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).hostPrefixExpression(resolvedHostExpression)
                    .withInput(createProjectRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateProjectRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes an access policy that grants the specified identity access to the specified IoT SiteWise Monitor
     * resource. You can use this operation to revoke access to an IoT SiteWise Monitor resource.
     * </p>
     *
     * @param deleteAccessPolicyRequest
     * @return Result of the DeleteAccessPolicy operation returned by the service.
     * @throws InvalidRequestException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters. Check your request and try again.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws InternalFailureException
     *         IoT SiteWise can't process your request right now. Try again later.
     * @throws ThrottlingException
     *         Your request exceeded a rate limit. For example, you might have exceeded the number of IoT SiteWise
     *         assets that can be created per second, the allowed number of messages per second, and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTSiteWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTSiteWiseClient.DeleteAccessPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/DeleteAccessPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteAccessPolicyResponse deleteAccessPolicy(DeleteAccessPolicyRequest deleteAccessPolicyRequest)
            throws InvalidRequestException, ResourceNotFoundException, InternalFailureException, ThrottlingException,
            AwsServiceException, SdkClientException, IoTSiteWiseException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteAccessPolicyResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeleteAccessPolicyResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteAccessPolicyRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoTSiteWise");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteAccessPolicy");
            String hostPrefix = "monitor.";
            String resolvedHostExpression = "monitor.";

            return clientHandler.execute(new ClientExecutionParams<DeleteAccessPolicyRequest, DeleteAccessPolicyResponse>()
                    .withOperationName("DeleteAccessPolicy").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).hostPrefixExpression(resolvedHostExpression)
                    .withInput(deleteAccessPolicyRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteAccessPolicyRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes an asset. This action can't be undone. For more information, see <a
     * href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/delete-assets-and-models.html">Deleting assets
     * and models</a> in the <i>IoT SiteWise User Guide</i>.
     * </p>
     * <note>
     * <p>
     * You can't delete an asset that's associated to another asset. For more information, see <a
     * href="https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_DisassociateAssets.html"
     * >DisassociateAssets</a>.
     * </p>
     * </note>
     *
     * @param deleteAssetRequest
     * @return Result of the DeleteAsset operation returned by the service.
     * @throws InvalidRequestException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters. Check your request and try again.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws InternalFailureException
     *         IoT SiteWise can't process your request right now. Try again later.
     * @throws ThrottlingException
     *         Your request exceeded a rate limit. For example, you might have exceeded the number of IoT SiteWise
     *         assets that can be created per second, the allowed number of messages per second, and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.
     * @throws ConflictingOperationException
     *         Your request has conflicting operations. This can occur if you're trying to perform more than one
     *         operation on the same resource at the same time.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTSiteWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTSiteWiseClient.DeleteAsset
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/DeleteAsset" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DeleteAssetResponse deleteAsset(DeleteAssetRequest deleteAssetRequest) throws InvalidRequestException,
            ResourceNotFoundException, InternalFailureException, ThrottlingException, ConflictingOperationException,
            AwsServiceException, SdkClientException, IoTSiteWiseException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteAssetResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DeleteAssetResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteAssetRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoTSiteWise");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteAsset");
            String hostPrefix = "api.";
            String resolvedHostExpression = "api.";

            return clientHandler.execute(new ClientExecutionParams<DeleteAssetRequest, DeleteAssetResponse>()
                    .withOperationName("DeleteAsset").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).hostPrefixExpression(resolvedHostExpression)
                    .withInput(deleteAssetRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteAssetRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes an asset model. This action can't be undone. You must delete all assets created from an asset model
     * before you can delete the model. Also, you can't delete an asset model if a parent asset model exists that
     * contains a property formula expression that depends on the asset model that you want to delete. For more
     * information, see <a
     * href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/delete-assets-and-models.html">Deleting assets
     * and models</a> in the <i>IoT SiteWise User Guide</i>.
     * </p>
     *
     * @param deleteAssetModelRequest
     * @return Result of the DeleteAssetModel operation returned by the service.
     * @throws InvalidRequestException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters. Check your request and try again.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws InternalFailureException
     *         IoT SiteWise can't process your request right now. Try again later.
     * @throws ThrottlingException
     *         Your request exceeded a rate limit. For example, you might have exceeded the number of IoT SiteWise
     *         assets that can be created per second, the allowed number of messages per second, and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.
     * @throws ConflictingOperationException
     *         Your request has conflicting operations. This can occur if you're trying to perform more than one
     *         operation on the same resource at the same time.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTSiteWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTSiteWiseClient.DeleteAssetModel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/DeleteAssetModel" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public DeleteAssetModelResponse deleteAssetModel(DeleteAssetModelRequest deleteAssetModelRequest)
            throws InvalidRequestException, ResourceNotFoundException, InternalFailureException, ThrottlingException,
            ConflictingOperationException, AwsServiceException, SdkClientException, IoTSiteWiseException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteAssetModelResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DeleteAssetModelResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteAssetModelRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoTSiteWise");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteAssetModel");
            String hostPrefix = "api.";
            String resolvedHostExpression = "api.";

            return clientHandler.execute(new ClientExecutionParams<DeleteAssetModelRequest, DeleteAssetModelResponse>()
                    .withOperationName("DeleteAssetModel").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).hostPrefixExpression(resolvedHostExpression)
                    .withInput(deleteAssetModelRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteAssetModelRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes a dashboard from IoT SiteWise Monitor.
     * </p>
     *
     * @param deleteDashboardRequest
     * @return Result of the DeleteDashboard operation returned by the service.
     * @throws InvalidRequestException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters. Check your request and try again.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws InternalFailureException
     *         IoT SiteWise can't process your request right now. Try again later.
     * @throws ThrottlingException
     *         Your request exceeded a rate limit. For example, you might have exceeded the number of IoT SiteWise
     *         assets that can be created per second, the allowed number of messages per second, and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTSiteWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTSiteWiseClient.DeleteDashboard
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/DeleteDashboard" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public DeleteDashboardResponse deleteDashboard(DeleteDashboardRequest deleteDashboardRequest) throws InvalidRequestException,
            ResourceNotFoundException, InternalFailureException, ThrottlingException, AwsServiceException, SdkClientException,
            IoTSiteWiseException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteDashboardResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DeleteDashboardResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteDashboardRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoTSiteWise");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteDashboard");
            String hostPrefix = "monitor.";
            String resolvedHostExpression = "monitor.";

            return clientHandler.execute(new ClientExecutionParams<DeleteDashboardRequest, DeleteDashboardResponse>()
                    .withOperationName("DeleteDashboard").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).hostPrefixExpression(resolvedHostExpression)
                    .withInput(deleteDashboardRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteDashboardRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes a gateway from IoT SiteWise. When you delete a gateway, some of the gateway's files remain in your
     * gateway's file system.
     * </p>
     *
     * @param deleteGatewayRequest
     * @return Result of the DeleteGateway operation returned by the service.
     * @throws InvalidRequestException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters. Check your request and try again.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws InternalFailureException
     *         IoT SiteWise can't process your request right now. Try again later.
     * @throws ThrottlingException
     *         Your request exceeded a rate limit. For example, you might have exceeded the number of IoT SiteWise
     *         assets that can be created per second, the allowed number of messages per second, and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTSiteWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTSiteWiseClient.DeleteGateway
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/DeleteGateway" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DeleteGatewayResponse deleteGateway(DeleteGatewayRequest deleteGatewayRequest) throws InvalidRequestException,
            ResourceNotFoundException, InternalFailureException, ThrottlingException, AwsServiceException, SdkClientException,
            IoTSiteWiseException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteGatewayResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DeleteGatewayResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteGatewayRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoTSiteWise");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteGateway");
            String hostPrefix = "api.";
            String resolvedHostExpression = "api.";

            return clientHandler.execute(new ClientExecutionParams<DeleteGatewayRequest, DeleteGatewayResponse>()
                    .withOperationName("DeleteGateway").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).hostPrefixExpression(resolvedHostExpression)
                    .withInput(deleteGatewayRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteGatewayRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes a portal from IoT SiteWise Monitor.
     * </p>
     *
     * @param deletePortalRequest
     * @return Result of the DeletePortal operation returned by the service.
     * @throws InvalidRequestException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters. Check your request and try again.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws InternalFailureException
     *         IoT SiteWise can't process your request right now. Try again later.
     * @throws ThrottlingException
     *         Your request exceeded a rate limit. For example, you might have exceeded the number of IoT SiteWise
     *         assets that can be created per second, the allowed number of messages per second, and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.
     * @throws ConflictingOperationException
     *         Your request has conflicting operations. This can occur if you're trying to perform more than one
     *         operation on the same resource at the same time.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTSiteWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTSiteWiseClient.DeletePortal
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/DeletePortal" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DeletePortalResponse deletePortal(DeletePortalRequest deletePortalRequest) throws InvalidRequestException,
            ResourceNotFoundException, InternalFailureException, ThrottlingException, ConflictingOperationException,
            AwsServiceException, SdkClientException, IoTSiteWiseException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeletePortalResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DeletePortalResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deletePortalRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoTSiteWise");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeletePortal");
            String hostPrefix = "monitor.";
            String resolvedHostExpression = "monitor.";

            return clientHandler.execute(new ClientExecutionParams<DeletePortalRequest, DeletePortalResponse>()
                    .withOperationName("DeletePortal").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).hostPrefixExpression(resolvedHostExpression)
                    .withInput(deletePortalRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeletePortalRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes a project from IoT SiteWise Monitor.
     * </p>
     *
     * @param deleteProjectRequest
     * @return Result of the DeleteProject operation returned by the service.
     * @throws InvalidRequestException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters. Check your request and try again.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws InternalFailureException
     *         IoT SiteWise can't process your request right now. Try again later.
     * @throws ThrottlingException
     *         Your request exceeded a rate limit. For example, you might have exceeded the number of IoT SiteWise
     *         assets that can be created per second, the allowed number of messages per second, and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTSiteWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTSiteWiseClient.DeleteProject
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/DeleteProject" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DeleteProjectResponse deleteProject(DeleteProjectRequest deleteProjectRequest) throws InvalidRequestException,
            ResourceNotFoundException, InternalFailureException, ThrottlingException, AwsServiceException, SdkClientException,
            IoTSiteWiseException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteProjectResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DeleteProjectResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteProjectRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoTSiteWise");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteProject");
            String hostPrefix = "monitor.";
            String resolvedHostExpression = "monitor.";

            return clientHandler.execute(new ClientExecutionParams<DeleteProjectRequest, DeleteProjectResponse>()
                    .withOperationName("DeleteProject").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).hostPrefixExpression(resolvedHostExpression)
                    .withInput(deleteProjectRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteProjectRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes a time series (data stream). If you delete a time series that's associated with an asset property, the
     * asset property still exists, but the time series will no longer be associated with this asset property.
     * </p>
     * <p>
     * To identify a time series, do one of the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * If the time series isn't associated with an asset property, specify the <code>alias</code> of the time series.
     * </p>
     * </li>
     * <li>
     * <p>
     * If the time series is associated with an asset property, specify one of the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * The <code>alias</code> of the time series.
     * </p>
     * </li>
     * <li>
     * <p>
     * The <code>assetId</code> and <code>propertyId</code> that identifies the asset property.
     * </p>
     * </li>
     * </ul>
     * </li>
     * </ul>
     *
     * @param deleteTimeSeriesRequest
     * @return Result of the DeleteTimeSeries operation returned by the service.
     * @throws InvalidRequestException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters. Check your request and try again.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws InternalFailureException
     *         IoT SiteWise can't process your request right now. Try again later.
     * @throws ThrottlingException
     *         Your request exceeded a rate limit. For example, you might have exceeded the number of IoT SiteWise
     *         assets that can be created per second, the allowed number of messages per second, and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.
     * @throws ConflictingOperationException
     *         Your request has conflicting operations. This can occur if you're trying to perform more than one
     *         operation on the same resource at the same time.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTSiteWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTSiteWiseClient.DeleteTimeSeries
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/DeleteTimeSeries" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public DeleteTimeSeriesResponse deleteTimeSeries(DeleteTimeSeriesRequest deleteTimeSeriesRequest)
            throws InvalidRequestException, ResourceNotFoundException, InternalFailureException, ThrottlingException,
            ConflictingOperationException, AwsServiceException, SdkClientException, IoTSiteWiseException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteTimeSeriesResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DeleteTimeSeriesResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteTimeSeriesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoTSiteWise");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteTimeSeries");
            String hostPrefix = "api.";
            String resolvedHostExpression = "api.";

            return clientHandler.execute(new ClientExecutionParams<DeleteTimeSeriesRequest, DeleteTimeSeriesResponse>()
                    .withOperationName("DeleteTimeSeries").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).hostPrefixExpression(resolvedHostExpression)
                    .withInput(deleteTimeSeriesRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteTimeSeriesRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Describes an access policy, which specifies an identity's access to an IoT SiteWise Monitor portal or project.
     * </p>
     *
     * @param describeAccessPolicyRequest
     * @return Result of the DescribeAccessPolicy operation returned by the service.
     * @throws InvalidRequestException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters. Check your request and try again.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws InternalFailureException
     *         IoT SiteWise can't process your request right now. Try again later.
     * @throws ThrottlingException
     *         Your request exceeded a rate limit. For example, you might have exceeded the number of IoT SiteWise
     *         assets that can be created per second, the allowed number of messages per second, and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTSiteWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTSiteWiseClient.DescribeAccessPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/DescribeAccessPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeAccessPolicyResponse describeAccessPolicy(DescribeAccessPolicyRequest describeAccessPolicyRequest)
            throws InvalidRequestException, ResourceNotFoundException, InternalFailureException, ThrottlingException,
            AwsServiceException, SdkClientException, IoTSiteWiseException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeAccessPolicyResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DescribeAccessPolicyResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeAccessPolicyRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoTSiteWise");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeAccessPolicy");
            String hostPrefix = "monitor.";
            String resolvedHostExpression = "monitor.";

            return clientHandler.execute(new ClientExecutionParams<DescribeAccessPolicyRequest, DescribeAccessPolicyResponse>()
                    .withOperationName("DescribeAccessPolicy").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).hostPrefixExpression(resolvedHostExpression)
                    .withInput(describeAccessPolicyRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DescribeAccessPolicyRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves information about an asset.
     * </p>
     *
     * @param describeAssetRequest
     * @return Result of the DescribeAsset operation returned by the service.
     * @throws InvalidRequestException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters. Check your request and try again.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws InternalFailureException
     *         IoT SiteWise can't process your request right now. Try again later.
     * @throws ThrottlingException
     *         Your request exceeded a rate limit. For example, you might have exceeded the number of IoT SiteWise
     *         assets that can be created per second, the allowed number of messages per second, and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTSiteWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTSiteWiseClient.DescribeAsset
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/DescribeAsset" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DescribeAssetResponse describeAsset(DescribeAssetRequest describeAssetRequest) throws InvalidRequestException,
            ResourceNotFoundException, InternalFailureException, ThrottlingException, AwsServiceException, SdkClientException,
            IoTSiteWiseException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeAssetResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DescribeAssetResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeAssetRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoTSiteWise");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeAsset");
            String hostPrefix = "api.";
            String resolvedHostExpression = "api.";

            return clientHandler.execute(new ClientExecutionParams<DescribeAssetRequest, DescribeAssetResponse>()
                    .withOperationName("DescribeAsset").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).hostPrefixExpression(resolvedHostExpression)
                    .withInput(describeAssetRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DescribeAssetRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves information about an asset model.
     * </p>
     *
     * @param describeAssetModelRequest
     * @return Result of the DescribeAssetModel operation returned by the service.
     * @throws InvalidRequestException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters. Check your request and try again.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws InternalFailureException
     *         IoT SiteWise can't process your request right now. Try again later.
     * @throws ThrottlingException
     *         Your request exceeded a rate limit. For example, you might have exceeded the number of IoT SiteWise
     *         assets that can be created per second, the allowed number of messages per second, and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTSiteWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTSiteWiseClient.DescribeAssetModel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/DescribeAssetModel"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeAssetModelResponse describeAssetModel(DescribeAssetModelRequest describeAssetModelRequest)
            throws InvalidRequestException, ResourceNotFoundException, InternalFailureException, ThrottlingException,
            AwsServiceException, SdkClientException, IoTSiteWiseException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeAssetModelResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DescribeAssetModelResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeAssetModelRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoTSiteWise");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeAssetModel");
            String hostPrefix = "api.";
            String resolvedHostExpression = "api.";

            return clientHandler.execute(new ClientExecutionParams<DescribeAssetModelRequest, DescribeAssetModelResponse>()
                    .withOperationName("DescribeAssetModel").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).hostPrefixExpression(resolvedHostExpression)
                    .withInput(describeAssetModelRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DescribeAssetModelRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves information about an asset property.
     * </p>
     * <note>
     * <p>
     * When you call this operation for an attribute property, this response includes the default attribute value that
     * you define in the asset model. If you update the default value in the model, this operation's response includes
     * the new default value.
     * </p>
     * </note>
     * <p>
     * This operation doesn't return the value of the asset property. To get the value of an asset property, use <a
     * href="https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_GetAssetPropertyValue.html">
     * GetAssetPropertyValue</a>.
     * </p>
     *
     * @param describeAssetPropertyRequest
     * @return Result of the DescribeAssetProperty operation returned by the service.
     * @throws InvalidRequestException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters. Check your request and try again.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws InternalFailureException
     *         IoT SiteWise can't process your request right now. Try again later.
     * @throws ThrottlingException
     *         Your request exceeded a rate limit. For example, you might have exceeded the number of IoT SiteWise
     *         assets that can be created per second, the allowed number of messages per second, and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTSiteWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTSiteWiseClient.DescribeAssetProperty
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/DescribeAssetProperty"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeAssetPropertyResponse describeAssetProperty(DescribeAssetPropertyRequest describeAssetPropertyRequest)
            throws InvalidRequestException, ResourceNotFoundException, InternalFailureException, ThrottlingException,
            AwsServiceException, SdkClientException, IoTSiteWiseException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeAssetPropertyResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DescribeAssetPropertyResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeAssetPropertyRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoTSiteWise");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeAssetProperty");
            String hostPrefix = "api.";
            String resolvedHostExpression = "api.";

            return clientHandler.execute(new ClientExecutionParams<DescribeAssetPropertyRequest, DescribeAssetPropertyResponse>()
                    .withOperationName("DescribeAssetProperty").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).hostPrefixExpression(resolvedHostExpression)
                    .withInput(describeAssetPropertyRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DescribeAssetPropertyRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves information about a bulk import job request. For more information, see <a
     * href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/DescribeBulkImportJob.html">Describe a bulk
     * import job (CLI)</a> in the <i>Amazon Simple Storage Service User Guide</i>.
     * </p>
     *
     * @param describeBulkImportJobRequest
     * @return Result of the DescribeBulkImportJob operation returned by the service.
     * @throws InvalidRequestException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters. Check your request and try again.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws InternalFailureException
     *         IoT SiteWise can't process your request right now. Try again later.
     * @throws ThrottlingException
     *         Your request exceeded a rate limit. For example, you might have exceeded the number of IoT SiteWise
     *         assets that can be created per second, the allowed number of messages per second, and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTSiteWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTSiteWiseClient.DescribeBulkImportJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/DescribeBulkImportJob"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeBulkImportJobResponse describeBulkImportJob(DescribeBulkImportJobRequest describeBulkImportJobRequest)
            throws InvalidRequestException, ResourceNotFoundException, InternalFailureException, ThrottlingException,
            AwsServiceException, SdkClientException, IoTSiteWiseException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeBulkImportJobResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DescribeBulkImportJobResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeBulkImportJobRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoTSiteWise");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeBulkImportJob");
            String hostPrefix = "data.";
            String resolvedHostExpression = "data.";

            return clientHandler.execute(new ClientExecutionParams<DescribeBulkImportJobRequest, DescribeBulkImportJobResponse>()
                    .withOperationName("DescribeBulkImportJob").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).hostPrefixExpression(resolvedHostExpression)
                    .withInput(describeBulkImportJobRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DescribeBulkImportJobRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves information about a dashboard.
     * </p>
     *
     * @param describeDashboardRequest
     * @return Result of the DescribeDashboard operation returned by the service.
     * @throws InvalidRequestException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters. Check your request and try again.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws InternalFailureException
     *         IoT SiteWise can't process your request right now. Try again later.
     * @throws ThrottlingException
     *         Your request exceeded a rate limit. For example, you might have exceeded the number of IoT SiteWise
     *         assets that can be created per second, the allowed number of messages per second, and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTSiteWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTSiteWiseClient.DescribeDashboard
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/DescribeDashboard" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public DescribeDashboardResponse describeDashboard(DescribeDashboardRequest describeDashboardRequest)
            throws InvalidRequestException, ResourceNotFoundException, InternalFailureException, ThrottlingException,
            AwsServiceException, SdkClientException, IoTSiteWiseException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeDashboardResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DescribeDashboardResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeDashboardRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoTSiteWise");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeDashboard");
            String hostPrefix = "monitor.";
            String resolvedHostExpression = "monitor.";

            return clientHandler.execute(new ClientExecutionParams<DescribeDashboardRequest, DescribeDashboardResponse>()
                    .withOperationName("DescribeDashboard").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).hostPrefixExpression(resolvedHostExpression)
                    .withInput(describeDashboardRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DescribeDashboardRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves information about the default encryption configuration for the Amazon Web Services account in the
     * default or specified Region. For more information, see <a
     * href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/key-management.html">Key management</a> in the
     * <i>IoT SiteWise User Guide</i>.
     * </p>
     *
     * @param describeDefaultEncryptionConfigurationRequest
     * @return Result of the DescribeDefaultEncryptionConfiguration operation returned by the service.
     * @throws InvalidRequestException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters. Check your request and try again.
     * @throws InternalFailureException
     *         IoT SiteWise can't process your request right now. Try again later.
     * @throws ThrottlingException
     *         Your request exceeded a rate limit. For example, you might have exceeded the number of IoT SiteWise
     *         assets that can be created per second, the allowed number of messages per second, and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTSiteWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTSiteWiseClient.DescribeDefaultEncryptionConfiguration
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/DescribeDefaultEncryptionConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeDefaultEncryptionConfigurationResponse describeDefaultEncryptionConfiguration(
            DescribeDefaultEncryptionConfigurationRequest describeDefaultEncryptionConfigurationRequest)
            throws InvalidRequestException, InternalFailureException, ThrottlingException, AwsServiceException,
            SdkClientException, IoTSiteWiseException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeDefaultEncryptionConfigurationResponse> responseHandler = protocolFactory
                .createResponseHandler(operationMetadata, DescribeDefaultEncryptionConfigurationResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                describeDefaultEncryptionConfigurationRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoTSiteWise");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeDefaultEncryptionConfiguration");
            String hostPrefix = "api.";
            String resolvedHostExpression = "api.";

            return clientHandler
                    .execute(new ClientExecutionParams<DescribeDefaultEncryptionConfigurationRequest, DescribeDefaultEncryptionConfigurationResponse>()
                            .withOperationName("DescribeDefaultEncryptionConfiguration").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).hostPrefixExpression(resolvedHostExpression)
                            .withInput(describeDefaultEncryptionConfigurationRequest).withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DescribeDefaultEncryptionConfigurationRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves information about a gateway.
     * </p>
     *
     * @param describeGatewayRequest
     * @return Result of the DescribeGateway operation returned by the service.
     * @throws InvalidRequestException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters. Check your request and try again.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws InternalFailureException
     *         IoT SiteWise can't process your request right now. Try again later.
     * @throws ThrottlingException
     *         Your request exceeded a rate limit. For example, you might have exceeded the number of IoT SiteWise
     *         assets that can be created per second, the allowed number of messages per second, and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTSiteWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTSiteWiseClient.DescribeGateway
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/DescribeGateway" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public DescribeGatewayResponse describeGateway(DescribeGatewayRequest describeGatewayRequest) throws InvalidRequestException,
            ResourceNotFoundException, InternalFailureException, ThrottlingException, AwsServiceException, SdkClientException,
            IoTSiteWiseException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeGatewayResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DescribeGatewayResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeGatewayRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoTSiteWise");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeGateway");
            String hostPrefix = "api.";
            String resolvedHostExpression = "api.";

            return clientHandler.execute(new ClientExecutionParams<DescribeGatewayRequest, DescribeGatewayResponse>()
                    .withOperationName("DescribeGateway").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).hostPrefixExpression(resolvedHostExpression)
                    .withInput(describeGatewayRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DescribeGatewayRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves information about a gateway capability configuration. Each gateway capability defines data sources for
     * a gateway. A capability configuration can contain multiple data source configurations. If you define OPC-UA
     * sources for a gateway in the IoT SiteWise console, all of your OPC-UA sources are stored in one capability
     * configuration. To list all capability configurations for a gateway, use <a
     * href="https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_DescribeGateway.html">DescribeGateway</a>.
     * </p>
     *
     * @param describeGatewayCapabilityConfigurationRequest
     * @return Result of the DescribeGatewayCapabilityConfiguration operation returned by the service.
     * @throws InvalidRequestException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters. Check your request and try again.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws InternalFailureException
     *         IoT SiteWise can't process your request right now. Try again later.
     * @throws ThrottlingException
     *         Your request exceeded a rate limit. For example, you might have exceeded the number of IoT SiteWise
     *         assets that can be created per second, the allowed number of messages per second, and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTSiteWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTSiteWiseClient.DescribeGatewayCapabilityConfiguration
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/DescribeGatewayCapabilityConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeGatewayCapabilityConfigurationResponse describeGatewayCapabilityConfiguration(
            DescribeGatewayCapabilityConfigurationRequest describeGatewayCapabilityConfigurationRequest)
            throws InvalidRequestException, ResourceNotFoundException, InternalFailureException, ThrottlingException,
            AwsServiceException, SdkClientException, IoTSiteWiseException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeGatewayCapabilityConfigurationResponse> responseHandler = protocolFactory
                .createResponseHandler(operationMetadata, DescribeGatewayCapabilityConfigurationResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                describeGatewayCapabilityConfigurationRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoTSiteWise");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeGatewayCapabilityConfiguration");
            String hostPrefix = "api.";
            String resolvedHostExpression = "api.";

            return clientHandler
                    .execute(new ClientExecutionParams<DescribeGatewayCapabilityConfigurationRequest, DescribeGatewayCapabilityConfigurationResponse>()
                            .withOperationName("DescribeGatewayCapabilityConfiguration").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).hostPrefixExpression(resolvedHostExpression)
                            .withInput(describeGatewayCapabilityConfigurationRequest).withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DescribeGatewayCapabilityConfigurationRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves the current IoT SiteWise logging options.
     * </p>
     *
     * @param describeLoggingOptionsRequest
     * @return Result of the DescribeLoggingOptions operation returned by the service.
     * @throws InvalidRequestException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters. Check your request and try again.
     * @throws ThrottlingException
     *         Your request exceeded a rate limit. For example, you might have exceeded the number of IoT SiteWise
     *         assets that can be created per second, the allowed number of messages per second, and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.
     * @throws InternalFailureException
     *         IoT SiteWise can't process your request right now. Try again later.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTSiteWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTSiteWiseClient.DescribeLoggingOptions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/DescribeLoggingOptions"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeLoggingOptionsResponse describeLoggingOptions(DescribeLoggingOptionsRequest describeLoggingOptionsRequest)
            throws InvalidRequestException, ThrottlingException, InternalFailureException, ResourceNotFoundException,
            AwsServiceException, SdkClientException, IoTSiteWiseException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeLoggingOptionsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DescribeLoggingOptionsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeLoggingOptionsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoTSiteWise");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeLoggingOptions");
            String hostPrefix = "api.";
            String resolvedHostExpression = "api.";

            return clientHandler
                    .execute(new ClientExecutionParams<DescribeLoggingOptionsRequest, DescribeLoggingOptionsResponse>()
                            .withOperationName("DescribeLoggingOptions").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).hostPrefixExpression(resolvedHostExpression)
                            .withInput(describeLoggingOptionsRequest).withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DescribeLoggingOptionsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves information about a portal.
     * </p>
     *
     * @param describePortalRequest
     * @return Result of the DescribePortal operation returned by the service.
     * @throws InvalidRequestException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters. Check your request and try again.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws InternalFailureException
     *         IoT SiteWise can't process your request right now. Try again later.
     * @throws ThrottlingException
     *         Your request exceeded a rate limit. For example, you might have exceeded the number of IoT SiteWise
     *         assets that can be created per second, the allowed number of messages per second, and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTSiteWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTSiteWiseClient.DescribePortal
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/DescribePortal" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public DescribePortalResponse describePortal(DescribePortalRequest describePortalRequest) throws InvalidRequestException,
            ResourceNotFoundException, InternalFailureException, ThrottlingException, AwsServiceException, SdkClientException,
            IoTSiteWiseException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribePortalResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DescribePortalResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describePortalRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoTSiteWise");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribePortal");
            String hostPrefix = "monitor.";
            String resolvedHostExpression = "monitor.";

            return clientHandler.execute(new ClientExecutionParams<DescribePortalRequest, DescribePortalResponse>()
                    .withOperationName("DescribePortal").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).hostPrefixExpression(resolvedHostExpression)
                    .withInput(describePortalRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DescribePortalRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves information about a project.
     * </p>
     *
     * @param describeProjectRequest
     * @return Result of the DescribeProject operation returned by the service.
     * @throws InvalidRequestException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters. Check your request and try again.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws InternalFailureException
     *         IoT SiteWise can't process your request right now. Try again later.
     * @throws ThrottlingException
     *         Your request exceeded a rate limit. For example, you might have exceeded the number of IoT SiteWise
     *         assets that can be created per second, the allowed number of messages per second, and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTSiteWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTSiteWiseClient.DescribeProject
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/DescribeProject" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public DescribeProjectResponse describeProject(DescribeProjectRequest describeProjectRequest) throws InvalidRequestException,
            ResourceNotFoundException, InternalFailureException, ThrottlingException, AwsServiceException, SdkClientException,
            IoTSiteWiseException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeProjectResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DescribeProjectResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeProjectRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoTSiteWise");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeProject");
            String hostPrefix = "monitor.";
            String resolvedHostExpression = "monitor.";

            return clientHandler.execute(new ClientExecutionParams<DescribeProjectRequest, DescribeProjectResponse>()
                    .withOperationName("DescribeProject").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).hostPrefixExpression(resolvedHostExpression)
                    .withInput(describeProjectRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DescribeProjectRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves information about the storage configuration for IoT SiteWise.
     * </p>
     *
     * @param describeStorageConfigurationRequest
     * @return Result of the DescribeStorageConfiguration operation returned by the service.
     * @throws InvalidRequestException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters. Check your request and try again.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws InternalFailureException
     *         IoT SiteWise can't process your request right now. Try again later.
     * @throws ThrottlingException
     *         Your request exceeded a rate limit. For example, you might have exceeded the number of IoT SiteWise
     *         assets that can be created per second, the allowed number of messages per second, and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.
     * @throws LimitExceededException
     *         You've reached the limit for a resource. For example, this can occur if you're trying to associate more
     *         than the allowed number of child assets or attempting to create more than the allowed number of
     *         properties for an asset model.
     *         </p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.
     * @throws ConflictingOperationException
     *         Your request has conflicting operations. This can occur if you're trying to perform more than one
     *         operation on the same resource at the same time.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTSiteWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTSiteWiseClient.DescribeStorageConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/DescribeStorageConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeStorageConfigurationResponse describeStorageConfiguration(
            DescribeStorageConfigurationRequest describeStorageConfigurationRequest) throws InvalidRequestException,
            ResourceNotFoundException, InternalFailureException, ThrottlingException, LimitExceededException,
            ConflictingOperationException, AwsServiceException, SdkClientException, IoTSiteWiseException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeStorageConfigurationResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DescribeStorageConfigurationResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeStorageConfigurationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoTSiteWise");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeStorageConfiguration");
            String hostPrefix = "api.";
            String resolvedHostExpression = "api.";

            return clientHandler
                    .execute(new ClientExecutionParams<DescribeStorageConfigurationRequest, DescribeStorageConfigurationResponse>()
                            .withOperationName("DescribeStorageConfiguration").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).hostPrefixExpression(resolvedHostExpression)
                            .withInput(describeStorageConfigurationRequest).withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DescribeStorageConfigurationRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves information about a time series (data stream).
     * </p>
     * <p>
     * To identify a time series, do one of the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * If the time series isn't associated with an asset property, specify the <code>alias</code> of the time series.
     * </p>
     * </li>
     * <li>
     * <p>
     * If the time series is associated with an asset property, specify one of the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * The <code>alias</code> of the time series.
     * </p>
     * </li>
     * <li>
     * <p>
     * The <code>assetId</code> and <code>propertyId</code> that identifies the asset property.
     * </p>
     * </li>
     * </ul>
     * </li>
     * </ul>
     *
     * @param describeTimeSeriesRequest
     * @return Result of the DescribeTimeSeries operation returned by the service.
     * @throws InvalidRequestException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters. Check your request and try again.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws InternalFailureException
     *         IoT SiteWise can't process your request right now. Try again later.
     * @throws ThrottlingException
     *         Your request exceeded a rate limit. For example, you might have exceeded the number of IoT SiteWise
     *         assets that can be created per second, the allowed number of messages per second, and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTSiteWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTSiteWiseClient.DescribeTimeSeries
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/DescribeTimeSeries"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeTimeSeriesResponse describeTimeSeries(DescribeTimeSeriesRequest describeTimeSeriesRequest)
            throws InvalidRequestException, ResourceNotFoundException, InternalFailureException, ThrottlingException,
            AwsServiceException, SdkClientException, IoTSiteWiseException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeTimeSeriesResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DescribeTimeSeriesResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeTimeSeriesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoTSiteWise");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeTimeSeries");
            String hostPrefix = "api.";
            String resolvedHostExpression = "api.";

            return clientHandler.execute(new ClientExecutionParams<DescribeTimeSeriesRequest, DescribeTimeSeriesResponse>()
                    .withOperationName("DescribeTimeSeries").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).hostPrefixExpression(resolvedHostExpression)
                    .withInput(describeTimeSeriesRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DescribeTimeSeriesRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Disassociates a child asset from the given parent asset through a hierarchy defined in the parent asset's model.
     * </p>
     *
     * @param disassociateAssetsRequest
     * @return Result of the DisassociateAssets operation returned by the service.
     * @throws InvalidRequestException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters. Check your request and try again.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws InternalFailureException
     *         IoT SiteWise can't process your request right now. Try again later.
     * @throws ThrottlingException
     *         Your request exceeded a rate limit. For example, you might have exceeded the number of IoT SiteWise
     *         assets that can be created per second, the allowed number of messages per second, and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.
     * @throws ConflictingOperationException
     *         Your request has conflicting operations. This can occur if you're trying to perform more than one
     *         operation on the same resource at the same time.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTSiteWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTSiteWiseClient.DisassociateAssets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/DisassociateAssets"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DisassociateAssetsResponse disassociateAssets(DisassociateAssetsRequest disassociateAssetsRequest)
            throws InvalidRequestException, ResourceNotFoundException, InternalFailureException, ThrottlingException,
            ConflictingOperationException, AwsServiceException, SdkClientException, IoTSiteWiseException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DisassociateAssetsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DisassociateAssetsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, disassociateAssetsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoTSiteWise");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DisassociateAssets");
            String hostPrefix = "api.";
            String resolvedHostExpression = "api.";

            return clientHandler.execute(new ClientExecutionParams<DisassociateAssetsRequest, DisassociateAssetsResponse>()
                    .withOperationName("DisassociateAssets").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).hostPrefixExpression(resolvedHostExpression)
                    .withInput(disassociateAssetsRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DisassociateAssetsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Disassociates a time series (data stream) from an asset property.
     * </p>
     *
     * @param disassociateTimeSeriesFromAssetPropertyRequest
     * @return Result of the DisassociateTimeSeriesFromAssetProperty operation returned by the service.
     * @throws InvalidRequestException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters. Check your request and try again.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws InternalFailureException
     *         IoT SiteWise can't process your request right now. Try again later.
     * @throws ThrottlingException
     *         Your request exceeded a rate limit. For example, you might have exceeded the number of IoT SiteWise
     *         assets that can be created per second, the allowed number of messages per second, and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.
     * @throws ConflictingOperationException
     *         Your request has conflicting operations. This can occur if you're trying to perform more than one
     *         operation on the same resource at the same time.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTSiteWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTSiteWiseClient.DisassociateTimeSeriesFromAssetProperty
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/DisassociateTimeSeriesFromAssetProperty"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DisassociateTimeSeriesFromAssetPropertyResponse disassociateTimeSeriesFromAssetProperty(
            DisassociateTimeSeriesFromAssetPropertyRequest disassociateTimeSeriesFromAssetPropertyRequest)
            throws InvalidRequestException, ResourceNotFoundException, InternalFailureException, ThrottlingException,
            ConflictingOperationException, AwsServiceException, SdkClientException, IoTSiteWiseException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DisassociateTimeSeriesFromAssetPropertyResponse> responseHandler = protocolFactory
                .createResponseHandler(operationMetadata, DisassociateTimeSeriesFromAssetPropertyResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                disassociateTimeSeriesFromAssetPropertyRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoTSiteWise");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DisassociateTimeSeriesFromAssetProperty");
            String hostPrefix = "api.";
            String resolvedHostExpression = "api.";

            return clientHandler
                    .execute(new ClientExecutionParams<DisassociateTimeSeriesFromAssetPropertyRequest, DisassociateTimeSeriesFromAssetPropertyResponse>()
                            .withOperationName("DisassociateTimeSeriesFromAssetProperty").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).hostPrefixExpression(resolvedHostExpression)
                            .withInput(disassociateTimeSeriesFromAssetPropertyRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DisassociateTimeSeriesFromAssetPropertyRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets aggregated values for an asset property. For more information, see <a
     * href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/query-industrial-data.html#aggregates">Querying
     * aggregates</a> in the <i>IoT SiteWise User Guide</i>.
     * </p>
     * <p>
     * To identify an asset property, you must specify one of the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * The <code>assetId</code> and <code>propertyId</code> of an asset property.
     * </p>
     * </li>
     * <li>
     * <p>
     * A <code>propertyAlias</code>, which is a data stream alias (for example,
     * <code>/company/windfarm/3/turbine/7/temperature</code>). To define an asset property's alias, see <a
     * href="https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_UpdateAssetProperty.html"
     * >UpdateAssetProperty</a>.
     * </p>
     * </li>
     * </ul>
     *
     * @param getAssetPropertyAggregatesRequest
     * @return Result of the GetAssetPropertyAggregates operation returned by the service.
     * @throws InvalidRequestException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters. Check your request and try again.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws InternalFailureException
     *         IoT SiteWise can't process your request right now. Try again later.
     * @throws ThrottlingException
     *         Your request exceeded a rate limit. For example, you might have exceeded the number of IoT SiteWise
     *         assets that can be created per second, the allowed number of messages per second, and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.
     * @throws ServiceUnavailableException
     *         The requested service is unavailable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTSiteWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTSiteWiseClient.GetAssetPropertyAggregates
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/GetAssetPropertyAggregates"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public GetAssetPropertyAggregatesResponse getAssetPropertyAggregates(
            GetAssetPropertyAggregatesRequest getAssetPropertyAggregatesRequest) throws InvalidRequestException,
            ResourceNotFoundException, InternalFailureException, ThrottlingException, ServiceUnavailableException,
            AwsServiceException, SdkClientException, IoTSiteWiseException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetAssetPropertyAggregatesResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, GetAssetPropertyAggregatesResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getAssetPropertyAggregatesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoTSiteWise");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetAssetPropertyAggregates");
            String hostPrefix = "data.";
            String resolvedHostExpression = "data.";

            return clientHandler
                    .execute(new ClientExecutionParams<GetAssetPropertyAggregatesRequest, GetAssetPropertyAggregatesResponse>()
                            .withOperationName("GetAssetPropertyAggregates").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).hostPrefixExpression(resolvedHostExpression)
                            .withInput(getAssetPropertyAggregatesRequest).withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new GetAssetPropertyAggregatesRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets an asset property's current value. For more information, see <a
     * href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/query-industrial-data.html#current-values"
     * >Querying current values</a> in the <i>IoT SiteWise User Guide</i>.
     * </p>
     * <p>
     * To identify an asset property, you must specify one of the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * The <code>assetId</code> and <code>propertyId</code> of an asset property.
     * </p>
     * </li>
     * <li>
     * <p>
     * A <code>propertyAlias</code>, which is a data stream alias (for example,
     * <code>/company/windfarm/3/turbine/7/temperature</code>). To define an asset property's alias, see <a
     * href="https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_UpdateAssetProperty.html"
     * >UpdateAssetProperty</a>.
     * </p>
     * </li>
     * </ul>
     *
     * @param getAssetPropertyValueRequest
     * @return Result of the GetAssetPropertyValue operation returned by the service.
     * @throws InvalidRequestException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters. Check your request and try again.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws InternalFailureException
     *         IoT SiteWise can't process your request right now. Try again later.
     * @throws ThrottlingException
     *         Your request exceeded a rate limit. For example, you might have exceeded the number of IoT SiteWise
     *         assets that can be created per second, the allowed number of messages per second, and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.
     * @throws ServiceUnavailableException
     *         The requested service is unavailable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTSiteWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTSiteWiseClient.GetAssetPropertyValue
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/GetAssetPropertyValue"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public GetAssetPropertyValueResponse getAssetPropertyValue(GetAssetPropertyValueRequest getAssetPropertyValueRequest)
            throws InvalidRequestException, ResourceNotFoundException, InternalFailureException, ThrottlingException,
            ServiceUnavailableException, AwsServiceException, SdkClientException, IoTSiteWiseException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetAssetPropertyValueResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, GetAssetPropertyValueResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getAssetPropertyValueRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoTSiteWise");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetAssetPropertyValue");
            String hostPrefix = "data.";
            String resolvedHostExpression = "data.";

            return clientHandler.execute(new ClientExecutionParams<GetAssetPropertyValueRequest, GetAssetPropertyValueResponse>()
                    .withOperationName("GetAssetPropertyValue").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).hostPrefixExpression(resolvedHostExpression)
                    .withInput(getAssetPropertyValueRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetAssetPropertyValueRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets the history of an asset property's values. For more information, see <a
     * href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/query-industrial-data.html#historical-values"
     * >Querying historical values</a> in the <i>IoT SiteWise User Guide</i>.
     * </p>
     * <p>
     * To identify an asset property, you must specify one of the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * The <code>assetId</code> and <code>propertyId</code> of an asset property.
     * </p>
     * </li>
     * <li>
     * <p>
     * A <code>propertyAlias</code>, which is a data stream alias (for example,
     * <code>/company/windfarm/3/turbine/7/temperature</code>). To define an asset property's alias, see <a
     * href="https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_UpdateAssetProperty.html"
     * >UpdateAssetProperty</a>.
     * </p>
     * </li>
     * </ul>
     *
     * @param getAssetPropertyValueHistoryRequest
     * @return Result of the GetAssetPropertyValueHistory operation returned by the service.
     * @throws InvalidRequestException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters. Check your request and try again.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws InternalFailureException
     *         IoT SiteWise can't process your request right now. Try again later.
     * @throws ThrottlingException
     *         Your request exceeded a rate limit. For example, you might have exceeded the number of IoT SiteWise
     *         assets that can be created per second, the allowed number of messages per second, and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.
     * @throws ServiceUnavailableException
     *         The requested service is unavailable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTSiteWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTSiteWiseClient.GetAssetPropertyValueHistory
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/GetAssetPropertyValueHistory"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public GetAssetPropertyValueHistoryResponse getAssetPropertyValueHistory(
            GetAssetPropertyValueHistoryRequest getAssetPropertyValueHistoryRequest) throws InvalidRequestException,
            ResourceNotFoundException, InternalFailureException, ThrottlingException, ServiceUnavailableException,
            AwsServiceException, SdkClientException, IoTSiteWiseException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetAssetPropertyValueHistoryResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, GetAssetPropertyValueHistoryResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getAssetPropertyValueHistoryRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoTSiteWise");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetAssetPropertyValueHistory");
            String hostPrefix = "data.";
            String resolvedHostExpression = "data.";

            return clientHandler
                    .execute(new ClientExecutionParams<GetAssetPropertyValueHistoryRequest, GetAssetPropertyValueHistoryResponse>()
                            .withOperationName("GetAssetPropertyValueHistory").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).hostPrefixExpression(resolvedHostExpression)
                            .withInput(getAssetPropertyValueHistoryRequest).withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new GetAssetPropertyValueHistoryRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Get interpolated values for an asset property for a specified time interval, during a period of time. If your
     * time series is missing data points during the specified time interval, you can use interpolation to estimate the
     * missing data.
     * </p>
     * <p>
     * For example, you can use this operation to return the interpolated temperature values for a wind turbine every 24
     * hours over a duration of 7 days.
     * </p>
     * <p>
     * To identify an asset property, you must specify one of the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * The <code>assetId</code> and <code>propertyId</code> of an asset property.
     * </p>
     * </li>
     * <li>
     * <p>
     * A <code>propertyAlias</code>, which is a data stream alias (for example,
     * <code>/company/windfarm/3/turbine/7/temperature</code>). To define an asset property's alias, see <a
     * href="https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_UpdateAssetProperty.html"
     * >UpdateAssetProperty</a>.
     * </p>
     * </li>
     * </ul>
     *
     * @param getInterpolatedAssetPropertyValuesRequest
     * @return Result of the GetInterpolatedAssetPropertyValues operation returned by the service.
     * @throws InvalidRequestException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters. Check your request and try again.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws InternalFailureException
     *         IoT SiteWise can't process your request right now. Try again later.
     * @throws ThrottlingException
     *         Your request exceeded a rate limit. For example, you might have exceeded the number of IoT SiteWise
     *         assets that can be created per second, the allowed number of messages per second, and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.
     * @throws ServiceUnavailableException
     *         The requested service is unavailable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTSiteWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTSiteWiseClient.GetInterpolatedAssetPropertyValues
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/GetInterpolatedAssetPropertyValues"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public GetInterpolatedAssetPropertyValuesResponse getInterpolatedAssetPropertyValues(
            GetInterpolatedAssetPropertyValuesRequest getInterpolatedAssetPropertyValuesRequest) throws InvalidRequestException,
            ResourceNotFoundException, InternalFailureException, ThrottlingException, ServiceUnavailableException,
            AwsServiceException, SdkClientException, IoTSiteWiseException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetInterpolatedAssetPropertyValuesResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, GetInterpolatedAssetPropertyValuesResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                getInterpolatedAssetPropertyValuesRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoTSiteWise");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetInterpolatedAssetPropertyValues");
            String hostPrefix = "data.";
            String resolvedHostExpression = "data.";

            return clientHandler
                    .execute(new ClientExecutionParams<GetInterpolatedAssetPropertyValuesRequest, GetInterpolatedAssetPropertyValuesResponse>()
                            .withOperationName("GetInterpolatedAssetPropertyValues").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).hostPrefixExpression(resolvedHostExpression)
                            .withInput(getInterpolatedAssetPropertyValuesRequest).withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new GetInterpolatedAssetPropertyValuesRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves a paginated list of access policies for an identity (an IAM Identity Center user, an IAM Identity
     * Center group, or an IAM user) or an IoT SiteWise Monitor resource (a portal or project).
     * </p>
     *
     * @param listAccessPoliciesRequest
     * @return Result of the ListAccessPolicies operation returned by the service.
     * @throws InvalidRequestException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters. Check your request and try again.
     * @throws InternalFailureException
     *         IoT SiteWise can't process your request right now. Try again later.
     * @throws ThrottlingException
     *         Your request exceeded a rate limit. For example, you might have exceeded the number of IoT SiteWise
     *         assets that can be created per second, the allowed number of messages per second, and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTSiteWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTSiteWiseClient.ListAccessPolicies
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/ListAccessPolicies"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListAccessPoliciesResponse listAccessPolicies(ListAccessPoliciesRequest listAccessPoliciesRequest)
            throws InvalidRequestException, InternalFailureException, ThrottlingException, AwsServiceException,
            SdkClientException, IoTSiteWiseException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListAccessPoliciesResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListAccessPoliciesResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listAccessPoliciesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoTSiteWise");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListAccessPolicies");
            String hostPrefix = "monitor.";
            String resolvedHostExpression = "monitor.";

            return clientHandler.execute(new ClientExecutionParams<ListAccessPoliciesRequest, ListAccessPoliciesResponse>()
                    .withOperationName("ListAccessPolicies").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).hostPrefixExpression(resolvedHostExpression)
                    .withInput(listAccessPoliciesRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListAccessPoliciesRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves a paginated list of properties associated with an asset model. If you update properties associated with
     * the model before you finish listing all the properties, you need to start all over again.
     * </p>
     *
     * @param listAssetModelPropertiesRequest
     * @return Result of the ListAssetModelProperties operation returned by the service.
     * @throws InvalidRequestException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters. Check your request and try again.
     * @throws InternalFailureException
     *         IoT SiteWise can't process your request right now. Try again later.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws ThrottlingException
     *         Your request exceeded a rate limit. For example, you might have exceeded the number of IoT SiteWise
     *         assets that can be created per second, the allowed number of messages per second, and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTSiteWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTSiteWiseClient.ListAssetModelProperties
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/ListAssetModelProperties"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListAssetModelPropertiesResponse listAssetModelProperties(
            ListAssetModelPropertiesRequest listAssetModelPropertiesRequest) throws InvalidRequestException,
            InternalFailureException, ResourceNotFoundException, ThrottlingException, AwsServiceException, SdkClientException,
            IoTSiteWiseException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListAssetModelPropertiesResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListAssetModelPropertiesResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listAssetModelPropertiesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoTSiteWise");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListAssetModelProperties");
            String hostPrefix = "api.";
            String resolvedHostExpression = "api.";

            return clientHandler
                    .execute(new ClientExecutionParams<ListAssetModelPropertiesRequest, ListAssetModelPropertiesResponse>()
                            .withOperationName("ListAssetModelProperties").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).hostPrefixExpression(resolvedHostExpression)
                            .withInput(listAssetModelPropertiesRequest).withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new ListAssetModelPropertiesRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves a paginated list of summaries of all asset models.
     * </p>
     *
     * @param listAssetModelsRequest
     * @return Result of the ListAssetModels operation returned by the service.
     * @throws InvalidRequestException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters. Check your request and try again.
     * @throws InternalFailureException
     *         IoT SiteWise can't process your request right now. Try again later.
     * @throws ThrottlingException
     *         Your request exceeded a rate limit. For example, you might have exceeded the number of IoT SiteWise
     *         assets that can be created per second, the allowed number of messages per second, and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTSiteWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTSiteWiseClient.ListAssetModels
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/ListAssetModels" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public ListAssetModelsResponse listAssetModels(ListAssetModelsRequest listAssetModelsRequest) throws InvalidRequestException,
            InternalFailureException, ThrottlingException, AwsServiceException, SdkClientException, IoTSiteWiseException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListAssetModelsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                ListAssetModelsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listAssetModelsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoTSiteWise");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListAssetModels");
            String hostPrefix = "api.";
            String resolvedHostExpression = "api.";

            return clientHandler.execute(new ClientExecutionParams<ListAssetModelsRequest, ListAssetModelsResponse>()
                    .withOperationName("ListAssetModels").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).hostPrefixExpression(resolvedHostExpression)
                    .withInput(listAssetModelsRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListAssetModelsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves a paginated list of properties associated with an asset. If you update properties associated with the
     * model before you finish listing all the properties, you need to start all over again.
     * </p>
     *
     * @param listAssetPropertiesRequest
     * @return Result of the ListAssetProperties operation returned by the service.
     * @throws InvalidRequestException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters. Check your request and try again.
     * @throws InternalFailureException
     *         IoT SiteWise can't process your request right now. Try again later.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws ThrottlingException
     *         Your request exceeded a rate limit. For example, you might have exceeded the number of IoT SiteWise
     *         assets that can be created per second, the allowed number of messages per second, and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTSiteWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTSiteWiseClient.ListAssetProperties
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/ListAssetProperties"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListAssetPropertiesResponse listAssetProperties(ListAssetPropertiesRequest listAssetPropertiesRequest)
            throws InvalidRequestException, InternalFailureException, ResourceNotFoundException, ThrottlingException,
            AwsServiceException, SdkClientException, IoTSiteWiseException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListAssetPropertiesResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListAssetPropertiesResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listAssetPropertiesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoTSiteWise");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListAssetProperties");
            String hostPrefix = "api.";
            String resolvedHostExpression = "api.";

            return clientHandler.execute(new ClientExecutionParams<ListAssetPropertiesRequest, ListAssetPropertiesResponse>()
                    .withOperationName("ListAssetProperties").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).hostPrefixExpression(resolvedHostExpression)
                    .withInput(listAssetPropertiesRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListAssetPropertiesRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves a paginated list of asset relationships for an asset. You can use this operation to identify an asset's
     * root asset and all associated assets between that asset and its root.
     * </p>
     *
     * @param listAssetRelationshipsRequest
     * @return Result of the ListAssetRelationships operation returned by the service.
     * @throws InvalidRequestException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters. Check your request and try again.
     * @throws InternalFailureException
     *         IoT SiteWise can't process your request right now. Try again later.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws ThrottlingException
     *         Your request exceeded a rate limit. For example, you might have exceeded the number of IoT SiteWise
     *         assets that can be created per second, the allowed number of messages per second, and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTSiteWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTSiteWiseClient.ListAssetRelationships
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/ListAssetRelationships"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListAssetRelationshipsResponse listAssetRelationships(ListAssetRelationshipsRequest listAssetRelationshipsRequest)
            throws InvalidRequestException, InternalFailureException, ResourceNotFoundException, ThrottlingException,
            AwsServiceException, SdkClientException, IoTSiteWiseException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListAssetRelationshipsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListAssetRelationshipsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listAssetRelationshipsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoTSiteWise");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListAssetRelationships");
            String hostPrefix = "api.";
            String resolvedHostExpression = "api.";

            return clientHandler
                    .execute(new ClientExecutionParams<ListAssetRelationshipsRequest, ListAssetRelationshipsResponse>()
                            .withOperationName("ListAssetRelationships").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).hostPrefixExpression(resolvedHostExpression)
                            .withInput(listAssetRelationshipsRequest).withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new ListAssetRelationshipsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves a paginated list of asset summaries.
     * </p>
     * <p>
     * You can use this operation to do the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * List assets based on a specific asset model.
     * </p>
     * </li>
     * <li>
     * <p>
     * List top-level assets.
     * </p>
     * </li>
     * </ul>
     * <p>
     * You can't use this operation to list all assets. To retrieve summaries for all of your assets, use <a
     * href="https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_ListAssetModels.html">ListAssetModels</a>
     * to get all of your asset model IDs. Then, use ListAssets to get all assets for each asset model.
     * </p>
     *
     * @param listAssetsRequest
     * @return Result of the ListAssets operation returned by the service.
     * @throws InvalidRequestException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters. Check your request and try again.
     * @throws InternalFailureException
     *         IoT SiteWise can't process your request right now. Try again later.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws ThrottlingException
     *         Your request exceeded a rate limit. For example, you might have exceeded the number of IoT SiteWise
     *         assets that can be created per second, the allowed number of messages per second, and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTSiteWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTSiteWiseClient.ListAssets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/ListAssets" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ListAssetsResponse listAssets(ListAssetsRequest listAssetsRequest) throws InvalidRequestException,
            InternalFailureException, ResourceNotFoundException, ThrottlingException, AwsServiceException, SdkClientException,
            IoTSiteWiseException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListAssetsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                ListAssetsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listAssetsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoTSiteWise");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListAssets");
            String hostPrefix = "api.";
            String resolvedHostExpression = "api.";

            return clientHandler.execute(new ClientExecutionParams<ListAssetsRequest, ListAssetsResponse>()
                    .withOperationName("ListAssets").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).hostPrefixExpression(resolvedHostExpression)
                    .withInput(listAssetsRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListAssetsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves a paginated list of associated assets.
     * </p>
     * <p>
     * You can use this operation to do the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * List child assets associated to a parent asset by a hierarchy that you specify.
     * </p>
     * </li>
     * <li>
     * <p>
     * List an asset's parent asset.
     * </p>
     * </li>
     * </ul>
     *
     * @param listAssociatedAssetsRequest
     * @return Result of the ListAssociatedAssets operation returned by the service.
     * @throws InvalidRequestException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters. Check your request and try again.
     * @throws InternalFailureException
     *         IoT SiteWise can't process your request right now. Try again later.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws ThrottlingException
     *         Your request exceeded a rate limit. For example, you might have exceeded the number of IoT SiteWise
     *         assets that can be created per second, the allowed number of messages per second, and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTSiteWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTSiteWiseClient.ListAssociatedAssets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/ListAssociatedAssets"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListAssociatedAssetsResponse listAssociatedAssets(ListAssociatedAssetsRequest listAssociatedAssetsRequest)
            throws InvalidRequestException, InternalFailureException, ResourceNotFoundException, ThrottlingException,
            AwsServiceException, SdkClientException, IoTSiteWiseException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListAssociatedAssetsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListAssociatedAssetsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listAssociatedAssetsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoTSiteWise");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListAssociatedAssets");
            String hostPrefix = "api.";
            String resolvedHostExpression = "api.";

            return clientHandler.execute(new ClientExecutionParams<ListAssociatedAssetsRequest, ListAssociatedAssetsResponse>()
                    .withOperationName("ListAssociatedAssets").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).hostPrefixExpression(resolvedHostExpression)
                    .withInput(listAssociatedAssetsRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListAssociatedAssetsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves a paginated list of bulk import job requests. For more information, see <a
     * href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/ListBulkImportJobs.html">List bulk import jobs
     * (CLI)</a> in the <i>IoT SiteWise User Guide</i>.
     * </p>
     *
     * @param listBulkImportJobsRequest
     * @return Result of the ListBulkImportJobs operation returned by the service.
     * @throws InvalidRequestException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters. Check your request and try again.
     * @throws InternalFailureException
     *         IoT SiteWise can't process your request right now. Try again later.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws ThrottlingException
     *         Your request exceeded a rate limit. For example, you might have exceeded the number of IoT SiteWise
     *         assets that can be created per second, the allowed number of messages per second, and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTSiteWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTSiteWiseClient.ListBulkImportJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/ListBulkImportJobs"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListBulkImportJobsResponse listBulkImportJobs(ListBulkImportJobsRequest listBulkImportJobsRequest)
            throws InvalidRequestException, InternalFailureException, ResourceNotFoundException, ThrottlingException,
            AwsServiceException, SdkClientException, IoTSiteWiseException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListBulkImportJobsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListBulkImportJobsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listBulkImportJobsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoTSiteWise");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListBulkImportJobs");
            String hostPrefix = "data.";
            String resolvedHostExpression = "data.";

            return clientHandler.execute(new ClientExecutionParams<ListBulkImportJobsRequest, ListBulkImportJobsResponse>()
                    .withOperationName("ListBulkImportJobs").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).hostPrefixExpression(resolvedHostExpression)
                    .withInput(listBulkImportJobsRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListBulkImportJobsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves a paginated list of dashboards for an IoT SiteWise Monitor project.
     * </p>
     *
     * @param listDashboardsRequest
     * @return Result of the ListDashboards operation returned by the service.
     * @throws InvalidRequestException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters. Check your request and try again.
     * @throws InternalFailureException
     *         IoT SiteWise can't process your request right now. Try again later.
     * @throws ThrottlingException
     *         Your request exceeded a rate limit. For example, you might have exceeded the number of IoT SiteWise
     *         assets that can be created per second, the allowed number of messages per second, and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTSiteWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTSiteWiseClient.ListDashboards
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/ListDashboards" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public ListDashboardsResponse listDashboards(ListDashboardsRequest listDashboardsRequest) throws InvalidRequestException,
            InternalFailureException, ThrottlingException, AwsServiceException, SdkClientException, IoTSiteWiseException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListDashboardsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                ListDashboardsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listDashboardsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoTSiteWise");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListDashboards");
            String hostPrefix = "monitor.";
            String resolvedHostExpression = "monitor.";

            return clientHandler.execute(new ClientExecutionParams<ListDashboardsRequest, ListDashboardsResponse>()
                    .withOperationName("ListDashboards").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).hostPrefixExpression(resolvedHostExpression)
                    .withInput(listDashboardsRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListDashboardsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves a paginated list of gateways.
     * </p>
     *
     * @param listGatewaysRequest
     * @return Result of the ListGateways operation returned by the service.
     * @throws InvalidRequestException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters. Check your request and try again.
     * @throws InternalFailureException
     *         IoT SiteWise can't process your request right now. Try again later.
     * @throws ThrottlingException
     *         Your request exceeded a rate limit. For example, you might have exceeded the number of IoT SiteWise
     *         assets that can be created per second, the allowed number of messages per second, and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTSiteWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTSiteWiseClient.ListGateways
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/ListGateways" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ListGatewaysResponse listGateways(ListGatewaysRequest listGatewaysRequest) throws InvalidRequestException,
            InternalFailureException, ThrottlingException, AwsServiceException, SdkClientException, IoTSiteWiseException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListGatewaysResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                ListGatewaysResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listGatewaysRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoTSiteWise");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListGateways");
            String hostPrefix = "api.";
            String resolvedHostExpression = "api.";

            return clientHandler.execute(new ClientExecutionParams<ListGatewaysRequest, ListGatewaysResponse>()
                    .withOperationName("ListGateways").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).hostPrefixExpression(resolvedHostExpression)
                    .withInput(listGatewaysRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListGatewaysRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves a paginated list of IoT SiteWise Monitor portals.
     * </p>
     *
     * @param listPortalsRequest
     * @return Result of the ListPortals operation returned by the service.
     * @throws InvalidRequestException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters. Check your request and try again.
     * @throws InternalFailureException
     *         IoT SiteWise can't process your request right now. Try again later.
     * @throws ThrottlingException
     *         Your request exceeded a rate limit. For example, you might have exceeded the number of IoT SiteWise
     *         assets that can be created per second, the allowed number of messages per second, and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTSiteWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTSiteWiseClient.ListPortals
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/ListPortals" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ListPortalsResponse listPortals(ListPortalsRequest listPortalsRequest) throws InvalidRequestException,
            InternalFailureException, ThrottlingException, AwsServiceException, SdkClientException, IoTSiteWiseException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListPortalsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                ListPortalsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listPortalsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoTSiteWise");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListPortals");
            String hostPrefix = "monitor.";
            String resolvedHostExpression = "monitor.";

            return clientHandler.execute(new ClientExecutionParams<ListPortalsRequest, ListPortalsResponse>()
                    .withOperationName("ListPortals").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).hostPrefixExpression(resolvedHostExpression)
                    .withInput(listPortalsRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListPortalsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves a paginated list of assets associated with an IoT SiteWise Monitor project.
     * </p>
     *
     * @param listProjectAssetsRequest
     * @return Result of the ListProjectAssets operation returned by the service.
     * @throws InvalidRequestException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters. Check your request and try again.
     * @throws InternalFailureException
     *         IoT SiteWise can't process your request right now. Try again later.
     * @throws ThrottlingException
     *         Your request exceeded a rate limit. For example, you might have exceeded the number of IoT SiteWise
     *         assets that can be created per second, the allowed number of messages per second, and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTSiteWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTSiteWiseClient.ListProjectAssets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/ListProjectAssets" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public ListProjectAssetsResponse listProjectAssets(ListProjectAssetsRequest listProjectAssetsRequest)
            throws InvalidRequestException, InternalFailureException, ThrottlingException, AwsServiceException,
            SdkClientException, IoTSiteWiseException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListProjectAssetsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                ListProjectAssetsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listProjectAssetsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoTSiteWise");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListProjectAssets");
            String hostPrefix = "monitor.";
            String resolvedHostExpression = "monitor.";

            return clientHandler.execute(new ClientExecutionParams<ListProjectAssetsRequest, ListProjectAssetsResponse>()
                    .withOperationName("ListProjectAssets").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).hostPrefixExpression(resolvedHostExpression)
                    .withInput(listProjectAssetsRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListProjectAssetsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves a paginated list of projects for an IoT SiteWise Monitor portal.
     * </p>
     *
     * @param listProjectsRequest
     * @return Result of the ListProjects operation returned by the service.
     * @throws InvalidRequestException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters. Check your request and try again.
     * @throws InternalFailureException
     *         IoT SiteWise can't process your request right now. Try again later.
     * @throws ThrottlingException
     *         Your request exceeded a rate limit. For example, you might have exceeded the number of IoT SiteWise
     *         assets that can be created per second, the allowed number of messages per second, and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTSiteWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTSiteWiseClient.ListProjects
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/ListProjects" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ListProjectsResponse listProjects(ListProjectsRequest listProjectsRequest) throws InvalidRequestException,
            InternalFailureException, ThrottlingException, AwsServiceException, SdkClientException, IoTSiteWiseException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListProjectsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                ListProjectsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listProjectsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoTSiteWise");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListProjects");
            String hostPrefix = "monitor.";
            String resolvedHostExpression = "monitor.";

            return clientHandler.execute(new ClientExecutionParams<ListProjectsRequest, ListProjectsResponse>()
                    .withOperationName("ListProjects").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).hostPrefixExpression(resolvedHostExpression)
                    .withInput(listProjectsRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListProjectsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves the list of tags for an IoT SiteWise resource.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws InvalidRequestException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters. Check your request and try again.
     * @throws InternalFailureException
     *         IoT SiteWise can't process your request right now. Try again later.
     * @throws ThrottlingException
     *         Your request exceeded a rate limit. For example, you might have exceeded the number of IoT SiteWise
     *         assets that can be created per second, the allowed number of messages per second, and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws ConflictingOperationException
     *         Your request has conflicting operations. This can occur if you're trying to perform more than one
     *         operation on the same resource at the same time.
     * @throws LimitExceededException
     *         You've reached the limit for a resource. For example, this can occur if you're trying to associate more
     *         than the allowed number of child assets or attempting to create more than the allowed number of
     *         properties for an asset model.
     *         </p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.
     * @throws UnauthorizedException
     *         You are not authorized.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTSiteWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTSiteWiseClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest)
            throws InvalidRequestException, InternalFailureException, ThrottlingException, ResourceNotFoundException,
            ConflictingOperationException, LimitExceededException, UnauthorizedException, AwsServiceException,
            SdkClientException, IoTSiteWiseException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListTagsForResourceResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListTagsForResourceResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listTagsForResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoTSiteWise");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListTagsForResource");
            String hostPrefix = "api.";
            String resolvedHostExpression = "api.";

            return clientHandler.execute(new ClientExecutionParams<ListTagsForResourceRequest, ListTagsForResourceResponse>()
                    .withOperationName("ListTagsForResource").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).hostPrefixExpression(resolvedHostExpression)
                    .withInput(listTagsForResourceRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListTagsForResourceRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves a paginated list of time series (data streams).
     * </p>
     *
     * @param listTimeSeriesRequest
     * @return Result of the ListTimeSeries operation returned by the service.
     * @throws InvalidRequestException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters. Check your request and try again.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws InternalFailureException
     *         IoT SiteWise can't process your request right now. Try again later.
     * @throws ThrottlingException
     *         Your request exceeded a rate limit. For example, you might have exceeded the number of IoT SiteWise
     *         assets that can be created per second, the allowed number of messages per second, and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTSiteWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTSiteWiseClient.ListTimeSeries
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/ListTimeSeries" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public ListTimeSeriesResponse listTimeSeries(ListTimeSeriesRequest listTimeSeriesRequest) throws InvalidRequestException,
            ResourceNotFoundException, InternalFailureException, ThrottlingException, AwsServiceException, SdkClientException,
            IoTSiteWiseException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListTimeSeriesResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                ListTimeSeriesResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listTimeSeriesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoTSiteWise");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListTimeSeries");
            String hostPrefix = "api.";
            String resolvedHostExpression = "api.";

            return clientHandler.execute(new ClientExecutionParams<ListTimeSeriesRequest, ListTimeSeriesResponse>()
                    .withOperationName("ListTimeSeries").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).hostPrefixExpression(resolvedHostExpression)
                    .withInput(listTimeSeriesRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListTimeSeriesRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Sets the default encryption configuration for the Amazon Web Services account. For more information, see <a
     * href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/key-management.html">Key management</a> in the
     * <i>IoT SiteWise User Guide</i>.
     * </p>
     *
     * @param putDefaultEncryptionConfigurationRequest
     * @return Result of the PutDefaultEncryptionConfiguration operation returned by the service.
     * @throws InvalidRequestException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters. Check your request and try again.
     * @throws InternalFailureException
     *         IoT SiteWise can't process your request right now. Try again later.
     * @throws ThrottlingException
     *         Your request exceeded a rate limit. For example, you might have exceeded the number of IoT SiteWise
     *         assets that can be created per second, the allowed number of messages per second, and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.
     * @throws LimitExceededException
     *         You've reached the limit for a resource. For example, this can occur if you're trying to associate more
     *         than the allowed number of child assets or attempting to create more than the allowed number of
     *         properties for an asset model.
     *         </p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.
     * @throws ConflictingOperationException
     *         Your request has conflicting operations. This can occur if you're trying to perform more than one
     *         operation on the same resource at the same time.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTSiteWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTSiteWiseClient.PutDefaultEncryptionConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/PutDefaultEncryptionConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public PutDefaultEncryptionConfigurationResponse putDefaultEncryptionConfiguration(
            PutDefaultEncryptionConfigurationRequest putDefaultEncryptionConfigurationRequest) throws InvalidRequestException,
            InternalFailureException, ThrottlingException, LimitExceededException, ConflictingOperationException,
            AwsServiceException, SdkClientException, IoTSiteWiseException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<PutDefaultEncryptionConfigurationResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, PutDefaultEncryptionConfigurationResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                putDefaultEncryptionConfigurationRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoTSiteWise");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "PutDefaultEncryptionConfiguration");
            String hostPrefix = "api.";
            String resolvedHostExpression = "api.";

            return clientHandler
                    .execute(new ClientExecutionParams<PutDefaultEncryptionConfigurationRequest, PutDefaultEncryptionConfigurationResponse>()
                            .withOperationName("PutDefaultEncryptionConfiguration").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).hostPrefixExpression(resolvedHostExpression)
                            .withInput(putDefaultEncryptionConfigurationRequest).withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new PutDefaultEncryptionConfigurationRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Sets logging options for IoT SiteWise.
     * </p>
     *
     * @param putLoggingOptionsRequest
     * @return Result of the PutLoggingOptions operation returned by the service.
     * @throws InvalidRequestException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters. Check your request and try again.
     * @throws ThrottlingException
     *         Your request exceeded a rate limit. For example, you might have exceeded the number of IoT SiteWise
     *         assets that can be created per second, the allowed number of messages per second, and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.
     * @throws InternalFailureException
     *         IoT SiteWise can't process your request right now. Try again later.
     * @throws ConflictingOperationException
     *         Your request has conflicting operations. This can occur if you're trying to perform more than one
     *         operation on the same resource at the same time.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTSiteWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTSiteWiseClient.PutLoggingOptions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/PutLoggingOptions" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public PutLoggingOptionsResponse putLoggingOptions(PutLoggingOptionsRequest putLoggingOptionsRequest)
            throws InvalidRequestException, ThrottlingException, InternalFailureException, ConflictingOperationException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, IoTSiteWiseException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<PutLoggingOptionsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                PutLoggingOptionsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, putLoggingOptionsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoTSiteWise");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "PutLoggingOptions");
            String hostPrefix = "api.";
            String resolvedHostExpression = "api.";

            return clientHandler.execute(new ClientExecutionParams<PutLoggingOptionsRequest, PutLoggingOptionsResponse>()
                    .withOperationName("PutLoggingOptions").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).hostPrefixExpression(resolvedHostExpression)
                    .withInput(putLoggingOptionsRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new PutLoggingOptionsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Configures storage settings for IoT SiteWise.
     * </p>
     *
     * @param putStorageConfigurationRequest
     * @return Result of the PutStorageConfiguration operation returned by the service.
     * @throws InvalidRequestException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters. Check your request and try again.
     * @throws ResourceAlreadyExistsException
     *         The resource already exists.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws InternalFailureException
     *         IoT SiteWise can't process your request right now. Try again later.
     * @throws ThrottlingException
     *         Your request exceeded a rate limit. For example, you might have exceeded the number of IoT SiteWise
     *         assets that can be created per second, the allowed number of messages per second, and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.
     * @throws LimitExceededException
     *         You've reached the limit for a resource. For example, this can occur if you're trying to associate more
     *         than the allowed number of child assets or attempting to create more than the allowed number of
     *         properties for an asset model.
     *         </p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.
     * @throws ConflictingOperationException
     *         Your request has conflicting operations. This can occur if you're trying to perform more than one
     *         operation on the same resource at the same time.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTSiteWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTSiteWiseClient.PutStorageConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/PutStorageConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public PutStorageConfigurationResponse putStorageConfiguration(PutStorageConfigurationRequest putStorageConfigurationRequest)
            throws InvalidRequestException, ResourceAlreadyExistsException, ResourceNotFoundException, InternalFailureException,
            ThrottlingException, LimitExceededException, ConflictingOperationException, AwsServiceException, SdkClientException,
            IoTSiteWiseException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<PutStorageConfigurationResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, PutStorageConfigurationResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, putStorageConfigurationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoTSiteWise");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "PutStorageConfiguration");
            String hostPrefix = "api.";
            String resolvedHostExpression = "api.";

            return clientHandler
                    .execute(new ClientExecutionParams<PutStorageConfigurationRequest, PutStorageConfigurationResponse>()
                            .withOperationName("PutStorageConfiguration").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).hostPrefixExpression(resolvedHostExpression)
                            .withInput(putStorageConfigurationRequest).withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new PutStorageConfigurationRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Adds tags to an IoT SiteWise resource. If a tag already exists for the resource, this operation updates the tag's
     * value.
     * </p>
     *
     * @param tagResourceRequest
     * @return Result of the TagResource operation returned by the service.
     * @throws InvalidRequestException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters. Check your request and try again.
     * @throws InternalFailureException
     *         IoT SiteWise can't process your request right now. Try again later.
     * @throws ThrottlingException
     *         Your request exceeded a rate limit. For example, you might have exceeded the number of IoT SiteWise
     *         assets that can be created per second, the allowed number of messages per second, and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws ConflictingOperationException
     *         Your request has conflicting operations. This can occur if you're trying to perform more than one
     *         operation on the same resource at the same time.
     * @throws LimitExceededException
     *         You've reached the limit for a resource. For example, this can occur if you're trying to associate more
     *         than the allowed number of child assets or attempting to create more than the allowed number of
     *         properties for an asset model.
     *         </p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.
     * @throws UnauthorizedException
     *         You are not authorized.
     * @throws TooManyTagsException
     *         You've reached the limit for the number of tags allowed for a resource. For more information, see <a
     *         href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html#tag-conventions">Tag naming limits
     *         and requirements</a> in the <i>Amazon Web Services General Reference</i>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTSiteWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTSiteWiseClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws InvalidRequestException,
            InternalFailureException, ThrottlingException, ResourceNotFoundException, ConflictingOperationException,
            LimitExceededException, UnauthorizedException, TooManyTagsException, AwsServiceException, SdkClientException,
            IoTSiteWiseException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<TagResourceResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                TagResourceResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, tagResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoTSiteWise");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "TagResource");
            String hostPrefix = "api.";
            String resolvedHostExpression = "api.";

            return clientHandler.execute(new ClientExecutionParams<TagResourceRequest, TagResourceResponse>()
                    .withOperationName("TagResource").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).hostPrefixExpression(resolvedHostExpression)
                    .withInput(tagResourceRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new TagResourceRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Removes a tag from an IoT SiteWise resource.
     * </p>
     *
     * @param untagResourceRequest
     * @return Result of the UntagResource operation returned by the service.
     * @throws InvalidRequestException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters. Check your request and try again.
     * @throws InternalFailureException
     *         IoT SiteWise can't process your request right now. Try again later.
     * @throws ThrottlingException
     *         Your request exceeded a rate limit. For example, you might have exceeded the number of IoT SiteWise
     *         assets that can be created per second, the allowed number of messages per second, and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws ConflictingOperationException
     *         Your request has conflicting operations. This can occur if you're trying to perform more than one
     *         operation on the same resource at the same time.
     * @throws LimitExceededException
     *         You've reached the limit for a resource. For example, this can occur if you're trying to associate more
     *         than the allowed number of child assets or attempting to create more than the allowed number of
     *         properties for an asset model.
     *         </p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.
     * @throws UnauthorizedException
     *         You are not authorized.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTSiteWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTSiteWiseClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws InvalidRequestException,
            InternalFailureException, ThrottlingException, ResourceNotFoundException, ConflictingOperationException,
            LimitExceededException, UnauthorizedException, AwsServiceException, SdkClientException, IoTSiteWiseException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UntagResourceResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                UntagResourceResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, untagResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoTSiteWise");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UntagResource");
            String hostPrefix = "api.";
            String resolvedHostExpression = "api.";

            return clientHandler.execute(new ClientExecutionParams<UntagResourceRequest, UntagResourceResponse>()
                    .withOperationName("UntagResource").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).hostPrefixExpression(resolvedHostExpression)
                    .withInput(untagResourceRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new UntagResourceRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Updates an existing access policy that specifies an identity's access to an IoT SiteWise Monitor portal or
     * project resource.
     * </p>
     *
     * @param updateAccessPolicyRequest
     * @return Result of the UpdateAccessPolicy operation returned by the service.
     * @throws InvalidRequestException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters. Check your request and try again.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws InternalFailureException
     *         IoT SiteWise can't process your request right now. Try again later.
     * @throws ThrottlingException
     *         Your request exceeded a rate limit. For example, you might have exceeded the number of IoT SiteWise
     *         assets that can be created per second, the allowed number of messages per second, and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTSiteWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTSiteWiseClient.UpdateAccessPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/UpdateAccessPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public UpdateAccessPolicyResponse updateAccessPolicy(UpdateAccessPolicyRequest updateAccessPolicyRequest)
            throws InvalidRequestException, ResourceNotFoundException, InternalFailureException, ThrottlingException,
            AwsServiceException, SdkClientException, IoTSiteWiseException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateAccessPolicyResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, UpdateAccessPolicyResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateAccessPolicyRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoTSiteWise");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateAccessPolicy");
            String hostPrefix = "monitor.";
            String resolvedHostExpression = "monitor.";

            return clientHandler.execute(new ClientExecutionParams<UpdateAccessPolicyRequest, UpdateAccessPolicyResponse>()
                    .withOperationName("UpdateAccessPolicy").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).hostPrefixExpression(resolvedHostExpression)
                    .withInput(updateAccessPolicyRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new UpdateAccessPolicyRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Updates an asset's name. For more information, see <a
     * href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/update-assets-and-models.html">Updating assets
     * and models</a> in the <i>IoT SiteWise User Guide</i>.
     * </p>
     *
     * @param updateAssetRequest
     * @return Result of the UpdateAsset operation returned by the service.
     * @throws InvalidRequestException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters. Check your request and try again.
     * @throws ResourceAlreadyExistsException
     *         The resource already exists.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws InternalFailureException
     *         IoT SiteWise can't process your request right now. Try again later.
     * @throws ThrottlingException
     *         Your request exceeded a rate limit. For example, you might have exceeded the number of IoT SiteWise
     *         assets that can be created per second, the allowed number of messages per second, and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.
     * @throws ConflictingOperationException
     *         Your request has conflicting operations. This can occur if you're trying to perform more than one
     *         operation on the same resource at the same time.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTSiteWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTSiteWiseClient.UpdateAsset
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/UpdateAsset" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public UpdateAssetResponse updateAsset(UpdateAssetRequest updateAssetRequest) throws InvalidRequestException,
            ResourceAlreadyExistsException, ResourceNotFoundException, InternalFailureException, ThrottlingException,
            ConflictingOperationException, AwsServiceException, SdkClientException, IoTSiteWiseException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateAssetResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                UpdateAssetResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateAssetRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoTSiteWise");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateAsset");
            String hostPrefix = "api.";
            String resolvedHostExpression = "api.";

            return clientHandler.execute(new ClientExecutionParams<UpdateAssetRequest, UpdateAssetResponse>()
                    .withOperationName("UpdateAsset").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).hostPrefixExpression(resolvedHostExpression)
                    .withInput(updateAssetRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new UpdateAssetRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Updates an asset model and all of the assets that were created from the model. Each asset created from the model
     * inherits the updated asset model's property and hierarchy definitions. For more information, see <a
     * href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/update-assets-and-models.html">Updating assets
     * and models</a> in the <i>IoT SiteWise User Guide</i>.
     * </p>
     * <important>
     * <p>
     * This operation overwrites the existing model with the provided model. To avoid deleting your asset model's
     * properties or hierarchies, you must include their IDs and definitions in the updated asset model payload. For
     * more information, see <a
     * href="https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_DescribeAssetModel.html"
     * >DescribeAssetModel</a>.
     * </p>
     * <p>
     * If you remove a property from an asset model, IoT SiteWise deletes all previous data for that property. If you
     * remove a hierarchy definition from an asset model, IoT SiteWise disassociates every asset associated with that
     * hierarchy. You can't change the type or data type of an existing property.
     * </p>
     * </important>
     *
     * @param updateAssetModelRequest
     * @return Result of the UpdateAssetModel operation returned by the service.
     * @throws InvalidRequestException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters. Check your request and try again.
     * @throws ResourceAlreadyExistsException
     *         The resource already exists.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws InternalFailureException
     *         IoT SiteWise can't process your request right now. Try again later.
     * @throws LimitExceededException
     *         You've reached the limit for a resource. For example, this can occur if you're trying to associate more
     *         than the allowed number of child assets or attempting to create more than the allowed number of
     *         properties for an asset model.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.
     * @throws ThrottlingException
     *         Your request exceeded a rate limit. For example, you might have exceeded the number of IoT SiteWise
     *         assets that can be created per second, the allowed number of messages per second, and so on.
     *         </p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.
     * @throws ConflictingOperationException
     *         Your request has conflicting operations. This can occur if you're trying to perform more than one
     *         operation on the same resource at the same time.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTSiteWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTSiteWiseClient.UpdateAssetModel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/UpdateAssetModel" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public UpdateAssetModelResponse updateAssetModel(UpdateAssetModelRequest updateAssetModelRequest)
            throws InvalidRequestException, ResourceAlreadyExistsException, ResourceNotFoundException, InternalFailureException,
            LimitExceededException, ThrottlingException, ConflictingOperationException, AwsServiceException, SdkClientException,
            IoTSiteWiseException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateAssetModelResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                UpdateAssetModelResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateAssetModelRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoTSiteWise");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateAssetModel");
            String hostPrefix = "api.";
            String resolvedHostExpression = "api.";

            return clientHandler.execute(new ClientExecutionParams<UpdateAssetModelRequest, UpdateAssetModelResponse>()
                    .withOperationName("UpdateAssetModel").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).hostPrefixExpression(resolvedHostExpression)
                    .withInput(updateAssetModelRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new UpdateAssetModelRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Updates an asset property's alias and notification state.
     * </p>
     * <important>
     * <p>
     * This operation overwrites the property's existing alias and notification state. To keep your existing property's
     * alias or notification state, you must include the existing values in the UpdateAssetProperty request. For more
     * information, see <a
     * href="https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_DescribeAssetProperty.html"
     * >DescribeAssetProperty</a>.
     * </p>
     * </important>
     *
     * @param updateAssetPropertyRequest
     * @return Result of the UpdateAssetProperty operation returned by the service.
     * @throws InvalidRequestException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters. Check your request and try again.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws InternalFailureException
     *         IoT SiteWise can't process your request right now. Try again later.
     * @throws ThrottlingException
     *         Your request exceeded a rate limit. For example, you might have exceeded the number of IoT SiteWise
     *         assets that can be created per second, the allowed number of messages per second, and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.
     * @throws ConflictingOperationException
     *         Your request has conflicting operations. This can occur if you're trying to perform more than one
     *         operation on the same resource at the same time.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTSiteWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTSiteWiseClient.UpdateAssetProperty
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/UpdateAssetProperty"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public UpdateAssetPropertyResponse updateAssetProperty(UpdateAssetPropertyRequest updateAssetPropertyRequest)
            throws InvalidRequestException, ResourceNotFoundException, InternalFailureException, ThrottlingException,
            ConflictingOperationException, AwsServiceException, SdkClientException, IoTSiteWiseException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateAssetPropertyResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, UpdateAssetPropertyResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateAssetPropertyRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoTSiteWise");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateAssetProperty");
            String hostPrefix = "api.";
            String resolvedHostExpression = "api.";

            return clientHandler.execute(new ClientExecutionParams<UpdateAssetPropertyRequest, UpdateAssetPropertyResponse>()
                    .withOperationName("UpdateAssetProperty").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).hostPrefixExpression(resolvedHostExpression)
                    .withInput(updateAssetPropertyRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new UpdateAssetPropertyRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Updates an IoT SiteWise Monitor dashboard.
     * </p>
     *
     * @param updateDashboardRequest
     * @return Result of the UpdateDashboard operation returned by the service.
     * @throws InvalidRequestException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters. Check your request and try again.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws InternalFailureException
     *         IoT SiteWise can't process your request right now. Try again later.
     * @throws ThrottlingException
     *         Your request exceeded a rate limit. For example, you might have exceeded the number of IoT SiteWise
     *         assets that can be created per second, the allowed number of messages per second, and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTSiteWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTSiteWiseClient.UpdateDashboard
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/UpdateDashboard" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public UpdateDashboardResponse updateDashboard(UpdateDashboardRequest updateDashboardRequest) throws InvalidRequestException,
            ResourceNotFoundException, InternalFailureException, ThrottlingException, AwsServiceException, SdkClientException,
            IoTSiteWiseException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateDashboardResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                UpdateDashboardResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateDashboardRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoTSiteWise");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateDashboard");
            String hostPrefix = "monitor.";
            String resolvedHostExpression = "monitor.";

            return clientHandler.execute(new ClientExecutionParams<UpdateDashboardRequest, UpdateDashboardResponse>()
                    .withOperationName("UpdateDashboard").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).hostPrefixExpression(resolvedHostExpression)
                    .withInput(updateDashboardRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new UpdateDashboardRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Updates a gateway's name.
     * </p>
     *
     * @param updateGatewayRequest
     * @return Result of the UpdateGateway operation returned by the service.
     * @throws InvalidRequestException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters. Check your request and try again.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws ConflictingOperationException
     *         Your request has conflicting operations. This can occur if you're trying to perform more than one
     *         operation on the same resource at the same time.
     * @throws InternalFailureException
     *         IoT SiteWise can't process your request right now. Try again later.
     * @throws ThrottlingException
     *         Your request exceeded a rate limit. For example, you might have exceeded the number of IoT SiteWise
     *         assets that can be created per second, the allowed number of messages per second, and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTSiteWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTSiteWiseClient.UpdateGateway
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/UpdateGateway" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public UpdateGatewayResponse updateGateway(UpdateGatewayRequest updateGatewayRequest) throws InvalidRequestException,
            ResourceNotFoundException, ConflictingOperationException, InternalFailureException, ThrottlingException,
            AwsServiceException, SdkClientException, IoTSiteWiseException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateGatewayResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                UpdateGatewayResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateGatewayRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoTSiteWise");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateGateway");
            String hostPrefix = "api.";
            String resolvedHostExpression = "api.";

            return clientHandler.execute(new ClientExecutionParams<UpdateGatewayRequest, UpdateGatewayResponse>()
                    .withOperationName("UpdateGateway").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).hostPrefixExpression(resolvedHostExpression)
                    .withInput(updateGatewayRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new UpdateGatewayRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Updates a gateway capability configuration or defines a new capability configuration. Each gateway capability
     * defines data sources for a gateway. A capability configuration can contain multiple data source configurations.
     * If you define OPC-UA sources for a gateway in the IoT SiteWise console, all of your OPC-UA sources are stored in
     * one capability configuration. To list all capability configurations for a gateway, use <a
     * href="https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_DescribeGateway.html">DescribeGateway</a>.
     * </p>
     *
     * @param updateGatewayCapabilityConfigurationRequest
     * @return Result of the UpdateGatewayCapabilityConfiguration operation returned by the service.
     * @throws InvalidRequestException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters. Check your request and try again.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws ConflictingOperationException
     *         Your request has conflicting operations. This can occur if you're trying to perform more than one
     *         operation on the same resource at the same time.
     * @throws InternalFailureException
     *         IoT SiteWise can't process your request right now. Try again later.
     * @throws ThrottlingException
     *         Your request exceeded a rate limit. For example, you might have exceeded the number of IoT SiteWise
     *         assets that can be created per second, the allowed number of messages per second, and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.
     * @throws LimitExceededException
     *         You've reached the limit for a resource. For example, this can occur if you're trying to associate more
     *         than the allowed number of child assets or attempting to create more than the allowed number of
     *         properties for an asset model.
     *         </p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTSiteWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTSiteWiseClient.UpdateGatewayCapabilityConfiguration
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/UpdateGatewayCapabilityConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public UpdateGatewayCapabilityConfigurationResponse updateGatewayCapabilityConfiguration(
            UpdateGatewayCapabilityConfigurationRequest updateGatewayCapabilityConfigurationRequest)
            throws InvalidRequestException, ResourceNotFoundException, ConflictingOperationException, InternalFailureException,
            ThrottlingException, LimitExceededException, AwsServiceException, SdkClientException, IoTSiteWiseException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateGatewayCapabilityConfigurationResponse> responseHandler = protocolFactory
                .createResponseHandler(operationMetadata, UpdateGatewayCapabilityConfigurationResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                updateGatewayCapabilityConfigurationRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoTSiteWise");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateGatewayCapabilityConfiguration");
            String hostPrefix = "api.";
            String resolvedHostExpression = "api.";

            return clientHandler
                    .execute(new ClientExecutionParams<UpdateGatewayCapabilityConfigurationRequest, UpdateGatewayCapabilityConfigurationResponse>()
                            .withOperationName("UpdateGatewayCapabilityConfiguration").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).hostPrefixExpression(resolvedHostExpression)
                            .withInput(updateGatewayCapabilityConfigurationRequest).withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new UpdateGatewayCapabilityConfigurationRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Updates an IoT SiteWise Monitor portal.
     * </p>
     *
     * @param updatePortalRequest
     * @return Result of the UpdatePortal operation returned by the service.
     * @throws InvalidRequestException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters. Check your request and try again.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws InternalFailureException
     *         IoT SiteWise can't process your request right now. Try again later.
     * @throws ThrottlingException
     *         Your request exceeded a rate limit. For example, you might have exceeded the number of IoT SiteWise
     *         assets that can be created per second, the allowed number of messages per second, and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.
     * @throws ConflictingOperationException
     *         Your request has conflicting operations. This can occur if you're trying to perform more than one
     *         operation on the same resource at the same time.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTSiteWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTSiteWiseClient.UpdatePortal
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/UpdatePortal" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public UpdatePortalResponse updatePortal(UpdatePortalRequest updatePortalRequest) throws InvalidRequestException,
            ResourceNotFoundException, InternalFailureException, ThrottlingException, ConflictingOperationException,
            AwsServiceException, SdkClientException, IoTSiteWiseException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdatePortalResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                UpdatePortalResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updatePortalRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoTSiteWise");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdatePortal");
            String hostPrefix = "monitor.";
            String resolvedHostExpression = "monitor.";

            return clientHandler.execute(new ClientExecutionParams<UpdatePortalRequest, UpdatePortalResponse>()
                    .withOperationName("UpdatePortal").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).hostPrefixExpression(resolvedHostExpression)
                    .withInput(updatePortalRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new UpdatePortalRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Updates an IoT SiteWise Monitor project.
     * </p>
     *
     * @param updateProjectRequest
     * @return Result of the UpdateProject operation returned by the service.
     * @throws InvalidRequestException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters. Check your request and try again.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws InternalFailureException
     *         IoT SiteWise can't process your request right now. Try again later.
     * @throws ThrottlingException
     *         Your request exceeded a rate limit. For example, you might have exceeded the number of IoT SiteWise
     *         assets that can be created per second, the allowed number of messages per second, and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTSiteWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTSiteWiseClient.UpdateProject
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/UpdateProject" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public UpdateProjectResponse updateProject(UpdateProjectRequest updateProjectRequest) throws InvalidRequestException,
            ResourceNotFoundException, InternalFailureException, ThrottlingException, AwsServiceException, SdkClientException,
            IoTSiteWiseException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateProjectResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                UpdateProjectResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateProjectRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoTSiteWise");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateProject");
            String hostPrefix = "monitor.";
            String resolvedHostExpression = "monitor.";

            return clientHandler.execute(new ClientExecutionParams<UpdateProjectRequest, UpdateProjectResponse>()
                    .withOperationName("UpdateProject").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).hostPrefixExpression(resolvedHostExpression)
                    .withInput(updateProjectRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new UpdateProjectRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * Create an instance of {@link IoTSiteWiseWaiter} using this client.
     * <p>
     * Waiters created via this method are managed by the SDK and resources will be released when the service client is
     * closed.
     *
     * @return an instance of {@link IoTSiteWiseWaiter}
     */
    @Override
    public IoTSiteWiseWaiter waiter() {
        return IoTSiteWiseWaiter.builder().client(this).build();
    }

    @Override
    public final String serviceName() {
        return SERVICE_NAME;
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration,
            RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = clientConfiguration.option(SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory,
            JsonOperationMetadata operationMetadata) {
        return protocolFactory.createErrorResponseHandler(operationMetadata);
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return builder
                .clientConfiguration(clientConfiguration)
                .defaultServiceExceptionSupplier(IoTSiteWiseException::builder)
                .protocol(AwsJsonProtocol.REST_JSON)
                .protocolVersion("1.1")
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InternalFailureException")
                                .exceptionBuilderSupplier(InternalFailureException::builder).httpStatusCode(500).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidRequestException")
                                .exceptionBuilderSupplier(InvalidRequestException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("LimitExceededException")
                                .exceptionBuilderSupplier(LimitExceededException::builder).httpStatusCode(410).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ResourceNotFoundException")
                                .exceptionBuilderSupplier(ResourceNotFoundException::builder).httpStatusCode(404).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException")
                                .exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).httpStatusCode(409).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ThrottlingException")
                                .exceptionBuilderSupplier(ThrottlingException::builder).httpStatusCode(429).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("UnauthorizedException")
                                .exceptionBuilderSupplier(UnauthorizedException::builder).httpStatusCode(401).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("TooManyTagsException")
                                .exceptionBuilderSupplier(TooManyTagsException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ConflictingOperationException")
                                .exceptionBuilderSupplier(ConflictingOperationException::builder).httpStatusCode(409).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ServiceUnavailableException")
                                .exceptionBuilderSupplier(ServiceUnavailableException::builder).httpStatusCode(503).build());
    }

    @Override
    public final IoTSiteWiseServiceClientConfiguration serviceClientConfiguration() {
        return this.serviceClientConfiguration;
    }

    @Override
    public void close() {
        clientHandler.close();
    }
}
