/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotsitewise.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.iotsitewise.model.DashboardSummariesCopier;
import software.amazon.awssdk.services.iotsitewise.model.DashboardSummary;
import software.amazon.awssdk.services.iotsitewise.model.IoTSiteWiseResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListDashboardsResponse
extends IoTSiteWiseResponse
implements ToCopyableBuilder<Builder, ListDashboardsResponse> {
    private static final SdkField<List<DashboardSummary>> DASHBOARD_SUMMARIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("dashboardSummaries").getter(ListDashboardsResponse.getter(ListDashboardsResponse::dashboardSummaries)).setter(ListDashboardsResponse.setter(Builder::dashboardSummaries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dashboardSummaries").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DashboardSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListDashboardsResponse.getter(ListDashboardsResponse::nextToken)).setter(ListDashboardsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DASHBOARD_SUMMARIES_FIELD, NEXT_TOKEN_FIELD));
    private final List<DashboardSummary> dashboardSummaries;
    private final String nextToken;

    private ListDashboardsResponse(BuilderImpl builder) {
        super(builder);
        this.dashboardSummaries = builder.dashboardSummaries;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasDashboardSummaries() {
        return this.dashboardSummaries != null && !(this.dashboardSummaries instanceof SdkAutoConstructList);
    }

    public final List<DashboardSummary> dashboardSummaries() {
        return this.dashboardSummaries;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDashboardSummaries() ? this.dashboardSummaries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListDashboardsResponse)) {
            return false;
        }
        ListDashboardsResponse other = (ListDashboardsResponse)((Object)obj);
        return this.hasDashboardSummaries() == other.hasDashboardSummaries() && Objects.equals(this.dashboardSummaries(), other.dashboardSummaries()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListDashboardsResponse").add("DashboardSummaries", this.hasDashboardSummaries() ? this.dashboardSummaries() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "dashboardSummaries": {
                return Optional.ofNullable(clazz.cast(this.dashboardSummaries()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListDashboardsResponse, T> g) {
        return obj -> g.apply((ListDashboardsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IoTSiteWiseResponse.BuilderImpl
    implements Builder {
        private List<DashboardSummary> dashboardSummaries = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListDashboardsResponse model) {
            super(model);
            this.dashboardSummaries(model.dashboardSummaries);
            this.nextToken(model.nextToken);
        }

        public final List<DashboardSummary.Builder> getDashboardSummaries() {
            List<DashboardSummary.Builder> result = DashboardSummariesCopier.copyToBuilder(this.dashboardSummaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDashboardSummaries(Collection<DashboardSummary.BuilderImpl> dashboardSummaries) {
            this.dashboardSummaries = DashboardSummariesCopier.copyFromBuilder(dashboardSummaries);
        }

        @Override
        public final Builder dashboardSummaries(Collection<DashboardSummary> dashboardSummaries) {
            this.dashboardSummaries = DashboardSummariesCopier.copy(dashboardSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dashboardSummaries(DashboardSummary ... dashboardSummaries) {
            this.dashboardSummaries(Arrays.asList(dashboardSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dashboardSummaries(Consumer<DashboardSummary.Builder> ... dashboardSummaries) {
            this.dashboardSummaries(Stream.of(dashboardSummaries).map(c -> (DashboardSummary)((DashboardSummary.Builder)DashboardSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListDashboardsResponse build() {
            return new ListDashboardsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends IoTSiteWiseResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListDashboardsResponse> {
        public Builder dashboardSummaries(Collection<DashboardSummary> var1);

        public Builder dashboardSummaries(DashboardSummary ... var1);

        public Builder dashboardSummaries(Consumer<DashboardSummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

