/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotsitewise.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.iotsitewise.model.Alarms;
import software.amazon.awssdk.services.iotsitewise.model.AuthMode;
import software.amazon.awssdk.services.iotsitewise.model.ImageLocation;
import software.amazon.awssdk.services.iotsitewise.model.IoTSiteWiseResponse;
import software.amazon.awssdk.services.iotsitewise.model.PortalStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribePortalResponse
extends IoTSiteWiseResponse
implements ToCopyableBuilder<Builder, DescribePortalResponse> {
    private static final SdkField<String> PORTAL_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("portalId").getter(DescribePortalResponse.getter(DescribePortalResponse::portalId)).setter(DescribePortalResponse.setter(Builder::portalId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("portalId").build()}).build();
    private static final SdkField<String> PORTAL_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("portalArn").getter(DescribePortalResponse.getter(DescribePortalResponse::portalArn)).setter(DescribePortalResponse.setter(Builder::portalArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("portalArn").build()}).build();
    private static final SdkField<String> PORTAL_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("portalName").getter(DescribePortalResponse.getter(DescribePortalResponse::portalName)).setter(DescribePortalResponse.setter(Builder::portalName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("portalName").build()}).build();
    private static final SdkField<String> PORTAL_DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("portalDescription").getter(DescribePortalResponse.getter(DescribePortalResponse::portalDescription)).setter(DescribePortalResponse.setter(Builder::portalDescription)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("portalDescription").build()}).build();
    private static final SdkField<String> PORTAL_CLIENT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("portalClientId").getter(DescribePortalResponse.getter(DescribePortalResponse::portalClientId)).setter(DescribePortalResponse.setter(Builder::portalClientId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("portalClientId").build()}).build();
    private static final SdkField<String> PORTAL_START_URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("portalStartUrl").getter(DescribePortalResponse.getter(DescribePortalResponse::portalStartUrl)).setter(DescribePortalResponse.setter(Builder::portalStartUrl)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("portalStartUrl").build()}).build();
    private static final SdkField<String> PORTAL_CONTACT_EMAIL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("portalContactEmail").getter(DescribePortalResponse.getter(DescribePortalResponse::portalContactEmail)).setter(DescribePortalResponse.setter(Builder::portalContactEmail)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("portalContactEmail").build()}).build();
    private static final SdkField<PortalStatus> PORTAL_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("portalStatus").getter(DescribePortalResponse.getter(DescribePortalResponse::portalStatus)).setter(DescribePortalResponse.setter(Builder::portalStatus)).constructor(PortalStatus::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("portalStatus").build()}).build();
    private static final SdkField<Instant> PORTAL_CREATION_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("portalCreationDate").getter(DescribePortalResponse.getter(DescribePortalResponse::portalCreationDate)).setter(DescribePortalResponse.setter(Builder::portalCreationDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("portalCreationDate").build()}).build();
    private static final SdkField<Instant> PORTAL_LAST_UPDATE_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("portalLastUpdateDate").getter(DescribePortalResponse.getter(DescribePortalResponse::portalLastUpdateDate)).setter(DescribePortalResponse.setter(Builder::portalLastUpdateDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("portalLastUpdateDate").build()}).build();
    private static final SdkField<ImageLocation> PORTAL_LOGO_IMAGE_LOCATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("portalLogoImageLocation").getter(DescribePortalResponse.getter(DescribePortalResponse::portalLogoImageLocation)).setter(DescribePortalResponse.setter(Builder::portalLogoImageLocation)).constructor(ImageLocation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("portalLogoImageLocation").build()}).build();
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("roleArn").getter(DescribePortalResponse.getter(DescribePortalResponse::roleArn)).setter(DescribePortalResponse.setter(Builder::roleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArn").build()}).build();
    private static final SdkField<String> PORTAL_AUTH_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("portalAuthMode").getter(DescribePortalResponse.getter(DescribePortalResponse::portalAuthModeAsString)).setter(DescribePortalResponse.setter(Builder::portalAuthMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("portalAuthMode").build()}).build();
    private static final SdkField<String> NOTIFICATION_SENDER_EMAIL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("notificationSenderEmail").getter(DescribePortalResponse.getter(DescribePortalResponse::notificationSenderEmail)).setter(DescribePortalResponse.setter(Builder::notificationSenderEmail)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("notificationSenderEmail").build()}).build();
    private static final SdkField<Alarms> ALARMS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("alarms").getter(DescribePortalResponse.getter(DescribePortalResponse::alarms)).setter(DescribePortalResponse.setter(Builder::alarms)).constructor(Alarms::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("alarms").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PORTAL_ID_FIELD, PORTAL_ARN_FIELD, PORTAL_NAME_FIELD, PORTAL_DESCRIPTION_FIELD, PORTAL_CLIENT_ID_FIELD, PORTAL_START_URL_FIELD, PORTAL_CONTACT_EMAIL_FIELD, PORTAL_STATUS_FIELD, PORTAL_CREATION_DATE_FIELD, PORTAL_LAST_UPDATE_DATE_FIELD, PORTAL_LOGO_IMAGE_LOCATION_FIELD, ROLE_ARN_FIELD, PORTAL_AUTH_MODE_FIELD, NOTIFICATION_SENDER_EMAIL_FIELD, ALARMS_FIELD));
    private final String portalId;
    private final String portalArn;
    private final String portalName;
    private final String portalDescription;
    private final String portalClientId;
    private final String portalStartUrl;
    private final String portalContactEmail;
    private final PortalStatus portalStatus;
    private final Instant portalCreationDate;
    private final Instant portalLastUpdateDate;
    private final ImageLocation portalLogoImageLocation;
    private final String roleArn;
    private final String portalAuthMode;
    private final String notificationSenderEmail;
    private final Alarms alarms;

    private DescribePortalResponse(BuilderImpl builder) {
        super(builder);
        this.portalId = builder.portalId;
        this.portalArn = builder.portalArn;
        this.portalName = builder.portalName;
        this.portalDescription = builder.portalDescription;
        this.portalClientId = builder.portalClientId;
        this.portalStartUrl = builder.portalStartUrl;
        this.portalContactEmail = builder.portalContactEmail;
        this.portalStatus = builder.portalStatus;
        this.portalCreationDate = builder.portalCreationDate;
        this.portalLastUpdateDate = builder.portalLastUpdateDate;
        this.portalLogoImageLocation = builder.portalLogoImageLocation;
        this.roleArn = builder.roleArn;
        this.portalAuthMode = builder.portalAuthMode;
        this.notificationSenderEmail = builder.notificationSenderEmail;
        this.alarms = builder.alarms;
    }

    public final String portalId() {
        return this.portalId;
    }

    public final String portalArn() {
        return this.portalArn;
    }

    public final String portalName() {
        return this.portalName;
    }

    public final String portalDescription() {
        return this.portalDescription;
    }

    public final String portalClientId() {
        return this.portalClientId;
    }

    public final String portalStartUrl() {
        return this.portalStartUrl;
    }

    public final String portalContactEmail() {
        return this.portalContactEmail;
    }

    public final PortalStatus portalStatus() {
        return this.portalStatus;
    }

    public final Instant portalCreationDate() {
        return this.portalCreationDate;
    }

    public final Instant portalLastUpdateDate() {
        return this.portalLastUpdateDate;
    }

    public final ImageLocation portalLogoImageLocation() {
        return this.portalLogoImageLocation;
    }

    public final String roleArn() {
        return this.roleArn;
    }

    public final AuthMode portalAuthMode() {
        return AuthMode.fromValue(this.portalAuthMode);
    }

    public final String portalAuthModeAsString() {
        return this.portalAuthMode;
    }

    public final String notificationSenderEmail() {
        return this.notificationSenderEmail;
    }

    public final Alarms alarms() {
        return this.alarms;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.portalId());
        hashCode = 31 * hashCode + Objects.hashCode(this.portalArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.portalName());
        hashCode = 31 * hashCode + Objects.hashCode(this.portalDescription());
        hashCode = 31 * hashCode + Objects.hashCode(this.portalClientId());
        hashCode = 31 * hashCode + Objects.hashCode(this.portalStartUrl());
        hashCode = 31 * hashCode + Objects.hashCode(this.portalContactEmail());
        hashCode = 31 * hashCode + Objects.hashCode(this.portalStatus());
        hashCode = 31 * hashCode + Objects.hashCode(this.portalCreationDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.portalLastUpdateDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.portalLogoImageLocation());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.portalAuthModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.notificationSenderEmail());
        hashCode = 31 * hashCode + Objects.hashCode(this.alarms());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribePortalResponse)) {
            return false;
        }
        DescribePortalResponse other = (DescribePortalResponse)((Object)obj);
        return Objects.equals(this.portalId(), other.portalId()) && Objects.equals(this.portalArn(), other.portalArn()) && Objects.equals(this.portalName(), other.portalName()) && Objects.equals(this.portalDescription(), other.portalDescription()) && Objects.equals(this.portalClientId(), other.portalClientId()) && Objects.equals(this.portalStartUrl(), other.portalStartUrl()) && Objects.equals(this.portalContactEmail(), other.portalContactEmail()) && Objects.equals(this.portalStatus(), other.portalStatus()) && Objects.equals(this.portalCreationDate(), other.portalCreationDate()) && Objects.equals(this.portalLastUpdateDate(), other.portalLastUpdateDate()) && Objects.equals(this.portalLogoImageLocation(), other.portalLogoImageLocation()) && Objects.equals(this.roleArn(), other.roleArn()) && Objects.equals(this.portalAuthModeAsString(), other.portalAuthModeAsString()) && Objects.equals(this.notificationSenderEmail(), other.notificationSenderEmail()) && Objects.equals(this.alarms(), other.alarms());
    }

    public final String toString() {
        return ToString.builder((String)"DescribePortalResponse").add("PortalId", (Object)this.portalId()).add("PortalArn", (Object)this.portalArn()).add("PortalName", (Object)this.portalName()).add("PortalDescription", (Object)this.portalDescription()).add("PortalClientId", (Object)this.portalClientId()).add("PortalStartUrl", (Object)this.portalStartUrl()).add("PortalContactEmail", (Object)this.portalContactEmail()).add("PortalStatus", (Object)this.portalStatus()).add("PortalCreationDate", (Object)this.portalCreationDate()).add("PortalLastUpdateDate", (Object)this.portalLastUpdateDate()).add("PortalLogoImageLocation", (Object)this.portalLogoImageLocation()).add("RoleArn", (Object)this.roleArn()).add("PortalAuthMode", (Object)this.portalAuthModeAsString()).add("NotificationSenderEmail", (Object)this.notificationSenderEmail()).add("Alarms", (Object)this.alarms()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "portalId": {
                return Optional.ofNullable(clazz.cast(this.portalId()));
            }
            case "portalArn": {
                return Optional.ofNullable(clazz.cast(this.portalArn()));
            }
            case "portalName": {
                return Optional.ofNullable(clazz.cast(this.portalName()));
            }
            case "portalDescription": {
                return Optional.ofNullable(clazz.cast(this.portalDescription()));
            }
            case "portalClientId": {
                return Optional.ofNullable(clazz.cast(this.portalClientId()));
            }
            case "portalStartUrl": {
                return Optional.ofNullable(clazz.cast(this.portalStartUrl()));
            }
            case "portalContactEmail": {
                return Optional.ofNullable(clazz.cast(this.portalContactEmail()));
            }
            case "portalStatus": {
                return Optional.ofNullable(clazz.cast(this.portalStatus()));
            }
            case "portalCreationDate": {
                return Optional.ofNullable(clazz.cast(this.portalCreationDate()));
            }
            case "portalLastUpdateDate": {
                return Optional.ofNullable(clazz.cast(this.portalLastUpdateDate()));
            }
            case "portalLogoImageLocation": {
                return Optional.ofNullable(clazz.cast(this.portalLogoImageLocation()));
            }
            case "roleArn": {
                return Optional.ofNullable(clazz.cast(this.roleArn()));
            }
            case "portalAuthMode": {
                return Optional.ofNullable(clazz.cast(this.portalAuthModeAsString()));
            }
            case "notificationSenderEmail": {
                return Optional.ofNullable(clazz.cast(this.notificationSenderEmail()));
            }
            case "alarms": {
                return Optional.ofNullable(clazz.cast(this.alarms()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribePortalResponse, T> g) {
        return obj -> g.apply((DescribePortalResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IoTSiteWiseResponse.BuilderImpl
    implements Builder {
        private String portalId;
        private String portalArn;
        private String portalName;
        private String portalDescription;
        private String portalClientId;
        private String portalStartUrl;
        private String portalContactEmail;
        private PortalStatus portalStatus;
        private Instant portalCreationDate;
        private Instant portalLastUpdateDate;
        private ImageLocation portalLogoImageLocation;
        private String roleArn;
        private String portalAuthMode;
        private String notificationSenderEmail;
        private Alarms alarms;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribePortalResponse model) {
            super(model);
            this.portalId(model.portalId);
            this.portalArn(model.portalArn);
            this.portalName(model.portalName);
            this.portalDescription(model.portalDescription);
            this.portalClientId(model.portalClientId);
            this.portalStartUrl(model.portalStartUrl);
            this.portalContactEmail(model.portalContactEmail);
            this.portalStatus(model.portalStatus);
            this.portalCreationDate(model.portalCreationDate);
            this.portalLastUpdateDate(model.portalLastUpdateDate);
            this.portalLogoImageLocation(model.portalLogoImageLocation);
            this.roleArn(model.roleArn);
            this.portalAuthMode(model.portalAuthMode);
            this.notificationSenderEmail(model.notificationSenderEmail);
            this.alarms(model.alarms);
        }

        public final String getPortalId() {
            return this.portalId;
        }

        public final void setPortalId(String portalId) {
            this.portalId = portalId;
        }

        @Override
        public final Builder portalId(String portalId) {
            this.portalId = portalId;
            return this;
        }

        public final String getPortalArn() {
            return this.portalArn;
        }

        public final void setPortalArn(String portalArn) {
            this.portalArn = portalArn;
        }

        @Override
        public final Builder portalArn(String portalArn) {
            this.portalArn = portalArn;
            return this;
        }

        public final String getPortalName() {
            return this.portalName;
        }

        public final void setPortalName(String portalName) {
            this.portalName = portalName;
        }

        @Override
        public final Builder portalName(String portalName) {
            this.portalName = portalName;
            return this;
        }

        public final String getPortalDescription() {
            return this.portalDescription;
        }

        public final void setPortalDescription(String portalDescription) {
            this.portalDescription = portalDescription;
        }

        @Override
        public final Builder portalDescription(String portalDescription) {
            this.portalDescription = portalDescription;
            return this;
        }

        public final String getPortalClientId() {
            return this.portalClientId;
        }

        public final void setPortalClientId(String portalClientId) {
            this.portalClientId = portalClientId;
        }

        @Override
        public final Builder portalClientId(String portalClientId) {
            this.portalClientId = portalClientId;
            return this;
        }

        public final String getPortalStartUrl() {
            return this.portalStartUrl;
        }

        public final void setPortalStartUrl(String portalStartUrl) {
            this.portalStartUrl = portalStartUrl;
        }

        @Override
        public final Builder portalStartUrl(String portalStartUrl) {
            this.portalStartUrl = portalStartUrl;
            return this;
        }

        public final String getPortalContactEmail() {
            return this.portalContactEmail;
        }

        public final void setPortalContactEmail(String portalContactEmail) {
            this.portalContactEmail = portalContactEmail;
        }

        @Override
        public final Builder portalContactEmail(String portalContactEmail) {
            this.portalContactEmail = portalContactEmail;
            return this;
        }

        public final PortalStatus.Builder getPortalStatus() {
            return this.portalStatus != null ? this.portalStatus.toBuilder() : null;
        }

        public final void setPortalStatus(PortalStatus.BuilderImpl portalStatus) {
            this.portalStatus = portalStatus != null ? portalStatus.build() : null;
        }

        @Override
        public final Builder portalStatus(PortalStatus portalStatus) {
            this.portalStatus = portalStatus;
            return this;
        }

        public final Instant getPortalCreationDate() {
            return this.portalCreationDate;
        }

        public final void setPortalCreationDate(Instant portalCreationDate) {
            this.portalCreationDate = portalCreationDate;
        }

        @Override
        public final Builder portalCreationDate(Instant portalCreationDate) {
            this.portalCreationDate = portalCreationDate;
            return this;
        }

        public final Instant getPortalLastUpdateDate() {
            return this.portalLastUpdateDate;
        }

        public final void setPortalLastUpdateDate(Instant portalLastUpdateDate) {
            this.portalLastUpdateDate = portalLastUpdateDate;
        }

        @Override
        public final Builder portalLastUpdateDate(Instant portalLastUpdateDate) {
            this.portalLastUpdateDate = portalLastUpdateDate;
            return this;
        }

        public final ImageLocation.Builder getPortalLogoImageLocation() {
            return this.portalLogoImageLocation != null ? this.portalLogoImageLocation.toBuilder() : null;
        }

        public final void setPortalLogoImageLocation(ImageLocation.BuilderImpl portalLogoImageLocation) {
            this.portalLogoImageLocation = portalLogoImageLocation != null ? portalLogoImageLocation.build() : null;
        }

        @Override
        public final Builder portalLogoImageLocation(ImageLocation portalLogoImageLocation) {
            this.portalLogoImageLocation = portalLogoImageLocation;
            return this;
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final String getPortalAuthMode() {
            return this.portalAuthMode;
        }

        public final void setPortalAuthMode(String portalAuthMode) {
            this.portalAuthMode = portalAuthMode;
        }

        @Override
        public final Builder portalAuthMode(String portalAuthMode) {
            this.portalAuthMode = portalAuthMode;
            return this;
        }

        @Override
        public final Builder portalAuthMode(AuthMode portalAuthMode) {
            this.portalAuthMode(portalAuthMode == null ? null : portalAuthMode.toString());
            return this;
        }

        public final String getNotificationSenderEmail() {
            return this.notificationSenderEmail;
        }

        public final void setNotificationSenderEmail(String notificationSenderEmail) {
            this.notificationSenderEmail = notificationSenderEmail;
        }

        @Override
        public final Builder notificationSenderEmail(String notificationSenderEmail) {
            this.notificationSenderEmail = notificationSenderEmail;
            return this;
        }

        public final Alarms.Builder getAlarms() {
            return this.alarms != null ? this.alarms.toBuilder() : null;
        }

        public final void setAlarms(Alarms.BuilderImpl alarms) {
            this.alarms = alarms != null ? alarms.build() : null;
        }

        @Override
        public final Builder alarms(Alarms alarms) {
            this.alarms = alarms;
            return this;
        }

        @Override
        public DescribePortalResponse build() {
            return new DescribePortalResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends IoTSiteWiseResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribePortalResponse> {
        public Builder portalId(String var1);

        public Builder portalArn(String var1);

        public Builder portalName(String var1);

        public Builder portalDescription(String var1);

        public Builder portalClientId(String var1);

        public Builder portalStartUrl(String var1);

        public Builder portalContactEmail(String var1);

        public Builder portalStatus(PortalStatus var1);

        default public Builder portalStatus(Consumer<PortalStatus.Builder> portalStatus) {
            return this.portalStatus((PortalStatus)((PortalStatus.Builder)PortalStatus.builder().applyMutation(portalStatus)).build());
        }

        public Builder portalCreationDate(Instant var1);

        public Builder portalLastUpdateDate(Instant var1);

        public Builder portalLogoImageLocation(ImageLocation var1);

        default public Builder portalLogoImageLocation(Consumer<ImageLocation.Builder> portalLogoImageLocation) {
            return this.portalLogoImageLocation((ImageLocation)((ImageLocation.Builder)ImageLocation.builder().applyMutation(portalLogoImageLocation)).build());
        }

        public Builder roleArn(String var1);

        public Builder portalAuthMode(String var1);

        public Builder portalAuthMode(AuthMode var1);

        public Builder notificationSenderEmail(String var1);

        public Builder alarms(Alarms var1);

        default public Builder alarms(Consumer<Alarms.Builder> alarms) {
            return this.alarms((Alarms)((Alarms.Builder)Alarms.builder().applyMutation(alarms)).build());
        }
    }
}

