/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotsitewise.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.iotsitewise.IoTSiteWiseAsyncClient;
import software.amazon.awssdk.services.iotsitewise.model.AssetModelPropertySummary;
import software.amazon.awssdk.services.iotsitewise.model.ListAssetModelPropertiesRequest;
import software.amazon.awssdk.services.iotsitewise.model.ListAssetModelPropertiesResponse;

public class ListAssetModelPropertiesPublisher
implements SdkPublisher<ListAssetModelPropertiesResponse> {
    private final IoTSiteWiseAsyncClient client;
    private final ListAssetModelPropertiesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListAssetModelPropertiesPublisher(IoTSiteWiseAsyncClient client, ListAssetModelPropertiesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListAssetModelPropertiesPublisher(IoTSiteWiseAsyncClient client, ListAssetModelPropertiesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListAssetModelPropertiesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListAssetModelPropertiesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<AssetModelPropertySummary> assetModelPropertySummaries() {
        Function<ListAssetModelPropertiesResponse, Iterator> getIterator = response -> {
            if (response != null && response.assetModelPropertySummaries() != null) {
                return response.assetModelPropertySummaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListAssetModelPropertiesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListAssetModelPropertiesResponseFetcher
    implements AsyncPageFetcher<ListAssetModelPropertiesResponse> {
        private ListAssetModelPropertiesResponseFetcher() {
        }

        public boolean hasNextPage(ListAssetModelPropertiesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListAssetModelPropertiesResponse> nextPage(ListAssetModelPropertiesResponse previousPage) {
            if (previousPage == null) {
                return ListAssetModelPropertiesPublisher.this.client.listAssetModelProperties(ListAssetModelPropertiesPublisher.this.firstRequest);
            }
            return ListAssetModelPropertiesPublisher.this.client.listAssetModelProperties((ListAssetModelPropertiesRequest)((Object)ListAssetModelPropertiesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

