/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotsitewise.endpoints.internal;

import java.util.Optional;
import java.util.concurrent.CompletionException;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.AwsExecutionAttribute;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.interceptor.Context;
import software.amazon.awssdk.core.interceptor.ExecutionAttributes;
import software.amazon.awssdk.core.interceptor.ExecutionInterceptor;
import software.amazon.awssdk.core.interceptor.SdkExecutionAttribute;
import software.amazon.awssdk.core.interceptor.SdkInternalExecutionAttribute;
import software.amazon.awssdk.endpoints.Endpoint;
import software.amazon.awssdk.services.iotsitewise.endpoints.IoTSiteWiseEndpointParams;
import software.amazon.awssdk.services.iotsitewise.endpoints.IoTSiteWiseEndpointProvider;
import software.amazon.awssdk.services.iotsitewise.endpoints.internal.AwsEndpointProviderUtils;

@SdkInternalApi
public final class IoTSiteWiseResolveEndpointInterceptor
implements ExecutionInterceptor {
    public SdkRequest modifyRequest(Context.ModifyRequest context, ExecutionAttributes executionAttributes) {
        if (AwsEndpointProviderUtils.endpointIsDiscovered(executionAttributes)) {
            return context.request();
        }
        IoTSiteWiseEndpointProvider provider = (IoTSiteWiseEndpointProvider)executionAttributes.getAttribute(SdkInternalExecutionAttribute.ENDPOINT_PROVIDER);
        try {
            Optional<String> hostPrefix;
            Endpoint result = provider.resolveEndpoint(IoTSiteWiseResolveEndpointInterceptor.ruleParams(context, executionAttributes)).join();
            if (!AwsEndpointProviderUtils.disableHostPrefixInjection(executionAttributes) && (hostPrefix = IoTSiteWiseResolveEndpointInterceptor.hostPrefix((String)executionAttributes.getAttribute(SdkExecutionAttribute.OPERATION_NAME), context.request())).isPresent()) {
                result = AwsEndpointProviderUtils.addHostPrefix(result, hostPrefix.get());
            }
            executionAttributes.putAttribute(SdkInternalExecutionAttribute.RESOLVED_ENDPOINT, (Object)result);
            return context.request();
        }
        catch (CompletionException e) {
            Throwable cause = e.getCause();
            if (cause instanceof SdkClientException) {
                throw (SdkClientException)cause;
            }
            throw SdkClientException.create((String)"Endpoint resolution failed", (Throwable)cause);
        }
    }

    private static IoTSiteWiseEndpointParams ruleParams(Context.ModifyRequest context, ExecutionAttributes executionAttributes) {
        IoTSiteWiseEndpointParams.Builder builder = IoTSiteWiseEndpointParams.builder();
        IoTSiteWiseResolveEndpointInterceptor.setStaticContextParams(builder, (String)executionAttributes.getAttribute(AwsExecutionAttribute.OPERATION_NAME));
        IoTSiteWiseResolveEndpointInterceptor.setContextParams(builder, (String)executionAttributes.getAttribute(AwsExecutionAttribute.OPERATION_NAME), context.request());
        builder.region(AwsEndpointProviderUtils.regionBuiltIn(executionAttributes));
        builder.useDualStack(AwsEndpointProviderUtils.dualStackEnabledBuiltIn(executionAttributes));
        builder.useFips(AwsEndpointProviderUtils.fipsEnabledBuiltIn(executionAttributes));
        builder.endpoint(AwsEndpointProviderUtils.endpointBuiltIn(executionAttributes));
        return builder.build();
    }

    private static void setContextParams(IoTSiteWiseEndpointParams.Builder params, String operationName, SdkRequest request) {
    }

    private static void setStaticContextParams(IoTSiteWiseEndpointParams.Builder params, String operationName) {
    }

    private static Optional<String> hostPrefix(String operationName, SdkRequest request) {
        switch (operationName) {
            case "AssociateAssets": {
                return Optional.of("api.");
            }
            case "AssociateTimeSeriesToAssetProperty": {
                return Optional.of("api.");
            }
            case "BatchAssociateProjectAssets": {
                return Optional.of("monitor.");
            }
            case "BatchDisassociateProjectAssets": {
                return Optional.of("monitor.");
            }
            case "BatchGetAssetPropertyAggregates": {
                return Optional.of("data.");
            }
            case "BatchGetAssetPropertyValue": {
                return Optional.of("data.");
            }
            case "BatchGetAssetPropertyValueHistory": {
                return Optional.of("data.");
            }
            case "BatchPutAssetPropertyValue": {
                return Optional.of("data.");
            }
            case "CreateAccessPolicy": {
                return Optional.of("monitor.");
            }
            case "CreateAsset": {
                return Optional.of("api.");
            }
            case "CreateAssetModel": {
                return Optional.of("api.");
            }
            case "CreateBulkImportJob": {
                return Optional.of("data.");
            }
            case "CreateDashboard": {
                return Optional.of("monitor.");
            }
            case "CreateGateway": {
                return Optional.of("api.");
            }
            case "CreatePortal": {
                return Optional.of("monitor.");
            }
            case "CreateProject": {
                return Optional.of("monitor.");
            }
            case "DeleteAccessPolicy": {
                return Optional.of("monitor.");
            }
            case "DeleteAsset": {
                return Optional.of("api.");
            }
            case "DeleteAssetModel": {
                return Optional.of("api.");
            }
            case "DeleteDashboard": {
                return Optional.of("monitor.");
            }
            case "DeleteGateway": {
                return Optional.of("api.");
            }
            case "DeletePortal": {
                return Optional.of("monitor.");
            }
            case "DeleteProject": {
                return Optional.of("monitor.");
            }
            case "DeleteTimeSeries": {
                return Optional.of("api.");
            }
            case "DescribeAccessPolicy": {
                return Optional.of("monitor.");
            }
            case "DescribeAsset": {
                return Optional.of("api.");
            }
            case "DescribeAssetModel": {
                return Optional.of("api.");
            }
            case "DescribeAssetProperty": {
                return Optional.of("api.");
            }
            case "DescribeBulkImportJob": {
                return Optional.of("data.");
            }
            case "DescribeDashboard": {
                return Optional.of("monitor.");
            }
            case "DescribeDefaultEncryptionConfiguration": {
                return Optional.of("api.");
            }
            case "DescribeGateway": {
                return Optional.of("api.");
            }
            case "DescribeGatewayCapabilityConfiguration": {
                return Optional.of("api.");
            }
            case "DescribeLoggingOptions": {
                return Optional.of("api.");
            }
            case "DescribePortal": {
                return Optional.of("monitor.");
            }
            case "DescribeProject": {
                return Optional.of("monitor.");
            }
            case "DescribeStorageConfiguration": {
                return Optional.of("api.");
            }
            case "DescribeTimeSeries": {
                return Optional.of("api.");
            }
            case "DisassociateAssets": {
                return Optional.of("api.");
            }
            case "DisassociateTimeSeriesFromAssetProperty": {
                return Optional.of("api.");
            }
            case "GetAssetPropertyAggregates": {
                return Optional.of("data.");
            }
            case "GetAssetPropertyValue": {
                return Optional.of("data.");
            }
            case "GetAssetPropertyValueHistory": {
                return Optional.of("data.");
            }
            case "GetInterpolatedAssetPropertyValues": {
                return Optional.of("data.");
            }
            case "ListAccessPolicies": {
                return Optional.of("monitor.");
            }
            case "ListAssetModelProperties": {
                return Optional.of("api.");
            }
            case "ListAssetModels": {
                return Optional.of("api.");
            }
            case "ListAssetProperties": {
                return Optional.of("api.");
            }
            case "ListAssetRelationships": {
                return Optional.of("api.");
            }
            case "ListAssets": {
                return Optional.of("api.");
            }
            case "ListAssociatedAssets": {
                return Optional.of("api.");
            }
            case "ListBulkImportJobs": {
                return Optional.of("data.");
            }
            case "ListDashboards": {
                return Optional.of("monitor.");
            }
            case "ListGateways": {
                return Optional.of("api.");
            }
            case "ListPortals": {
                return Optional.of("monitor.");
            }
            case "ListProjectAssets": {
                return Optional.of("monitor.");
            }
            case "ListProjects": {
                return Optional.of("monitor.");
            }
            case "ListTagsForResource": {
                return Optional.of("api.");
            }
            case "ListTimeSeries": {
                return Optional.of("api.");
            }
            case "PutDefaultEncryptionConfiguration": {
                return Optional.of("api.");
            }
            case "PutLoggingOptions": {
                return Optional.of("api.");
            }
            case "PutStorageConfiguration": {
                return Optional.of("api.");
            }
            case "TagResource": {
                return Optional.of("api.");
            }
            case "UntagResource": {
                return Optional.of("api.");
            }
            case "UpdateAccessPolicy": {
                return Optional.of("monitor.");
            }
            case "UpdateAsset": {
                return Optional.of("api.");
            }
            case "UpdateAssetModel": {
                return Optional.of("api.");
            }
            case "UpdateAssetProperty": {
                return Optional.of("api.");
            }
            case "UpdateDashboard": {
                return Optional.of("monitor.");
            }
            case "UpdateGateway": {
                return Optional.of("api.");
            }
            case "UpdateGatewayCapabilityConfiguration": {
                return Optional.of("api.");
            }
            case "UpdatePortal": {
                return Optional.of("monitor.");
            }
            case "UpdateProject": {
                return Optional.of("monitor.");
            }
        }
        return Optional.empty();
    }
}

