/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotsitewise.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ColumnName {
    ALIAS("ALIAS"),
    ASSET_ID("ASSET_ID"),
    PROPERTY_ID("PROPERTY_ID"),
    DATA_TYPE("DATA_TYPE"),
    TIMESTAMP_SECONDS("TIMESTAMP_SECONDS"),
    TIMESTAMP_NANO_OFFSET("TIMESTAMP_NANO_OFFSET"),
    QUALITY("QUALITY"),
    VALUE("VALUE"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ColumnName> VALUE_MAP;
    private final String value;

    private ColumnName(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ColumnName fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ColumnName> knownValues() {
        EnumSet<ColumnName> knownValues = EnumSet.allOf(ColumnName.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ColumnName.class, ColumnName::toString);
    }
}

