/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotsitewise.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.iotsitewise.model.IoTSiteWiseRequest;
import software.amazon.awssdk.services.iotsitewise.model.TagMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateDashboardRequest
extends IoTSiteWiseRequest
implements ToCopyableBuilder<Builder, CreateDashboardRequest> {
    private static final SdkField<String> PROJECT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("projectId").getter(CreateDashboardRequest.getter(CreateDashboardRequest::projectId)).setter(CreateDashboardRequest.setter(Builder::projectId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("projectId").build()}).build();
    private static final SdkField<String> DASHBOARD_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("dashboardName").getter(CreateDashboardRequest.getter(CreateDashboardRequest::dashboardName)).setter(CreateDashboardRequest.setter(Builder::dashboardName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dashboardName").build()}).build();
    private static final SdkField<String> DASHBOARD_DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("dashboardDescription").getter(CreateDashboardRequest.getter(CreateDashboardRequest::dashboardDescription)).setter(CreateDashboardRequest.setter(Builder::dashboardDescription)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dashboardDescription").build()}).build();
    private static final SdkField<String> DASHBOARD_DEFINITION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("dashboardDefinition").getter(CreateDashboardRequest.getter(CreateDashboardRequest::dashboardDefinition)).setter(CreateDashboardRequest.setter(Builder::dashboardDefinition)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dashboardDefinition").build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clientToken").getter(CreateDashboardRequest.getter(CreateDashboardRequest::clientToken)).setter(CreateDashboardRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("tags").getter(CreateDashboardRequest.getter(CreateDashboardRequest::tags)).setter(CreateDashboardRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROJECT_ID_FIELD, DASHBOARD_NAME_FIELD, DASHBOARD_DESCRIPTION_FIELD, DASHBOARD_DEFINITION_FIELD, CLIENT_TOKEN_FIELD, TAGS_FIELD));
    private final String projectId;
    private final String dashboardName;
    private final String dashboardDescription;
    private final String dashboardDefinition;
    private final String clientToken;
    private final Map<String, String> tags;

    private CreateDashboardRequest(BuilderImpl builder) {
        super(builder);
        this.projectId = builder.projectId;
        this.dashboardName = builder.dashboardName;
        this.dashboardDescription = builder.dashboardDescription;
        this.dashboardDefinition = builder.dashboardDefinition;
        this.clientToken = builder.clientToken;
        this.tags = builder.tags;
    }

    public final String projectId() {
        return this.projectId;
    }

    public final String dashboardName() {
        return this.dashboardName;
    }

    public final String dashboardDescription() {
        return this.dashboardDescription;
    }

    public final String dashboardDefinition() {
        return this.dashboardDefinition;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.projectId());
        hashCode = 31 * hashCode + Objects.hashCode(this.dashboardName());
        hashCode = 31 * hashCode + Objects.hashCode(this.dashboardDescription());
        hashCode = 31 * hashCode + Objects.hashCode(this.dashboardDefinition());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateDashboardRequest)) {
            return false;
        }
        CreateDashboardRequest other = (CreateDashboardRequest)((Object)obj);
        return Objects.equals(this.projectId(), other.projectId()) && Objects.equals(this.dashboardName(), other.dashboardName()) && Objects.equals(this.dashboardDescription(), other.dashboardDescription()) && Objects.equals(this.dashboardDefinition(), other.dashboardDefinition()) && Objects.equals(this.clientToken(), other.clientToken()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"CreateDashboardRequest").add("ProjectId", (Object)this.projectId()).add("DashboardName", (Object)this.dashboardName()).add("DashboardDescription", (Object)this.dashboardDescription()).add("DashboardDefinition", (Object)this.dashboardDefinition()).add("ClientToken", (Object)this.clientToken()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "projectId": {
                return Optional.ofNullable(clazz.cast(this.projectId()));
            }
            case "dashboardName": {
                return Optional.ofNullable(clazz.cast(this.dashboardName()));
            }
            case "dashboardDescription": {
                return Optional.ofNullable(clazz.cast(this.dashboardDescription()));
            }
            case "dashboardDefinition": {
                return Optional.ofNullable(clazz.cast(this.dashboardDefinition()));
            }
            case "clientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateDashboardRequest, T> g) {
        return obj -> g.apply((CreateDashboardRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IoTSiteWiseRequest.BuilderImpl
    implements Builder {
        private String projectId;
        private String dashboardName;
        private String dashboardDescription;
        private String dashboardDefinition;
        private String clientToken;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateDashboardRequest model) {
            super(model);
            this.projectId(model.projectId);
            this.dashboardName(model.dashboardName);
            this.dashboardDescription(model.dashboardDescription);
            this.dashboardDefinition(model.dashboardDefinition);
            this.clientToken(model.clientToken);
            this.tags(model.tags);
        }

        public final String getProjectId() {
            return this.projectId;
        }

        public final void setProjectId(String projectId) {
            this.projectId = projectId;
        }

        @Override
        @Transient
        public final Builder projectId(String projectId) {
            this.projectId = projectId;
            return this;
        }

        public final String getDashboardName() {
            return this.dashboardName;
        }

        public final void setDashboardName(String dashboardName) {
            this.dashboardName = dashboardName;
        }

        @Override
        @Transient
        public final Builder dashboardName(String dashboardName) {
            this.dashboardName = dashboardName;
            return this;
        }

        public final String getDashboardDescription() {
            return this.dashboardDescription;
        }

        public final void setDashboardDescription(String dashboardDescription) {
            this.dashboardDescription = dashboardDescription;
        }

        @Override
        @Transient
        public final Builder dashboardDescription(String dashboardDescription) {
            this.dashboardDescription = dashboardDescription;
            return this;
        }

        public final String getDashboardDefinition() {
            return this.dashboardDefinition;
        }

        public final void setDashboardDefinition(String dashboardDefinition) {
            this.dashboardDefinition = dashboardDefinition;
        }

        @Override
        @Transient
        public final Builder dashboardDefinition(String dashboardDefinition) {
            this.dashboardDefinition = dashboardDefinition;
            return this;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        @Transient
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        @Transient
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateDashboardRequest build() {
            return new CreateDashboardRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends IoTSiteWiseRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateDashboardRequest> {
        public Builder projectId(String var1);

        public Builder dashboardName(String var1);

        public Builder dashboardDescription(String var1);

        public Builder dashboardDefinition(String var1);

        public Builder clientToken(String var1);

        public Builder tags(Map<String, String> var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

