/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotsitewise.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.iotsitewise.IoTSiteWiseAsyncClient;
import software.amazon.awssdk.services.iotsitewise.model.AssetPropertyValue;
import software.amazon.awssdk.services.iotsitewise.model.GetAssetPropertyValueHistoryRequest;
import software.amazon.awssdk.services.iotsitewise.model.GetAssetPropertyValueHistoryResponse;

public class GetAssetPropertyValueHistoryPublisher
implements SdkPublisher<GetAssetPropertyValueHistoryResponse> {
    private final IoTSiteWiseAsyncClient client;
    private final GetAssetPropertyValueHistoryRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public GetAssetPropertyValueHistoryPublisher(IoTSiteWiseAsyncClient client, GetAssetPropertyValueHistoryRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private GetAssetPropertyValueHistoryPublisher(IoTSiteWiseAsyncClient client, GetAssetPropertyValueHistoryRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new GetAssetPropertyValueHistoryResponseFetcher();
    }

    public void subscribe(Subscriber<? super GetAssetPropertyValueHistoryResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<AssetPropertyValue> assetPropertyValueHistory() {
        Function<GetAssetPropertyValueHistoryResponse, Iterator> getIterator = response -> {
            if (response != null && response.assetPropertyValueHistory() != null) {
                return response.assetPropertyValueHistory().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new GetAssetPropertyValueHistoryResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class GetAssetPropertyValueHistoryResponseFetcher
    implements AsyncPageFetcher<GetAssetPropertyValueHistoryResponse> {
        private GetAssetPropertyValueHistoryResponseFetcher() {
        }

        public boolean hasNextPage(GetAssetPropertyValueHistoryResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<GetAssetPropertyValueHistoryResponse> nextPage(GetAssetPropertyValueHistoryResponse previousPage) {
            if (previousPage == null) {
                return GetAssetPropertyValueHistoryPublisher.this.client.getAssetPropertyValueHistory(GetAssetPropertyValueHistoryPublisher.this.firstRequest);
            }
            return GetAssetPropertyValueHistoryPublisher.this.client.getAssetPropertyValueHistory((GetAssetPropertyValueHistoryRequest)((Object)GetAssetPropertyValueHistoryPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

