/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotsitewise.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.iotsitewise.model.DetailedError;
import software.amazon.awssdk.services.iotsitewise.model.DetailedErrorsCopier;
import software.amazon.awssdk.services.iotsitewise.model.ErrorCode;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ErrorDetails
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ErrorDetails> {
    private static final SdkField<String> CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("code").getter(ErrorDetails.getter(ErrorDetails::codeAsString)).setter(ErrorDetails.setter(Builder::code)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("code").build()}).build();
    private static final SdkField<String> MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("message").getter(ErrorDetails.getter(ErrorDetails::message)).setter(ErrorDetails.setter(Builder::message)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("message").build()}).build();
    private static final SdkField<List<DetailedError>> DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("details").getter(ErrorDetails.getter(ErrorDetails::details)).setter(ErrorDetails.setter(Builder::details)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("details").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DetailedError::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CODE_FIELD, MESSAGE_FIELD, DETAILS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String code;
    private final String message;
    private final List<DetailedError> details;

    private ErrorDetails(BuilderImpl builder) {
        this.code = builder.code;
        this.message = builder.message;
        this.details = builder.details;
    }

    public final ErrorCode code() {
        return ErrorCode.fromValue(this.code);
    }

    public final String codeAsString() {
        return this.code;
    }

    public final String message() {
        return this.message;
    }

    public final boolean hasDetails() {
        return this.details != null && !(this.details instanceof SdkAutoConstructList);
    }

    public final List<DetailedError> details() {
        return this.details;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.codeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.message());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDetails() ? this.details() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ErrorDetails)) {
            return false;
        }
        ErrorDetails other = (ErrorDetails)obj;
        return Objects.equals(this.codeAsString(), other.codeAsString()) && Objects.equals(this.message(), other.message()) && this.hasDetails() == other.hasDetails() && Objects.equals(this.details(), other.details());
    }

    public final String toString() {
        return ToString.builder((String)"ErrorDetails").add("Code", (Object)this.codeAsString()).add("Message", (Object)this.message()).add("Details", this.hasDetails() ? this.details() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "code": {
                return Optional.ofNullable(clazz.cast(this.codeAsString()));
            }
            case "message": {
                return Optional.ofNullable(clazz.cast(this.message()));
            }
            case "details": {
                return Optional.ofNullable(clazz.cast(this.details()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ErrorDetails, T> g) {
        return obj -> g.apply((ErrorDetails)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String code;
        private String message;
        private List<DetailedError> details = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ErrorDetails model) {
            this.code(model.code);
            this.message(model.message);
            this.details(model.details);
        }

        public final String getCode() {
            return this.code;
        }

        @Override
        public final Builder code(String code) {
            this.code = code;
            return this;
        }

        @Override
        public final Builder code(ErrorCode code) {
            this.code(code == null ? null : code.toString());
            return this;
        }

        public final void setCode(String code) {
            this.code = code;
        }

        public final String getMessage() {
            return this.message;
        }

        @Override
        public final Builder message(String message) {
            this.message = message;
            return this;
        }

        public final void setMessage(String message) {
            this.message = message;
        }

        public final List<DetailedError.Builder> getDetails() {
            List<DetailedError.Builder> result = DetailedErrorsCopier.copyToBuilder(this.details);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder details(Collection<DetailedError> details) {
            this.details = DetailedErrorsCopier.copy(details);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder details(DetailedError ... details) {
            this.details(Arrays.asList(details));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder details(Consumer<DetailedError.Builder> ... details) {
            this.details(Stream.of(details).map(c -> (DetailedError)((DetailedError.Builder)DetailedError.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setDetails(Collection<DetailedError.BuilderImpl> details) {
            this.details = DetailedErrorsCopier.copyFromBuilder(details);
        }

        public ErrorDetails build() {
            return new ErrorDetails(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ErrorDetails> {
        public Builder code(String var1);

        public Builder code(ErrorCode var1);

        public Builder message(String var1);

        public Builder details(Collection<DetailedError> var1);

        public Builder details(DetailedError ... var1);

        public Builder details(Consumer<DetailedError.Builder> ... var1);
    }
}

