/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotsitewise.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.iotsitewise.model.IoTSiteWiseResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateAccessPolicyResponse
extends IoTSiteWiseResponse
implements ToCopyableBuilder<Builder, CreateAccessPolicyResponse> {
    private static final SdkField<String> ACCESS_POLICY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("accessPolicyId").getter(CreateAccessPolicyResponse.getter(CreateAccessPolicyResponse::accessPolicyId)).setter(CreateAccessPolicyResponse.setter(Builder::accessPolicyId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accessPolicyId").build()}).build();
    private static final SdkField<String> ACCESS_POLICY_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("accessPolicyArn").getter(CreateAccessPolicyResponse.getter(CreateAccessPolicyResponse::accessPolicyArn)).setter(CreateAccessPolicyResponse.setter(Builder::accessPolicyArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accessPolicyArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCESS_POLICY_ID_FIELD, ACCESS_POLICY_ARN_FIELD));
    private final String accessPolicyId;
    private final String accessPolicyArn;

    private CreateAccessPolicyResponse(BuilderImpl builder) {
        super(builder);
        this.accessPolicyId = builder.accessPolicyId;
        this.accessPolicyArn = builder.accessPolicyArn;
    }

    public final String accessPolicyId() {
        return this.accessPolicyId;
    }

    public final String accessPolicyArn() {
        return this.accessPolicyArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.accessPolicyId());
        hashCode = 31 * hashCode + Objects.hashCode(this.accessPolicyArn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateAccessPolicyResponse)) {
            return false;
        }
        CreateAccessPolicyResponse other = (CreateAccessPolicyResponse)((Object)obj);
        return Objects.equals(this.accessPolicyId(), other.accessPolicyId()) && Objects.equals(this.accessPolicyArn(), other.accessPolicyArn());
    }

    public final String toString() {
        return ToString.builder((String)"CreateAccessPolicyResponse").add("AccessPolicyId", (Object)this.accessPolicyId()).add("AccessPolicyArn", (Object)this.accessPolicyArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "accessPolicyId": {
                return Optional.ofNullable(clazz.cast(this.accessPolicyId()));
            }
            case "accessPolicyArn": {
                return Optional.ofNullable(clazz.cast(this.accessPolicyArn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateAccessPolicyResponse, T> g) {
        return obj -> g.apply((CreateAccessPolicyResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IoTSiteWiseResponse.BuilderImpl
    implements Builder {
        private String accessPolicyId;
        private String accessPolicyArn;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateAccessPolicyResponse model) {
            super(model);
            this.accessPolicyId(model.accessPolicyId);
            this.accessPolicyArn(model.accessPolicyArn);
        }

        public final String getAccessPolicyId() {
            return this.accessPolicyId;
        }

        @Override
        public final Builder accessPolicyId(String accessPolicyId) {
            this.accessPolicyId = accessPolicyId;
            return this;
        }

        public final void setAccessPolicyId(String accessPolicyId) {
            this.accessPolicyId = accessPolicyId;
        }

        public final String getAccessPolicyArn() {
            return this.accessPolicyArn;
        }

        @Override
        public final Builder accessPolicyArn(String accessPolicyArn) {
            this.accessPolicyArn = accessPolicyArn;
            return this;
        }

        public final void setAccessPolicyArn(String accessPolicyArn) {
            this.accessPolicyArn = accessPolicyArn;
        }

        @Override
        public CreateAccessPolicyResponse build() {
            return new CreateAccessPolicyResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends IoTSiteWiseResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateAccessPolicyResponse> {
        public Builder accessPolicyId(String var1);

        public Builder accessPolicyArn(String var1);
    }
}

