/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotsitewise.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.iotsitewise.model.AssetModelCompositeModel;
import software.amazon.awssdk.services.iotsitewise.model.AssetModelCompositeModelsCopier;
import software.amazon.awssdk.services.iotsitewise.model.AssetModelHierarchiesCopier;
import software.amazon.awssdk.services.iotsitewise.model.AssetModelHierarchy;
import software.amazon.awssdk.services.iotsitewise.model.AssetModelPropertiesCopier;
import software.amazon.awssdk.services.iotsitewise.model.AssetModelProperty;
import software.amazon.awssdk.services.iotsitewise.model.AssetModelStatus;
import software.amazon.awssdk.services.iotsitewise.model.IoTSiteWiseResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeAssetModelResponse
extends IoTSiteWiseResponse
implements ToCopyableBuilder<Builder, DescribeAssetModelResponse> {
    private static final SdkField<String> ASSET_MODEL_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("assetModelId").getter(DescribeAssetModelResponse.getter(DescribeAssetModelResponse::assetModelId)).setter(DescribeAssetModelResponse.setter(Builder::assetModelId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assetModelId").build()}).build();
    private static final SdkField<String> ASSET_MODEL_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("assetModelArn").getter(DescribeAssetModelResponse.getter(DescribeAssetModelResponse::assetModelArn)).setter(DescribeAssetModelResponse.setter(Builder::assetModelArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assetModelArn").build()}).build();
    private static final SdkField<String> ASSET_MODEL_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("assetModelName").getter(DescribeAssetModelResponse.getter(DescribeAssetModelResponse::assetModelName)).setter(DescribeAssetModelResponse.setter(Builder::assetModelName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assetModelName").build()}).build();
    private static final SdkField<String> ASSET_MODEL_DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("assetModelDescription").getter(DescribeAssetModelResponse.getter(DescribeAssetModelResponse::assetModelDescription)).setter(DescribeAssetModelResponse.setter(Builder::assetModelDescription)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assetModelDescription").build()}).build();
    private static final SdkField<List<AssetModelProperty>> ASSET_MODEL_PROPERTIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("assetModelProperties").getter(DescribeAssetModelResponse.getter(DescribeAssetModelResponse::assetModelProperties)).setter(DescribeAssetModelResponse.setter(Builder::assetModelProperties)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assetModelProperties").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AssetModelProperty::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<AssetModelHierarchy>> ASSET_MODEL_HIERARCHIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("assetModelHierarchies").getter(DescribeAssetModelResponse.getter(DescribeAssetModelResponse::assetModelHierarchies)).setter(DescribeAssetModelResponse.setter(Builder::assetModelHierarchies)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assetModelHierarchies").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AssetModelHierarchy::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<AssetModelCompositeModel>> ASSET_MODEL_COMPOSITE_MODELS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("assetModelCompositeModels").getter(DescribeAssetModelResponse.getter(DescribeAssetModelResponse::assetModelCompositeModels)).setter(DescribeAssetModelResponse.setter(Builder::assetModelCompositeModels)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assetModelCompositeModels").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AssetModelCompositeModel::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Instant> ASSET_MODEL_CREATION_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("assetModelCreationDate").getter(DescribeAssetModelResponse.getter(DescribeAssetModelResponse::assetModelCreationDate)).setter(DescribeAssetModelResponse.setter(Builder::assetModelCreationDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assetModelCreationDate").build()}).build();
    private static final SdkField<Instant> ASSET_MODEL_LAST_UPDATE_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("assetModelLastUpdateDate").getter(DescribeAssetModelResponse.getter(DescribeAssetModelResponse::assetModelLastUpdateDate)).setter(DescribeAssetModelResponse.setter(Builder::assetModelLastUpdateDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assetModelLastUpdateDate").build()}).build();
    private static final SdkField<AssetModelStatus> ASSET_MODEL_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("assetModelStatus").getter(DescribeAssetModelResponse.getter(DescribeAssetModelResponse::assetModelStatus)).setter(DescribeAssetModelResponse.setter(Builder::assetModelStatus)).constructor(AssetModelStatus::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assetModelStatus").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASSET_MODEL_ID_FIELD, ASSET_MODEL_ARN_FIELD, ASSET_MODEL_NAME_FIELD, ASSET_MODEL_DESCRIPTION_FIELD, ASSET_MODEL_PROPERTIES_FIELD, ASSET_MODEL_HIERARCHIES_FIELD, ASSET_MODEL_COMPOSITE_MODELS_FIELD, ASSET_MODEL_CREATION_DATE_FIELD, ASSET_MODEL_LAST_UPDATE_DATE_FIELD, ASSET_MODEL_STATUS_FIELD));
    private final String assetModelId;
    private final String assetModelArn;
    private final String assetModelName;
    private final String assetModelDescription;
    private final List<AssetModelProperty> assetModelProperties;
    private final List<AssetModelHierarchy> assetModelHierarchies;
    private final List<AssetModelCompositeModel> assetModelCompositeModels;
    private final Instant assetModelCreationDate;
    private final Instant assetModelLastUpdateDate;
    private final AssetModelStatus assetModelStatus;

    private DescribeAssetModelResponse(BuilderImpl builder) {
        super(builder);
        this.assetModelId = builder.assetModelId;
        this.assetModelArn = builder.assetModelArn;
        this.assetModelName = builder.assetModelName;
        this.assetModelDescription = builder.assetModelDescription;
        this.assetModelProperties = builder.assetModelProperties;
        this.assetModelHierarchies = builder.assetModelHierarchies;
        this.assetModelCompositeModels = builder.assetModelCompositeModels;
        this.assetModelCreationDate = builder.assetModelCreationDate;
        this.assetModelLastUpdateDate = builder.assetModelLastUpdateDate;
        this.assetModelStatus = builder.assetModelStatus;
    }

    public final String assetModelId() {
        return this.assetModelId;
    }

    public final String assetModelArn() {
        return this.assetModelArn;
    }

    public final String assetModelName() {
        return this.assetModelName;
    }

    public final String assetModelDescription() {
        return this.assetModelDescription;
    }

    public final boolean hasAssetModelProperties() {
        return this.assetModelProperties != null && !(this.assetModelProperties instanceof SdkAutoConstructList);
    }

    public final List<AssetModelProperty> assetModelProperties() {
        return this.assetModelProperties;
    }

    public final boolean hasAssetModelHierarchies() {
        return this.assetModelHierarchies != null && !(this.assetModelHierarchies instanceof SdkAutoConstructList);
    }

    public final List<AssetModelHierarchy> assetModelHierarchies() {
        return this.assetModelHierarchies;
    }

    public final boolean hasAssetModelCompositeModels() {
        return this.assetModelCompositeModels != null && !(this.assetModelCompositeModels instanceof SdkAutoConstructList);
    }

    public final List<AssetModelCompositeModel> assetModelCompositeModels() {
        return this.assetModelCompositeModels;
    }

    public final Instant assetModelCreationDate() {
        return this.assetModelCreationDate;
    }

    public final Instant assetModelLastUpdateDate() {
        return this.assetModelLastUpdateDate;
    }

    public final AssetModelStatus assetModelStatus() {
        return this.assetModelStatus;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.assetModelId());
        hashCode = 31 * hashCode + Objects.hashCode(this.assetModelArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.assetModelName());
        hashCode = 31 * hashCode + Objects.hashCode(this.assetModelDescription());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAssetModelProperties() ? this.assetModelProperties() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAssetModelHierarchies() ? this.assetModelHierarchies() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAssetModelCompositeModels() ? this.assetModelCompositeModels() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.assetModelCreationDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.assetModelLastUpdateDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.assetModelStatus());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeAssetModelResponse)) {
            return false;
        }
        DescribeAssetModelResponse other = (DescribeAssetModelResponse)((Object)obj);
        return Objects.equals(this.assetModelId(), other.assetModelId()) && Objects.equals(this.assetModelArn(), other.assetModelArn()) && Objects.equals(this.assetModelName(), other.assetModelName()) && Objects.equals(this.assetModelDescription(), other.assetModelDescription()) && this.hasAssetModelProperties() == other.hasAssetModelProperties() && Objects.equals(this.assetModelProperties(), other.assetModelProperties()) && this.hasAssetModelHierarchies() == other.hasAssetModelHierarchies() && Objects.equals(this.assetModelHierarchies(), other.assetModelHierarchies()) && this.hasAssetModelCompositeModels() == other.hasAssetModelCompositeModels() && Objects.equals(this.assetModelCompositeModels(), other.assetModelCompositeModels()) && Objects.equals(this.assetModelCreationDate(), other.assetModelCreationDate()) && Objects.equals(this.assetModelLastUpdateDate(), other.assetModelLastUpdateDate()) && Objects.equals(this.assetModelStatus(), other.assetModelStatus());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeAssetModelResponse").add("AssetModelId", (Object)this.assetModelId()).add("AssetModelArn", (Object)this.assetModelArn()).add("AssetModelName", (Object)this.assetModelName()).add("AssetModelDescription", (Object)this.assetModelDescription()).add("AssetModelProperties", this.hasAssetModelProperties() ? this.assetModelProperties() : null).add("AssetModelHierarchies", this.hasAssetModelHierarchies() ? this.assetModelHierarchies() : null).add("AssetModelCompositeModels", this.hasAssetModelCompositeModels() ? this.assetModelCompositeModels() : null).add("AssetModelCreationDate", (Object)this.assetModelCreationDate()).add("AssetModelLastUpdateDate", (Object)this.assetModelLastUpdateDate()).add("AssetModelStatus", (Object)this.assetModelStatus()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "assetModelId": {
                return Optional.ofNullable(clazz.cast(this.assetModelId()));
            }
            case "assetModelArn": {
                return Optional.ofNullable(clazz.cast(this.assetModelArn()));
            }
            case "assetModelName": {
                return Optional.ofNullable(clazz.cast(this.assetModelName()));
            }
            case "assetModelDescription": {
                return Optional.ofNullable(clazz.cast(this.assetModelDescription()));
            }
            case "assetModelProperties": {
                return Optional.ofNullable(clazz.cast(this.assetModelProperties()));
            }
            case "assetModelHierarchies": {
                return Optional.ofNullable(clazz.cast(this.assetModelHierarchies()));
            }
            case "assetModelCompositeModels": {
                return Optional.ofNullable(clazz.cast(this.assetModelCompositeModels()));
            }
            case "assetModelCreationDate": {
                return Optional.ofNullable(clazz.cast(this.assetModelCreationDate()));
            }
            case "assetModelLastUpdateDate": {
                return Optional.ofNullable(clazz.cast(this.assetModelLastUpdateDate()));
            }
            case "assetModelStatus": {
                return Optional.ofNullable(clazz.cast(this.assetModelStatus()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeAssetModelResponse, T> g) {
        return obj -> g.apply((DescribeAssetModelResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IoTSiteWiseResponse.BuilderImpl
    implements Builder {
        private String assetModelId;
        private String assetModelArn;
        private String assetModelName;
        private String assetModelDescription;
        private List<AssetModelProperty> assetModelProperties = DefaultSdkAutoConstructList.getInstance();
        private List<AssetModelHierarchy> assetModelHierarchies = DefaultSdkAutoConstructList.getInstance();
        private List<AssetModelCompositeModel> assetModelCompositeModels = DefaultSdkAutoConstructList.getInstance();
        private Instant assetModelCreationDate;
        private Instant assetModelLastUpdateDate;
        private AssetModelStatus assetModelStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeAssetModelResponse model) {
            super(model);
            this.assetModelId(model.assetModelId);
            this.assetModelArn(model.assetModelArn);
            this.assetModelName(model.assetModelName);
            this.assetModelDescription(model.assetModelDescription);
            this.assetModelProperties(model.assetModelProperties);
            this.assetModelHierarchies(model.assetModelHierarchies);
            this.assetModelCompositeModels(model.assetModelCompositeModels);
            this.assetModelCreationDate(model.assetModelCreationDate);
            this.assetModelLastUpdateDate(model.assetModelLastUpdateDate);
            this.assetModelStatus(model.assetModelStatus);
        }

        public final String getAssetModelId() {
            return this.assetModelId;
        }

        @Override
        public final Builder assetModelId(String assetModelId) {
            this.assetModelId = assetModelId;
            return this;
        }

        public final void setAssetModelId(String assetModelId) {
            this.assetModelId = assetModelId;
        }

        public final String getAssetModelArn() {
            return this.assetModelArn;
        }

        @Override
        public final Builder assetModelArn(String assetModelArn) {
            this.assetModelArn = assetModelArn;
            return this;
        }

        public final void setAssetModelArn(String assetModelArn) {
            this.assetModelArn = assetModelArn;
        }

        public final String getAssetModelName() {
            return this.assetModelName;
        }

        @Override
        public final Builder assetModelName(String assetModelName) {
            this.assetModelName = assetModelName;
            return this;
        }

        public final void setAssetModelName(String assetModelName) {
            this.assetModelName = assetModelName;
        }

        public final String getAssetModelDescription() {
            return this.assetModelDescription;
        }

        @Override
        public final Builder assetModelDescription(String assetModelDescription) {
            this.assetModelDescription = assetModelDescription;
            return this;
        }

        public final void setAssetModelDescription(String assetModelDescription) {
            this.assetModelDescription = assetModelDescription;
        }

        public final Collection<AssetModelProperty.Builder> getAssetModelProperties() {
            if (this.assetModelProperties instanceof SdkAutoConstructList) {
                return null;
            }
            return this.assetModelProperties != null ? (Collection)this.assetModelProperties.stream().map(AssetModelProperty::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder assetModelProperties(Collection<AssetModelProperty> assetModelProperties) {
            this.assetModelProperties = AssetModelPropertiesCopier.copy(assetModelProperties);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder assetModelProperties(AssetModelProperty ... assetModelProperties) {
            this.assetModelProperties(Arrays.asList(assetModelProperties));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder assetModelProperties(Consumer<AssetModelProperty.Builder> ... assetModelProperties) {
            this.assetModelProperties(Stream.of(assetModelProperties).map(c -> (AssetModelProperty)((AssetModelProperty.Builder)AssetModelProperty.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setAssetModelProperties(Collection<AssetModelProperty.BuilderImpl> assetModelProperties) {
            this.assetModelProperties = AssetModelPropertiesCopier.copyFromBuilder(assetModelProperties);
        }

        public final Collection<AssetModelHierarchy.Builder> getAssetModelHierarchies() {
            if (this.assetModelHierarchies instanceof SdkAutoConstructList) {
                return null;
            }
            return this.assetModelHierarchies != null ? (Collection)this.assetModelHierarchies.stream().map(AssetModelHierarchy::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder assetModelHierarchies(Collection<AssetModelHierarchy> assetModelHierarchies) {
            this.assetModelHierarchies = AssetModelHierarchiesCopier.copy(assetModelHierarchies);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder assetModelHierarchies(AssetModelHierarchy ... assetModelHierarchies) {
            this.assetModelHierarchies(Arrays.asList(assetModelHierarchies));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder assetModelHierarchies(Consumer<AssetModelHierarchy.Builder> ... assetModelHierarchies) {
            this.assetModelHierarchies(Stream.of(assetModelHierarchies).map(c -> (AssetModelHierarchy)((AssetModelHierarchy.Builder)AssetModelHierarchy.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setAssetModelHierarchies(Collection<AssetModelHierarchy.BuilderImpl> assetModelHierarchies) {
            this.assetModelHierarchies = AssetModelHierarchiesCopier.copyFromBuilder(assetModelHierarchies);
        }

        public final Collection<AssetModelCompositeModel.Builder> getAssetModelCompositeModels() {
            if (this.assetModelCompositeModels instanceof SdkAutoConstructList) {
                return null;
            }
            return this.assetModelCompositeModels != null ? (Collection)this.assetModelCompositeModels.stream().map(AssetModelCompositeModel::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder assetModelCompositeModels(Collection<AssetModelCompositeModel> assetModelCompositeModels) {
            this.assetModelCompositeModels = AssetModelCompositeModelsCopier.copy(assetModelCompositeModels);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder assetModelCompositeModels(AssetModelCompositeModel ... assetModelCompositeModels) {
            this.assetModelCompositeModels(Arrays.asList(assetModelCompositeModels));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder assetModelCompositeModels(Consumer<AssetModelCompositeModel.Builder> ... assetModelCompositeModels) {
            this.assetModelCompositeModels(Stream.of(assetModelCompositeModels).map(c -> (AssetModelCompositeModel)((AssetModelCompositeModel.Builder)AssetModelCompositeModel.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setAssetModelCompositeModels(Collection<AssetModelCompositeModel.BuilderImpl> assetModelCompositeModels) {
            this.assetModelCompositeModels = AssetModelCompositeModelsCopier.copyFromBuilder(assetModelCompositeModels);
        }

        public final Instant getAssetModelCreationDate() {
            return this.assetModelCreationDate;
        }

        @Override
        public final Builder assetModelCreationDate(Instant assetModelCreationDate) {
            this.assetModelCreationDate = assetModelCreationDate;
            return this;
        }

        public final void setAssetModelCreationDate(Instant assetModelCreationDate) {
            this.assetModelCreationDate = assetModelCreationDate;
        }

        public final Instant getAssetModelLastUpdateDate() {
            return this.assetModelLastUpdateDate;
        }

        @Override
        public final Builder assetModelLastUpdateDate(Instant assetModelLastUpdateDate) {
            this.assetModelLastUpdateDate = assetModelLastUpdateDate;
            return this;
        }

        public final void setAssetModelLastUpdateDate(Instant assetModelLastUpdateDate) {
            this.assetModelLastUpdateDate = assetModelLastUpdateDate;
        }

        public final AssetModelStatus.Builder getAssetModelStatus() {
            return this.assetModelStatus != null ? this.assetModelStatus.toBuilder() : null;
        }

        @Override
        public final Builder assetModelStatus(AssetModelStatus assetModelStatus) {
            this.assetModelStatus = assetModelStatus;
            return this;
        }

        public final void setAssetModelStatus(AssetModelStatus.BuilderImpl assetModelStatus) {
            this.assetModelStatus = assetModelStatus != null ? assetModelStatus.build() : null;
        }

        @Override
        public DescribeAssetModelResponse build() {
            return new DescribeAssetModelResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends IoTSiteWiseResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeAssetModelResponse> {
        public Builder assetModelId(String var1);

        public Builder assetModelArn(String var1);

        public Builder assetModelName(String var1);

        public Builder assetModelDescription(String var1);

        public Builder assetModelProperties(Collection<AssetModelProperty> var1);

        public Builder assetModelProperties(AssetModelProperty ... var1);

        public Builder assetModelProperties(Consumer<AssetModelProperty.Builder> ... var1);

        public Builder assetModelHierarchies(Collection<AssetModelHierarchy> var1);

        public Builder assetModelHierarchies(AssetModelHierarchy ... var1);

        public Builder assetModelHierarchies(Consumer<AssetModelHierarchy.Builder> ... var1);

        public Builder assetModelCompositeModels(Collection<AssetModelCompositeModel> var1);

        public Builder assetModelCompositeModels(AssetModelCompositeModel ... var1);

        public Builder assetModelCompositeModels(Consumer<AssetModelCompositeModel.Builder> ... var1);

        public Builder assetModelCreationDate(Instant var1);

        public Builder assetModelLastUpdateDate(Instant var1);

        public Builder assetModelStatus(AssetModelStatus var1);

        default public Builder assetModelStatus(Consumer<AssetModelStatus.Builder> assetModelStatus) {
            return this.assetModelStatus((AssetModelStatus)((AssetModelStatus.Builder)AssetModelStatus.builder().applyMutation(assetModelStatus)).build());
        }
    }
}

