/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotsitewise.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.iotsitewise.IoTSiteWiseClient;
import software.amazon.awssdk.services.iotsitewise.model.AssetPropertyValue;
import software.amazon.awssdk.services.iotsitewise.model.GetAssetPropertyValueHistoryRequest;
import software.amazon.awssdk.services.iotsitewise.model.GetAssetPropertyValueHistoryResponse;

public class GetAssetPropertyValueHistoryIterable
implements SdkIterable<GetAssetPropertyValueHistoryResponse> {
    private final IoTSiteWiseClient client;
    private final GetAssetPropertyValueHistoryRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public GetAssetPropertyValueHistoryIterable(IoTSiteWiseClient client, GetAssetPropertyValueHistoryRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new GetAssetPropertyValueHistoryResponseFetcher();
    }

    public Iterator<GetAssetPropertyValueHistoryResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<AssetPropertyValue> assetPropertyValueHistory() {
        Function<GetAssetPropertyValueHistoryResponse, Iterator> getIterator = response -> {
            if (response != null && response.assetPropertyValueHistory() != null) {
                return response.assetPropertyValueHistory().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class GetAssetPropertyValueHistoryResponseFetcher
    implements SyncPageFetcher<GetAssetPropertyValueHistoryResponse> {
        private GetAssetPropertyValueHistoryResponseFetcher() {
        }

        public boolean hasNextPage(GetAssetPropertyValueHistoryResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public GetAssetPropertyValueHistoryResponse nextPage(GetAssetPropertyValueHistoryResponse previousPage) {
            if (previousPage == null) {
                return GetAssetPropertyValueHistoryIterable.this.client.getAssetPropertyValueHistory(GetAssetPropertyValueHistoryIterable.this.firstRequest);
            }
            return GetAssetPropertyValueHistoryIterable.this.client.getAssetPropertyValueHistory((GetAssetPropertyValueHistoryRequest)((Object)GetAssetPropertyValueHistoryIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

