/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotsitewise.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.iotsitewise.model.IoTSiteWiseRequest;
import software.amazon.awssdk.services.iotsitewise.model.PropertyNotificationState;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateAssetPropertyRequest
extends IoTSiteWiseRequest
implements ToCopyableBuilder<Builder, UpdateAssetPropertyRequest> {
    private static final SdkField<String> ASSET_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("assetId").getter(UpdateAssetPropertyRequest.getter(UpdateAssetPropertyRequest::assetId)).setter(UpdateAssetPropertyRequest.setter(Builder::assetId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("assetId").build()}).build();
    private static final SdkField<String> PROPERTY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("propertyId").getter(UpdateAssetPropertyRequest.getter(UpdateAssetPropertyRequest::propertyId)).setter(UpdateAssetPropertyRequest.setter(Builder::propertyId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("propertyId").build()}).build();
    private static final SdkField<String> PROPERTY_ALIAS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("propertyAlias").getter(UpdateAssetPropertyRequest.getter(UpdateAssetPropertyRequest::propertyAlias)).setter(UpdateAssetPropertyRequest.setter(Builder::propertyAlias)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("propertyAlias").build()}).build();
    private static final SdkField<String> PROPERTY_NOTIFICATION_STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("propertyNotificationState").getter(UpdateAssetPropertyRequest.getter(UpdateAssetPropertyRequest::propertyNotificationStateAsString)).setter(UpdateAssetPropertyRequest.setter(Builder::propertyNotificationState)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("propertyNotificationState").build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clientToken").getter(UpdateAssetPropertyRequest.getter(UpdateAssetPropertyRequest::clientToken)).setter(UpdateAssetPropertyRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASSET_ID_FIELD, PROPERTY_ID_FIELD, PROPERTY_ALIAS_FIELD, PROPERTY_NOTIFICATION_STATE_FIELD, CLIENT_TOKEN_FIELD));
    private final String assetId;
    private final String propertyId;
    private final String propertyAlias;
    private final String propertyNotificationState;
    private final String clientToken;

    private UpdateAssetPropertyRequest(BuilderImpl builder) {
        super(builder);
        this.assetId = builder.assetId;
        this.propertyId = builder.propertyId;
        this.propertyAlias = builder.propertyAlias;
        this.propertyNotificationState = builder.propertyNotificationState;
        this.clientToken = builder.clientToken;
    }

    public String assetId() {
        return this.assetId;
    }

    public String propertyId() {
        return this.propertyId;
    }

    public String propertyAlias() {
        return this.propertyAlias;
    }

    public PropertyNotificationState propertyNotificationState() {
        return PropertyNotificationState.fromValue(this.propertyNotificationState);
    }

    public String propertyNotificationStateAsString() {
        return this.propertyNotificationState;
    }

    public String clientToken() {
        return this.clientToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.assetId());
        hashCode = 31 * hashCode + Objects.hashCode(this.propertyId());
        hashCode = 31 * hashCode + Objects.hashCode(this.propertyAlias());
        hashCode = 31 * hashCode + Objects.hashCode(this.propertyNotificationStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateAssetPropertyRequest)) {
            return false;
        }
        UpdateAssetPropertyRequest other = (UpdateAssetPropertyRequest)((Object)obj);
        return Objects.equals(this.assetId(), other.assetId()) && Objects.equals(this.propertyId(), other.propertyId()) && Objects.equals(this.propertyAlias(), other.propertyAlias()) && Objects.equals(this.propertyNotificationStateAsString(), other.propertyNotificationStateAsString()) && Objects.equals(this.clientToken(), other.clientToken());
    }

    public String toString() {
        return ToString.builder((String)"UpdateAssetPropertyRequest").add("AssetId", (Object)this.assetId()).add("PropertyId", (Object)this.propertyId()).add("PropertyAlias", (Object)this.propertyAlias()).add("PropertyNotificationState", (Object)this.propertyNotificationStateAsString()).add("ClientToken", (Object)this.clientToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "assetId": {
                return Optional.ofNullable(clazz.cast(this.assetId()));
            }
            case "propertyId": {
                return Optional.ofNullable(clazz.cast(this.propertyId()));
            }
            case "propertyAlias": {
                return Optional.ofNullable(clazz.cast(this.propertyAlias()));
            }
            case "propertyNotificationState": {
                return Optional.ofNullable(clazz.cast(this.propertyNotificationStateAsString()));
            }
            case "clientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateAssetPropertyRequest, T> g) {
        return obj -> g.apply((UpdateAssetPropertyRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IoTSiteWiseRequest.BuilderImpl
    implements Builder {
        private String assetId;
        private String propertyId;
        private String propertyAlias;
        private String propertyNotificationState;
        private String clientToken;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateAssetPropertyRequest model) {
            super(model);
            this.assetId(model.assetId);
            this.propertyId(model.propertyId);
            this.propertyAlias(model.propertyAlias);
            this.propertyNotificationState(model.propertyNotificationState);
            this.clientToken(model.clientToken);
        }

        public final String getAssetId() {
            return this.assetId;
        }

        @Override
        public final Builder assetId(String assetId) {
            this.assetId = assetId;
            return this;
        }

        public final void setAssetId(String assetId) {
            this.assetId = assetId;
        }

        public final String getPropertyId() {
            return this.propertyId;
        }

        @Override
        public final Builder propertyId(String propertyId) {
            this.propertyId = propertyId;
            return this;
        }

        public final void setPropertyId(String propertyId) {
            this.propertyId = propertyId;
        }

        public final String getPropertyAlias() {
            return this.propertyAlias;
        }

        @Override
        public final Builder propertyAlias(String propertyAlias) {
            this.propertyAlias = propertyAlias;
            return this;
        }

        public final void setPropertyAlias(String propertyAlias) {
            this.propertyAlias = propertyAlias;
        }

        public final String getPropertyNotificationState() {
            return this.propertyNotificationState;
        }

        @Override
        public final Builder propertyNotificationState(String propertyNotificationState) {
            this.propertyNotificationState = propertyNotificationState;
            return this;
        }

        @Override
        public final Builder propertyNotificationState(PropertyNotificationState propertyNotificationState) {
            this.propertyNotificationState(propertyNotificationState == null ? null : propertyNotificationState.toString());
            return this;
        }

        public final void setPropertyNotificationState(String propertyNotificationState) {
            this.propertyNotificationState = propertyNotificationState;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateAssetPropertyRequest build() {
            return new UpdateAssetPropertyRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends IoTSiteWiseRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateAssetPropertyRequest> {
        public Builder assetId(String var1);

        public Builder propertyId(String var1);

        public Builder propertyAlias(String var1);

        public Builder propertyNotificationState(String var1);

        public Builder propertyNotificationState(PropertyNotificationState var1);

        public Builder clientToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

