/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotsitewise.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.iotsitewise.model.BatchPutAssetPropertyError;
import software.amazon.awssdk.services.iotsitewise.model.BatchPutAssetPropertyErrorsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BatchPutAssetPropertyErrorEntry
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, BatchPutAssetPropertyErrorEntry> {
    private static final SdkField<String> ENTRY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("entryId").getter(BatchPutAssetPropertyErrorEntry.getter(BatchPutAssetPropertyErrorEntry::entryId)).setter(BatchPutAssetPropertyErrorEntry.setter(Builder::entryId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("entryId").build()}).build();
    private static final SdkField<List<BatchPutAssetPropertyError>> ERRORS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("errors").getter(BatchPutAssetPropertyErrorEntry.getter(BatchPutAssetPropertyErrorEntry::errors)).setter(BatchPutAssetPropertyErrorEntry.setter(Builder::errors)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("errors").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(BatchPutAssetPropertyError::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENTRY_ID_FIELD, ERRORS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String entryId;
    private final List<BatchPutAssetPropertyError> errors;

    private BatchPutAssetPropertyErrorEntry(BuilderImpl builder) {
        this.entryId = builder.entryId;
        this.errors = builder.errors;
    }

    public String entryId() {
        return this.entryId;
    }

    public boolean hasErrors() {
        return this.errors != null && !(this.errors instanceof SdkAutoConstructList);
    }

    public List<BatchPutAssetPropertyError> errors() {
        return this.errors;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.entryId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasErrors() ? this.errors() : null);
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchPutAssetPropertyErrorEntry)) {
            return false;
        }
        BatchPutAssetPropertyErrorEntry other = (BatchPutAssetPropertyErrorEntry)obj;
        return Objects.equals(this.entryId(), other.entryId()) && this.hasErrors() == other.hasErrors() && Objects.equals(this.errors(), other.errors());
    }

    public String toString() {
        return ToString.builder((String)"BatchPutAssetPropertyErrorEntry").add("EntryId", (Object)this.entryId()).add("Errors", this.hasErrors() ? this.errors() : null).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "entryId": {
                return Optional.ofNullable(clazz.cast(this.entryId()));
            }
            case "errors": {
                return Optional.ofNullable(clazz.cast(this.errors()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BatchPutAssetPropertyErrorEntry, T> g) {
        return obj -> g.apply((BatchPutAssetPropertyErrorEntry)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String entryId;
        private List<BatchPutAssetPropertyError> errors = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchPutAssetPropertyErrorEntry model) {
            this.entryId(model.entryId);
            this.errors(model.errors);
        }

        public final String getEntryId() {
            return this.entryId;
        }

        @Override
        public final Builder entryId(String entryId) {
            this.entryId = entryId;
            return this;
        }

        public final void setEntryId(String entryId) {
            this.entryId = entryId;
        }

        public final Collection<BatchPutAssetPropertyError.Builder> getErrors() {
            if (this.errors instanceof SdkAutoConstructList) {
                return null;
            }
            return this.errors != null ? (Collection)this.errors.stream().map(BatchPutAssetPropertyError::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder errors(Collection<BatchPutAssetPropertyError> errors) {
            this.errors = BatchPutAssetPropertyErrorsCopier.copy(errors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errors(BatchPutAssetPropertyError ... errors) {
            this.errors(Arrays.asList(errors));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errors(Consumer<BatchPutAssetPropertyError.Builder> ... errors) {
            this.errors(Stream.of(errors).map(c -> (BatchPutAssetPropertyError)((BatchPutAssetPropertyError.Builder)BatchPutAssetPropertyError.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setErrors(Collection<BatchPutAssetPropertyError.BuilderImpl> errors) {
            this.errors = BatchPutAssetPropertyErrorsCopier.copyFromBuilder(errors);
        }

        public BatchPutAssetPropertyErrorEntry build() {
            return new BatchPutAssetPropertyErrorEntry(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, BatchPutAssetPropertyErrorEntry> {
        public Builder entryId(String var1);

        public Builder errors(Collection<BatchPutAssetPropertyError> var1);

        public Builder errors(BatchPutAssetPropertyError ... var1);

        public Builder errors(Consumer<BatchPutAssetPropertyError.Builder> ... var1);
    }
}

