/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotsitewise.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.iotsitewise.IoTSiteWiseClient;
import software.amazon.awssdk.services.iotsitewise.model.AccessPolicySummary;
import software.amazon.awssdk.services.iotsitewise.model.ListAccessPoliciesRequest;
import software.amazon.awssdk.services.iotsitewise.model.ListAccessPoliciesResponse;

public class ListAccessPoliciesIterable
implements SdkIterable<ListAccessPoliciesResponse> {
    private final IoTSiteWiseClient client;
    private final ListAccessPoliciesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListAccessPoliciesIterable(IoTSiteWiseClient client, ListAccessPoliciesRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListAccessPoliciesResponseFetcher();
    }

    public Iterator<ListAccessPoliciesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<AccessPolicySummary> accessPolicySummaries() {
        Function<ListAccessPoliciesResponse, Iterator> getIterator = response -> {
            if (response != null && response.accessPolicySummaries() != null) {
                return response.accessPolicySummaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListAccessPoliciesResponseFetcher
    implements SyncPageFetcher<ListAccessPoliciesResponse> {
        private ListAccessPoliciesResponseFetcher() {
        }

        public boolean hasNextPage(ListAccessPoliciesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListAccessPoliciesResponse nextPage(ListAccessPoliciesResponse previousPage) {
            if (previousPage == null) {
                return ListAccessPoliciesIterable.this.client.listAccessPolicies(ListAccessPoliciesIterable.this.firstRequest);
            }
            return ListAccessPoliciesIterable.this.client.listAccessPolicies((ListAccessPoliciesRequest)((Object)ListAccessPoliciesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

