/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotsitewise.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.iotsitewise.model.GatewaySummariesCopier;
import software.amazon.awssdk.services.iotsitewise.model.GatewaySummary;
import software.amazon.awssdk.services.iotsitewise.model.IoTSiteWiseResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListGatewaysResponse
extends IoTSiteWiseResponse
implements ToCopyableBuilder<Builder, ListGatewaysResponse> {
    private static final SdkField<List<GatewaySummary>> GATEWAY_SUMMARIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("gatewaySummaries").getter(ListGatewaysResponse.getter(ListGatewaysResponse::gatewaySummaries)).setter(ListGatewaysResponse.setter(Builder::gatewaySummaries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("gatewaySummaries").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(GatewaySummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListGatewaysResponse.getter(ListGatewaysResponse::nextToken)).setter(ListGatewaysResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GATEWAY_SUMMARIES_FIELD, NEXT_TOKEN_FIELD));
    private final List<GatewaySummary> gatewaySummaries;
    private final String nextToken;

    private ListGatewaysResponse(BuilderImpl builder) {
        super(builder);
        this.gatewaySummaries = builder.gatewaySummaries;
        this.nextToken = builder.nextToken;
    }

    public boolean hasGatewaySummaries() {
        return this.gatewaySummaries != null && !(this.gatewaySummaries instanceof SdkAutoConstructList);
    }

    public List<GatewaySummary> gatewaySummaries() {
        return this.gatewaySummaries;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasGatewaySummaries() ? this.gatewaySummaries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListGatewaysResponse)) {
            return false;
        }
        ListGatewaysResponse other = (ListGatewaysResponse)((Object)obj);
        return this.hasGatewaySummaries() == other.hasGatewaySummaries() && Objects.equals(this.gatewaySummaries(), other.gatewaySummaries()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"ListGatewaysResponse").add("GatewaySummaries", this.hasGatewaySummaries() ? this.gatewaySummaries() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "gatewaySummaries": {
                return Optional.ofNullable(clazz.cast(this.gatewaySummaries()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListGatewaysResponse, T> g) {
        return obj -> g.apply((ListGatewaysResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IoTSiteWiseResponse.BuilderImpl
    implements Builder {
        private List<GatewaySummary> gatewaySummaries = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListGatewaysResponse model) {
            super(model);
            this.gatewaySummaries(model.gatewaySummaries);
            this.nextToken(model.nextToken);
        }

        public final Collection<GatewaySummary.Builder> getGatewaySummaries() {
            if (this.gatewaySummaries instanceof SdkAutoConstructList) {
                return null;
            }
            return this.gatewaySummaries != null ? (Collection)this.gatewaySummaries.stream().map(GatewaySummary::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder gatewaySummaries(Collection<GatewaySummary> gatewaySummaries) {
            this.gatewaySummaries = GatewaySummariesCopier.copy(gatewaySummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder gatewaySummaries(GatewaySummary ... gatewaySummaries) {
            this.gatewaySummaries(Arrays.asList(gatewaySummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder gatewaySummaries(Consumer<GatewaySummary.Builder> ... gatewaySummaries) {
            this.gatewaySummaries(Stream.of(gatewaySummaries).map(c -> (GatewaySummary)((GatewaySummary.Builder)GatewaySummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setGatewaySummaries(Collection<GatewaySummary.BuilderImpl> gatewaySummaries) {
            this.gatewaySummaries = GatewaySummariesCopier.copyFromBuilder(gatewaySummaries);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListGatewaysResponse build() {
            return new ListGatewaysResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends IoTSiteWiseResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListGatewaysResponse> {
        public Builder gatewaySummaries(Collection<GatewaySummary> var1);

        public Builder gatewaySummaries(GatewaySummary ... var1);

        public Builder gatewaySummaries(Consumer<GatewaySummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

