/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotsitewise.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.iotsitewise.model.CapabilitySyncStatus;
import software.amazon.awssdk.services.iotsitewise.model.IoTSiteWiseResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateGatewayCapabilityConfigurationResponse
extends IoTSiteWiseResponse
implements ToCopyableBuilder<Builder, UpdateGatewayCapabilityConfigurationResponse> {
    private static final SdkField<String> CAPABILITY_NAMESPACE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(UpdateGatewayCapabilityConfigurationResponse.getter(UpdateGatewayCapabilityConfigurationResponse::capabilityNamespace)).setter(UpdateGatewayCapabilityConfigurationResponse.setter(Builder::capabilityNamespace)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("capabilityNamespace").build()}).build();
    private static final SdkField<String> CAPABILITY_SYNC_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(UpdateGatewayCapabilityConfigurationResponse.getter(UpdateGatewayCapabilityConfigurationResponse::capabilitySyncStatusAsString)).setter(UpdateGatewayCapabilityConfigurationResponse.setter(Builder::capabilitySyncStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("capabilitySyncStatus").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CAPABILITY_NAMESPACE_FIELD, CAPABILITY_SYNC_STATUS_FIELD));
    private final String capabilityNamespace;
    private final String capabilitySyncStatus;

    private UpdateGatewayCapabilityConfigurationResponse(BuilderImpl builder) {
        super(builder);
        this.capabilityNamespace = builder.capabilityNamespace;
        this.capabilitySyncStatus = builder.capabilitySyncStatus;
    }

    public String capabilityNamespace() {
        return this.capabilityNamespace;
    }

    public CapabilitySyncStatus capabilitySyncStatus() {
        return CapabilitySyncStatus.fromValue(this.capabilitySyncStatus);
    }

    public String capabilitySyncStatusAsString() {
        return this.capabilitySyncStatus;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.capabilityNamespace());
        hashCode = 31 * hashCode + Objects.hashCode(this.capabilitySyncStatusAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateGatewayCapabilityConfigurationResponse)) {
            return false;
        }
        UpdateGatewayCapabilityConfigurationResponse other = (UpdateGatewayCapabilityConfigurationResponse)((Object)obj);
        return Objects.equals(this.capabilityNamespace(), other.capabilityNamespace()) && Objects.equals(this.capabilitySyncStatusAsString(), other.capabilitySyncStatusAsString());
    }

    public String toString() {
        return ToString.builder((String)"UpdateGatewayCapabilityConfigurationResponse").add("CapabilityNamespace", (Object)this.capabilityNamespace()).add("CapabilitySyncStatus", (Object)this.capabilitySyncStatusAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "capabilityNamespace": {
                return Optional.ofNullable(clazz.cast(this.capabilityNamespace()));
            }
            case "capabilitySyncStatus": {
                return Optional.ofNullable(clazz.cast(this.capabilitySyncStatusAsString()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateGatewayCapabilityConfigurationResponse, T> g) {
        return obj -> g.apply((UpdateGatewayCapabilityConfigurationResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IoTSiteWiseResponse.BuilderImpl
    implements Builder {
        private String capabilityNamespace;
        private String capabilitySyncStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateGatewayCapabilityConfigurationResponse model) {
            super(model);
            this.capabilityNamespace(model.capabilityNamespace);
            this.capabilitySyncStatus(model.capabilitySyncStatus);
        }

        public final String getCapabilityNamespace() {
            return this.capabilityNamespace;
        }

        @Override
        public final Builder capabilityNamespace(String capabilityNamespace) {
            this.capabilityNamespace = capabilityNamespace;
            return this;
        }

        public final void setCapabilityNamespace(String capabilityNamespace) {
            this.capabilityNamespace = capabilityNamespace;
        }

        public final String getCapabilitySyncStatus() {
            return this.capabilitySyncStatus;
        }

        @Override
        public final Builder capabilitySyncStatus(String capabilitySyncStatus) {
            this.capabilitySyncStatus = capabilitySyncStatus;
            return this;
        }

        @Override
        public final Builder capabilitySyncStatus(CapabilitySyncStatus capabilitySyncStatus) {
            this.capabilitySyncStatus(capabilitySyncStatus == null ? null : capabilitySyncStatus.toString());
            return this;
        }

        public final void setCapabilitySyncStatus(String capabilitySyncStatus) {
            this.capabilitySyncStatus = capabilitySyncStatus;
        }

        @Override
        public UpdateGatewayCapabilityConfigurationResponse build() {
            return new UpdateGatewayCapabilityConfigurationResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends IoTSiteWiseResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateGatewayCapabilityConfigurationResponse> {
        public Builder capabilityNamespace(String var1);

        public Builder capabilitySyncStatus(String var1);

        public Builder capabilitySyncStatus(CapabilitySyncStatus var1);
    }
}

