/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotsitewise.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.iotsitewise.model.IoTSiteWiseRequest;
import software.amazon.awssdk.services.iotsitewise.model.QualitiesCopier;
import software.amazon.awssdk.services.iotsitewise.model.Quality;
import software.amazon.awssdk.services.iotsitewise.model.TimeOrdering;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetAssetPropertyValueHistoryRequest
extends IoTSiteWiseRequest
implements ToCopyableBuilder<Builder, GetAssetPropertyValueHistoryRequest> {
    private static final SdkField<String> ASSET_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(GetAssetPropertyValueHistoryRequest.getter(GetAssetPropertyValueHistoryRequest::assetId)).setter(GetAssetPropertyValueHistoryRequest.setter(Builder::assetId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("assetId").build()}).build();
    private static final SdkField<String> PROPERTY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(GetAssetPropertyValueHistoryRequest.getter(GetAssetPropertyValueHistoryRequest::propertyId)).setter(GetAssetPropertyValueHistoryRequest.setter(Builder::propertyId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("propertyId").build()}).build();
    private static final SdkField<String> PROPERTY_ALIAS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(GetAssetPropertyValueHistoryRequest.getter(GetAssetPropertyValueHistoryRequest::propertyAlias)).setter(GetAssetPropertyValueHistoryRequest.setter(Builder::propertyAlias)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("propertyAlias").build()}).build();
    private static final SdkField<Instant> START_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(GetAssetPropertyValueHistoryRequest.getter(GetAssetPropertyValueHistoryRequest::startDate)).setter(GetAssetPropertyValueHistoryRequest.setter(Builder::startDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("startDate").build()}).build();
    private static final SdkField<Instant> END_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(GetAssetPropertyValueHistoryRequest.getter(GetAssetPropertyValueHistoryRequest::endDate)).setter(GetAssetPropertyValueHistoryRequest.setter(Builder::endDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("endDate").build()}).build();
    private static final SdkField<List<String>> QUALITIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(GetAssetPropertyValueHistoryRequest.getter(GetAssetPropertyValueHistoryRequest::qualitiesAsStrings)).setter(GetAssetPropertyValueHistoryRequest.setter(Builder::qualitiesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("qualities").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> TIME_ORDERING_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(GetAssetPropertyValueHistoryRequest.getter(GetAssetPropertyValueHistoryRequest::timeOrderingAsString)).setter(GetAssetPropertyValueHistoryRequest.setter(Builder::timeOrdering)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("timeOrdering").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(GetAssetPropertyValueHistoryRequest.getter(GetAssetPropertyValueHistoryRequest::nextToken)).setter(GetAssetPropertyValueHistoryRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("nextToken").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(GetAssetPropertyValueHistoryRequest.getter(GetAssetPropertyValueHistoryRequest::maxResults)).setter(GetAssetPropertyValueHistoryRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("maxResults").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASSET_ID_FIELD, PROPERTY_ID_FIELD, PROPERTY_ALIAS_FIELD, START_DATE_FIELD, END_DATE_FIELD, QUALITIES_FIELD, TIME_ORDERING_FIELD, NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD));
    private final String assetId;
    private final String propertyId;
    private final String propertyAlias;
    private final Instant startDate;
    private final Instant endDate;
    private final List<String> qualities;
    private final String timeOrdering;
    private final String nextToken;
    private final Integer maxResults;

    private GetAssetPropertyValueHistoryRequest(BuilderImpl builder) {
        super(builder);
        this.assetId = builder.assetId;
        this.propertyId = builder.propertyId;
        this.propertyAlias = builder.propertyAlias;
        this.startDate = builder.startDate;
        this.endDate = builder.endDate;
        this.qualities = builder.qualities;
        this.timeOrdering = builder.timeOrdering;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
    }

    public String assetId() {
        return this.assetId;
    }

    public String propertyId() {
        return this.propertyId;
    }

    public String propertyAlias() {
        return this.propertyAlias;
    }

    public Instant startDate() {
        return this.startDate;
    }

    public Instant endDate() {
        return this.endDate;
    }

    public List<Quality> qualities() {
        return QualitiesCopier.copyStringToEnum(this.qualities);
    }

    public boolean hasQualities() {
        return this.qualities != null && !(this.qualities instanceof SdkAutoConstructList);
    }

    public List<String> qualitiesAsStrings() {
        return this.qualities;
    }

    public TimeOrdering timeOrdering() {
        return TimeOrdering.fromValue(this.timeOrdering);
    }

    public String timeOrderingAsString() {
        return this.timeOrdering;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Integer maxResults() {
        return this.maxResults;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.assetId());
        hashCode = 31 * hashCode + Objects.hashCode(this.propertyId());
        hashCode = 31 * hashCode + Objects.hashCode(this.propertyAlias());
        hashCode = 31 * hashCode + Objects.hashCode(this.startDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.endDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.qualitiesAsStrings());
        hashCode = 31 * hashCode + Objects.hashCode(this.timeOrderingAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetAssetPropertyValueHistoryRequest)) {
            return false;
        }
        GetAssetPropertyValueHistoryRequest other = (GetAssetPropertyValueHistoryRequest)((Object)obj);
        return Objects.equals(this.assetId(), other.assetId()) && Objects.equals(this.propertyId(), other.propertyId()) && Objects.equals(this.propertyAlias(), other.propertyAlias()) && Objects.equals(this.startDate(), other.startDate()) && Objects.equals(this.endDate(), other.endDate()) && Objects.equals(this.qualitiesAsStrings(), other.qualitiesAsStrings()) && Objects.equals(this.timeOrderingAsString(), other.timeOrderingAsString()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.maxResults(), other.maxResults());
    }

    public String toString() {
        return ToString.builder((String)"GetAssetPropertyValueHistoryRequest").add("AssetId", (Object)this.assetId()).add("PropertyId", (Object)this.propertyId()).add("PropertyAlias", (Object)this.propertyAlias()).add("StartDate", (Object)this.startDate()).add("EndDate", (Object)this.endDate()).add("Qualities", this.qualitiesAsStrings()).add("TimeOrdering", (Object)this.timeOrderingAsString()).add("NextToken", (Object)this.nextToken()).add("MaxResults", (Object)this.maxResults()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "assetId": {
                return Optional.ofNullable(clazz.cast(this.assetId()));
            }
            case "propertyId": {
                return Optional.ofNullable(clazz.cast(this.propertyId()));
            }
            case "propertyAlias": {
                return Optional.ofNullable(clazz.cast(this.propertyAlias()));
            }
            case "startDate": {
                return Optional.ofNullable(clazz.cast(this.startDate()));
            }
            case "endDate": {
                return Optional.ofNullable(clazz.cast(this.endDate()));
            }
            case "qualities": {
                return Optional.ofNullable(clazz.cast(this.qualitiesAsStrings()));
            }
            case "timeOrdering": {
                return Optional.ofNullable(clazz.cast(this.timeOrderingAsString()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "maxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetAssetPropertyValueHistoryRequest, T> g) {
        return obj -> g.apply((GetAssetPropertyValueHistoryRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IoTSiteWiseRequest.BuilderImpl
    implements Builder {
        private String assetId;
        private String propertyId;
        private String propertyAlias;
        private Instant startDate;
        private Instant endDate;
        private List<String> qualities = DefaultSdkAutoConstructList.getInstance();
        private String timeOrdering;
        private String nextToken;
        private Integer maxResults;

        private BuilderImpl() {
        }

        private BuilderImpl(GetAssetPropertyValueHistoryRequest model) {
            super(model);
            this.assetId(model.assetId);
            this.propertyId(model.propertyId);
            this.propertyAlias(model.propertyAlias);
            this.startDate(model.startDate);
            this.endDate(model.endDate);
            this.qualitiesWithStrings(model.qualities);
            this.timeOrdering(model.timeOrdering);
            this.nextToken(model.nextToken);
            this.maxResults(model.maxResults);
        }

        public final String getAssetId() {
            return this.assetId;
        }

        @Override
        public final Builder assetId(String assetId) {
            this.assetId = assetId;
            return this;
        }

        public final void setAssetId(String assetId) {
            this.assetId = assetId;
        }

        public final String getPropertyId() {
            return this.propertyId;
        }

        @Override
        public final Builder propertyId(String propertyId) {
            this.propertyId = propertyId;
            return this;
        }

        public final void setPropertyId(String propertyId) {
            this.propertyId = propertyId;
        }

        public final String getPropertyAlias() {
            return this.propertyAlias;
        }

        @Override
        public final Builder propertyAlias(String propertyAlias) {
            this.propertyAlias = propertyAlias;
            return this;
        }

        public final void setPropertyAlias(String propertyAlias) {
            this.propertyAlias = propertyAlias;
        }

        public final Instant getStartDate() {
            return this.startDate;
        }

        @Override
        public final Builder startDate(Instant startDate) {
            this.startDate = startDate;
            return this;
        }

        public final void setStartDate(Instant startDate) {
            this.startDate = startDate;
        }

        public final Instant getEndDate() {
            return this.endDate;
        }

        @Override
        public final Builder endDate(Instant endDate) {
            this.endDate = endDate;
            return this;
        }

        public final void setEndDate(Instant endDate) {
            this.endDate = endDate;
        }

        public final Collection<String> getQualities() {
            return this.qualities;
        }

        @Override
        public final Builder qualitiesWithStrings(Collection<String> qualities) {
            this.qualities = QualitiesCopier.copy(qualities);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder qualitiesWithStrings(String ... qualities) {
            this.qualitiesWithStrings(Arrays.asList(qualities));
            return this;
        }

        @Override
        public final Builder qualities(Collection<Quality> qualities) {
            this.qualities = QualitiesCopier.copyEnumToString(qualities);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder qualities(Quality ... qualities) {
            this.qualities(Arrays.asList(qualities));
            return this;
        }

        public final void setQualities(Collection<String> qualities) {
            this.qualities = QualitiesCopier.copy(qualities);
        }

        public final String getTimeOrdering() {
            return this.timeOrdering;
        }

        @Override
        public final Builder timeOrdering(String timeOrdering) {
            this.timeOrdering = timeOrdering;
            return this;
        }

        @Override
        public final Builder timeOrdering(TimeOrdering timeOrdering) {
            this.timeOrdering(timeOrdering == null ? null : timeOrdering.toString());
            return this;
        }

        public final void setTimeOrdering(String timeOrdering) {
            this.timeOrdering = timeOrdering;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetAssetPropertyValueHistoryRequest build() {
            return new GetAssetPropertyValueHistoryRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends IoTSiteWiseRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetAssetPropertyValueHistoryRequest> {
        public Builder assetId(String var1);

        public Builder propertyId(String var1);

        public Builder propertyAlias(String var1);

        public Builder startDate(Instant var1);

        public Builder endDate(Instant var1);

        public Builder qualitiesWithStrings(Collection<String> var1);

        public Builder qualitiesWithStrings(String ... var1);

        public Builder qualities(Collection<Quality> var1);

        public Builder qualities(Quality ... var1);

        public Builder timeOrdering(String var1);

        public Builder timeOrdering(TimeOrdering var1);

        public Builder nextToken(String var1);

        public Builder maxResults(Integer var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

