/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotsitewise.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Aggregates
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Aggregates> {
    private static final SdkField<Double> AVERAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).getter(Aggregates.getter(Aggregates::average)).setter(Aggregates.setter(Builder::average)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("average").build()}).build();
    private static final SdkField<Double> COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).getter(Aggregates.getter(Aggregates::count)).setter(Aggregates.setter(Builder::count)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("count").build()}).build();
    private static final SdkField<Double> MAXIMUM_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).getter(Aggregates.getter(Aggregates::maximum)).setter(Aggregates.setter(Builder::maximum)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maximum").build()}).build();
    private static final SdkField<Double> MINIMUM_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).getter(Aggregates.getter(Aggregates::minimum)).setter(Aggregates.setter(Builder::minimum)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("minimum").build()}).build();
    private static final SdkField<Double> SUM_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).getter(Aggregates.getter(Aggregates::sum)).setter(Aggregates.setter(Builder::sum)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sum").build()}).build();
    private static final SdkField<Double> STANDARD_DEVIATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).getter(Aggregates.getter(Aggregates::standardDeviation)).setter(Aggregates.setter(Builder::standardDeviation)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("standardDeviation").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AVERAGE_FIELD, COUNT_FIELD, MAXIMUM_FIELD, MINIMUM_FIELD, SUM_FIELD, STANDARD_DEVIATION_FIELD));
    private static final long serialVersionUID = 1L;
    private final Double average;
    private final Double count;
    private final Double maximum;
    private final Double minimum;
    private final Double sum;
    private final Double standardDeviation;

    private Aggregates(BuilderImpl builder) {
        this.average = builder.average;
        this.count = builder.count;
        this.maximum = builder.maximum;
        this.minimum = builder.minimum;
        this.sum = builder.sum;
        this.standardDeviation = builder.standardDeviation;
    }

    public Double average() {
        return this.average;
    }

    public Double count() {
        return this.count;
    }

    public Double maximum() {
        return this.maximum;
    }

    public Double minimum() {
        return this.minimum;
    }

    public Double sum() {
        return this.sum;
    }

    public Double standardDeviation() {
        return this.standardDeviation;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.average());
        hashCode = 31 * hashCode + Objects.hashCode(this.count());
        hashCode = 31 * hashCode + Objects.hashCode(this.maximum());
        hashCode = 31 * hashCode + Objects.hashCode(this.minimum());
        hashCode = 31 * hashCode + Objects.hashCode(this.sum());
        hashCode = 31 * hashCode + Objects.hashCode(this.standardDeviation());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Aggregates)) {
            return false;
        }
        Aggregates other = (Aggregates)obj;
        return Objects.equals(this.average(), other.average()) && Objects.equals(this.count(), other.count()) && Objects.equals(this.maximum(), other.maximum()) && Objects.equals(this.minimum(), other.minimum()) && Objects.equals(this.sum(), other.sum()) && Objects.equals(this.standardDeviation(), other.standardDeviation());
    }

    public String toString() {
        return ToString.builder((String)"Aggregates").add("Average", (Object)this.average()).add("Count", (Object)this.count()).add("Maximum", (Object)this.maximum()).add("Minimum", (Object)this.minimum()).add("Sum", (Object)this.sum()).add("StandardDeviation", (Object)this.standardDeviation()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "average": {
                return Optional.ofNullable(clazz.cast(this.average()));
            }
            case "count": {
                return Optional.ofNullable(clazz.cast(this.count()));
            }
            case "maximum": {
                return Optional.ofNullable(clazz.cast(this.maximum()));
            }
            case "minimum": {
                return Optional.ofNullable(clazz.cast(this.minimum()));
            }
            case "sum": {
                return Optional.ofNullable(clazz.cast(this.sum()));
            }
            case "standardDeviation": {
                return Optional.ofNullable(clazz.cast(this.standardDeviation()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Aggregates, T> g) {
        return obj -> g.apply((Aggregates)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Double average;
        private Double count;
        private Double maximum;
        private Double minimum;
        private Double sum;
        private Double standardDeviation;

        private BuilderImpl() {
        }

        private BuilderImpl(Aggregates model) {
            this.average(model.average);
            this.count(model.count);
            this.maximum(model.maximum);
            this.minimum(model.minimum);
            this.sum(model.sum);
            this.standardDeviation(model.standardDeviation);
        }

        public final Double getAverage() {
            return this.average;
        }

        @Override
        public final Builder average(Double average) {
            this.average = average;
            return this;
        }

        public final void setAverage(Double average) {
            this.average = average;
        }

        public final Double getCount() {
            return this.count;
        }

        @Override
        public final Builder count(Double count) {
            this.count = count;
            return this;
        }

        public final void setCount(Double count) {
            this.count = count;
        }

        public final Double getMaximum() {
            return this.maximum;
        }

        @Override
        public final Builder maximum(Double maximum) {
            this.maximum = maximum;
            return this;
        }

        public final void setMaximum(Double maximum) {
            this.maximum = maximum;
        }

        public final Double getMinimum() {
            return this.minimum;
        }

        @Override
        public final Builder minimum(Double minimum) {
            this.minimum = minimum;
            return this;
        }

        public final void setMinimum(Double minimum) {
            this.minimum = minimum;
        }

        public final Double getSum() {
            return this.sum;
        }

        @Override
        public final Builder sum(Double sum) {
            this.sum = sum;
            return this;
        }

        public final void setSum(Double sum) {
            this.sum = sum;
        }

        public final Double getStandardDeviation() {
            return this.standardDeviation;
        }

        @Override
        public final Builder standardDeviation(Double standardDeviation) {
            this.standardDeviation = standardDeviation;
            return this;
        }

        public final void setStandardDeviation(Double standardDeviation) {
            this.standardDeviation = standardDeviation;
        }

        public Aggregates build() {
            return new Aggregates(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Aggregates> {
        public Builder average(Double var1);

        public Builder count(Double var1);

        public Builder maximum(Double var1);

        public Builder minimum(Double var1);

        public Builder sum(Double var1);

        public Builder standardDeviation(Double var1);
    }
}

