/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotsitewise.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum AggregateType {
    AVERAGE("AVERAGE"),
    COUNT("COUNT"),
    MAXIMUM("MAXIMUM"),
    MINIMUM("MINIMUM"),
    SUM("SUM"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private AggregateType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static AggregateType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(AggregateType.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<AggregateType> knownValues() {
        return Stream.of(AggregateType.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

