/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotsitewise.model;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.adapter.StandardMemberCopier;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.iotsitewise.model.ImageFileType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ImageFile
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ImageFile> {
    private static final SdkField<SdkBytes> ENCODED_STRING_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_BYTES).getter(ImageFile.getter(ImageFile::encodedString)).setter(ImageFile.setter(Builder::encodedString)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("encodedString").build()}).build();
    private static final SdkField<String> FILE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ImageFile.getter(ImageFile::fileTypeAsString)).setter(ImageFile.setter(Builder::fileType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fileType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENCODED_STRING_FIELD, FILE_TYPE_FIELD));
    private static final long serialVersionUID = 1L;
    private final SdkBytes encodedString;
    private final String fileType;

    private ImageFile(BuilderImpl builder) {
        this.encodedString = builder.encodedString;
        this.fileType = builder.fileType;
    }

    public SdkBytes encodedString() {
        return this.encodedString;
    }

    public ImageFileType fileType() {
        return ImageFileType.fromValue(this.fileType);
    }

    public String fileTypeAsString() {
        return this.fileType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.encodedString());
        hashCode = 31 * hashCode + Objects.hashCode(this.fileTypeAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ImageFile)) {
            return false;
        }
        ImageFile other = (ImageFile)obj;
        return Objects.equals(this.encodedString(), other.encodedString()) && Objects.equals(this.fileTypeAsString(), other.fileTypeAsString());
    }

    public String toString() {
        return ToString.builder((String)"ImageFile").add("EncodedString", (Object)this.encodedString()).add("FileType", (Object)this.fileTypeAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "encodedString": {
                return Optional.ofNullable(clazz.cast(this.encodedString()));
            }
            case "fileType": {
                return Optional.ofNullable(clazz.cast(this.fileTypeAsString()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ImageFile, T> g) {
        return obj -> g.apply((ImageFile)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private SdkBytes encodedString;
        private String fileType;

        private BuilderImpl() {
        }

        private BuilderImpl(ImageFile model) {
            this.encodedString(model.encodedString);
            this.fileType(model.fileType);
        }

        public final ByteBuffer getEncodedString() {
            return this.encodedString == null ? null : this.encodedString.asByteBuffer();
        }

        @Override
        public final Builder encodedString(SdkBytes encodedString) {
            this.encodedString = StandardMemberCopier.copy((SdkBytes)encodedString);
            return this;
        }

        public final void setEncodedString(ByteBuffer encodedString) {
            this.encodedString(encodedString == null ? null : SdkBytes.fromByteBuffer((ByteBuffer)encodedString));
        }

        public final String getFileType() {
            return this.fileType;
        }

        @Override
        public final Builder fileType(String fileType) {
            this.fileType = fileType;
            return this;
        }

        @Override
        public final Builder fileType(ImageFileType fileType) {
            this.fileType(fileType == null ? null : fileType.toString());
            return this;
        }

        public final void setFileType(String fileType) {
            this.fileType = fileType;
        }

        public ImageFile build() {
            return new ImageFile(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ImageFile> {
        public Builder encodedString(SdkBytes var1);

        public Builder fileType(String var1);

        public Builder fileType(ImageFileType var1);
    }
}

