/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotsecuretunneling.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.iotsecuretunneling.model.ConnectionState;
import software.amazon.awssdk.services.iotsecuretunneling.model.DestinationConfig;
import software.amazon.awssdk.services.iotsecuretunneling.model.Tag;
import software.amazon.awssdk.services.iotsecuretunneling.model.TagListCopier;
import software.amazon.awssdk.services.iotsecuretunneling.model.TimeoutConfig;
import software.amazon.awssdk.services.iotsecuretunneling.model.TunnelStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Tunnel
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Tunnel> {
    private static final SdkField<String> TUNNEL_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Tunnel.getter(Tunnel::tunnelId)).setter(Tunnel.setter(Builder::tunnelId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tunnelId").build()}).build();
    private static final SdkField<String> TUNNEL_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Tunnel.getter(Tunnel::tunnelArn)).setter(Tunnel.setter(Builder::tunnelArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tunnelArn").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Tunnel.getter(Tunnel::statusAsString)).setter(Tunnel.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<ConnectionState> SOURCE_CONNECTION_STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(Tunnel.getter(Tunnel::sourceConnectionState)).setter(Tunnel.setter(Builder::sourceConnectionState)).constructor(ConnectionState::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceConnectionState").build()}).build();
    private static final SdkField<ConnectionState> DESTINATION_CONNECTION_STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(Tunnel.getter(Tunnel::destinationConnectionState)).setter(Tunnel.setter(Builder::destinationConnectionState)).constructor(ConnectionState::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("destinationConnectionState").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Tunnel.getter(Tunnel::description)).setter(Tunnel.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<DestinationConfig> DESTINATION_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(Tunnel.getter(Tunnel::destinationConfig)).setter(Tunnel.setter(Builder::destinationConfig)).constructor(DestinationConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("destinationConfig").build()}).build();
    private static final SdkField<TimeoutConfig> TIMEOUT_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(Tunnel.getter(Tunnel::timeoutConfig)).setter(Tunnel.setter(Builder::timeoutConfig)).constructor(TimeoutConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timeoutConfig").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(Tunnel.getter(Tunnel::tags)).setter(Tunnel.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(Tunnel.getter(Tunnel::createdAt)).setter(Tunnel.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build()}).build();
    private static final SdkField<Instant> LAST_UPDATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(Tunnel.getter(Tunnel::lastUpdatedAt)).setter(Tunnel.setter(Builder::lastUpdatedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdatedAt").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TUNNEL_ID_FIELD, TUNNEL_ARN_FIELD, STATUS_FIELD, SOURCE_CONNECTION_STATE_FIELD, DESTINATION_CONNECTION_STATE_FIELD, DESCRIPTION_FIELD, DESTINATION_CONFIG_FIELD, TIMEOUT_CONFIG_FIELD, TAGS_FIELD, CREATED_AT_FIELD, LAST_UPDATED_AT_FIELD));
    private static final long serialVersionUID = 1L;
    private final String tunnelId;
    private final String tunnelArn;
    private final String status;
    private final ConnectionState sourceConnectionState;
    private final ConnectionState destinationConnectionState;
    private final String description;
    private final DestinationConfig destinationConfig;
    private final TimeoutConfig timeoutConfig;
    private final List<Tag> tags;
    private final Instant createdAt;
    private final Instant lastUpdatedAt;

    private Tunnel(BuilderImpl builder) {
        this.tunnelId = builder.tunnelId;
        this.tunnelArn = builder.tunnelArn;
        this.status = builder.status;
        this.sourceConnectionState = builder.sourceConnectionState;
        this.destinationConnectionState = builder.destinationConnectionState;
        this.description = builder.description;
        this.destinationConfig = builder.destinationConfig;
        this.timeoutConfig = builder.timeoutConfig;
        this.tags = builder.tags;
        this.createdAt = builder.createdAt;
        this.lastUpdatedAt = builder.lastUpdatedAt;
    }

    public String tunnelId() {
        return this.tunnelId;
    }

    public String tunnelArn() {
        return this.tunnelArn;
    }

    public TunnelStatus status() {
        return TunnelStatus.fromValue(this.status);
    }

    public String statusAsString() {
        return this.status;
    }

    public ConnectionState sourceConnectionState() {
        return this.sourceConnectionState;
    }

    public ConnectionState destinationConnectionState() {
        return this.destinationConnectionState;
    }

    public String description() {
        return this.description;
    }

    public DestinationConfig destinationConfig() {
        return this.destinationConfig;
    }

    public TimeoutConfig timeoutConfig() {
        return this.timeoutConfig;
    }

    public boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public List<Tag> tags() {
        return this.tags;
    }

    public Instant createdAt() {
        return this.createdAt;
    }

    public Instant lastUpdatedAt() {
        return this.lastUpdatedAt;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.tunnelId());
        hashCode = 31 * hashCode + Objects.hashCode(this.tunnelArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceConnectionState());
        hashCode = 31 * hashCode + Objects.hashCode(this.destinationConnectionState());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.destinationConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.timeoutConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.tags());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdatedAt());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Tunnel)) {
            return false;
        }
        Tunnel other = (Tunnel)obj;
        return Objects.equals(this.tunnelId(), other.tunnelId()) && Objects.equals(this.tunnelArn(), other.tunnelArn()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.sourceConnectionState(), other.sourceConnectionState()) && Objects.equals(this.destinationConnectionState(), other.destinationConnectionState()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.destinationConfig(), other.destinationConfig()) && Objects.equals(this.timeoutConfig(), other.timeoutConfig()) && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.lastUpdatedAt(), other.lastUpdatedAt());
    }

    public String toString() {
        return ToString.builder((String)"Tunnel").add("TunnelId", (Object)this.tunnelId()).add("TunnelArn", (Object)this.tunnelArn()).add("Status", (Object)this.statusAsString()).add("SourceConnectionState", (Object)this.sourceConnectionState()).add("DestinationConnectionState", (Object)this.destinationConnectionState()).add("Description", (Object)this.description()).add("DestinationConfig", (Object)this.destinationConfig()).add("TimeoutConfig", (Object)this.timeoutConfig()).add("Tags", this.tags()).add("CreatedAt", (Object)this.createdAt()).add("LastUpdatedAt", (Object)this.lastUpdatedAt()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "tunnelId": {
                return Optional.ofNullable(clazz.cast(this.tunnelId()));
            }
            case "tunnelArn": {
                return Optional.ofNullable(clazz.cast(this.tunnelArn()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "sourceConnectionState": {
                return Optional.ofNullable(clazz.cast(this.sourceConnectionState()));
            }
            case "destinationConnectionState": {
                return Optional.ofNullable(clazz.cast(this.destinationConnectionState()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "destinationConfig": {
                return Optional.ofNullable(clazz.cast(this.destinationConfig()));
            }
            case "timeoutConfig": {
                return Optional.ofNullable(clazz.cast(this.timeoutConfig()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "createdAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "lastUpdatedAt": {
                return Optional.ofNullable(clazz.cast(this.lastUpdatedAt()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Tunnel, T> g) {
        return obj -> g.apply((Tunnel)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String tunnelId;
        private String tunnelArn;
        private String status;
        private ConnectionState sourceConnectionState;
        private ConnectionState destinationConnectionState;
        private String description;
        private DestinationConfig destinationConfig;
        private TimeoutConfig timeoutConfig;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();
        private Instant createdAt;
        private Instant lastUpdatedAt;

        private BuilderImpl() {
        }

        private BuilderImpl(Tunnel model) {
            this.tunnelId(model.tunnelId);
            this.tunnelArn(model.tunnelArn);
            this.status(model.status);
            this.sourceConnectionState(model.sourceConnectionState);
            this.destinationConnectionState(model.destinationConnectionState);
            this.description(model.description);
            this.destinationConfig(model.destinationConfig);
            this.timeoutConfig(model.timeoutConfig);
            this.tags(model.tags);
            this.createdAt(model.createdAt);
            this.lastUpdatedAt(model.lastUpdatedAt);
        }

        public final String getTunnelId() {
            return this.tunnelId;
        }

        @Override
        public final Builder tunnelId(String tunnelId) {
            this.tunnelId = tunnelId;
            return this;
        }

        public final void setTunnelId(String tunnelId) {
            this.tunnelId = tunnelId;
        }

        public final String getTunnelArn() {
            return this.tunnelArn;
        }

        @Override
        public final Builder tunnelArn(String tunnelArn) {
            this.tunnelArn = tunnelArn;
            return this;
        }

        public final void setTunnelArn(String tunnelArn) {
            this.tunnelArn = tunnelArn;
        }

        public final String getStatusAsString() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(TunnelStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final ConnectionState.Builder getSourceConnectionState() {
            return this.sourceConnectionState != null ? this.sourceConnectionState.toBuilder() : null;
        }

        @Override
        public final Builder sourceConnectionState(ConnectionState sourceConnectionState) {
            this.sourceConnectionState = sourceConnectionState;
            return this;
        }

        public final void setSourceConnectionState(ConnectionState.BuilderImpl sourceConnectionState) {
            this.sourceConnectionState = sourceConnectionState != null ? sourceConnectionState.build() : null;
        }

        public final ConnectionState.Builder getDestinationConnectionState() {
            return this.destinationConnectionState != null ? this.destinationConnectionState.toBuilder() : null;
        }

        @Override
        public final Builder destinationConnectionState(ConnectionState destinationConnectionState) {
            this.destinationConnectionState = destinationConnectionState;
            return this;
        }

        public final void setDestinationConnectionState(ConnectionState.BuilderImpl destinationConnectionState) {
            this.destinationConnectionState = destinationConnectionState != null ? destinationConnectionState.build() : null;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final DestinationConfig.Builder getDestinationConfig() {
            return this.destinationConfig != null ? this.destinationConfig.toBuilder() : null;
        }

        @Override
        public final Builder destinationConfig(DestinationConfig destinationConfig) {
            this.destinationConfig = destinationConfig;
            return this;
        }

        public final void setDestinationConfig(DestinationConfig.BuilderImpl destinationConfig) {
            this.destinationConfig = destinationConfig != null ? destinationConfig.build() : null;
        }

        public final TimeoutConfig.Builder getTimeoutConfig() {
            return this.timeoutConfig != null ? this.timeoutConfig.toBuilder() : null;
        }

        @Override
        public final Builder timeoutConfig(TimeoutConfig timeoutConfig) {
            this.timeoutConfig = timeoutConfig;
            return this;
        }

        public final void setTimeoutConfig(TimeoutConfig.BuilderImpl timeoutConfig) {
            this.timeoutConfig = timeoutConfig != null ? timeoutConfig.build() : null;
        }

        public final Collection<Tag.Builder> getTags() {
            return this.tags != null ? (Collection)this.tags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        public final Instant getLastUpdatedAt() {
            return this.lastUpdatedAt;
        }

        @Override
        public final Builder lastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
            return this;
        }

        public final void setLastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
        }

        public Tunnel build() {
            return new Tunnel(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Tunnel> {
        public Builder tunnelId(String var1);

        public Builder tunnelArn(String var1);

        public Builder status(String var1);

        public Builder status(TunnelStatus var1);

        public Builder sourceConnectionState(ConnectionState var1);

        default public Builder sourceConnectionState(Consumer<ConnectionState.Builder> sourceConnectionState) {
            return this.sourceConnectionState((ConnectionState)((ConnectionState.Builder)ConnectionState.builder().applyMutation(sourceConnectionState)).build());
        }

        public Builder destinationConnectionState(ConnectionState var1);

        default public Builder destinationConnectionState(Consumer<ConnectionState.Builder> destinationConnectionState) {
            return this.destinationConnectionState((ConnectionState)((ConnectionState.Builder)ConnectionState.builder().applyMutation(destinationConnectionState)).build());
        }

        public Builder description(String var1);

        public Builder destinationConfig(DestinationConfig var1);

        default public Builder destinationConfig(Consumer<DestinationConfig.Builder> destinationConfig) {
            return this.destinationConfig((DestinationConfig)((DestinationConfig.Builder)DestinationConfig.builder().applyMutation(destinationConfig)).build());
        }

        public Builder timeoutConfig(TimeoutConfig var1);

        default public Builder timeoutConfig(Consumer<TimeoutConfig.Builder> timeoutConfig) {
            return this.timeoutConfig((TimeoutConfig)((TimeoutConfig.Builder)TimeoutConfig.builder().applyMutation(timeoutConfig)).build());
        }

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder createdAt(Instant var1);

        public Builder lastUpdatedAt(Instant var1);
    }
}

