/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotroborunner.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.iotroborunner.IotRoboRunnerAsyncClient;
import software.amazon.awssdk.services.iotroborunner.internal.UserAgentUtils;
import software.amazon.awssdk.services.iotroborunner.model.ListWorkerFleetsRequest;
import software.amazon.awssdk.services.iotroborunner.model.ListWorkerFleetsResponse;
import software.amazon.awssdk.services.iotroborunner.model.WorkerFleet;

public class ListWorkerFleetsPublisher
implements SdkPublisher<ListWorkerFleetsResponse> {
    private final IotRoboRunnerAsyncClient client;
    private final ListWorkerFleetsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListWorkerFleetsPublisher(IotRoboRunnerAsyncClient client, ListWorkerFleetsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListWorkerFleetsPublisher(IotRoboRunnerAsyncClient client, ListWorkerFleetsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListWorkerFleetsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListWorkerFleetsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<WorkerFleet> workerFleets() {
        Function<ListWorkerFleetsResponse, Iterator> getIterator = response -> {
            if (response != null && response.workerFleets() != null) {
                return response.workerFleets().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListWorkerFleetsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListWorkerFleetsResponseFetcher
    implements AsyncPageFetcher<ListWorkerFleetsResponse> {
        private ListWorkerFleetsResponseFetcher() {
        }

        public boolean hasNextPage(ListWorkerFleetsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListWorkerFleetsResponse> nextPage(ListWorkerFleetsResponse previousPage) {
            if (previousPage == null) {
                return ListWorkerFleetsPublisher.this.client.listWorkerFleets(ListWorkerFleetsPublisher.this.firstRequest);
            }
            return ListWorkerFleetsPublisher.this.client.listWorkerFleets((ListWorkerFleetsRequest)((Object)ListWorkerFleetsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

