/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotroborunner.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.iotroborunner.model.IotRoboRunnerRequest;
import software.amazon.awssdk.services.iotroborunner.model.Orientation;
import software.amazon.awssdk.services.iotroborunner.model.PositionCoordinates;
import software.amazon.awssdk.services.iotroborunner.model.VendorProperties;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateWorkerRequest
extends IotRoboRunnerRequest
implements ToCopyableBuilder<Builder, CreateWorkerRequest> {
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clientToken").getter(CreateWorkerRequest.getter(CreateWorkerRequest::clientToken)).setter(CreateWorkerRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(CreateWorkerRequest.getter(CreateWorkerRequest::name)).setter(CreateWorkerRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> FLEET_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("fleet").getter(CreateWorkerRequest.getter(CreateWorkerRequest::fleet)).setter(CreateWorkerRequest.setter(Builder::fleet)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fleet").build()}).build();
    private static final SdkField<String> ADDITIONAL_TRANSIENT_PROPERTIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("additionalTransientProperties").getter(CreateWorkerRequest.getter(CreateWorkerRequest::additionalTransientProperties)).setter(CreateWorkerRequest.setter(Builder::additionalTransientProperties)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("additionalTransientProperties").build()}).build();
    private static final SdkField<String> ADDITIONAL_FIXED_PROPERTIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("additionalFixedProperties").getter(CreateWorkerRequest.getter(CreateWorkerRequest::additionalFixedProperties)).setter(CreateWorkerRequest.setter(Builder::additionalFixedProperties)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("additionalFixedProperties").build()}).build();
    private static final SdkField<VendorProperties> VENDOR_PROPERTIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("vendorProperties").getter(CreateWorkerRequest.getter(CreateWorkerRequest::vendorProperties)).setter(CreateWorkerRequest.setter(Builder::vendorProperties)).constructor(VendorProperties::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vendorProperties").build()}).build();
    private static final SdkField<PositionCoordinates> POSITION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("position").getter(CreateWorkerRequest.getter(CreateWorkerRequest::position)).setter(CreateWorkerRequest.setter(Builder::position)).constructor(PositionCoordinates::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("position").build()}).build();
    private static final SdkField<Orientation> ORIENTATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("orientation").getter(CreateWorkerRequest.getter(CreateWorkerRequest::orientation)).setter(CreateWorkerRequest.setter(Builder::orientation)).constructor(Orientation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("orientation").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_TOKEN_FIELD, NAME_FIELD, FLEET_FIELD, ADDITIONAL_TRANSIENT_PROPERTIES_FIELD, ADDITIONAL_FIXED_PROPERTIES_FIELD, VENDOR_PROPERTIES_FIELD, POSITION_FIELD, ORIENTATION_FIELD));
    private final String clientToken;
    private final String name;
    private final String fleet;
    private final String additionalTransientProperties;
    private final String additionalFixedProperties;
    private final VendorProperties vendorProperties;
    private final PositionCoordinates position;
    private final Orientation orientation;

    private CreateWorkerRequest(BuilderImpl builder) {
        super(builder);
        this.clientToken = builder.clientToken;
        this.name = builder.name;
        this.fleet = builder.fleet;
        this.additionalTransientProperties = builder.additionalTransientProperties;
        this.additionalFixedProperties = builder.additionalFixedProperties;
        this.vendorProperties = builder.vendorProperties;
        this.position = builder.position;
        this.orientation = builder.orientation;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    public final String name() {
        return this.name;
    }

    public final String fleet() {
        return this.fleet;
    }

    public final String additionalTransientProperties() {
        return this.additionalTransientProperties;
    }

    public final String additionalFixedProperties() {
        return this.additionalFixedProperties;
    }

    public final VendorProperties vendorProperties() {
        return this.vendorProperties;
    }

    public final PositionCoordinates position() {
        return this.position;
    }

    public final Orientation orientation() {
        return this.orientation;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.fleet());
        hashCode = 31 * hashCode + Objects.hashCode(this.additionalTransientProperties());
        hashCode = 31 * hashCode + Objects.hashCode(this.additionalFixedProperties());
        hashCode = 31 * hashCode + Objects.hashCode(this.vendorProperties());
        hashCode = 31 * hashCode + Objects.hashCode(this.position());
        hashCode = 31 * hashCode + Objects.hashCode(this.orientation());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateWorkerRequest)) {
            return false;
        }
        CreateWorkerRequest other = (CreateWorkerRequest)((Object)obj);
        return Objects.equals(this.clientToken(), other.clientToken()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.fleet(), other.fleet()) && Objects.equals(this.additionalTransientProperties(), other.additionalTransientProperties()) && Objects.equals(this.additionalFixedProperties(), other.additionalFixedProperties()) && Objects.equals(this.vendorProperties(), other.vendorProperties()) && Objects.equals(this.position(), other.position()) && Objects.equals(this.orientation(), other.orientation());
    }

    public final String toString() {
        return ToString.builder((String)"CreateWorkerRequest").add("ClientToken", (Object)this.clientToken()).add("Name", (Object)this.name()).add("Fleet", (Object)this.fleet()).add("AdditionalTransientProperties", (Object)this.additionalTransientProperties()).add("AdditionalFixedProperties", (Object)this.additionalFixedProperties()).add("VendorProperties", (Object)this.vendorProperties()).add("Position", (Object)this.position()).add("Orientation", (Object)this.orientation()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "clientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "fleet": {
                return Optional.ofNullable(clazz.cast(this.fleet()));
            }
            case "additionalTransientProperties": {
                return Optional.ofNullable(clazz.cast(this.additionalTransientProperties()));
            }
            case "additionalFixedProperties": {
                return Optional.ofNullable(clazz.cast(this.additionalFixedProperties()));
            }
            case "vendorProperties": {
                return Optional.ofNullable(clazz.cast(this.vendorProperties()));
            }
            case "position": {
                return Optional.ofNullable(clazz.cast(this.position()));
            }
            case "orientation": {
                return Optional.ofNullable(clazz.cast(this.orientation()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateWorkerRequest, T> g) {
        return obj -> g.apply((CreateWorkerRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IotRoboRunnerRequest.BuilderImpl
    implements Builder {
        private String clientToken;
        private String name;
        private String fleet;
        private String additionalTransientProperties;
        private String additionalFixedProperties;
        private VendorProperties vendorProperties;
        private PositionCoordinates position;
        private Orientation orientation;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateWorkerRequest model) {
            super(model);
            this.clientToken(model.clientToken);
            this.name(model.name);
            this.fleet(model.fleet);
            this.additionalTransientProperties(model.additionalTransientProperties);
            this.additionalFixedProperties(model.additionalFixedProperties);
            this.vendorProperties(model.vendorProperties);
            this.position(model.position);
            this.orientation(model.orientation);
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getFleet() {
            return this.fleet;
        }

        public final void setFleet(String fleet) {
            this.fleet = fleet;
        }

        @Override
        public final Builder fleet(String fleet) {
            this.fleet = fleet;
            return this;
        }

        public final String getAdditionalTransientProperties() {
            return this.additionalTransientProperties;
        }

        public final void setAdditionalTransientProperties(String additionalTransientProperties) {
            this.additionalTransientProperties = additionalTransientProperties;
        }

        @Override
        public final Builder additionalTransientProperties(String additionalTransientProperties) {
            this.additionalTransientProperties = additionalTransientProperties;
            return this;
        }

        public final String getAdditionalFixedProperties() {
            return this.additionalFixedProperties;
        }

        public final void setAdditionalFixedProperties(String additionalFixedProperties) {
            this.additionalFixedProperties = additionalFixedProperties;
        }

        @Override
        public final Builder additionalFixedProperties(String additionalFixedProperties) {
            this.additionalFixedProperties = additionalFixedProperties;
            return this;
        }

        public final VendorProperties.Builder getVendorProperties() {
            return this.vendorProperties != null ? this.vendorProperties.toBuilder() : null;
        }

        public final void setVendorProperties(VendorProperties.BuilderImpl vendorProperties) {
            this.vendorProperties = vendorProperties != null ? vendorProperties.build() : null;
        }

        @Override
        public final Builder vendorProperties(VendorProperties vendorProperties) {
            this.vendorProperties = vendorProperties;
            return this;
        }

        public final PositionCoordinates.Builder getPosition() {
            return this.position != null ? this.position.toBuilder() : null;
        }

        public final void setPosition(PositionCoordinates.BuilderImpl position) {
            this.position = position != null ? position.build() : null;
        }

        @Override
        public final Builder position(PositionCoordinates position) {
            this.position = position;
            return this;
        }

        public final Orientation.Builder getOrientation() {
            return this.orientation != null ? this.orientation.toBuilder() : null;
        }

        public final void setOrientation(Orientation.BuilderImpl orientation) {
            this.orientation = orientation != null ? orientation.build() : null;
        }

        @Override
        public final Builder orientation(Orientation orientation) {
            this.orientation = orientation;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateWorkerRequest build() {
            return new CreateWorkerRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends IotRoboRunnerRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateWorkerRequest> {
        public Builder clientToken(String var1);

        public Builder name(String var1);

        public Builder fleet(String var1);

        public Builder additionalTransientProperties(String var1);

        public Builder additionalFixedProperties(String var1);

        public Builder vendorProperties(VendorProperties var1);

        default public Builder vendorProperties(Consumer<VendorProperties.Builder> vendorProperties) {
            return this.vendorProperties((VendorProperties)((VendorProperties.Builder)VendorProperties.builder().applyMutation(vendorProperties)).build());
        }

        public Builder position(PositionCoordinates var1);

        default public Builder position(Consumer<PositionCoordinates.Builder> position) {
            return this.position((PositionCoordinates)((PositionCoordinates.Builder)PositionCoordinates.builder().applyMutation(position)).build());
        }

        public Builder orientation(Orientation var1);

        default public Builder orientation(Consumer<Orientation.Builder> orientation) {
            return this.orientation((Orientation)((Orientation.Builder)Orientation.builder().applyMutation(orientation)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

