/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotmanagedintegrations.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.iotmanagedintegrations.IotManagedIntegrationsAsyncClient;
import software.amazon.awssdk.services.iotmanagedintegrations.internal.UserAgentUtils;
import software.amazon.awssdk.services.iotmanagedintegrations.model.ListProvisioningProfilesRequest;
import software.amazon.awssdk.services.iotmanagedintegrations.model.ListProvisioningProfilesResponse;
import software.amazon.awssdk.services.iotmanagedintegrations.model.ProvisioningProfileSummary;

public class ListProvisioningProfilesPublisher
implements SdkPublisher<ListProvisioningProfilesResponse> {
    private final IotManagedIntegrationsAsyncClient client;
    private final ListProvisioningProfilesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListProvisioningProfilesPublisher(IotManagedIntegrationsAsyncClient client, ListProvisioningProfilesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListProvisioningProfilesPublisher(IotManagedIntegrationsAsyncClient client, ListProvisioningProfilesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListProvisioningProfilesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListProvisioningProfilesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ProvisioningProfileSummary> items() {
        Function<ListProvisioningProfilesResponse, Iterator> getIterator = response -> {
            if (response != null && response.items() != null) {
                return response.items().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListProvisioningProfilesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListProvisioningProfilesResponseFetcher
    implements AsyncPageFetcher<ListProvisioningProfilesResponse> {
        private ListProvisioningProfilesResponseFetcher() {
        }

        public boolean hasNextPage(ListProvisioningProfilesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListProvisioningProfilesResponse> nextPage(ListProvisioningProfilesResponse previousPage) {
            if (previousPage == null) {
                return ListProvisioningProfilesPublisher.this.client.listProvisioningProfiles(ListProvisioningProfilesPublisher.this.firstRequest);
            }
            return ListProvisioningProfilesPublisher.this.client.listProvisioningProfiles((ListProvisioningProfilesRequest)((Object)ListProvisioningProfilesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

