/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotmanagedintegrations.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.iotmanagedintegrations.IotManagedIntegrationsClient;
import software.amazon.awssdk.services.iotmanagedintegrations.internal.UserAgentUtils;
import software.amazon.awssdk.services.iotmanagedintegrations.model.ListProvisioningProfilesRequest;
import software.amazon.awssdk.services.iotmanagedintegrations.model.ListProvisioningProfilesResponse;
import software.amazon.awssdk.services.iotmanagedintegrations.model.ProvisioningProfileSummary;

public class ListProvisioningProfilesIterable
implements SdkIterable<ListProvisioningProfilesResponse> {
    private final IotManagedIntegrationsClient client;
    private final ListProvisioningProfilesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListProvisioningProfilesIterable(IotManagedIntegrationsClient client, ListProvisioningProfilesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListProvisioningProfilesResponseFetcher();
    }

    public Iterator<ListProvisioningProfilesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ProvisioningProfileSummary> items() {
        Function<ListProvisioningProfilesResponse, Iterator> getIterator = response -> {
            if (response != null && response.items() != null) {
                return response.items().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListProvisioningProfilesResponseFetcher
    implements SyncPageFetcher<ListProvisioningProfilesResponse> {
        private ListProvisioningProfilesResponseFetcher() {
        }

        public boolean hasNextPage(ListProvisioningProfilesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListProvisioningProfilesResponse nextPage(ListProvisioningProfilesResponse previousPage) {
            if (previousPage == null) {
                return ListProvisioningProfilesIterable.this.client.listProvisioningProfiles(ListProvisioningProfilesIterable.this.firstRequest);
            }
            return ListProvisioningProfilesIterable.this.client.listProvisioningProfiles((ListProvisioningProfilesRequest)((Object)ListProvisioningProfilesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

