/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotmanagedintegrations.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum TokenEndpointAuthenticationScheme {
    HTTP_BASIC("HTTP_BASIC"),
    REQUEST_BODY_CREDENTIALS("REQUEST_BODY_CREDENTIALS"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, TokenEndpointAuthenticationScheme> VALUE_MAP;
    private final String value;

    private TokenEndpointAuthenticationScheme(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static TokenEndpointAuthenticationScheme fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<TokenEndpointAuthenticationScheme> knownValues() {
        EnumSet<TokenEndpointAuthenticationScheme> knownValues = EnumSet.allOf(TokenEndpointAuthenticationScheme.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(TokenEndpointAuthenticationScheme.class, TokenEndpointAuthenticationScheme::toString);
    }
}

