/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotmanagedintegrations.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.iotmanagedintegrations.model.DeviceDiscoveryStatus;
import software.amazon.awssdk.services.iotmanagedintegrations.model.DiscoveryType;
import software.amazon.awssdk.services.iotmanagedintegrations.model.IotManagedIntegrationsResponse;
import software.amazon.awssdk.services.iotmanagedintegrations.model.TagsMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetDeviceDiscoveryResponse
extends IotManagedIntegrationsResponse
implements ToCopyableBuilder<Builder, GetDeviceDiscoveryResponse> {
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Id").getter(GetDeviceDiscoveryResponse.getter(GetDeviceDiscoveryResponse::id)).setter(GetDeviceDiscoveryResponse.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()}).build();
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Arn").getter(GetDeviceDiscoveryResponse.getter(GetDeviceDiscoveryResponse::arn)).setter(GetDeviceDiscoveryResponse.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()}).build();
    private static final SdkField<String> DISCOVERY_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DiscoveryType").getter(GetDeviceDiscoveryResponse.getter(GetDeviceDiscoveryResponse::discoveryTypeAsString)).setter(GetDeviceDiscoveryResponse.setter(Builder::discoveryType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DiscoveryType").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(GetDeviceDiscoveryResponse.getter(GetDeviceDiscoveryResponse::statusAsString)).setter(GetDeviceDiscoveryResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<Instant> STARTED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("StartedAt").getter(GetDeviceDiscoveryResponse.getter(GetDeviceDiscoveryResponse::startedAt)).setter(GetDeviceDiscoveryResponse.setter(Builder::startedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartedAt").build()}).build();
    private static final SdkField<String> CONTROLLER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ControllerId").getter(GetDeviceDiscoveryResponse.getter(GetDeviceDiscoveryResponse::controllerId)).setter(GetDeviceDiscoveryResponse.setter(Builder::controllerId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ControllerId").build()}).build();
    private static final SdkField<String> CONNECTOR_ASSOCIATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ConnectorAssociationId").getter(GetDeviceDiscoveryResponse.getter(GetDeviceDiscoveryResponse::connectorAssociationId)).setter(GetDeviceDiscoveryResponse.setter(Builder::connectorAssociationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectorAssociationId").build()}).build();
    private static final SdkField<String> ACCOUNT_ASSOCIATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AccountAssociationId").getter(GetDeviceDiscoveryResponse.getter(GetDeviceDiscoveryResponse::accountAssociationId)).setter(GetDeviceDiscoveryResponse.setter(Builder::accountAssociationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccountAssociationId").build()}).build();
    private static final SdkField<Instant> FINISHED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("FinishedAt").getter(GetDeviceDiscoveryResponse.getter(GetDeviceDiscoveryResponse::finishedAt)).setter(GetDeviceDiscoveryResponse.setter(Builder::finishedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FinishedAt").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Tags").getter(GetDeviceDiscoveryResponse.getter(GetDeviceDiscoveryResponse::tags)).setter(GetDeviceDiscoveryResponse.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, ARN_FIELD, DISCOVERY_TYPE_FIELD, STATUS_FIELD, STARTED_AT_FIELD, CONTROLLER_ID_FIELD, CONNECTOR_ASSOCIATION_ID_FIELD, ACCOUNT_ASSOCIATION_ID_FIELD, FINISHED_AT_FIELD, TAGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetDeviceDiscoveryResponse.memberNameToFieldInitializer();
    private final String id;
    private final String arn;
    private final String discoveryType;
    private final String status;
    private final Instant startedAt;
    private final String controllerId;
    private final String connectorAssociationId;
    private final String accountAssociationId;
    private final Instant finishedAt;
    private final Map<String, String> tags;

    private GetDeviceDiscoveryResponse(BuilderImpl builder) {
        super(builder);
        this.id = builder.id;
        this.arn = builder.arn;
        this.discoveryType = builder.discoveryType;
        this.status = builder.status;
        this.startedAt = builder.startedAt;
        this.controllerId = builder.controllerId;
        this.connectorAssociationId = builder.connectorAssociationId;
        this.accountAssociationId = builder.accountAssociationId;
        this.finishedAt = builder.finishedAt;
        this.tags = builder.tags;
    }

    public final String id() {
        return this.id;
    }

    public final String arn() {
        return this.arn;
    }

    public final DiscoveryType discoveryType() {
        return DiscoveryType.fromValue(this.discoveryType);
    }

    public final String discoveryTypeAsString() {
        return this.discoveryType;
    }

    public final DeviceDiscoveryStatus status() {
        return DeviceDiscoveryStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final Instant startedAt() {
        return this.startedAt;
    }

    public final String controllerId() {
        return this.controllerId;
    }

    @Deprecated
    public final String connectorAssociationId() {
        return this.connectorAssociationId;
    }

    public final String accountAssociationId() {
        return this.accountAssociationId;
    }

    public final Instant finishedAt() {
        return this.finishedAt;
    }

    @Deprecated
    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    @Deprecated
    public final Map<String, String> tags() {
        return this.tags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.discoveryTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.startedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.controllerId());
        hashCode = 31 * hashCode + Objects.hashCode(this.connectorAssociationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.accountAssociationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.finishedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetDeviceDiscoveryResponse)) {
            return false;
        }
        GetDeviceDiscoveryResponse other = (GetDeviceDiscoveryResponse)((Object)obj);
        return Objects.equals(this.id(), other.id()) && Objects.equals(this.arn(), other.arn()) && Objects.equals(this.discoveryTypeAsString(), other.discoveryTypeAsString()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.startedAt(), other.startedAt()) && Objects.equals(this.controllerId(), other.controllerId()) && Objects.equals(this.connectorAssociationId(), other.connectorAssociationId()) && Objects.equals(this.accountAssociationId(), other.accountAssociationId()) && Objects.equals(this.finishedAt(), other.finishedAt()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"GetDeviceDiscoveryResponse").add("Id", (Object)this.id()).add("Arn", (Object)this.arn()).add("DiscoveryType", (Object)this.discoveryTypeAsString()).add("Status", (Object)this.statusAsString()).add("StartedAt", (Object)this.startedAt()).add("ControllerId", (Object)this.controllerId()).add("ConnectorAssociationId", (Object)this.connectorAssociationId()).add("AccountAssociationId", (Object)this.accountAssociationId()).add("FinishedAt", (Object)this.finishedAt()).add("Tags", (Object)(this.tags() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "Arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "DiscoveryType": {
                return Optional.ofNullable(clazz.cast(this.discoveryTypeAsString()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "StartedAt": {
                return Optional.ofNullable(clazz.cast(this.startedAt()));
            }
            case "ControllerId": {
                return Optional.ofNullable(clazz.cast(this.controllerId()));
            }
            case "ConnectorAssociationId": {
                return Optional.ofNullable(clazz.cast(this.connectorAssociationId()));
            }
            case "AccountAssociationId": {
                return Optional.ofNullable(clazz.cast(this.accountAssociationId()));
            }
            case "FinishedAt": {
                return Optional.ofNullable(clazz.cast(this.finishedAt()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Id", ID_FIELD);
        map.put("Arn", ARN_FIELD);
        map.put("DiscoveryType", DISCOVERY_TYPE_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("StartedAt", STARTED_AT_FIELD);
        map.put("ControllerId", CONTROLLER_ID_FIELD);
        map.put("ConnectorAssociationId", CONNECTOR_ASSOCIATION_ID_FIELD);
        map.put("AccountAssociationId", ACCOUNT_ASSOCIATION_ID_FIELD);
        map.put("FinishedAt", FINISHED_AT_FIELD);
        map.put("Tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetDeviceDiscoveryResponse, T> g) {
        return obj -> g.apply((GetDeviceDiscoveryResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IotManagedIntegrationsResponse.BuilderImpl
    implements Builder {
        private String id;
        private String arn;
        private String discoveryType;
        private String status;
        private Instant startedAt;
        private String controllerId;
        private String connectorAssociationId;
        private String accountAssociationId;
        private Instant finishedAt;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetDeviceDiscoveryResponse model) {
            super(model);
            this.id(model.id);
            this.arn(model.arn);
            this.discoveryType(model.discoveryType);
            this.status(model.status);
            this.startedAt(model.startedAt);
            this.controllerId(model.controllerId);
            this.connectorAssociationId(model.connectorAssociationId);
            this.accountAssociationId(model.accountAssociationId);
            this.finishedAt(model.finishedAt);
            this.tags(model.tags);
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getDiscoveryType() {
            return this.discoveryType;
        }

        public final void setDiscoveryType(String discoveryType) {
            this.discoveryType = discoveryType;
        }

        @Override
        public final Builder discoveryType(String discoveryType) {
            this.discoveryType = discoveryType;
            return this;
        }

        @Override
        public final Builder discoveryType(DiscoveryType discoveryType) {
            this.discoveryType(discoveryType == null ? null : discoveryType.toString());
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(DeviceDiscoveryStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Instant getStartedAt() {
            return this.startedAt;
        }

        public final void setStartedAt(Instant startedAt) {
            this.startedAt = startedAt;
        }

        @Override
        public final Builder startedAt(Instant startedAt) {
            this.startedAt = startedAt;
            return this;
        }

        public final String getControllerId() {
            return this.controllerId;
        }

        public final void setControllerId(String controllerId) {
            this.controllerId = controllerId;
        }

        @Override
        public final Builder controllerId(String controllerId) {
            this.controllerId = controllerId;
            return this;
        }

        @Deprecated
        public final String getConnectorAssociationId() {
            return this.connectorAssociationId;
        }

        @Deprecated
        public final void setConnectorAssociationId(String connectorAssociationId) {
            this.connectorAssociationId = connectorAssociationId;
        }

        @Override
        @Deprecated
        public final Builder connectorAssociationId(String connectorAssociationId) {
            this.connectorAssociationId = connectorAssociationId;
            return this;
        }

        public final String getAccountAssociationId() {
            return this.accountAssociationId;
        }

        public final void setAccountAssociationId(String accountAssociationId) {
            this.accountAssociationId = accountAssociationId;
        }

        @Override
        public final Builder accountAssociationId(String accountAssociationId) {
            this.accountAssociationId = accountAssociationId;
            return this;
        }

        public final Instant getFinishedAt() {
            return this.finishedAt;
        }

        public final void setFinishedAt(Instant finishedAt) {
            this.finishedAt = finishedAt;
        }

        @Override
        public final Builder finishedAt(Instant finishedAt) {
            this.finishedAt = finishedAt;
            return this;
        }

        @Deprecated
        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        @Deprecated
        public final void setTags(Map<String, String> tags) {
            this.tags = TagsMapCopier.copy(tags);
        }

        @Override
        @Deprecated
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsMapCopier.copy(tags);
            return this;
        }

        @Override
        public GetDeviceDiscoveryResponse build() {
            return new GetDeviceDiscoveryResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends IotManagedIntegrationsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetDeviceDiscoveryResponse> {
        public Builder id(String var1);

        public Builder arn(String var1);

        public Builder discoveryType(String var1);

        public Builder discoveryType(DiscoveryType var1);

        public Builder status(String var1);

        public Builder status(DeviceDiscoveryStatus var1);

        public Builder startedAt(Instant var1);

        public Builder controllerId(String var1);

        @Deprecated
        public Builder connectorAssociationId(String var1);

        public Builder accountAssociationId(String var1);

        public Builder finishedAt(Instant var1);

        @Deprecated
        public Builder tags(Map<String, String> var1);
    }
}

