/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotmanagedintegrations.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.document.Document;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.iotmanagedintegrations.model.CapabilitySchemaItem;
import software.amazon.awssdk.services.iotmanagedintegrations.model.CapabilitySchemasCopier;
import software.amazon.awssdk.services.iotmanagedintegrations.model.MatterCapabilityReport;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Device
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Device> {
    private static final SdkField<String> CONNECTOR_DEVICE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ConnectorDeviceId").getter(Device.getter(Device::connectorDeviceId)).setter(Device.setter(Builder::connectorDeviceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectorDeviceId").build()}).build();
    private static final SdkField<String> CONNECTOR_DEVICE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ConnectorDeviceName").getter(Device.getter(Device::connectorDeviceName)).setter(Device.setter(Builder::connectorDeviceName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectorDeviceName").build()}).build();
    private static final SdkField<MatterCapabilityReport> CAPABILITY_REPORT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("CapabilityReport").getter(Device.getter(Device::capabilityReport)).setter(Device.setter(Builder::capabilityReport)).constructor(MatterCapabilityReport::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CapabilityReport").build()}).build();
    private static final SdkField<List<CapabilitySchemaItem>> CAPABILITY_SCHEMAS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("CapabilitySchemas").getter(Device.getter(Device::capabilitySchemas)).setter(Device.setter(Builder::capabilitySchemas)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CapabilitySchemas").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(CapabilitySchemaItem::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Document> DEVICE_METADATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOCUMENT).memberName("DeviceMetadata").getter(Device.getter(Device::deviceMetadata)).setter(Device.setter(Builder::deviceMetadata)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeviceMetadata").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONNECTOR_DEVICE_ID_FIELD, CONNECTOR_DEVICE_NAME_FIELD, CAPABILITY_REPORT_FIELD, CAPABILITY_SCHEMAS_FIELD, DEVICE_METADATA_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Device.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String connectorDeviceId;
    private final String connectorDeviceName;
    private final MatterCapabilityReport capabilityReport;
    private final List<CapabilitySchemaItem> capabilitySchemas;
    private final Document deviceMetadata;

    private Device(BuilderImpl builder) {
        this.connectorDeviceId = builder.connectorDeviceId;
        this.connectorDeviceName = builder.connectorDeviceName;
        this.capabilityReport = builder.capabilityReport;
        this.capabilitySchemas = builder.capabilitySchemas;
        this.deviceMetadata = builder.deviceMetadata;
    }

    public final String connectorDeviceId() {
        return this.connectorDeviceId;
    }

    public final String connectorDeviceName() {
        return this.connectorDeviceName;
    }

    public final MatterCapabilityReport capabilityReport() {
        return this.capabilityReport;
    }

    public final boolean hasCapabilitySchemas() {
        return this.capabilitySchemas != null && !(this.capabilitySchemas instanceof SdkAutoConstructList);
    }

    public final List<CapabilitySchemaItem> capabilitySchemas() {
        return this.capabilitySchemas;
    }

    public final Document deviceMetadata() {
        return this.deviceMetadata;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.connectorDeviceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.connectorDeviceName());
        hashCode = 31 * hashCode + Objects.hashCode(this.capabilityReport());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCapabilitySchemas() ? this.capabilitySchemas() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.deviceMetadata());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Device)) {
            return false;
        }
        Device other = (Device)obj;
        return Objects.equals(this.connectorDeviceId(), other.connectorDeviceId()) && Objects.equals(this.connectorDeviceName(), other.connectorDeviceName()) && Objects.equals(this.capabilityReport(), other.capabilityReport()) && this.hasCapabilitySchemas() == other.hasCapabilitySchemas() && Objects.equals(this.capabilitySchemas(), other.capabilitySchemas()) && Objects.equals(this.deviceMetadata(), other.deviceMetadata());
    }

    public final String toString() {
        return ToString.builder((String)"Device").add("ConnectorDeviceId", (Object)(this.connectorDeviceId() == null ? null : "*** Sensitive Data Redacted ***")).add("ConnectorDeviceName", (Object)(this.connectorDeviceName() == null ? null : "*** Sensitive Data Redacted ***")).add("CapabilityReport", (Object)this.capabilityReport()).add("CapabilitySchemas", this.hasCapabilitySchemas() ? this.capabilitySchemas() : null).add("DeviceMetadata", (Object)this.deviceMetadata()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ConnectorDeviceId": {
                return Optional.ofNullable(clazz.cast(this.connectorDeviceId()));
            }
            case "ConnectorDeviceName": {
                return Optional.ofNullable(clazz.cast(this.connectorDeviceName()));
            }
            case "CapabilityReport": {
                return Optional.ofNullable(clazz.cast(this.capabilityReport()));
            }
            case "CapabilitySchemas": {
                return Optional.ofNullable(clazz.cast(this.capabilitySchemas()));
            }
            case "DeviceMetadata": {
                return Optional.ofNullable(clazz.cast(this.deviceMetadata()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ConnectorDeviceId", CONNECTOR_DEVICE_ID_FIELD);
        map.put("ConnectorDeviceName", CONNECTOR_DEVICE_NAME_FIELD);
        map.put("CapabilityReport", CAPABILITY_REPORT_FIELD);
        map.put("CapabilitySchemas", CAPABILITY_SCHEMAS_FIELD);
        map.put("DeviceMetadata", DEVICE_METADATA_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Device, T> g) {
        return obj -> g.apply((Device)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String connectorDeviceId;
        private String connectorDeviceName;
        private MatterCapabilityReport capabilityReport;
        private List<CapabilitySchemaItem> capabilitySchemas = DefaultSdkAutoConstructList.getInstance();
        private Document deviceMetadata;

        private BuilderImpl() {
        }

        private BuilderImpl(Device model) {
            this.connectorDeviceId(model.connectorDeviceId);
            this.connectorDeviceName(model.connectorDeviceName);
            this.capabilityReport(model.capabilityReport);
            this.capabilitySchemas(model.capabilitySchemas);
            this.deviceMetadata(model.deviceMetadata);
        }

        public final String getConnectorDeviceId() {
            return this.connectorDeviceId;
        }

        public final void setConnectorDeviceId(String connectorDeviceId) {
            this.connectorDeviceId = connectorDeviceId;
        }

        @Override
        public final Builder connectorDeviceId(String connectorDeviceId) {
            this.connectorDeviceId = connectorDeviceId;
            return this;
        }

        public final String getConnectorDeviceName() {
            return this.connectorDeviceName;
        }

        public final void setConnectorDeviceName(String connectorDeviceName) {
            this.connectorDeviceName = connectorDeviceName;
        }

        @Override
        public final Builder connectorDeviceName(String connectorDeviceName) {
            this.connectorDeviceName = connectorDeviceName;
            return this;
        }

        public final MatterCapabilityReport.Builder getCapabilityReport() {
            return this.capabilityReport != null ? this.capabilityReport.toBuilder() : null;
        }

        public final void setCapabilityReport(MatterCapabilityReport.BuilderImpl capabilityReport) {
            this.capabilityReport = capabilityReport != null ? capabilityReport.build() : null;
        }

        @Override
        public final Builder capabilityReport(MatterCapabilityReport capabilityReport) {
            this.capabilityReport = capabilityReport;
            return this;
        }

        public final List<CapabilitySchemaItem.Builder> getCapabilitySchemas() {
            List<CapabilitySchemaItem.Builder> result = CapabilitySchemasCopier.copyToBuilder(this.capabilitySchemas);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCapabilitySchemas(Collection<CapabilitySchemaItem.BuilderImpl> capabilitySchemas) {
            this.capabilitySchemas = CapabilitySchemasCopier.copyFromBuilder(capabilitySchemas);
        }

        @Override
        public final Builder capabilitySchemas(Collection<CapabilitySchemaItem> capabilitySchemas) {
            this.capabilitySchemas = CapabilitySchemasCopier.copy(capabilitySchemas);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder capabilitySchemas(CapabilitySchemaItem ... capabilitySchemas) {
            this.capabilitySchemas(Arrays.asList(capabilitySchemas));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder capabilitySchemas(Consumer<CapabilitySchemaItem.Builder> ... capabilitySchemas) {
            this.capabilitySchemas(Stream.of(capabilitySchemas).map(c -> (CapabilitySchemaItem)((CapabilitySchemaItem.Builder)CapabilitySchemaItem.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Document getDeviceMetadata() {
            return this.deviceMetadata;
        }

        public final void setDeviceMetadata(Document deviceMetadata) {
            this.deviceMetadata = deviceMetadata;
        }

        @Override
        public final Builder deviceMetadata(Document deviceMetadata) {
            this.deviceMetadata = deviceMetadata;
            return this;
        }

        public Device build() {
            return new Device(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Device> {
        public Builder connectorDeviceId(String var1);

        public Builder connectorDeviceName(String var1);

        public Builder capabilityReport(MatterCapabilityReport var1);

        default public Builder capabilityReport(Consumer<MatterCapabilityReport.Builder> capabilityReport) {
            return this.capabilityReport((MatterCapabilityReport)((MatterCapabilityReport.Builder)MatterCapabilityReport.builder().applyMutation(capabilityReport)).build());
        }

        public Builder capabilitySchemas(Collection<CapabilitySchemaItem> var1);

        public Builder capabilitySchemas(CapabilitySchemaItem ... var1);

        public Builder capabilitySchemas(Consumer<CapabilitySchemaItem.Builder> ... var1);

        public Builder deviceMetadata(Document var1);
    }
}

