/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotmanagedintegrations.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.iotmanagedintegrations.model.IotManagedIntegrationsResponse;
import software.amazon.awssdk.services.iotmanagedintegrations.model.ProvisioningType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateProvisioningProfileResponse
extends IotManagedIntegrationsResponse
implements ToCopyableBuilder<Builder, CreateProvisioningProfileResponse> {
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Arn").getter(CreateProvisioningProfileResponse.getter(CreateProvisioningProfileResponse::arn)).setter(CreateProvisioningProfileResponse.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(CreateProvisioningProfileResponse.getter(CreateProvisioningProfileResponse::name)).setter(CreateProvisioningProfileResponse.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> PROVISIONING_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ProvisioningType").getter(CreateProvisioningProfileResponse.getter(CreateProvisioningProfileResponse::provisioningTypeAsString)).setter(CreateProvisioningProfileResponse.setter(Builder::provisioningType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProvisioningType").build()}).build();
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Id").getter(CreateProvisioningProfileResponse.getter(CreateProvisioningProfileResponse::id)).setter(CreateProvisioningProfileResponse.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()}).build();
    private static final SdkField<String> CLAIM_CERTIFICATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClaimCertificate").getter(CreateProvisioningProfileResponse.getter(CreateProvisioningProfileResponse::claimCertificate)).setter(CreateProvisioningProfileResponse.setter(Builder::claimCertificate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClaimCertificate").build()}).build();
    private static final SdkField<String> CLAIM_CERTIFICATE_PRIVATE_KEY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClaimCertificatePrivateKey").getter(CreateProvisioningProfileResponse.getter(CreateProvisioningProfileResponse::claimCertificatePrivateKey)).setter(CreateProvisioningProfileResponse.setter(Builder::claimCertificatePrivateKey)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClaimCertificatePrivateKey").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, NAME_FIELD, PROVISIONING_TYPE_FIELD, ID_FIELD, CLAIM_CERTIFICATE_FIELD, CLAIM_CERTIFICATE_PRIVATE_KEY_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateProvisioningProfileResponse.memberNameToFieldInitializer();
    private final String arn;
    private final String name;
    private final String provisioningType;
    private final String id;
    private final String claimCertificate;
    private final String claimCertificatePrivateKey;

    private CreateProvisioningProfileResponse(BuilderImpl builder) {
        super(builder);
        this.arn = builder.arn;
        this.name = builder.name;
        this.provisioningType = builder.provisioningType;
        this.id = builder.id;
        this.claimCertificate = builder.claimCertificate;
        this.claimCertificatePrivateKey = builder.claimCertificatePrivateKey;
    }

    public final String arn() {
        return this.arn;
    }

    public final String name() {
        return this.name;
    }

    public final ProvisioningType provisioningType() {
        return ProvisioningType.fromValue(this.provisioningType);
    }

    public final String provisioningTypeAsString() {
        return this.provisioningType;
    }

    public final String id() {
        return this.id;
    }

    public final String claimCertificate() {
        return this.claimCertificate;
    }

    public final String claimCertificatePrivateKey() {
        return this.claimCertificatePrivateKey;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.provisioningTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.claimCertificate());
        hashCode = 31 * hashCode + Objects.hashCode(this.claimCertificatePrivateKey());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateProvisioningProfileResponse)) {
            return false;
        }
        CreateProvisioningProfileResponse other = (CreateProvisioningProfileResponse)((Object)obj);
        return Objects.equals(this.arn(), other.arn()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.provisioningTypeAsString(), other.provisioningTypeAsString()) && Objects.equals(this.id(), other.id()) && Objects.equals(this.claimCertificate(), other.claimCertificate()) && Objects.equals(this.claimCertificatePrivateKey(), other.claimCertificatePrivateKey());
    }

    public final String toString() {
        return ToString.builder((String)"CreateProvisioningProfileResponse").add("Arn", (Object)this.arn()).add("Name", (Object)this.name()).add("ProvisioningType", (Object)this.provisioningTypeAsString()).add("Id", (Object)this.id()).add("ClaimCertificate", (Object)(this.claimCertificate() == null ? null : "*** Sensitive Data Redacted ***")).add("ClaimCertificatePrivateKey", (Object)(this.claimCertificatePrivateKey() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "ProvisioningType": {
                return Optional.ofNullable(clazz.cast(this.provisioningTypeAsString()));
            }
            case "Id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "ClaimCertificate": {
                return Optional.ofNullable(clazz.cast(this.claimCertificate()));
            }
            case "ClaimCertificatePrivateKey": {
                return Optional.ofNullable(clazz.cast(this.claimCertificatePrivateKey()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("Arn", ARN_FIELD);
        map.put("Name", NAME_FIELD);
        map.put("ProvisioningType", PROVISIONING_TYPE_FIELD);
        map.put("Id", ID_FIELD);
        map.put("ClaimCertificate", CLAIM_CERTIFICATE_FIELD);
        map.put("ClaimCertificatePrivateKey", CLAIM_CERTIFICATE_PRIVATE_KEY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateProvisioningProfileResponse, T> g) {
        return obj -> g.apply((CreateProvisioningProfileResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IotManagedIntegrationsResponse.BuilderImpl
    implements Builder {
        private String arn;
        private String name;
        private String provisioningType;
        private String id;
        private String claimCertificate;
        private String claimCertificatePrivateKey;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateProvisioningProfileResponse model) {
            super(model);
            this.arn(model.arn);
            this.name(model.name);
            this.provisioningType(model.provisioningType);
            this.id(model.id);
            this.claimCertificate(model.claimCertificate);
            this.claimCertificatePrivateKey(model.claimCertificatePrivateKey);
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getProvisioningType() {
            return this.provisioningType;
        }

        public final void setProvisioningType(String provisioningType) {
            this.provisioningType = provisioningType;
        }

        @Override
        public final Builder provisioningType(String provisioningType) {
            this.provisioningType = provisioningType;
            return this;
        }

        @Override
        public final Builder provisioningType(ProvisioningType provisioningType) {
            this.provisioningType(provisioningType == null ? null : provisioningType.toString());
            return this;
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getClaimCertificate() {
            return this.claimCertificate;
        }

        public final void setClaimCertificate(String claimCertificate) {
            this.claimCertificate = claimCertificate;
        }

        @Override
        public final Builder claimCertificate(String claimCertificate) {
            this.claimCertificate = claimCertificate;
            return this;
        }

        public final String getClaimCertificatePrivateKey() {
            return this.claimCertificatePrivateKey;
        }

        public final void setClaimCertificatePrivateKey(String claimCertificatePrivateKey) {
            this.claimCertificatePrivateKey = claimCertificatePrivateKey;
        }

        @Override
        public final Builder claimCertificatePrivateKey(String claimCertificatePrivateKey) {
            this.claimCertificatePrivateKey = claimCertificatePrivateKey;
            return this;
        }

        @Override
        public CreateProvisioningProfileResponse build() {
            return new CreateProvisioningProfileResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends IotManagedIntegrationsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateProvisioningProfileResponse> {
        public Builder arn(String var1);

        public Builder name(String var1);

        public Builder provisioningType(String var1);

        public Builder provisioningType(ProvisioningType var1);

        public Builder id(String var1);

        public Builder claimCertificate(String var1);

        public Builder claimCertificatePrivateKey(String var1);
    }
}

