/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotmanagedintegrations.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.document.Document;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.iotmanagedintegrations.model.SchemaVersionFormat;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CapabilitySchemaItem
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CapabilitySchemaItem> {
    private static final SdkField<String> FORMAT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Format").getter(CapabilitySchemaItem.getter(CapabilitySchemaItem::formatAsString)).setter(CapabilitySchemaItem.setter(Builder::format)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Format").build()}).build();
    private static final SdkField<String> CAPABILITY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CapabilityId").getter(CapabilitySchemaItem.getter(CapabilitySchemaItem::capabilityId)).setter(CapabilitySchemaItem.setter(Builder::capabilityId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CapabilityId").build()}).build();
    private static final SdkField<String> EXTRINSIC_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ExtrinsicId").getter(CapabilitySchemaItem.getter(CapabilitySchemaItem::extrinsicId)).setter(CapabilitySchemaItem.setter(Builder::extrinsicId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExtrinsicId").build()}).build();
    private static final SdkField<Integer> EXTRINSIC_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("ExtrinsicVersion").getter(CapabilitySchemaItem.getter(CapabilitySchemaItem::extrinsicVersion)).setter(CapabilitySchemaItem.setter(Builder::extrinsicVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExtrinsicVersion").build()}).build();
    private static final SdkField<Document> SCHEMA_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOCUMENT).memberName("Schema").getter(CapabilitySchemaItem.getter(CapabilitySchemaItem::schema)).setter(CapabilitySchemaItem.setter(Builder::schema)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Schema").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FORMAT_FIELD, CAPABILITY_ID_FIELD, EXTRINSIC_ID_FIELD, EXTRINSIC_VERSION_FIELD, SCHEMA_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CapabilitySchemaItem.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String format;
    private final String capabilityId;
    private final String extrinsicId;
    private final Integer extrinsicVersion;
    private final Document schema;

    private CapabilitySchemaItem(BuilderImpl builder) {
        this.format = builder.format;
        this.capabilityId = builder.capabilityId;
        this.extrinsicId = builder.extrinsicId;
        this.extrinsicVersion = builder.extrinsicVersion;
        this.schema = builder.schema;
    }

    public final SchemaVersionFormat format() {
        return SchemaVersionFormat.fromValue(this.format);
    }

    public final String formatAsString() {
        return this.format;
    }

    public final String capabilityId() {
        return this.capabilityId;
    }

    public final String extrinsicId() {
        return this.extrinsicId;
    }

    public final Integer extrinsicVersion() {
        return this.extrinsicVersion;
    }

    public final Document schema() {
        return this.schema;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.formatAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.capabilityId());
        hashCode = 31 * hashCode + Objects.hashCode(this.extrinsicId());
        hashCode = 31 * hashCode + Objects.hashCode(this.extrinsicVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.schema());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CapabilitySchemaItem)) {
            return false;
        }
        CapabilitySchemaItem other = (CapabilitySchemaItem)obj;
        return Objects.equals(this.formatAsString(), other.formatAsString()) && Objects.equals(this.capabilityId(), other.capabilityId()) && Objects.equals(this.extrinsicId(), other.extrinsicId()) && Objects.equals(this.extrinsicVersion(), other.extrinsicVersion()) && Objects.equals(this.schema(), other.schema());
    }

    public final String toString() {
        return ToString.builder((String)"CapabilitySchemaItem").add("Format", (Object)this.formatAsString()).add("CapabilityId", (Object)this.capabilityId()).add("ExtrinsicId", (Object)this.extrinsicId()).add("ExtrinsicVersion", (Object)this.extrinsicVersion()).add("Schema", (Object)this.schema()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Format": {
                return Optional.ofNullable(clazz.cast(this.formatAsString()));
            }
            case "CapabilityId": {
                return Optional.ofNullable(clazz.cast(this.capabilityId()));
            }
            case "ExtrinsicId": {
                return Optional.ofNullable(clazz.cast(this.extrinsicId()));
            }
            case "ExtrinsicVersion": {
                return Optional.ofNullable(clazz.cast(this.extrinsicVersion()));
            }
            case "Schema": {
                return Optional.ofNullable(clazz.cast(this.schema()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Format", FORMAT_FIELD);
        map.put("CapabilityId", CAPABILITY_ID_FIELD);
        map.put("ExtrinsicId", EXTRINSIC_ID_FIELD);
        map.put("ExtrinsicVersion", EXTRINSIC_VERSION_FIELD);
        map.put("Schema", SCHEMA_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CapabilitySchemaItem, T> g) {
        return obj -> g.apply((CapabilitySchemaItem)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String format;
        private String capabilityId;
        private String extrinsicId;
        private Integer extrinsicVersion;
        private Document schema;

        private BuilderImpl() {
        }

        private BuilderImpl(CapabilitySchemaItem model) {
            this.format(model.format);
            this.capabilityId(model.capabilityId);
            this.extrinsicId(model.extrinsicId);
            this.extrinsicVersion(model.extrinsicVersion);
            this.schema(model.schema);
        }

        public final String getFormat() {
            return this.format;
        }

        public final void setFormat(String format) {
            this.format = format;
        }

        @Override
        public final Builder format(String format) {
            this.format = format;
            return this;
        }

        @Override
        public final Builder format(SchemaVersionFormat format) {
            this.format(format == null ? null : format.toString());
            return this;
        }

        public final String getCapabilityId() {
            return this.capabilityId;
        }

        public final void setCapabilityId(String capabilityId) {
            this.capabilityId = capabilityId;
        }

        @Override
        public final Builder capabilityId(String capabilityId) {
            this.capabilityId = capabilityId;
            return this;
        }

        public final String getExtrinsicId() {
            return this.extrinsicId;
        }

        public final void setExtrinsicId(String extrinsicId) {
            this.extrinsicId = extrinsicId;
        }

        @Override
        public final Builder extrinsicId(String extrinsicId) {
            this.extrinsicId = extrinsicId;
            return this;
        }

        public final Integer getExtrinsicVersion() {
            return this.extrinsicVersion;
        }

        public final void setExtrinsicVersion(Integer extrinsicVersion) {
            this.extrinsicVersion = extrinsicVersion;
        }

        @Override
        public final Builder extrinsicVersion(Integer extrinsicVersion) {
            this.extrinsicVersion = extrinsicVersion;
            return this;
        }

        public final Document getSchema() {
            return this.schema;
        }

        public final void setSchema(Document schema) {
            this.schema = schema;
        }

        @Override
        public final Builder schema(Document schema) {
            this.schema = schema;
            return this;
        }

        public CapabilitySchemaItem build() {
            return new CapabilitySchemaItem(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CapabilitySchemaItem> {
        public Builder format(String var1);

        public Builder format(SchemaVersionFormat var1);

        public Builder capabilityId(String var1);

        public Builder extrinsicId(String var1);

        public Builder extrinsicVersion(Integer var1);

        public Builder schema(Document var1);
    }
}

