/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotmanagedintegrations.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.iotmanagedintegrations.IotManagedIntegrationsClient;
import software.amazon.awssdk.services.iotmanagedintegrations.internal.UserAgentUtils;
import software.amazon.awssdk.services.iotmanagedintegrations.model.ListOtaTaskExecutionsRequest;
import software.amazon.awssdk.services.iotmanagedintegrations.model.ListOtaTaskExecutionsResponse;
import software.amazon.awssdk.services.iotmanagedintegrations.model.OtaTaskExecutionSummaries;

public class ListOtaTaskExecutionsIterable
implements SdkIterable<ListOtaTaskExecutionsResponse> {
    private final IotManagedIntegrationsClient client;
    private final ListOtaTaskExecutionsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListOtaTaskExecutionsIterable(IotManagedIntegrationsClient client, ListOtaTaskExecutionsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListOtaTaskExecutionsResponseFetcher();
    }

    public Iterator<ListOtaTaskExecutionsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<OtaTaskExecutionSummaries> executionSummaries() {
        Function<ListOtaTaskExecutionsResponse, Iterator> getIterator = response -> {
            if (response != null && response.executionSummaries() != null) {
                return response.executionSummaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListOtaTaskExecutionsResponseFetcher
    implements SyncPageFetcher<ListOtaTaskExecutionsResponse> {
        private ListOtaTaskExecutionsResponseFetcher() {
        }

        public boolean hasNextPage(ListOtaTaskExecutionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListOtaTaskExecutionsResponse nextPage(ListOtaTaskExecutionsResponse previousPage) {
            if (previousPage == null) {
                return ListOtaTaskExecutionsIterable.this.client.listOtaTaskExecutions(ListOtaTaskExecutionsIterable.this.firstRequest);
            }
            return ListOtaTaskExecutionsIterable.this.client.listOtaTaskExecutions((ListOtaTaskExecutionsRequest)((Object)ListOtaTaskExecutionsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

