/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotmanagedintegrations.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.iotmanagedintegrations.model.AuthConfigUpdate;
import software.amazon.awssdk.services.iotmanagedintegrations.model.AuthType;
import software.amazon.awssdk.services.iotmanagedintegrations.model.IotManagedIntegrationsRequest;
import software.amazon.awssdk.services.iotmanagedintegrations.model.SecretsManager;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateConnectorDestinationRequest
extends IotManagedIntegrationsRequest
implements ToCopyableBuilder<Builder, UpdateConnectorDestinationRequest> {
    private static final SdkField<String> IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Identifier").getter(UpdateConnectorDestinationRequest.getter(UpdateConnectorDestinationRequest::identifier)).setter(UpdateConnectorDestinationRequest.setter(Builder::identifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("Identifier").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(UpdateConnectorDestinationRequest.getter(UpdateConnectorDestinationRequest::description)).setter(UpdateConnectorDestinationRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(UpdateConnectorDestinationRequest.getter(UpdateConnectorDestinationRequest::name)).setter(UpdateConnectorDestinationRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> AUTH_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AuthType").getter(UpdateConnectorDestinationRequest.getter(UpdateConnectorDestinationRequest::authTypeAsString)).setter(UpdateConnectorDestinationRequest.setter(Builder::authType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AuthType").build()}).build();
    private static final SdkField<AuthConfigUpdate> AUTH_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("AuthConfig").getter(UpdateConnectorDestinationRequest.getter(UpdateConnectorDestinationRequest::authConfig)).setter(UpdateConnectorDestinationRequest.setter(Builder::authConfig)).constructor(AuthConfigUpdate::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AuthConfig").build()}).build();
    private static final SdkField<SecretsManager> SECRETS_MANAGER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SecretsManager").getter(UpdateConnectorDestinationRequest.getter(UpdateConnectorDestinationRequest::secretsManager)).setter(UpdateConnectorDestinationRequest.setter(Builder::secretsManager)).constructor(SecretsManager::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecretsManager").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IDENTIFIER_FIELD, DESCRIPTION_FIELD, NAME_FIELD, AUTH_TYPE_FIELD, AUTH_CONFIG_FIELD, SECRETS_MANAGER_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateConnectorDestinationRequest.memberNameToFieldInitializer();
    private final String identifier;
    private final String description;
    private final String name;
    private final String authType;
    private final AuthConfigUpdate authConfig;
    private final SecretsManager secretsManager;

    private UpdateConnectorDestinationRequest(BuilderImpl builder) {
        super(builder);
        this.identifier = builder.identifier;
        this.description = builder.description;
        this.name = builder.name;
        this.authType = builder.authType;
        this.authConfig = builder.authConfig;
        this.secretsManager = builder.secretsManager;
    }

    public final String identifier() {
        return this.identifier;
    }

    public final String description() {
        return this.description;
    }

    public final String name() {
        return this.name;
    }

    public final AuthType authType() {
        return AuthType.fromValue(this.authType);
    }

    public final String authTypeAsString() {
        return this.authType;
    }

    public final AuthConfigUpdate authConfig() {
        return this.authConfig;
    }

    public final SecretsManager secretsManager() {
        return this.secretsManager;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.identifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.authTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.authConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.secretsManager());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateConnectorDestinationRequest)) {
            return false;
        }
        UpdateConnectorDestinationRequest other = (UpdateConnectorDestinationRequest)((Object)obj);
        return Objects.equals(this.identifier(), other.identifier()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.authTypeAsString(), other.authTypeAsString()) && Objects.equals(this.authConfig(), other.authConfig()) && Objects.equals(this.secretsManager(), other.secretsManager());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateConnectorDestinationRequest").add("Identifier", (Object)this.identifier()).add("Description", (Object)this.description()).add("Name", (Object)this.name()).add("AuthType", (Object)this.authTypeAsString()).add("AuthConfig", (Object)this.authConfig()).add("SecretsManager", (Object)this.secretsManager()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Identifier": {
                return Optional.ofNullable(clazz.cast(this.identifier()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "AuthType": {
                return Optional.ofNullable(clazz.cast(this.authTypeAsString()));
            }
            case "AuthConfig": {
                return Optional.ofNullable(clazz.cast(this.authConfig()));
            }
            case "SecretsManager": {
                return Optional.ofNullable(clazz.cast(this.secretsManager()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Identifier", IDENTIFIER_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("Name", NAME_FIELD);
        map.put("AuthType", AUTH_TYPE_FIELD);
        map.put("AuthConfig", AUTH_CONFIG_FIELD);
        map.put("SecretsManager", SECRETS_MANAGER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateConnectorDestinationRequest, T> g) {
        return obj -> g.apply((UpdateConnectorDestinationRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IotManagedIntegrationsRequest.BuilderImpl
    implements Builder {
        private String identifier;
        private String description;
        private String name;
        private String authType;
        private AuthConfigUpdate authConfig;
        private SecretsManager secretsManager;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateConnectorDestinationRequest model) {
            super(model);
            this.identifier(model.identifier);
            this.description(model.description);
            this.name(model.name);
            this.authType(model.authType);
            this.authConfig(model.authConfig);
            this.secretsManager(model.secretsManager);
        }

        public final String getIdentifier() {
            return this.identifier;
        }

        public final void setIdentifier(String identifier) {
            this.identifier = identifier;
        }

        @Override
        public final Builder identifier(String identifier) {
            this.identifier = identifier;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getAuthType() {
            return this.authType;
        }

        public final void setAuthType(String authType) {
            this.authType = authType;
        }

        @Override
        public final Builder authType(String authType) {
            this.authType = authType;
            return this;
        }

        @Override
        public final Builder authType(AuthType authType) {
            this.authType(authType == null ? null : authType.toString());
            return this;
        }

        public final AuthConfigUpdate.Builder getAuthConfig() {
            return this.authConfig != null ? this.authConfig.toBuilder() : null;
        }

        public final void setAuthConfig(AuthConfigUpdate.BuilderImpl authConfig) {
            this.authConfig = authConfig != null ? authConfig.build() : null;
        }

        @Override
        public final Builder authConfig(AuthConfigUpdate authConfig) {
            this.authConfig = authConfig;
            return this;
        }

        public final SecretsManager.Builder getSecretsManager() {
            return this.secretsManager != null ? this.secretsManager.toBuilder() : null;
        }

        public final void setSecretsManager(SecretsManager.BuilderImpl secretsManager) {
            this.secretsManager = secretsManager != null ? secretsManager.build() : null;
        }

        @Override
        public final Builder secretsManager(SecretsManager secretsManager) {
            this.secretsManager = secretsManager;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateConnectorDestinationRequest build() {
            return new UpdateConnectorDestinationRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends IotManagedIntegrationsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateConnectorDestinationRequest> {
        public Builder identifier(String var1);

        public Builder description(String var1);

        public Builder name(String var1);

        public Builder authType(String var1);

        public Builder authType(AuthType var1);

        public Builder authConfig(AuthConfigUpdate var1);

        default public Builder authConfig(Consumer<AuthConfigUpdate.Builder> authConfig) {
            return this.authConfig((AuthConfigUpdate)((AuthConfigUpdate.Builder)AuthConfigUpdate.builder().applyMutation(authConfig)).build());
        }

        public Builder secretsManager(SecretsManager var1);

        default public Builder secretsManager(Consumer<SecretsManager.Builder> secretsManager) {
            return this.secretsManager((SecretsManager)((SecretsManager.Builder)SecretsManager.builder().applyMutation(secretsManager)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

