/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotjobsdataplane.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.iotjobsdataplane.model.DetailsMapCopier;
import software.amazon.awssdk.services.iotjobsdataplane.model.IotJobsDataPlaneRequest;
import software.amazon.awssdk.services.iotjobsdataplane.model.JobExecutionStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateJobExecutionRequest
extends IotJobsDataPlaneRequest
implements ToCopyableBuilder<Builder, UpdateJobExecutionRequest> {
    private static final SdkField<String> JOB_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("jobId").getter(UpdateJobExecutionRequest.getter(UpdateJobExecutionRequest::jobId)).setter(UpdateJobExecutionRequest.setter(Builder::jobId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("jobId").build()}).build();
    private static final SdkField<String> THING_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("thingName").getter(UpdateJobExecutionRequest.getter(UpdateJobExecutionRequest::thingName)).setter(UpdateJobExecutionRequest.setter(Builder::thingName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("thingName").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(UpdateJobExecutionRequest.getter(UpdateJobExecutionRequest::statusAsString)).setter(UpdateJobExecutionRequest.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<Map<String, String>> STATUS_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("statusDetails").getter(UpdateJobExecutionRequest.getter(UpdateJobExecutionRequest::statusDetails)).setter(UpdateJobExecutionRequest.setter(Builder::statusDetails)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statusDetails").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<Long> STEP_TIMEOUT_IN_MINUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("stepTimeoutInMinutes").getter(UpdateJobExecutionRequest.getter(UpdateJobExecutionRequest::stepTimeoutInMinutes)).setter(UpdateJobExecutionRequest.setter(Builder::stepTimeoutInMinutes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stepTimeoutInMinutes").build()}).build();
    private static final SdkField<Long> EXPECTED_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("expectedVersion").getter(UpdateJobExecutionRequest.getter(UpdateJobExecutionRequest::expectedVersion)).setter(UpdateJobExecutionRequest.setter(Builder::expectedVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("expectedVersion").build()}).build();
    private static final SdkField<Boolean> INCLUDE_JOB_EXECUTION_STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("includeJobExecutionState").getter(UpdateJobExecutionRequest.getter(UpdateJobExecutionRequest::includeJobExecutionState)).setter(UpdateJobExecutionRequest.setter(Builder::includeJobExecutionState)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("includeJobExecutionState").build()}).build();
    private static final SdkField<Boolean> INCLUDE_JOB_DOCUMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("includeJobDocument").getter(UpdateJobExecutionRequest.getter(UpdateJobExecutionRequest::includeJobDocument)).setter(UpdateJobExecutionRequest.setter(Builder::includeJobDocument)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("includeJobDocument").build()}).build();
    private static final SdkField<Long> EXECUTION_NUMBER_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("executionNumber").getter(UpdateJobExecutionRequest.getter(UpdateJobExecutionRequest::executionNumber)).setter(UpdateJobExecutionRequest.setter(Builder::executionNumber)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("executionNumber").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JOB_ID_FIELD, THING_NAME_FIELD, STATUS_FIELD, STATUS_DETAILS_FIELD, STEP_TIMEOUT_IN_MINUTES_FIELD, EXPECTED_VERSION_FIELD, INCLUDE_JOB_EXECUTION_STATE_FIELD, INCLUDE_JOB_DOCUMENT_FIELD, EXECUTION_NUMBER_FIELD));
    private final String jobId;
    private final String thingName;
    private final String status;
    private final Map<String, String> statusDetails;
    private final Long stepTimeoutInMinutes;
    private final Long expectedVersion;
    private final Boolean includeJobExecutionState;
    private final Boolean includeJobDocument;
    private final Long executionNumber;

    private UpdateJobExecutionRequest(BuilderImpl builder) {
        super(builder);
        this.jobId = builder.jobId;
        this.thingName = builder.thingName;
        this.status = builder.status;
        this.statusDetails = builder.statusDetails;
        this.stepTimeoutInMinutes = builder.stepTimeoutInMinutes;
        this.expectedVersion = builder.expectedVersion;
        this.includeJobExecutionState = builder.includeJobExecutionState;
        this.includeJobDocument = builder.includeJobDocument;
        this.executionNumber = builder.executionNumber;
    }

    public String jobId() {
        return this.jobId;
    }

    public String thingName() {
        return this.thingName;
    }

    public JobExecutionStatus status() {
        return JobExecutionStatus.fromValue(this.status);
    }

    public String statusAsString() {
        return this.status;
    }

    public boolean hasStatusDetails() {
        return this.statusDetails != null && !(this.statusDetails instanceof SdkAutoConstructMap);
    }

    public Map<String, String> statusDetails() {
        return this.statusDetails;
    }

    public Long stepTimeoutInMinutes() {
        return this.stepTimeoutInMinutes;
    }

    public Long expectedVersion() {
        return this.expectedVersion;
    }

    public Boolean includeJobExecutionState() {
        return this.includeJobExecutionState;
    }

    public Boolean includeJobDocument() {
        return this.includeJobDocument;
    }

    public Long executionNumber() {
        return this.executionNumber;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.jobId());
        hashCode = 31 * hashCode + Objects.hashCode(this.thingName());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasStatusDetails() ? this.statusDetails() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.stepTimeoutInMinutes());
        hashCode = 31 * hashCode + Objects.hashCode(this.expectedVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.includeJobExecutionState());
        hashCode = 31 * hashCode + Objects.hashCode(this.includeJobDocument());
        hashCode = 31 * hashCode + Objects.hashCode(this.executionNumber());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateJobExecutionRequest)) {
            return false;
        }
        UpdateJobExecutionRequest other = (UpdateJobExecutionRequest)((Object)obj);
        return Objects.equals(this.jobId(), other.jobId()) && Objects.equals(this.thingName(), other.thingName()) && Objects.equals(this.statusAsString(), other.statusAsString()) && this.hasStatusDetails() == other.hasStatusDetails() && Objects.equals(this.statusDetails(), other.statusDetails()) && Objects.equals(this.stepTimeoutInMinutes(), other.stepTimeoutInMinutes()) && Objects.equals(this.expectedVersion(), other.expectedVersion()) && Objects.equals(this.includeJobExecutionState(), other.includeJobExecutionState()) && Objects.equals(this.includeJobDocument(), other.includeJobDocument()) && Objects.equals(this.executionNumber(), other.executionNumber());
    }

    public String toString() {
        return ToString.builder((String)"UpdateJobExecutionRequest").add("JobId", (Object)this.jobId()).add("ThingName", (Object)this.thingName()).add("Status", (Object)this.statusAsString()).add("StatusDetails", this.hasStatusDetails() ? this.statusDetails() : null).add("StepTimeoutInMinutes", (Object)this.stepTimeoutInMinutes()).add("ExpectedVersion", (Object)this.expectedVersion()).add("IncludeJobExecutionState", (Object)this.includeJobExecutionState()).add("IncludeJobDocument", (Object)this.includeJobDocument()).add("ExecutionNumber", (Object)this.executionNumber()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "jobId": {
                return Optional.ofNullable(clazz.cast(this.jobId()));
            }
            case "thingName": {
                return Optional.ofNullable(clazz.cast(this.thingName()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "statusDetails": {
                return Optional.ofNullable(clazz.cast(this.statusDetails()));
            }
            case "stepTimeoutInMinutes": {
                return Optional.ofNullable(clazz.cast(this.stepTimeoutInMinutes()));
            }
            case "expectedVersion": {
                return Optional.ofNullable(clazz.cast(this.expectedVersion()));
            }
            case "includeJobExecutionState": {
                return Optional.ofNullable(clazz.cast(this.includeJobExecutionState()));
            }
            case "includeJobDocument": {
                return Optional.ofNullable(clazz.cast(this.includeJobDocument()));
            }
            case "executionNumber": {
                return Optional.ofNullable(clazz.cast(this.executionNumber()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateJobExecutionRequest, T> g) {
        return obj -> g.apply((UpdateJobExecutionRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IotJobsDataPlaneRequest.BuilderImpl
    implements Builder {
        private String jobId;
        private String thingName;
        private String status;
        private Map<String, String> statusDetails = DefaultSdkAutoConstructMap.getInstance();
        private Long stepTimeoutInMinutes;
        private Long expectedVersion;
        private Boolean includeJobExecutionState;
        private Boolean includeJobDocument;
        private Long executionNumber;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateJobExecutionRequest model) {
            super(model);
            this.jobId(model.jobId);
            this.thingName(model.thingName);
            this.status(model.status);
            this.statusDetails(model.statusDetails);
            this.stepTimeoutInMinutes(model.stepTimeoutInMinutes);
            this.expectedVersion(model.expectedVersion);
            this.includeJobExecutionState(model.includeJobExecutionState);
            this.includeJobDocument(model.includeJobDocument);
            this.executionNumber(model.executionNumber);
        }

        public final String getJobId() {
            return this.jobId;
        }

        @Override
        public final Builder jobId(String jobId) {
            this.jobId = jobId;
            return this;
        }

        public final void setJobId(String jobId) {
            this.jobId = jobId;
        }

        public final String getThingName() {
            return this.thingName;
        }

        @Override
        public final Builder thingName(String thingName) {
            this.thingName = thingName;
            return this;
        }

        public final void setThingName(String thingName) {
            this.thingName = thingName;
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(JobExecutionStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final Map<String, String> getStatusDetails() {
            if (this.statusDetails instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.statusDetails;
        }

        @Override
        public final Builder statusDetails(Map<String, String> statusDetails) {
            this.statusDetails = DetailsMapCopier.copy(statusDetails);
            return this;
        }

        public final void setStatusDetails(Map<String, String> statusDetails) {
            this.statusDetails = DetailsMapCopier.copy(statusDetails);
        }

        public final Long getStepTimeoutInMinutes() {
            return this.stepTimeoutInMinutes;
        }

        @Override
        public final Builder stepTimeoutInMinutes(Long stepTimeoutInMinutes) {
            this.stepTimeoutInMinutes = stepTimeoutInMinutes;
            return this;
        }

        public final void setStepTimeoutInMinutes(Long stepTimeoutInMinutes) {
            this.stepTimeoutInMinutes = stepTimeoutInMinutes;
        }

        public final Long getExpectedVersion() {
            return this.expectedVersion;
        }

        @Override
        public final Builder expectedVersion(Long expectedVersion) {
            this.expectedVersion = expectedVersion;
            return this;
        }

        public final void setExpectedVersion(Long expectedVersion) {
            this.expectedVersion = expectedVersion;
        }

        public final Boolean getIncludeJobExecutionState() {
            return this.includeJobExecutionState;
        }

        @Override
        public final Builder includeJobExecutionState(Boolean includeJobExecutionState) {
            this.includeJobExecutionState = includeJobExecutionState;
            return this;
        }

        public final void setIncludeJobExecutionState(Boolean includeJobExecutionState) {
            this.includeJobExecutionState = includeJobExecutionState;
        }

        public final Boolean getIncludeJobDocument() {
            return this.includeJobDocument;
        }

        @Override
        public final Builder includeJobDocument(Boolean includeJobDocument) {
            this.includeJobDocument = includeJobDocument;
            return this;
        }

        public final void setIncludeJobDocument(Boolean includeJobDocument) {
            this.includeJobDocument = includeJobDocument;
        }

        public final Long getExecutionNumber() {
            return this.executionNumber;
        }

        @Override
        public final Builder executionNumber(Long executionNumber) {
            this.executionNumber = executionNumber;
            return this;
        }

        public final void setExecutionNumber(Long executionNumber) {
            this.executionNumber = executionNumber;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateJobExecutionRequest build() {
            return new UpdateJobExecutionRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends IotJobsDataPlaneRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateJobExecutionRequest> {
        public Builder jobId(String var1);

        public Builder thingName(String var1);

        public Builder status(String var1);

        public Builder status(JobExecutionStatus var1);

        public Builder statusDetails(Map<String, String> var1);

        public Builder stepTimeoutInMinutes(Long var1);

        public Builder expectedVersion(Long var1);

        public Builder includeJobExecutionState(Boolean var1);

        public Builder includeJobDocument(Boolean var1);

        public Builder executionNumber(Long var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

