/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotjobsdataplane.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class JobExecutionSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, JobExecutionSummary> {
    private static final SdkField<String> JOB_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("jobId").getter(JobExecutionSummary.getter(JobExecutionSummary::jobId)).setter(JobExecutionSummary.setter(Builder::jobId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobId").build()}).build();
    private static final SdkField<Long> QUEUED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("queuedAt").getter(JobExecutionSummary.getter(JobExecutionSummary::queuedAt)).setter(JobExecutionSummary.setter(Builder::queuedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("queuedAt").build()}).build();
    private static final SdkField<Long> STARTED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("startedAt").getter(JobExecutionSummary.getter(JobExecutionSummary::startedAt)).setter(JobExecutionSummary.setter(Builder::startedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startedAt").build()}).build();
    private static final SdkField<Long> LAST_UPDATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("lastUpdatedAt").getter(JobExecutionSummary.getter(JobExecutionSummary::lastUpdatedAt)).setter(JobExecutionSummary.setter(Builder::lastUpdatedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdatedAt").build()}).build();
    private static final SdkField<Long> VERSION_NUMBER_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("versionNumber").getter(JobExecutionSummary.getter(JobExecutionSummary::versionNumber)).setter(JobExecutionSummary.setter(Builder::versionNumber)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("versionNumber").build()}).build();
    private static final SdkField<Long> EXECUTION_NUMBER_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("executionNumber").getter(JobExecutionSummary.getter(JobExecutionSummary::executionNumber)).setter(JobExecutionSummary.setter(Builder::executionNumber)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("executionNumber").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JOB_ID_FIELD, QUEUED_AT_FIELD, STARTED_AT_FIELD, LAST_UPDATED_AT_FIELD, VERSION_NUMBER_FIELD, EXECUTION_NUMBER_FIELD));
    private static final long serialVersionUID = 1L;
    private final String jobId;
    private final Long queuedAt;
    private final Long startedAt;
    private final Long lastUpdatedAt;
    private final Long versionNumber;
    private final Long executionNumber;

    private JobExecutionSummary(BuilderImpl builder) {
        this.jobId = builder.jobId;
        this.queuedAt = builder.queuedAt;
        this.startedAt = builder.startedAt;
        this.lastUpdatedAt = builder.lastUpdatedAt;
        this.versionNumber = builder.versionNumber;
        this.executionNumber = builder.executionNumber;
    }

    public String jobId() {
        return this.jobId;
    }

    public Long queuedAt() {
        return this.queuedAt;
    }

    public Long startedAt() {
        return this.startedAt;
    }

    public Long lastUpdatedAt() {
        return this.lastUpdatedAt;
    }

    public Long versionNumber() {
        return this.versionNumber;
    }

    public Long executionNumber() {
        return this.executionNumber;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.jobId());
        hashCode = 31 * hashCode + Objects.hashCode(this.queuedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.startedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.versionNumber());
        hashCode = 31 * hashCode + Objects.hashCode(this.executionNumber());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof JobExecutionSummary)) {
            return false;
        }
        JobExecutionSummary other = (JobExecutionSummary)obj;
        return Objects.equals(this.jobId(), other.jobId()) && Objects.equals(this.queuedAt(), other.queuedAt()) && Objects.equals(this.startedAt(), other.startedAt()) && Objects.equals(this.lastUpdatedAt(), other.lastUpdatedAt()) && Objects.equals(this.versionNumber(), other.versionNumber()) && Objects.equals(this.executionNumber(), other.executionNumber());
    }

    public String toString() {
        return ToString.builder((String)"JobExecutionSummary").add("JobId", (Object)this.jobId()).add("QueuedAt", (Object)this.queuedAt()).add("StartedAt", (Object)this.startedAt()).add("LastUpdatedAt", (Object)this.lastUpdatedAt()).add("VersionNumber", (Object)this.versionNumber()).add("ExecutionNumber", (Object)this.executionNumber()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "jobId": {
                return Optional.ofNullable(clazz.cast(this.jobId()));
            }
            case "queuedAt": {
                return Optional.ofNullable(clazz.cast(this.queuedAt()));
            }
            case "startedAt": {
                return Optional.ofNullable(clazz.cast(this.startedAt()));
            }
            case "lastUpdatedAt": {
                return Optional.ofNullable(clazz.cast(this.lastUpdatedAt()));
            }
            case "versionNumber": {
                return Optional.ofNullable(clazz.cast(this.versionNumber()));
            }
            case "executionNumber": {
                return Optional.ofNullable(clazz.cast(this.executionNumber()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<JobExecutionSummary, T> g) {
        return obj -> g.apply((JobExecutionSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String jobId;
        private Long queuedAt;
        private Long startedAt;
        private Long lastUpdatedAt;
        private Long versionNumber;
        private Long executionNumber;

        private BuilderImpl() {
        }

        private BuilderImpl(JobExecutionSummary model) {
            this.jobId(model.jobId);
            this.queuedAt(model.queuedAt);
            this.startedAt(model.startedAt);
            this.lastUpdatedAt(model.lastUpdatedAt);
            this.versionNumber(model.versionNumber);
            this.executionNumber(model.executionNumber);
        }

        public final String getJobId() {
            return this.jobId;
        }

        @Override
        public final Builder jobId(String jobId) {
            this.jobId = jobId;
            return this;
        }

        public final void setJobId(String jobId) {
            this.jobId = jobId;
        }

        public final Long getQueuedAt() {
            return this.queuedAt;
        }

        @Override
        public final Builder queuedAt(Long queuedAt) {
            this.queuedAt = queuedAt;
            return this;
        }

        public final void setQueuedAt(Long queuedAt) {
            this.queuedAt = queuedAt;
        }

        public final Long getStartedAt() {
            return this.startedAt;
        }

        @Override
        public final Builder startedAt(Long startedAt) {
            this.startedAt = startedAt;
            return this;
        }

        public final void setStartedAt(Long startedAt) {
            this.startedAt = startedAt;
        }

        public final Long getLastUpdatedAt() {
            return this.lastUpdatedAt;
        }

        @Override
        public final Builder lastUpdatedAt(Long lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
            return this;
        }

        public final void setLastUpdatedAt(Long lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
        }

        public final Long getVersionNumber() {
            return this.versionNumber;
        }

        @Override
        public final Builder versionNumber(Long versionNumber) {
            this.versionNumber = versionNumber;
            return this;
        }

        public final void setVersionNumber(Long versionNumber) {
            this.versionNumber = versionNumber;
        }

        public final Long getExecutionNumber() {
            return this.executionNumber;
        }

        @Override
        public final Builder executionNumber(Long executionNumber) {
            this.executionNumber = executionNumber;
            return this;
        }

        public final void setExecutionNumber(Long executionNumber) {
            this.executionNumber = executionNumber;
        }

        public JobExecutionSummary build() {
            return new JobExecutionSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, JobExecutionSummary> {
        public Builder jobId(String var1);

        public Builder queuedAt(Long var1);

        public Builder startedAt(Long var1);

        public Builder lastUpdatedAt(Long var1);

        public Builder versionNumber(Long var1);

        public Builder executionNumber(Long var1);
    }
}

