/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotfleetwise.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.iotfleetwise.model.IoTFleetWiseRequest;
import software.amazon.awssdk.services.iotfleetwise.model.ManifestStatus;
import software.amazon.awssdk.services.iotfleetwise.model.NodePathsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateModelManifestRequest
extends IoTFleetWiseRequest
implements ToCopyableBuilder<Builder, UpdateModelManifestRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(UpdateModelManifestRequest.getter(UpdateModelManifestRequest::name)).setter(UpdateModelManifestRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(UpdateModelManifestRequest.getter(UpdateModelManifestRequest::description)).setter(UpdateModelManifestRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<List<String>> NODES_TO_ADD_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("nodesToAdd").getter(UpdateModelManifestRequest.getter(UpdateModelManifestRequest::nodesToAdd)).setter(UpdateModelManifestRequest.setter(Builder::nodesToAdd)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nodesToAdd").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> NODES_TO_REMOVE_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("nodesToRemove").getter(UpdateModelManifestRequest.getter(UpdateModelManifestRequest::nodesToRemove)).setter(UpdateModelManifestRequest.setter(Builder::nodesToRemove)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nodesToRemove").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(UpdateModelManifestRequest.getter(UpdateModelManifestRequest::statusAsString)).setter(UpdateModelManifestRequest.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, DESCRIPTION_FIELD, NODES_TO_ADD_FIELD, NODES_TO_REMOVE_FIELD, STATUS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateModelManifestRequest.memberNameToFieldInitializer();
    private final String name;
    private final String description;
    private final List<String> nodesToAdd;
    private final List<String> nodesToRemove;
    private final String status;

    private UpdateModelManifestRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.description = builder.description;
        this.nodesToAdd = builder.nodesToAdd;
        this.nodesToRemove = builder.nodesToRemove;
        this.status = builder.status;
    }

    public final String name() {
        return this.name;
    }

    public final String description() {
        return this.description;
    }

    public final boolean hasNodesToAdd() {
        return this.nodesToAdd != null && !(this.nodesToAdd instanceof SdkAutoConstructList);
    }

    public final List<String> nodesToAdd() {
        return this.nodesToAdd;
    }

    public final boolean hasNodesToRemove() {
        return this.nodesToRemove != null && !(this.nodesToRemove instanceof SdkAutoConstructList);
    }

    public final List<String> nodesToRemove() {
        return this.nodesToRemove;
    }

    public final ManifestStatus status() {
        return ManifestStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasNodesToAdd() ? this.nodesToAdd() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasNodesToRemove() ? this.nodesToRemove() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateModelManifestRequest)) {
            return false;
        }
        UpdateModelManifestRequest other = (UpdateModelManifestRequest)((Object)obj);
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.description(), other.description()) && this.hasNodesToAdd() == other.hasNodesToAdd() && Objects.equals(this.nodesToAdd(), other.nodesToAdd()) && this.hasNodesToRemove() == other.hasNodesToRemove() && Objects.equals(this.nodesToRemove(), other.nodesToRemove()) && Objects.equals(this.statusAsString(), other.statusAsString());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateModelManifestRequest").add("Name", (Object)this.name()).add("Description", (Object)this.description()).add("NodesToAdd", this.hasNodesToAdd() ? this.nodesToAdd() : null).add("NodesToRemove", this.hasNodesToRemove() ? this.nodesToRemove() : null).add("Status", (Object)this.statusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "nodesToAdd": {
                return Optional.ofNullable(clazz.cast(this.nodesToAdd()));
            }
            case "nodesToRemove": {
                return Optional.ofNullable(clazz.cast(this.nodesToRemove()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("name", NAME_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("nodesToAdd", NODES_TO_ADD_FIELD);
        map.put("nodesToRemove", NODES_TO_REMOVE_FIELD);
        map.put("status", STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateModelManifestRequest, T> g) {
        return obj -> g.apply((UpdateModelManifestRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IoTFleetWiseRequest.BuilderImpl
    implements Builder {
        private String name;
        private String description;
        private List<String> nodesToAdd = DefaultSdkAutoConstructList.getInstance();
        private List<String> nodesToRemove = DefaultSdkAutoConstructList.getInstance();
        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateModelManifestRequest model) {
            super(model);
            this.name(model.name);
            this.description(model.description);
            this.nodesToAdd(model.nodesToAdd);
            this.nodesToRemove(model.nodesToRemove);
            this.status(model.status);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Collection<String> getNodesToAdd() {
            if (this.nodesToAdd instanceof SdkAutoConstructList) {
                return null;
            }
            return this.nodesToAdd;
        }

        public final void setNodesToAdd(Collection<String> nodesToAdd) {
            this.nodesToAdd = NodePathsCopier.copy(nodesToAdd);
        }

        @Override
        public final Builder nodesToAdd(Collection<String> nodesToAdd) {
            this.nodesToAdd = NodePathsCopier.copy(nodesToAdd);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder nodesToAdd(String ... nodesToAdd) {
            this.nodesToAdd(Arrays.asList(nodesToAdd));
            return this;
        }

        public final Collection<String> getNodesToRemove() {
            if (this.nodesToRemove instanceof SdkAutoConstructList) {
                return null;
            }
            return this.nodesToRemove;
        }

        public final void setNodesToRemove(Collection<String> nodesToRemove) {
            this.nodesToRemove = NodePathsCopier.copy(nodesToRemove);
        }

        @Override
        public final Builder nodesToRemove(Collection<String> nodesToRemove) {
            this.nodesToRemove = NodePathsCopier.copy(nodesToRemove);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder nodesToRemove(String ... nodesToRemove) {
            this.nodesToRemove(Arrays.asList(nodesToRemove));
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ManifestStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateModelManifestRequest build() {
            return new UpdateModelManifestRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends IoTFleetWiseRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateModelManifestRequest> {
        public Builder name(String var1);

        public Builder description(String var1);

        public Builder nodesToAdd(Collection<String> var1);

        public Builder nodesToAdd(String ... var1);

        public Builder nodesToRemove(Collection<String> var1);

        public Builder nodesToRemove(String ... var1);

        public Builder status(String var1);

        public Builder status(ManifestStatus var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

