/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotfleetwise.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.iotfleetwise.model.CampaignStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CampaignSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CampaignSummary> {
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("arn").getter(CampaignSummary.getter(CampaignSummary::arn)).setter(CampaignSummary.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(CampaignSummary.getter(CampaignSummary::name)).setter(CampaignSummary.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(CampaignSummary.getter(CampaignSummary::description)).setter(CampaignSummary.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<String> SIGNAL_CATALOG_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("signalCatalogArn").getter(CampaignSummary.getter(CampaignSummary::signalCatalogArn)).setter(CampaignSummary.setter(Builder::signalCatalogArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("signalCatalogArn").build()}).build();
    private static final SdkField<String> TARGET_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("targetArn").getter(CampaignSummary.getter(CampaignSummary::targetArn)).setter(CampaignSummary.setter(Builder::targetArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetArn").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(CampaignSummary.getter(CampaignSummary::statusAsString)).setter(CampaignSummary.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("creationTime").getter(CampaignSummary.getter(CampaignSummary::creationTime)).setter(CampaignSummary.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationTime").build()}).build();
    private static final SdkField<Instant> LAST_MODIFICATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("lastModificationTime").getter(CampaignSummary.getter(CampaignSummary::lastModificationTime)).setter(CampaignSummary.setter(Builder::lastModificationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastModificationTime").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, NAME_FIELD, DESCRIPTION_FIELD, SIGNAL_CATALOG_ARN_FIELD, TARGET_ARN_FIELD, STATUS_FIELD, CREATION_TIME_FIELD, LAST_MODIFICATION_TIME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CampaignSummary.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String arn;
    private final String name;
    private final String description;
    private final String signalCatalogArn;
    private final String targetArn;
    private final String status;
    private final Instant creationTime;
    private final Instant lastModificationTime;

    private CampaignSummary(BuilderImpl builder) {
        this.arn = builder.arn;
        this.name = builder.name;
        this.description = builder.description;
        this.signalCatalogArn = builder.signalCatalogArn;
        this.targetArn = builder.targetArn;
        this.status = builder.status;
        this.creationTime = builder.creationTime;
        this.lastModificationTime = builder.lastModificationTime;
    }

    public final String arn() {
        return this.arn;
    }

    public final String name() {
        return this.name;
    }

    public final String description() {
        return this.description;
    }

    public final String signalCatalogArn() {
        return this.signalCatalogArn;
    }

    public final String targetArn() {
        return this.targetArn;
    }

    public final CampaignStatus status() {
        return CampaignStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final Instant creationTime() {
        return this.creationTime;
    }

    public final Instant lastModificationTime() {
        return this.lastModificationTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.signalCatalogArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModificationTime());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CampaignSummary)) {
            return false;
        }
        CampaignSummary other = (CampaignSummary)obj;
        return Objects.equals(this.arn(), other.arn()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.signalCatalogArn(), other.signalCatalogArn()) && Objects.equals(this.targetArn(), other.targetArn()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.lastModificationTime(), other.lastModificationTime());
    }

    public final String toString() {
        return ToString.builder((String)"CampaignSummary").add("Arn", (Object)this.arn()).add("Name", (Object)this.name()).add("Description", (Object)this.description()).add("SignalCatalogArn", (Object)this.signalCatalogArn()).add("TargetArn", (Object)this.targetArn()).add("Status", (Object)this.statusAsString()).add("CreationTime", (Object)this.creationTime()).add("LastModificationTime", (Object)this.lastModificationTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "signalCatalogArn": {
                return Optional.ofNullable(clazz.cast(this.signalCatalogArn()));
            }
            case "targetArn": {
                return Optional.ofNullable(clazz.cast(this.targetArn()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "creationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "lastModificationTime": {
                return Optional.ofNullable(clazz.cast(this.lastModificationTime()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("arn", ARN_FIELD);
        map.put("name", NAME_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("signalCatalogArn", SIGNAL_CATALOG_ARN_FIELD);
        map.put("targetArn", TARGET_ARN_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("creationTime", CREATION_TIME_FIELD);
        map.put("lastModificationTime", LAST_MODIFICATION_TIME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CampaignSummary, T> g) {
        return obj -> g.apply((CampaignSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String arn;
        private String name;
        private String description;
        private String signalCatalogArn;
        private String targetArn;
        private String status;
        private Instant creationTime;
        private Instant lastModificationTime;

        private BuilderImpl() {
        }

        private BuilderImpl(CampaignSummary model) {
            this.arn(model.arn);
            this.name(model.name);
            this.description(model.description);
            this.signalCatalogArn(model.signalCatalogArn);
            this.targetArn(model.targetArn);
            this.status(model.status);
            this.creationTime(model.creationTime);
            this.lastModificationTime(model.lastModificationTime);
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getSignalCatalogArn() {
            return this.signalCatalogArn;
        }

        public final void setSignalCatalogArn(String signalCatalogArn) {
            this.signalCatalogArn = signalCatalogArn;
        }

        @Override
        public final Builder signalCatalogArn(String signalCatalogArn) {
            this.signalCatalogArn = signalCatalogArn;
            return this;
        }

        public final String getTargetArn() {
            return this.targetArn;
        }

        public final void setTargetArn(String targetArn) {
            this.targetArn = targetArn;
        }

        @Override
        public final Builder targetArn(String targetArn) {
            this.targetArn = targetArn;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(CampaignStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final Instant getLastModificationTime() {
            return this.lastModificationTime;
        }

        public final void setLastModificationTime(Instant lastModificationTime) {
            this.lastModificationTime = lastModificationTime;
        }

        @Override
        public final Builder lastModificationTime(Instant lastModificationTime) {
            this.lastModificationTime = lastModificationTime;
            return this;
        }

        public CampaignSummary build() {
            return new CampaignSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CampaignSummary> {
        public Builder arn(String var1);

        public Builder name(String var1);

        public Builder description(String var1);

        public Builder signalCatalogArn(String var1);

        public Builder targetArn(String var1);

        public Builder status(String var1);

        public Builder status(CampaignStatus var1);

        public Builder creationTime(Instant var1);

        public Builder lastModificationTime(Instant var1);
    }
}

