/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotfleetwise.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SignalInformation
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SignalInformation> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(SignalInformation.getter(SignalInformation::name)).setter(SignalInformation.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<Long> MAX_SAMPLE_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("maxSampleCount").getter(SignalInformation.getter(SignalInformation::maxSampleCount)).setter(SignalInformation.setter(Builder::maxSampleCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxSampleCount").build()}).build();
    private static final SdkField<Long> MINIMUM_SAMPLING_INTERVAL_MS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("minimumSamplingIntervalMs").getter(SignalInformation.getter(SignalInformation::minimumSamplingIntervalMs)).setter(SignalInformation.setter(Builder::minimumSamplingIntervalMs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("minimumSamplingIntervalMs").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, MAX_SAMPLE_COUNT_FIELD, MINIMUM_SAMPLING_INTERVAL_MS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("name", NAME_FIELD);
            this.put("maxSampleCount", MAX_SAMPLE_COUNT_FIELD);
            this.put("minimumSamplingIntervalMs", MINIMUM_SAMPLING_INTERVAL_MS_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String name;
    private final Long maxSampleCount;
    private final Long minimumSamplingIntervalMs;

    private SignalInformation(BuilderImpl builder) {
        this.name = builder.name;
        this.maxSampleCount = builder.maxSampleCount;
        this.minimumSamplingIntervalMs = builder.minimumSamplingIntervalMs;
    }

    public final String name() {
        return this.name;
    }

    public final Long maxSampleCount() {
        return this.maxSampleCount;
    }

    public final Long minimumSamplingIntervalMs() {
        return this.minimumSamplingIntervalMs;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxSampleCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.minimumSamplingIntervalMs());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SignalInformation)) {
            return false;
        }
        SignalInformation other = (SignalInformation)obj;
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.maxSampleCount(), other.maxSampleCount()) && Objects.equals(this.minimumSamplingIntervalMs(), other.minimumSamplingIntervalMs());
    }

    public final String toString() {
        return ToString.builder((String)"SignalInformation").add("Name", (Object)this.name()).add("MaxSampleCount", (Object)this.maxSampleCount()).add("MinimumSamplingIntervalMs", (Object)this.minimumSamplingIntervalMs()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "maxSampleCount": {
                return Optional.ofNullable(clazz.cast(this.maxSampleCount()));
            }
            case "minimumSamplingIntervalMs": {
                return Optional.ofNullable(clazz.cast(this.minimumSamplingIntervalMs()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<SignalInformation, T> g) {
        return obj -> g.apply((SignalInformation)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private Long maxSampleCount;
        private Long minimumSamplingIntervalMs;

        private BuilderImpl() {
        }

        private BuilderImpl(SignalInformation model) {
            this.name(model.name);
            this.maxSampleCount(model.maxSampleCount);
            this.minimumSamplingIntervalMs(model.minimumSamplingIntervalMs);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final Long getMaxSampleCount() {
            return this.maxSampleCount;
        }

        public final void setMaxSampleCount(Long maxSampleCount) {
            this.maxSampleCount = maxSampleCount;
        }

        @Override
        public final Builder maxSampleCount(Long maxSampleCount) {
            this.maxSampleCount = maxSampleCount;
            return this;
        }

        public final Long getMinimumSamplingIntervalMs() {
            return this.minimumSamplingIntervalMs;
        }

        public final void setMinimumSamplingIntervalMs(Long minimumSamplingIntervalMs) {
            this.minimumSamplingIntervalMs = minimumSamplingIntervalMs;
        }

        @Override
        public final Builder minimumSamplingIntervalMs(Long minimumSamplingIntervalMs) {
            this.minimumSamplingIntervalMs = minimumSamplingIntervalMs;
            return this;
        }

        public SignalInformation build() {
            return new SignalInformation(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SignalInformation> {
        public Builder name(String var1);

        public Builder maxSampleCount(Long var1);

        public Builder minimumSamplingIntervalMs(Long var1);
    }
}

