/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotfleetwise.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.iotfleetwise.model.CollectionScheme;
import software.amazon.awssdk.services.iotfleetwise.model.Compression;
import software.amazon.awssdk.services.iotfleetwise.model.DataDestinationConfig;
import software.amazon.awssdk.services.iotfleetwise.model.DataDestinationConfigsCopier;
import software.amazon.awssdk.services.iotfleetwise.model.DataExtraDimensionNodePathListCopier;
import software.amazon.awssdk.services.iotfleetwise.model.DiagnosticsMode;
import software.amazon.awssdk.services.iotfleetwise.model.IoTFleetWiseRequest;
import software.amazon.awssdk.services.iotfleetwise.model.SignalInformation;
import software.amazon.awssdk.services.iotfleetwise.model.SignalInformationListCopier;
import software.amazon.awssdk.services.iotfleetwise.model.SpoolingMode;
import software.amazon.awssdk.services.iotfleetwise.model.Tag;
import software.amazon.awssdk.services.iotfleetwise.model.TagListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateCampaignRequest
extends IoTFleetWiseRequest
implements ToCopyableBuilder<Builder, CreateCampaignRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(CreateCampaignRequest.getter(CreateCampaignRequest::name)).setter(CreateCampaignRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(CreateCampaignRequest.getter(CreateCampaignRequest::description)).setter(CreateCampaignRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<String> SIGNAL_CATALOG_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("signalCatalogArn").getter(CreateCampaignRequest.getter(CreateCampaignRequest::signalCatalogArn)).setter(CreateCampaignRequest.setter(Builder::signalCatalogArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("signalCatalogArn").build()}).build();
    private static final SdkField<String> TARGET_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("targetArn").getter(CreateCampaignRequest.getter(CreateCampaignRequest::targetArn)).setter(CreateCampaignRequest.setter(Builder::targetArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetArn").build()}).build();
    private static final SdkField<Instant> START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("startTime").getter(CreateCampaignRequest.getter(CreateCampaignRequest::startTime)).setter(CreateCampaignRequest.setter(Builder::startTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startTime").build()}).build();
    private static final SdkField<Instant> EXPIRY_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("expiryTime").getter(CreateCampaignRequest.getter(CreateCampaignRequest::expiryTime)).setter(CreateCampaignRequest.setter(Builder::expiryTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("expiryTime").build()}).build();
    private static final SdkField<Long> POST_TRIGGER_COLLECTION_DURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("postTriggerCollectionDuration").getter(CreateCampaignRequest.getter(CreateCampaignRequest::postTriggerCollectionDuration)).setter(CreateCampaignRequest.setter(Builder::postTriggerCollectionDuration)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("postTriggerCollectionDuration").build()}).build();
    private static final SdkField<String> DIAGNOSTICS_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("diagnosticsMode").getter(CreateCampaignRequest.getter(CreateCampaignRequest::diagnosticsModeAsString)).setter(CreateCampaignRequest.setter(Builder::diagnosticsMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("diagnosticsMode").build()}).build();
    private static final SdkField<String> SPOOLING_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("spoolingMode").getter(CreateCampaignRequest.getter(CreateCampaignRequest::spoolingModeAsString)).setter(CreateCampaignRequest.setter(Builder::spoolingMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("spoolingMode").build()}).build();
    private static final SdkField<String> COMPRESSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("compression").getter(CreateCampaignRequest.getter(CreateCampaignRequest::compressionAsString)).setter(CreateCampaignRequest.setter(Builder::compression)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("compression").build()}).build();
    private static final SdkField<Integer> PRIORITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("priority").getter(CreateCampaignRequest.getter(CreateCampaignRequest::priority)).setter(CreateCampaignRequest.setter(Builder::priority)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("priority").build()}).build();
    private static final SdkField<List<SignalInformation>> SIGNALS_TO_COLLECT_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("signalsToCollect").getter(CreateCampaignRequest.getter(CreateCampaignRequest::signalsToCollect)).setter(CreateCampaignRequest.setter(Builder::signalsToCollect)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("signalsToCollect").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SignalInformation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<CollectionScheme> COLLECTION_SCHEME_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("collectionScheme").getter(CreateCampaignRequest.getter(CreateCampaignRequest::collectionScheme)).setter(CreateCampaignRequest.setter(Builder::collectionScheme)).constructor(CollectionScheme::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("collectionScheme").build()}).build();
    private static final SdkField<List<String>> DATA_EXTRA_DIMENSIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("dataExtraDimensions").getter(CreateCampaignRequest.getter(CreateCampaignRequest::dataExtraDimensions)).setter(CreateCampaignRequest.setter(Builder::dataExtraDimensions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataExtraDimensions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("tags").getter(CreateCampaignRequest.getter(CreateCampaignRequest::tags)).setter(CreateCampaignRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<DataDestinationConfig>> DATA_DESTINATION_CONFIGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("dataDestinationConfigs").getter(CreateCampaignRequest.getter(CreateCampaignRequest::dataDestinationConfigs)).setter(CreateCampaignRequest.setter(Builder::dataDestinationConfigs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataDestinationConfigs").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DataDestinationConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, DESCRIPTION_FIELD, SIGNAL_CATALOG_ARN_FIELD, TARGET_ARN_FIELD, START_TIME_FIELD, EXPIRY_TIME_FIELD, POST_TRIGGER_COLLECTION_DURATION_FIELD, DIAGNOSTICS_MODE_FIELD, SPOOLING_MODE_FIELD, COMPRESSION_FIELD, PRIORITY_FIELD, SIGNALS_TO_COLLECT_FIELD, COLLECTION_SCHEME_FIELD, DATA_EXTRA_DIMENSIONS_FIELD, TAGS_FIELD, DATA_DESTINATION_CONFIGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("name", NAME_FIELD);
            this.put("description", DESCRIPTION_FIELD);
            this.put("signalCatalogArn", SIGNAL_CATALOG_ARN_FIELD);
            this.put("targetArn", TARGET_ARN_FIELD);
            this.put("startTime", START_TIME_FIELD);
            this.put("expiryTime", EXPIRY_TIME_FIELD);
            this.put("postTriggerCollectionDuration", POST_TRIGGER_COLLECTION_DURATION_FIELD);
            this.put("diagnosticsMode", DIAGNOSTICS_MODE_FIELD);
            this.put("spoolingMode", SPOOLING_MODE_FIELD);
            this.put("compression", COMPRESSION_FIELD);
            this.put("priority", PRIORITY_FIELD);
            this.put("signalsToCollect", SIGNALS_TO_COLLECT_FIELD);
            this.put("collectionScheme", COLLECTION_SCHEME_FIELD);
            this.put("dataExtraDimensions", DATA_EXTRA_DIMENSIONS_FIELD);
            this.put("tags", TAGS_FIELD);
            this.put("dataDestinationConfigs", DATA_DESTINATION_CONFIGS_FIELD);
        }
    });
    private final String name;
    private final String description;
    private final String signalCatalogArn;
    private final String targetArn;
    private final Instant startTime;
    private final Instant expiryTime;
    private final Long postTriggerCollectionDuration;
    private final String diagnosticsMode;
    private final String spoolingMode;
    private final String compression;
    private final Integer priority;
    private final List<SignalInformation> signalsToCollect;
    private final CollectionScheme collectionScheme;
    private final List<String> dataExtraDimensions;
    private final List<Tag> tags;
    private final List<DataDestinationConfig> dataDestinationConfigs;

    private CreateCampaignRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.description = builder.description;
        this.signalCatalogArn = builder.signalCatalogArn;
        this.targetArn = builder.targetArn;
        this.startTime = builder.startTime;
        this.expiryTime = builder.expiryTime;
        this.postTriggerCollectionDuration = builder.postTriggerCollectionDuration;
        this.diagnosticsMode = builder.diagnosticsMode;
        this.spoolingMode = builder.spoolingMode;
        this.compression = builder.compression;
        this.priority = builder.priority;
        this.signalsToCollect = builder.signalsToCollect;
        this.collectionScheme = builder.collectionScheme;
        this.dataExtraDimensions = builder.dataExtraDimensions;
        this.tags = builder.tags;
        this.dataDestinationConfigs = builder.dataDestinationConfigs;
    }

    public final String name() {
        return this.name;
    }

    public final String description() {
        return this.description;
    }

    public final String signalCatalogArn() {
        return this.signalCatalogArn;
    }

    public final String targetArn() {
        return this.targetArn;
    }

    public final Instant startTime() {
        return this.startTime;
    }

    public final Instant expiryTime() {
        return this.expiryTime;
    }

    public final Long postTriggerCollectionDuration() {
        return this.postTriggerCollectionDuration;
    }

    public final DiagnosticsMode diagnosticsMode() {
        return DiagnosticsMode.fromValue(this.diagnosticsMode);
    }

    public final String diagnosticsModeAsString() {
        return this.diagnosticsMode;
    }

    public final SpoolingMode spoolingMode() {
        return SpoolingMode.fromValue(this.spoolingMode);
    }

    public final String spoolingModeAsString() {
        return this.spoolingMode;
    }

    public final Compression compression() {
        return Compression.fromValue(this.compression);
    }

    public final String compressionAsString() {
        return this.compression;
    }

    @Deprecated
    public final Integer priority() {
        return this.priority;
    }

    public final boolean hasSignalsToCollect() {
        return this.signalsToCollect != null && !(this.signalsToCollect instanceof SdkAutoConstructList);
    }

    public final List<SignalInformation> signalsToCollect() {
        return this.signalsToCollect;
    }

    public final CollectionScheme collectionScheme() {
        return this.collectionScheme;
    }

    public final boolean hasDataExtraDimensions() {
        return this.dataExtraDimensions != null && !(this.dataExtraDimensions instanceof SdkAutoConstructList);
    }

    public final List<String> dataExtraDimensions() {
        return this.dataExtraDimensions;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    public final boolean hasDataDestinationConfigs() {
        return this.dataDestinationConfigs != null && !(this.dataDestinationConfigs instanceof SdkAutoConstructList);
    }

    public final List<DataDestinationConfig> dataDestinationConfigs() {
        return this.dataDestinationConfigs;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.signalCatalogArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.startTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.expiryTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.postTriggerCollectionDuration());
        hashCode = 31 * hashCode + Objects.hashCode(this.diagnosticsModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.spoolingModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.compressionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.priority());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSignalsToCollect() ? this.signalsToCollect() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.collectionScheme());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDataExtraDimensions() ? this.dataExtraDimensions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDataDestinationConfigs() ? this.dataDestinationConfigs() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateCampaignRequest)) {
            return false;
        }
        CreateCampaignRequest other = (CreateCampaignRequest)((Object)obj);
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.signalCatalogArn(), other.signalCatalogArn()) && Objects.equals(this.targetArn(), other.targetArn()) && Objects.equals(this.startTime(), other.startTime()) && Objects.equals(this.expiryTime(), other.expiryTime()) && Objects.equals(this.postTriggerCollectionDuration(), other.postTriggerCollectionDuration()) && Objects.equals(this.diagnosticsModeAsString(), other.diagnosticsModeAsString()) && Objects.equals(this.spoolingModeAsString(), other.spoolingModeAsString()) && Objects.equals(this.compressionAsString(), other.compressionAsString()) && Objects.equals(this.priority(), other.priority()) && this.hasSignalsToCollect() == other.hasSignalsToCollect() && Objects.equals(this.signalsToCollect(), other.signalsToCollect()) && Objects.equals(this.collectionScheme(), other.collectionScheme()) && this.hasDataExtraDimensions() == other.hasDataExtraDimensions() && Objects.equals(this.dataExtraDimensions(), other.dataExtraDimensions()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && this.hasDataDestinationConfigs() == other.hasDataDestinationConfigs() && Objects.equals(this.dataDestinationConfigs(), other.dataDestinationConfigs());
    }

    public final String toString() {
        return ToString.builder((String)"CreateCampaignRequest").add("Name", (Object)this.name()).add("Description", (Object)this.description()).add("SignalCatalogArn", (Object)this.signalCatalogArn()).add("TargetArn", (Object)this.targetArn()).add("StartTime", (Object)this.startTime()).add("ExpiryTime", (Object)this.expiryTime()).add("PostTriggerCollectionDuration", (Object)this.postTriggerCollectionDuration()).add("DiagnosticsMode", (Object)this.diagnosticsModeAsString()).add("SpoolingMode", (Object)this.spoolingModeAsString()).add("Compression", (Object)this.compressionAsString()).add("Priority", (Object)this.priority()).add("SignalsToCollect", (Object)(this.signalsToCollect() == null ? null : "*** Sensitive Data Redacted ***")).add("CollectionScheme", (Object)this.collectionScheme()).add("DataExtraDimensions", (Object)(this.dataExtraDimensions() == null ? null : "*** Sensitive Data Redacted ***")).add("Tags", this.hasTags() ? this.tags() : null).add("DataDestinationConfigs", this.hasDataDestinationConfigs() ? this.dataDestinationConfigs() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "signalCatalogArn": {
                return Optional.ofNullable(clazz.cast(this.signalCatalogArn()));
            }
            case "targetArn": {
                return Optional.ofNullable(clazz.cast(this.targetArn()));
            }
            case "startTime": {
                return Optional.ofNullable(clazz.cast(this.startTime()));
            }
            case "expiryTime": {
                return Optional.ofNullable(clazz.cast(this.expiryTime()));
            }
            case "postTriggerCollectionDuration": {
                return Optional.ofNullable(clazz.cast(this.postTriggerCollectionDuration()));
            }
            case "diagnosticsMode": {
                return Optional.ofNullable(clazz.cast(this.diagnosticsModeAsString()));
            }
            case "spoolingMode": {
                return Optional.ofNullable(clazz.cast(this.spoolingModeAsString()));
            }
            case "compression": {
                return Optional.ofNullable(clazz.cast(this.compressionAsString()));
            }
            case "priority": {
                return Optional.ofNullable(clazz.cast(this.priority()));
            }
            case "signalsToCollect": {
                return Optional.ofNullable(clazz.cast(this.signalsToCollect()));
            }
            case "collectionScheme": {
                return Optional.ofNullable(clazz.cast(this.collectionScheme()));
            }
            case "dataExtraDimensions": {
                return Optional.ofNullable(clazz.cast(this.dataExtraDimensions()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "dataDestinationConfigs": {
                return Optional.ofNullable(clazz.cast(this.dataDestinationConfigs()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<CreateCampaignRequest, T> g) {
        return obj -> g.apply((CreateCampaignRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IoTFleetWiseRequest.BuilderImpl
    implements Builder {
        private String name;
        private String description;
        private String signalCatalogArn;
        private String targetArn;
        private Instant startTime;
        private Instant expiryTime;
        private Long postTriggerCollectionDuration;
        private String diagnosticsMode;
        private String spoolingMode;
        private String compression;
        private Integer priority;
        private List<SignalInformation> signalsToCollect = DefaultSdkAutoConstructList.getInstance();
        private CollectionScheme collectionScheme;
        private List<String> dataExtraDimensions = DefaultSdkAutoConstructList.getInstance();
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();
        private List<DataDestinationConfig> dataDestinationConfigs = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateCampaignRequest model) {
            super(model);
            this.name(model.name);
            this.description(model.description);
            this.signalCatalogArn(model.signalCatalogArn);
            this.targetArn(model.targetArn);
            this.startTime(model.startTime);
            this.expiryTime(model.expiryTime);
            this.postTriggerCollectionDuration(model.postTriggerCollectionDuration);
            this.diagnosticsMode(model.diagnosticsMode);
            this.spoolingMode(model.spoolingMode);
            this.compression(model.compression);
            this.priority(model.priority);
            this.signalsToCollect(model.signalsToCollect);
            this.collectionScheme(model.collectionScheme);
            this.dataExtraDimensions(model.dataExtraDimensions);
            this.tags(model.tags);
            this.dataDestinationConfigs(model.dataDestinationConfigs);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getSignalCatalogArn() {
            return this.signalCatalogArn;
        }

        public final void setSignalCatalogArn(String signalCatalogArn) {
            this.signalCatalogArn = signalCatalogArn;
        }

        @Override
        public final Builder signalCatalogArn(String signalCatalogArn) {
            this.signalCatalogArn = signalCatalogArn;
            return this;
        }

        public final String getTargetArn() {
            return this.targetArn;
        }

        public final void setTargetArn(String targetArn) {
            this.targetArn = targetArn;
        }

        @Override
        public final Builder targetArn(String targetArn) {
            this.targetArn = targetArn;
            return this;
        }

        public final Instant getStartTime() {
            return this.startTime;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final Instant getExpiryTime() {
            return this.expiryTime;
        }

        public final void setExpiryTime(Instant expiryTime) {
            this.expiryTime = expiryTime;
        }

        @Override
        public final Builder expiryTime(Instant expiryTime) {
            this.expiryTime = expiryTime;
            return this;
        }

        public final Long getPostTriggerCollectionDuration() {
            return this.postTriggerCollectionDuration;
        }

        public final void setPostTriggerCollectionDuration(Long postTriggerCollectionDuration) {
            this.postTriggerCollectionDuration = postTriggerCollectionDuration;
        }

        @Override
        public final Builder postTriggerCollectionDuration(Long postTriggerCollectionDuration) {
            this.postTriggerCollectionDuration = postTriggerCollectionDuration;
            return this;
        }

        public final String getDiagnosticsMode() {
            return this.diagnosticsMode;
        }

        public final void setDiagnosticsMode(String diagnosticsMode) {
            this.diagnosticsMode = diagnosticsMode;
        }

        @Override
        public final Builder diagnosticsMode(String diagnosticsMode) {
            this.diagnosticsMode = diagnosticsMode;
            return this;
        }

        @Override
        public final Builder diagnosticsMode(DiagnosticsMode diagnosticsMode) {
            this.diagnosticsMode(diagnosticsMode == null ? null : diagnosticsMode.toString());
            return this;
        }

        public final String getSpoolingMode() {
            return this.spoolingMode;
        }

        public final void setSpoolingMode(String spoolingMode) {
            this.spoolingMode = spoolingMode;
        }

        @Override
        public final Builder spoolingMode(String spoolingMode) {
            this.spoolingMode = spoolingMode;
            return this;
        }

        @Override
        public final Builder spoolingMode(SpoolingMode spoolingMode) {
            this.spoolingMode(spoolingMode == null ? null : spoolingMode.toString());
            return this;
        }

        public final String getCompression() {
            return this.compression;
        }

        public final void setCompression(String compression) {
            this.compression = compression;
        }

        @Override
        public final Builder compression(String compression) {
            this.compression = compression;
            return this;
        }

        @Override
        public final Builder compression(Compression compression) {
            this.compression(compression == null ? null : compression.toString());
            return this;
        }

        @Deprecated
        public final Integer getPriority() {
            return this.priority;
        }

        @Deprecated
        public final void setPriority(Integer priority) {
            this.priority = priority;
        }

        @Override
        @Deprecated
        public final Builder priority(Integer priority) {
            this.priority = priority;
            return this;
        }

        public final List<SignalInformation.Builder> getSignalsToCollect() {
            List<SignalInformation.Builder> result = SignalInformationListCopier.copyToBuilder(this.signalsToCollect);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSignalsToCollect(Collection<SignalInformation.BuilderImpl> signalsToCollect) {
            this.signalsToCollect = SignalInformationListCopier.copyFromBuilder(signalsToCollect);
        }

        @Override
        public final Builder signalsToCollect(Collection<SignalInformation> signalsToCollect) {
            this.signalsToCollect = SignalInformationListCopier.copy(signalsToCollect);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder signalsToCollect(SignalInformation ... signalsToCollect) {
            this.signalsToCollect(Arrays.asList(signalsToCollect));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder signalsToCollect(Consumer<SignalInformation.Builder> ... signalsToCollect) {
            this.signalsToCollect(Stream.of(signalsToCollect).map(c -> (SignalInformation)((SignalInformation.Builder)SignalInformation.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final CollectionScheme.Builder getCollectionScheme() {
            return this.collectionScheme != null ? this.collectionScheme.toBuilder() : null;
        }

        public final void setCollectionScheme(CollectionScheme.BuilderImpl collectionScheme) {
            this.collectionScheme = collectionScheme != null ? collectionScheme.build() : null;
        }

        @Override
        public final Builder collectionScheme(CollectionScheme collectionScheme) {
            this.collectionScheme = collectionScheme;
            return this;
        }

        public final Collection<String> getDataExtraDimensions() {
            if (this.dataExtraDimensions instanceof SdkAutoConstructList) {
                return null;
            }
            return this.dataExtraDimensions;
        }

        public final void setDataExtraDimensions(Collection<String> dataExtraDimensions) {
            this.dataExtraDimensions = DataExtraDimensionNodePathListCopier.copy(dataExtraDimensions);
        }

        @Override
        public final Builder dataExtraDimensions(Collection<String> dataExtraDimensions) {
            this.dataExtraDimensions = DataExtraDimensionNodePathListCopier.copy(dataExtraDimensions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dataExtraDimensions(String ... dataExtraDimensions) {
            this.dataExtraDimensions(Arrays.asList(dataExtraDimensions));
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<DataDestinationConfig.Builder> getDataDestinationConfigs() {
            List<DataDestinationConfig.Builder> result = DataDestinationConfigsCopier.copyToBuilder(this.dataDestinationConfigs);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDataDestinationConfigs(Collection<DataDestinationConfig.BuilderImpl> dataDestinationConfigs) {
            this.dataDestinationConfigs = DataDestinationConfigsCopier.copyFromBuilder(dataDestinationConfigs);
        }

        @Override
        public final Builder dataDestinationConfigs(Collection<DataDestinationConfig> dataDestinationConfigs) {
            this.dataDestinationConfigs = DataDestinationConfigsCopier.copy(dataDestinationConfigs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dataDestinationConfigs(DataDestinationConfig ... dataDestinationConfigs) {
            this.dataDestinationConfigs(Arrays.asList(dataDestinationConfigs));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dataDestinationConfigs(Consumer<DataDestinationConfig.Builder> ... dataDestinationConfigs) {
            this.dataDestinationConfigs(Stream.of(dataDestinationConfigs).map(c -> (DataDestinationConfig)((DataDestinationConfig.Builder)DataDestinationConfig.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateCampaignRequest build() {
            return new CreateCampaignRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends IoTFleetWiseRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateCampaignRequest> {
        public Builder name(String var1);

        public Builder description(String var1);

        public Builder signalCatalogArn(String var1);

        public Builder targetArn(String var1);

        public Builder startTime(Instant var1);

        public Builder expiryTime(Instant var1);

        public Builder postTriggerCollectionDuration(Long var1);

        public Builder diagnosticsMode(String var1);

        public Builder diagnosticsMode(DiagnosticsMode var1);

        public Builder spoolingMode(String var1);

        public Builder spoolingMode(SpoolingMode var1);

        public Builder compression(String var1);

        public Builder compression(Compression var1);

        @Deprecated
        public Builder priority(Integer var1);

        public Builder signalsToCollect(Collection<SignalInformation> var1);

        public Builder signalsToCollect(SignalInformation ... var1);

        public Builder signalsToCollect(Consumer<SignalInformation.Builder> ... var1);

        public Builder collectionScheme(CollectionScheme var1);

        default public Builder collectionScheme(Consumer<CollectionScheme.Builder> collectionScheme) {
            return this.collectionScheme((CollectionScheme)((CollectionScheme.Builder)CollectionScheme.builder().applyMutation(collectionScheme)).build());
        }

        public Builder dataExtraDimensions(Collection<String> var1);

        public Builder dataExtraDimensions(String ... var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder dataDestinationConfigs(Collection<DataDestinationConfig> var1);

        public Builder dataDestinationConfigs(DataDestinationConfig ... var1);

        public Builder dataDestinationConfigs(Consumer<DataDestinationConfig.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

