/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotfleetwise.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.iotfleetwise.model.IoTFleetWiseResponse;
import software.amazon.awssdk.services.iotfleetwise.model.StateTemplateAssociation;
import software.amazon.awssdk.services.iotfleetwise.model.StateTemplateAssociationsCopier;
import software.amazon.awssdk.services.iotfleetwise.model._attributesMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetVehicleResponse
extends IoTFleetWiseResponse
implements ToCopyableBuilder<Builder, GetVehicleResponse> {
    private static final SdkField<String> VEHICLE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("vehicleName").getter(GetVehicleResponse.getter(GetVehicleResponse::vehicleName)).setter(GetVehicleResponse.setter(Builder::vehicleName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vehicleName").build()}).build();
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("arn").getter(GetVehicleResponse.getter(GetVehicleResponse::arn)).setter(GetVehicleResponse.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()}).build();
    private static final SdkField<String> MODEL_MANIFEST_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("modelManifestArn").getter(GetVehicleResponse.getter(GetVehicleResponse::modelManifestArn)).setter(GetVehicleResponse.setter(Builder::modelManifestArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("modelManifestArn").build()}).build();
    private static final SdkField<String> DECODER_MANIFEST_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("decoderManifestArn").getter(GetVehicleResponse.getter(GetVehicleResponse::decoderManifestArn)).setter(GetVehicleResponse.setter(Builder::decoderManifestArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("decoderManifestArn").build()}).build();
    private static final SdkField<Map<String, String>> ATTRIBUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("attributes").getter(GetVehicleResponse.getter(GetVehicleResponse::attributes)).setter(GetVehicleResponse.setter(Builder::attributes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("attributes").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<List<StateTemplateAssociation>> STATE_TEMPLATES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("stateTemplates").getter(GetVehicleResponse.getter(GetVehicleResponse::stateTemplates)).setter(GetVehicleResponse.setter(Builder::stateTemplates)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stateTemplates").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(StateTemplateAssociation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("creationTime").getter(GetVehicleResponse.getter(GetVehicleResponse::creationTime)).setter(GetVehicleResponse.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationTime").build()}).build();
    private static final SdkField<Instant> LAST_MODIFICATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("lastModificationTime").getter(GetVehicleResponse.getter(GetVehicleResponse::lastModificationTime)).setter(GetVehicleResponse.setter(Builder::lastModificationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastModificationTime").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VEHICLE_NAME_FIELD, ARN_FIELD, MODEL_MANIFEST_ARN_FIELD, DECODER_MANIFEST_ARN_FIELD, ATTRIBUTES_FIELD, STATE_TEMPLATES_FIELD, CREATION_TIME_FIELD, LAST_MODIFICATION_TIME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("vehicleName", VEHICLE_NAME_FIELD);
            this.put("arn", ARN_FIELD);
            this.put("modelManifestArn", MODEL_MANIFEST_ARN_FIELD);
            this.put("decoderManifestArn", DECODER_MANIFEST_ARN_FIELD);
            this.put("attributes", ATTRIBUTES_FIELD);
            this.put("stateTemplates", STATE_TEMPLATES_FIELD);
            this.put("creationTime", CREATION_TIME_FIELD);
            this.put("lastModificationTime", LAST_MODIFICATION_TIME_FIELD);
        }
    });
    private final String vehicleName;
    private final String arn;
    private final String modelManifestArn;
    private final String decoderManifestArn;
    private final Map<String, String> attributes;
    private final List<StateTemplateAssociation> stateTemplates;
    private final Instant creationTime;
    private final Instant lastModificationTime;

    private GetVehicleResponse(BuilderImpl builder) {
        super(builder);
        this.vehicleName = builder.vehicleName;
        this.arn = builder.arn;
        this.modelManifestArn = builder.modelManifestArn;
        this.decoderManifestArn = builder.decoderManifestArn;
        this.attributes = builder.attributes;
        this.stateTemplates = builder.stateTemplates;
        this.creationTime = builder.creationTime;
        this.lastModificationTime = builder.lastModificationTime;
    }

    public final String vehicleName() {
        return this.vehicleName;
    }

    public final String arn() {
        return this.arn;
    }

    public final String modelManifestArn() {
        return this.modelManifestArn;
    }

    public final String decoderManifestArn() {
        return this.decoderManifestArn;
    }

    public final boolean hasAttributes() {
        return this.attributes != null && !(this.attributes instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> attributes() {
        return this.attributes;
    }

    public final boolean hasStateTemplates() {
        return this.stateTemplates != null && !(this.stateTemplates instanceof SdkAutoConstructList);
    }

    public final List<StateTemplateAssociation> stateTemplates() {
        return this.stateTemplates;
    }

    public final Instant creationTime() {
        return this.creationTime;
    }

    public final Instant lastModificationTime() {
        return this.lastModificationTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.vehicleName());
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.modelManifestArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.decoderManifestArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAttributes() ? this.attributes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasStateTemplates() ? this.stateTemplates() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModificationTime());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetVehicleResponse)) {
            return false;
        }
        GetVehicleResponse other = (GetVehicleResponse)((Object)obj);
        return Objects.equals(this.vehicleName(), other.vehicleName()) && Objects.equals(this.arn(), other.arn()) && Objects.equals(this.modelManifestArn(), other.modelManifestArn()) && Objects.equals(this.decoderManifestArn(), other.decoderManifestArn()) && this.hasAttributes() == other.hasAttributes() && Objects.equals(this.attributes(), other.attributes()) && this.hasStateTemplates() == other.hasStateTemplates() && Objects.equals(this.stateTemplates(), other.stateTemplates()) && Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.lastModificationTime(), other.lastModificationTime());
    }

    public final String toString() {
        return ToString.builder((String)"GetVehicleResponse").add("VehicleName", (Object)this.vehicleName()).add("Arn", (Object)this.arn()).add("ModelManifestArn", (Object)this.modelManifestArn()).add("DecoderManifestArn", (Object)this.decoderManifestArn()).add("Attributes", this.hasAttributes() ? this.attributes() : null).add("StateTemplates", this.hasStateTemplates() ? this.stateTemplates() : null).add("CreationTime", (Object)this.creationTime()).add("LastModificationTime", (Object)this.lastModificationTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "vehicleName": {
                return Optional.ofNullable(clazz.cast(this.vehicleName()));
            }
            case "arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "modelManifestArn": {
                return Optional.ofNullable(clazz.cast(this.modelManifestArn()));
            }
            case "decoderManifestArn": {
                return Optional.ofNullable(clazz.cast(this.decoderManifestArn()));
            }
            case "attributes": {
                return Optional.ofNullable(clazz.cast(this.attributes()));
            }
            case "stateTemplates": {
                return Optional.ofNullable(clazz.cast(this.stateTemplates()));
            }
            case "creationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "lastModificationTime": {
                return Optional.ofNullable(clazz.cast(this.lastModificationTime()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<GetVehicleResponse, T> g) {
        return obj -> g.apply((GetVehicleResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IoTFleetWiseResponse.BuilderImpl
    implements Builder {
        private String vehicleName;
        private String arn;
        private String modelManifestArn;
        private String decoderManifestArn;
        private Map<String, String> attributes = DefaultSdkAutoConstructMap.getInstance();
        private List<StateTemplateAssociation> stateTemplates = DefaultSdkAutoConstructList.getInstance();
        private Instant creationTime;
        private Instant lastModificationTime;

        private BuilderImpl() {
        }

        private BuilderImpl(GetVehicleResponse model) {
            super(model);
            this.vehicleName(model.vehicleName);
            this.arn(model.arn);
            this.modelManifestArn(model.modelManifestArn);
            this.decoderManifestArn(model.decoderManifestArn);
            this.attributes(model.attributes);
            this.stateTemplates(model.stateTemplates);
            this.creationTime(model.creationTime);
            this.lastModificationTime(model.lastModificationTime);
        }

        public final String getVehicleName() {
            return this.vehicleName;
        }

        public final void setVehicleName(String vehicleName) {
            this.vehicleName = vehicleName;
        }

        @Override
        public final Builder vehicleName(String vehicleName) {
            this.vehicleName = vehicleName;
            return this;
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getModelManifestArn() {
            return this.modelManifestArn;
        }

        public final void setModelManifestArn(String modelManifestArn) {
            this.modelManifestArn = modelManifestArn;
        }

        @Override
        public final Builder modelManifestArn(String modelManifestArn) {
            this.modelManifestArn = modelManifestArn;
            return this;
        }

        public final String getDecoderManifestArn() {
            return this.decoderManifestArn;
        }

        public final void setDecoderManifestArn(String decoderManifestArn) {
            this.decoderManifestArn = decoderManifestArn;
        }

        @Override
        public final Builder decoderManifestArn(String decoderManifestArn) {
            this.decoderManifestArn = decoderManifestArn;
            return this;
        }

        public final Map<String, String> getAttributes() {
            if (this.attributes instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.attributes;
        }

        public final void setAttributes(Map<String, String> attributes) {
            this.attributes = _attributesMapCopier.copy(attributes);
        }

        @Override
        public final Builder attributes(Map<String, String> attributes) {
            this.attributes = _attributesMapCopier.copy(attributes);
            return this;
        }

        public final List<StateTemplateAssociation.Builder> getStateTemplates() {
            List<StateTemplateAssociation.Builder> result = StateTemplateAssociationsCopier.copyToBuilder(this.stateTemplates);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setStateTemplates(Collection<StateTemplateAssociation.BuilderImpl> stateTemplates) {
            this.stateTemplates = StateTemplateAssociationsCopier.copyFromBuilder(stateTemplates);
        }

        @Override
        public final Builder stateTemplates(Collection<StateTemplateAssociation> stateTemplates) {
            this.stateTemplates = StateTemplateAssociationsCopier.copy(stateTemplates);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder stateTemplates(StateTemplateAssociation ... stateTemplates) {
            this.stateTemplates(Arrays.asList(stateTemplates));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder stateTemplates(Consumer<StateTemplateAssociation.Builder> ... stateTemplates) {
            this.stateTemplates(Stream.of(stateTemplates).map(c -> (StateTemplateAssociation)((StateTemplateAssociation.Builder)StateTemplateAssociation.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final Instant getLastModificationTime() {
            return this.lastModificationTime;
        }

        public final void setLastModificationTime(Instant lastModificationTime) {
            this.lastModificationTime = lastModificationTime;
        }

        @Override
        public final Builder lastModificationTime(Instant lastModificationTime) {
            this.lastModificationTime = lastModificationTime;
            return this;
        }

        @Override
        public GetVehicleResponse build() {
            return new GetVehicleResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends IoTFleetWiseResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetVehicleResponse> {
        public Builder vehicleName(String var1);

        public Builder arn(String var1);

        public Builder modelManifestArn(String var1);

        public Builder decoderManifestArn(String var1);

        public Builder attributes(Map<String, String> var1);

        public Builder stateTemplates(Collection<StateTemplateAssociation> var1);

        public Builder stateTemplates(StateTemplateAssociation ... var1);

        public Builder stateTemplates(Consumer<StateTemplateAssociation.Builder> ... var1);

        public Builder creationTime(Instant var1);

        public Builder lastModificationTime(Instant var1);
    }
}

