/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotfleetwise.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.iotfleetwise.model.StateTemplateAssociation;
import software.amazon.awssdk.services.iotfleetwise.model.StateTemplateAssociationIdentifiersCopier;
import software.amazon.awssdk.services.iotfleetwise.model.StateTemplateAssociationsCopier;
import software.amazon.awssdk.services.iotfleetwise.model.UpdateMode;
import software.amazon.awssdk.services.iotfleetwise.model._attributesMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateVehicleRequestItem
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, UpdateVehicleRequestItem> {
    private static final SdkField<String> VEHICLE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("vehicleName").getter(UpdateVehicleRequestItem.getter(UpdateVehicleRequestItem::vehicleName)).setter(UpdateVehicleRequestItem.setter(Builder::vehicleName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vehicleName").build()}).build();
    private static final SdkField<String> MODEL_MANIFEST_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("modelManifestArn").getter(UpdateVehicleRequestItem.getter(UpdateVehicleRequestItem::modelManifestArn)).setter(UpdateVehicleRequestItem.setter(Builder::modelManifestArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("modelManifestArn").build()}).build();
    private static final SdkField<String> DECODER_MANIFEST_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("decoderManifestArn").getter(UpdateVehicleRequestItem.getter(UpdateVehicleRequestItem::decoderManifestArn)).setter(UpdateVehicleRequestItem.setter(Builder::decoderManifestArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("decoderManifestArn").build()}).build();
    private static final SdkField<Map<String, String>> ATTRIBUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("attributes").getter(UpdateVehicleRequestItem.getter(UpdateVehicleRequestItem::attributes)).setter(UpdateVehicleRequestItem.setter(Builder::attributes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("attributes").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> ATTRIBUTE_UPDATE_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("attributeUpdateMode").getter(UpdateVehicleRequestItem.getter(UpdateVehicleRequestItem::attributeUpdateModeAsString)).setter(UpdateVehicleRequestItem.setter(Builder::attributeUpdateMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("attributeUpdateMode").build()}).build();
    private static final SdkField<List<StateTemplateAssociation>> STATE_TEMPLATES_TO_ADD_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("stateTemplatesToAdd").getter(UpdateVehicleRequestItem.getter(UpdateVehicleRequestItem::stateTemplatesToAdd)).setter(UpdateVehicleRequestItem.setter(Builder::stateTemplatesToAdd)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stateTemplatesToAdd").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(StateTemplateAssociation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> STATE_TEMPLATES_TO_REMOVE_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("stateTemplatesToRemove").getter(UpdateVehicleRequestItem.getter(UpdateVehicleRequestItem::stateTemplatesToRemove)).setter(UpdateVehicleRequestItem.setter(Builder::stateTemplatesToRemove)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stateTemplatesToRemove").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VEHICLE_NAME_FIELD, MODEL_MANIFEST_ARN_FIELD, DECODER_MANIFEST_ARN_FIELD, ATTRIBUTES_FIELD, ATTRIBUTE_UPDATE_MODE_FIELD, STATE_TEMPLATES_TO_ADD_FIELD, STATE_TEMPLATES_TO_REMOVE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("vehicleName", VEHICLE_NAME_FIELD);
            this.put("modelManifestArn", MODEL_MANIFEST_ARN_FIELD);
            this.put("decoderManifestArn", DECODER_MANIFEST_ARN_FIELD);
            this.put("attributes", ATTRIBUTES_FIELD);
            this.put("attributeUpdateMode", ATTRIBUTE_UPDATE_MODE_FIELD);
            this.put("stateTemplatesToAdd", STATE_TEMPLATES_TO_ADD_FIELD);
            this.put("stateTemplatesToRemove", STATE_TEMPLATES_TO_REMOVE_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String vehicleName;
    private final String modelManifestArn;
    private final String decoderManifestArn;
    private final Map<String, String> attributes;
    private final String attributeUpdateMode;
    private final List<StateTemplateAssociation> stateTemplatesToAdd;
    private final List<String> stateTemplatesToRemove;

    private UpdateVehicleRequestItem(BuilderImpl builder) {
        this.vehicleName = builder.vehicleName;
        this.modelManifestArn = builder.modelManifestArn;
        this.decoderManifestArn = builder.decoderManifestArn;
        this.attributes = builder.attributes;
        this.attributeUpdateMode = builder.attributeUpdateMode;
        this.stateTemplatesToAdd = builder.stateTemplatesToAdd;
        this.stateTemplatesToRemove = builder.stateTemplatesToRemove;
    }

    public final String vehicleName() {
        return this.vehicleName;
    }

    public final String modelManifestArn() {
        return this.modelManifestArn;
    }

    public final String decoderManifestArn() {
        return this.decoderManifestArn;
    }

    public final boolean hasAttributes() {
        return this.attributes != null && !(this.attributes instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> attributes() {
        return this.attributes;
    }

    public final UpdateMode attributeUpdateMode() {
        return UpdateMode.fromValue(this.attributeUpdateMode);
    }

    public final String attributeUpdateModeAsString() {
        return this.attributeUpdateMode;
    }

    public final boolean hasStateTemplatesToAdd() {
        return this.stateTemplatesToAdd != null && !(this.stateTemplatesToAdd instanceof SdkAutoConstructList);
    }

    public final List<StateTemplateAssociation> stateTemplatesToAdd() {
        return this.stateTemplatesToAdd;
    }

    public final boolean hasStateTemplatesToRemove() {
        return this.stateTemplatesToRemove != null && !(this.stateTemplatesToRemove instanceof SdkAutoConstructList);
    }

    public final List<String> stateTemplatesToRemove() {
        return this.stateTemplatesToRemove;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.vehicleName());
        hashCode = 31 * hashCode + Objects.hashCode(this.modelManifestArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.decoderManifestArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAttributes() ? this.attributes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.attributeUpdateModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasStateTemplatesToAdd() ? this.stateTemplatesToAdd() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasStateTemplatesToRemove() ? this.stateTemplatesToRemove() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateVehicleRequestItem)) {
            return false;
        }
        UpdateVehicleRequestItem other = (UpdateVehicleRequestItem)obj;
        return Objects.equals(this.vehicleName(), other.vehicleName()) && Objects.equals(this.modelManifestArn(), other.modelManifestArn()) && Objects.equals(this.decoderManifestArn(), other.decoderManifestArn()) && this.hasAttributes() == other.hasAttributes() && Objects.equals(this.attributes(), other.attributes()) && Objects.equals(this.attributeUpdateModeAsString(), other.attributeUpdateModeAsString()) && this.hasStateTemplatesToAdd() == other.hasStateTemplatesToAdd() && Objects.equals(this.stateTemplatesToAdd(), other.stateTemplatesToAdd()) && this.hasStateTemplatesToRemove() == other.hasStateTemplatesToRemove() && Objects.equals(this.stateTemplatesToRemove(), other.stateTemplatesToRemove());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateVehicleRequestItem").add("VehicleName", (Object)this.vehicleName()).add("ModelManifestArn", (Object)this.modelManifestArn()).add("DecoderManifestArn", (Object)this.decoderManifestArn()).add("Attributes", this.hasAttributes() ? this.attributes() : null).add("AttributeUpdateMode", (Object)this.attributeUpdateModeAsString()).add("StateTemplatesToAdd", this.hasStateTemplatesToAdd() ? this.stateTemplatesToAdd() : null).add("StateTemplatesToRemove", this.hasStateTemplatesToRemove() ? this.stateTemplatesToRemove() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "vehicleName": {
                return Optional.ofNullable(clazz.cast(this.vehicleName()));
            }
            case "modelManifestArn": {
                return Optional.ofNullable(clazz.cast(this.modelManifestArn()));
            }
            case "decoderManifestArn": {
                return Optional.ofNullable(clazz.cast(this.decoderManifestArn()));
            }
            case "attributes": {
                return Optional.ofNullable(clazz.cast(this.attributes()));
            }
            case "attributeUpdateMode": {
                return Optional.ofNullable(clazz.cast(this.attributeUpdateModeAsString()));
            }
            case "stateTemplatesToAdd": {
                return Optional.ofNullable(clazz.cast(this.stateTemplatesToAdd()));
            }
            case "stateTemplatesToRemove": {
                return Optional.ofNullable(clazz.cast(this.stateTemplatesToRemove()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<UpdateVehicleRequestItem, T> g) {
        return obj -> g.apply((UpdateVehicleRequestItem)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String vehicleName;
        private String modelManifestArn;
        private String decoderManifestArn;
        private Map<String, String> attributes = DefaultSdkAutoConstructMap.getInstance();
        private String attributeUpdateMode;
        private List<StateTemplateAssociation> stateTemplatesToAdd = DefaultSdkAutoConstructList.getInstance();
        private List<String> stateTemplatesToRemove = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateVehicleRequestItem model) {
            this.vehicleName(model.vehicleName);
            this.modelManifestArn(model.modelManifestArn);
            this.decoderManifestArn(model.decoderManifestArn);
            this.attributes(model.attributes);
            this.attributeUpdateMode(model.attributeUpdateMode);
            this.stateTemplatesToAdd(model.stateTemplatesToAdd);
            this.stateTemplatesToRemove(model.stateTemplatesToRemove);
        }

        public final String getVehicleName() {
            return this.vehicleName;
        }

        public final void setVehicleName(String vehicleName) {
            this.vehicleName = vehicleName;
        }

        @Override
        public final Builder vehicleName(String vehicleName) {
            this.vehicleName = vehicleName;
            return this;
        }

        public final String getModelManifestArn() {
            return this.modelManifestArn;
        }

        public final void setModelManifestArn(String modelManifestArn) {
            this.modelManifestArn = modelManifestArn;
        }

        @Override
        public final Builder modelManifestArn(String modelManifestArn) {
            this.modelManifestArn = modelManifestArn;
            return this;
        }

        public final String getDecoderManifestArn() {
            return this.decoderManifestArn;
        }

        public final void setDecoderManifestArn(String decoderManifestArn) {
            this.decoderManifestArn = decoderManifestArn;
        }

        @Override
        public final Builder decoderManifestArn(String decoderManifestArn) {
            this.decoderManifestArn = decoderManifestArn;
            return this;
        }

        public final Map<String, String> getAttributes() {
            if (this.attributes instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.attributes;
        }

        public final void setAttributes(Map<String, String> attributes) {
            this.attributes = _attributesMapCopier.copy(attributes);
        }

        @Override
        public final Builder attributes(Map<String, String> attributes) {
            this.attributes = _attributesMapCopier.copy(attributes);
            return this;
        }

        public final String getAttributeUpdateMode() {
            return this.attributeUpdateMode;
        }

        public final void setAttributeUpdateMode(String attributeUpdateMode) {
            this.attributeUpdateMode = attributeUpdateMode;
        }

        @Override
        public final Builder attributeUpdateMode(String attributeUpdateMode) {
            this.attributeUpdateMode = attributeUpdateMode;
            return this;
        }

        @Override
        public final Builder attributeUpdateMode(UpdateMode attributeUpdateMode) {
            this.attributeUpdateMode(attributeUpdateMode == null ? null : attributeUpdateMode.toString());
            return this;
        }

        public final List<StateTemplateAssociation.Builder> getStateTemplatesToAdd() {
            List<StateTemplateAssociation.Builder> result = StateTemplateAssociationsCopier.copyToBuilder(this.stateTemplatesToAdd);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setStateTemplatesToAdd(Collection<StateTemplateAssociation.BuilderImpl> stateTemplatesToAdd) {
            this.stateTemplatesToAdd = StateTemplateAssociationsCopier.copyFromBuilder(stateTemplatesToAdd);
        }

        @Override
        public final Builder stateTemplatesToAdd(Collection<StateTemplateAssociation> stateTemplatesToAdd) {
            this.stateTemplatesToAdd = StateTemplateAssociationsCopier.copy(stateTemplatesToAdd);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder stateTemplatesToAdd(StateTemplateAssociation ... stateTemplatesToAdd) {
            this.stateTemplatesToAdd(Arrays.asList(stateTemplatesToAdd));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder stateTemplatesToAdd(Consumer<StateTemplateAssociation.Builder> ... stateTemplatesToAdd) {
            this.stateTemplatesToAdd(Stream.of(stateTemplatesToAdd).map(c -> (StateTemplateAssociation)((StateTemplateAssociation.Builder)StateTemplateAssociation.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Collection<String> getStateTemplatesToRemove() {
            if (this.stateTemplatesToRemove instanceof SdkAutoConstructList) {
                return null;
            }
            return this.stateTemplatesToRemove;
        }

        public final void setStateTemplatesToRemove(Collection<String> stateTemplatesToRemove) {
            this.stateTemplatesToRemove = StateTemplateAssociationIdentifiersCopier.copy(stateTemplatesToRemove);
        }

        @Override
        public final Builder stateTemplatesToRemove(Collection<String> stateTemplatesToRemove) {
            this.stateTemplatesToRemove = StateTemplateAssociationIdentifiersCopier.copy(stateTemplatesToRemove);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder stateTemplatesToRemove(String ... stateTemplatesToRemove) {
            this.stateTemplatesToRemove(Arrays.asList(stateTemplatesToRemove));
            return this;
        }

        public UpdateVehicleRequestItem build() {
            return new UpdateVehicleRequestItem(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, UpdateVehicleRequestItem> {
        public Builder vehicleName(String var1);

        public Builder modelManifestArn(String var1);

        public Builder decoderManifestArn(String var1);

        public Builder attributes(Map<String, String> var1);

        public Builder attributeUpdateMode(String var1);

        public Builder attributeUpdateMode(UpdateMode var1);

        public Builder stateTemplatesToAdd(Collection<StateTemplateAssociation> var1);

        public Builder stateTemplatesToAdd(StateTemplateAssociation ... var1);

        public Builder stateTemplatesToAdd(Consumer<StateTemplateAssociation.Builder> ... var1);

        public Builder stateTemplatesToRemove(Collection<String> var1);

        public Builder stateTemplatesToRemove(String ... var1);
    }
}

