/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotfleetwise.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.iotfleetwise.model.IoTFleetWiseRequest;
import software.amazon.awssdk.services.iotfleetwise.model.StateTemplateDataExtraDimensionNodePathListCopier;
import software.amazon.awssdk.services.iotfleetwise.model.StateTemplateMetadataExtraDimensionNodePathListCopier;
import software.amazon.awssdk.services.iotfleetwise.model.StateTemplatePropertiesCopier;
import software.amazon.awssdk.services.iotfleetwise.model.Tag;
import software.amazon.awssdk.services.iotfleetwise.model.TagListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateStateTemplateRequest
extends IoTFleetWiseRequest
implements ToCopyableBuilder<Builder, CreateStateTemplateRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(CreateStateTemplateRequest.getter(CreateStateTemplateRequest::name)).setter(CreateStateTemplateRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(CreateStateTemplateRequest.getter(CreateStateTemplateRequest::description)).setter(CreateStateTemplateRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<String> SIGNAL_CATALOG_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("signalCatalogArn").getter(CreateStateTemplateRequest.getter(CreateStateTemplateRequest::signalCatalogArn)).setter(CreateStateTemplateRequest.setter(Builder::signalCatalogArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("signalCatalogArn").build()}).build();
    private static final SdkField<List<String>> STATE_TEMPLATE_PROPERTIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("stateTemplateProperties").getter(CreateStateTemplateRequest.getter(CreateStateTemplateRequest::stateTemplateProperties)).setter(CreateStateTemplateRequest.setter(Builder::stateTemplateProperties)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stateTemplateProperties").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> DATA_EXTRA_DIMENSIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("dataExtraDimensions").getter(CreateStateTemplateRequest.getter(CreateStateTemplateRequest::dataExtraDimensions)).setter(CreateStateTemplateRequest.setter(Builder::dataExtraDimensions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataExtraDimensions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> METADATA_EXTRA_DIMENSIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("metadataExtraDimensions").getter(CreateStateTemplateRequest.getter(CreateStateTemplateRequest::metadataExtraDimensions)).setter(CreateStateTemplateRequest.setter(Builder::metadataExtraDimensions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("metadataExtraDimensions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("tags").getter(CreateStateTemplateRequest.getter(CreateStateTemplateRequest::tags)).setter(CreateStateTemplateRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, DESCRIPTION_FIELD, SIGNAL_CATALOG_ARN_FIELD, STATE_TEMPLATE_PROPERTIES_FIELD, DATA_EXTRA_DIMENSIONS_FIELD, METADATA_EXTRA_DIMENSIONS_FIELD, TAGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("name", NAME_FIELD);
            this.put("description", DESCRIPTION_FIELD);
            this.put("signalCatalogArn", SIGNAL_CATALOG_ARN_FIELD);
            this.put("stateTemplateProperties", STATE_TEMPLATE_PROPERTIES_FIELD);
            this.put("dataExtraDimensions", DATA_EXTRA_DIMENSIONS_FIELD);
            this.put("metadataExtraDimensions", METADATA_EXTRA_DIMENSIONS_FIELD);
            this.put("tags", TAGS_FIELD);
        }
    });
    private final String name;
    private final String description;
    private final String signalCatalogArn;
    private final List<String> stateTemplateProperties;
    private final List<String> dataExtraDimensions;
    private final List<String> metadataExtraDimensions;
    private final List<Tag> tags;

    private CreateStateTemplateRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.description = builder.description;
        this.signalCatalogArn = builder.signalCatalogArn;
        this.stateTemplateProperties = builder.stateTemplateProperties;
        this.dataExtraDimensions = builder.dataExtraDimensions;
        this.metadataExtraDimensions = builder.metadataExtraDimensions;
        this.tags = builder.tags;
    }

    public final String name() {
        return this.name;
    }

    public final String description() {
        return this.description;
    }

    public final String signalCatalogArn() {
        return this.signalCatalogArn;
    }

    public final boolean hasStateTemplateProperties() {
        return this.stateTemplateProperties != null && !(this.stateTemplateProperties instanceof SdkAutoConstructList);
    }

    public final List<String> stateTemplateProperties() {
        return this.stateTemplateProperties;
    }

    public final boolean hasDataExtraDimensions() {
        return this.dataExtraDimensions != null && !(this.dataExtraDimensions instanceof SdkAutoConstructList);
    }

    public final List<String> dataExtraDimensions() {
        return this.dataExtraDimensions;
    }

    public final boolean hasMetadataExtraDimensions() {
        return this.metadataExtraDimensions != null && !(this.metadataExtraDimensions instanceof SdkAutoConstructList);
    }

    public final List<String> metadataExtraDimensions() {
        return this.metadataExtraDimensions;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.signalCatalogArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasStateTemplateProperties() ? this.stateTemplateProperties() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDataExtraDimensions() ? this.dataExtraDimensions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasMetadataExtraDimensions() ? this.metadataExtraDimensions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateStateTemplateRequest)) {
            return false;
        }
        CreateStateTemplateRequest other = (CreateStateTemplateRequest)((Object)obj);
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.signalCatalogArn(), other.signalCatalogArn()) && this.hasStateTemplateProperties() == other.hasStateTemplateProperties() && Objects.equals(this.stateTemplateProperties(), other.stateTemplateProperties()) && this.hasDataExtraDimensions() == other.hasDataExtraDimensions() && Objects.equals(this.dataExtraDimensions(), other.dataExtraDimensions()) && this.hasMetadataExtraDimensions() == other.hasMetadataExtraDimensions() && Objects.equals(this.metadataExtraDimensions(), other.metadataExtraDimensions()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"CreateStateTemplateRequest").add("Name", (Object)this.name()).add("Description", (Object)this.description()).add("SignalCatalogArn", (Object)this.signalCatalogArn()).add("StateTemplateProperties", this.hasStateTemplateProperties() ? this.stateTemplateProperties() : null).add("DataExtraDimensions", this.hasDataExtraDimensions() ? this.dataExtraDimensions() : null).add("MetadataExtraDimensions", this.hasMetadataExtraDimensions() ? this.metadataExtraDimensions() : null).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "signalCatalogArn": {
                return Optional.ofNullable(clazz.cast(this.signalCatalogArn()));
            }
            case "stateTemplateProperties": {
                return Optional.ofNullable(clazz.cast(this.stateTemplateProperties()));
            }
            case "dataExtraDimensions": {
                return Optional.ofNullable(clazz.cast(this.dataExtraDimensions()));
            }
            case "metadataExtraDimensions": {
                return Optional.ofNullable(clazz.cast(this.metadataExtraDimensions()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<CreateStateTemplateRequest, T> g) {
        return obj -> g.apply((CreateStateTemplateRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IoTFleetWiseRequest.BuilderImpl
    implements Builder {
        private String name;
        private String description;
        private String signalCatalogArn;
        private List<String> stateTemplateProperties = DefaultSdkAutoConstructList.getInstance();
        private List<String> dataExtraDimensions = DefaultSdkAutoConstructList.getInstance();
        private List<String> metadataExtraDimensions = DefaultSdkAutoConstructList.getInstance();
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateStateTemplateRequest model) {
            super(model);
            this.name(model.name);
            this.description(model.description);
            this.signalCatalogArn(model.signalCatalogArn);
            this.stateTemplateProperties(model.stateTemplateProperties);
            this.dataExtraDimensions(model.dataExtraDimensions);
            this.metadataExtraDimensions(model.metadataExtraDimensions);
            this.tags(model.tags);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getSignalCatalogArn() {
            return this.signalCatalogArn;
        }

        public final void setSignalCatalogArn(String signalCatalogArn) {
            this.signalCatalogArn = signalCatalogArn;
        }

        @Override
        public final Builder signalCatalogArn(String signalCatalogArn) {
            this.signalCatalogArn = signalCatalogArn;
            return this;
        }

        public final Collection<String> getStateTemplateProperties() {
            if (this.stateTemplateProperties instanceof SdkAutoConstructList) {
                return null;
            }
            return this.stateTemplateProperties;
        }

        public final void setStateTemplateProperties(Collection<String> stateTemplateProperties) {
            this.stateTemplateProperties = StateTemplatePropertiesCopier.copy(stateTemplateProperties);
        }

        @Override
        public final Builder stateTemplateProperties(Collection<String> stateTemplateProperties) {
            this.stateTemplateProperties = StateTemplatePropertiesCopier.copy(stateTemplateProperties);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder stateTemplateProperties(String ... stateTemplateProperties) {
            this.stateTemplateProperties(Arrays.asList(stateTemplateProperties));
            return this;
        }

        public final Collection<String> getDataExtraDimensions() {
            if (this.dataExtraDimensions instanceof SdkAutoConstructList) {
                return null;
            }
            return this.dataExtraDimensions;
        }

        public final void setDataExtraDimensions(Collection<String> dataExtraDimensions) {
            this.dataExtraDimensions = StateTemplateDataExtraDimensionNodePathListCopier.copy(dataExtraDimensions);
        }

        @Override
        public final Builder dataExtraDimensions(Collection<String> dataExtraDimensions) {
            this.dataExtraDimensions = StateTemplateDataExtraDimensionNodePathListCopier.copy(dataExtraDimensions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dataExtraDimensions(String ... dataExtraDimensions) {
            this.dataExtraDimensions(Arrays.asList(dataExtraDimensions));
            return this;
        }

        public final Collection<String> getMetadataExtraDimensions() {
            if (this.metadataExtraDimensions instanceof SdkAutoConstructList) {
                return null;
            }
            return this.metadataExtraDimensions;
        }

        public final void setMetadataExtraDimensions(Collection<String> metadataExtraDimensions) {
            this.metadataExtraDimensions = StateTemplateMetadataExtraDimensionNodePathListCopier.copy(metadataExtraDimensions);
        }

        @Override
        public final Builder metadataExtraDimensions(Collection<String> metadataExtraDimensions) {
            this.metadataExtraDimensions = StateTemplateMetadataExtraDimensionNodePathListCopier.copy(metadataExtraDimensions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder metadataExtraDimensions(String ... metadataExtraDimensions) {
            this.metadataExtraDimensions(Arrays.asList(metadataExtraDimensions));
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateStateTemplateRequest build() {
            return new CreateStateTemplateRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends IoTFleetWiseRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateStateTemplateRequest> {
        public Builder name(String var1);

        public Builder description(String var1);

        public Builder signalCatalogArn(String var1);

        public Builder stateTemplateProperties(Collection<String> var1);

        public Builder stateTemplateProperties(String ... var1);

        public Builder dataExtraDimensions(Collection<String> var1);

        public Builder dataExtraDimensions(String ... var1);

        public Builder metadataExtraDimensions(Collection<String> var1);

        public Builder metadataExtraDimensions(String ... var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

